/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Util.ea.AbstractEAUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EADirection;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorTag;
import org.sparx.Element;

public class EAConnectorUtil
extends AbstractEAUtil {
    public static void addTaggedValue(Connector con, EATaggedValue tv) throws EAException {
        Collection cTV = con.GetTaggedValues();
        String name = tv.getName();
        String type = "";
        List<String> values = tv.getValues();
        if (values != null) {
            for (String v : values) {
                ConnectorTag eaTv = (ConnectorTag)cTV.AddNew(name, type);
                cTV.Refresh();
                if (tv.createAsMemoField() || v.length() > 255) {
                    eaTv.SetValue("<memo>");
                    eaTv.SetNotes(v);
                } else {
                    eaTv.SetValue(v);
                    eaTv.SetNotes("");
                }
                if (eaTv.Update()) continue;
                throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(101), name, con.GetName(), v, eaTv.GetLastError()));
            }
        }
    }

    public static void addTaggedValues(Connector con, List<EATaggedValue> tvs) throws EAException {
        if (tvs != null && !tvs.isEmpty()) {
            Collection cTV = con.GetTaggedValues();
            for (EATaggedValue tv : tvs) {
                String name = tv.getName();
                List<String> values = tv.getValues();
                if (values == null) continue;
                for (String v : values) {
                    ConnectorTag eaTv = (ConnectorTag)cTV.AddNew(name, "");
                    cTV.Refresh();
                    if (tv.createAsMemoField() || v.length() > 255) {
                        eaTv.SetValue("<memo>");
                        eaTv.SetNotes(v);
                    } else {
                        eaTv.SetValue(v);
                        eaTv.SetNotes("");
                    }
                    if (eaTv.Update()) continue;
                    throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(101), name, con.GetName(), v, eaTv.GetLastError()));
                }
            }
        }
    }

    public static void addTaggedValues(Connector con, TaggedValues tvs) throws EAException {
        if (tvs != null && !tvs.isEmpty()) {
            Collection cTV = con.GetTaggedValues();
            for (Map.Entry<String, List<String>> e : tvs.asMap().entrySet()) {
                String name = e.getKey();
                List<String> values = e.getValue();
                if (values == null) continue;
                for (String v : values) {
                    ConnectorTag eaTv = (ConnectorTag)cTV.AddNew(name, "");
                    cTV.Refresh();
                    if (v.length() > 255) {
                        eaTv.SetValue("<memo>");
                        eaTv.SetNotes(v);
                    } else {
                        eaTv.SetValue(v);
                        eaTv.SetNotes("");
                    }
                    if (eaTv.Update()) continue;
                    throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(101), name, con.GetName(), v, eaTv.GetLastError()));
                }
            }
        }
    }

    public static void deleteTaggedValue(Connector con, String nameOfTVToDelete) {
        Collection cTV = con.GetTaggedValues();
        cTV.Refresh();
        for (short i = 0; i < cTV.GetCount(); i = (short)(i + 1)) {
            ConnectorTag tv = (ConnectorTag)cTV.GetAt(i);
            if (!tv.GetName().equalsIgnoreCase(nameOfTVToDelete)) continue;
            cTV.Delete(i);
        }
        cTV.Refresh();
    }

    public static void setEAAssociationClass(Connector con, Element classElement) throws EAException {
        int connectorID = con.GetConnectorID();
        classElement.CreateAssociationClass(connectorID);
    }

    public static void setEAAlias(Connector con, String aliasName) throws EAException {
        con.SetAlias(aliasName);
        if (!con.Update()) {
            throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(107), con.GetName(), con.GetLastError()));
        }
    }

    public static void setEANotes(Connector con, String notes) throws EAException {
        con.SetNotes(notes);
        if (!con.Update()) {
            throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(108), con.GetName(), con.GetLastError()));
        }
    }

    public static void setEAName(Connector con, String name) throws EAException {
        con.SetName(name);
        if (!con.Update()) {
            throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(102), name, con.GetLastError()));
        }
    }

    public static void setEAStereotype(Connector con, String stereotype) throws EAException {
        con.SetStereotype(stereotype);
        if (!con.Update()) {
            throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(103), con.GetName(), con.GetLastError()));
        }
    }

    public static void setEAStereotypeEx(Connector con, String stereotypeEx) throws EAException {
        con.SetStereotypeEx(stereotypeEx);
        if (!con.Update()) {
            throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(105), con.GetName(), con.GetLastError()));
        }
    }

    public static void setEAStyleEx(Connector con, String styleEx) throws EAException {
        con.SetStyleEx(styleEx);
        if (!con.Update()) {
            throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(106), con.GetName(), con.GetLastError()));
        }
    }

    public static void setEADirection(Connector con, EADirection direction) throws EAException {
        con.SetDirection(direction.getEAValue());
        if (!con.Update()) {
            throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(104), con.GetName(), con.GetLastError()));
        }
    }

    public static void setEASupplierID(Connector con, int supplierID) throws EAException {
        con.SetSupplierID(supplierID);
        if (!con.Update()) {
            throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(109), con.GetName(), con.GetLastError()));
        }
    }

    public static void setTaggedValues(Connector con, List<EATaggedValue> tvs) throws EAException {
        for (EATaggedValue tv : tvs) {
            EAConnectorUtil.deleteTaggedValue(con, tv.getName());
        }
        EAConnectorUtil.addTaggedValues(con, tvs);
    }

    public static void setTaggedValue(Connector con, EATaggedValue tv) throws EAException {
        EAConnectorUtil.deleteTaggedValue(con, tv.getName());
        EAConnectorUtil.addTaggedValue(con, tv);
    }

    public static void setTaggedValues(Connector con, TaggedValues tvs) throws EAException {
        for (String tvName : tvs.asMap().keySet()) {
            EAConnectorUtil.deleteTaggedValue(con, tvName);
        }
        EAConnectorUtil.addTaggedValues(con, tvs);
    }

    public static SortedMap<String, EATaggedValue> getEATaggedValues(Connector conn) {
        TreeMap<String, EATaggedValue> result = new TreeMap<String, EATaggedValue>();
        Collection tvs = conn.GetTaggedValues();
        for (short i = 0; i < tvs.GetCount(); i = (short)(i + 1)) {
            ConnectorTag tv = (ConnectorTag)tvs.GetAt(i);
            String name = tv.GetName();
            String fqName = tv.GetFQName();
            String tvValue = tv.GetValue();
            String value = tvValue.equals("<memo>") ? tv.GetNotes() : tvValue;
            String key = name + "#" + fqName;
            if (result.containsKey(key)) {
                EATaggedValue eatv = (EATaggedValue)result.get(key);
                eatv.addValue(value);
                continue;
            }
            result.put(key, new EATaggedValue(name, fqName, value));
        }
        return result;
    }

    public static void updateTaggedValue(Connector con, String name, String value, boolean createAsMemoField) throws EAException {
        boolean isQualifiedName = name.contains("::");
        Collection cTV = con.GetTaggedValues();
        cTV.Refresh();
        for (short i = 0; i < cTV.GetCount(); i = (short)(i + 1)) {
            ConnectorTag tv = (ConnectorTag)cTV.GetAt(i);
            if ((!isQualifiedName || !tv.GetFQName().equalsIgnoreCase(name)) && !tv.GetName().equalsIgnoreCase(name)) continue;
            if (createAsMemoField || value.length() > 255) {
                tv.SetValue("<memo>");
                tv.SetNotes(value);
            } else {
                tv.SetValue(value);
                tv.SetNotes("");
            }
            if (tv.Update()) continue;
            throw new EAException(EAConnectorUtil.createMessage(EAConnectorUtil.message(101), name, con.GetName(), value, tv.GetLastError()));
        }
        cTV.Refresh();
    }

    public static boolean isAssociationClassConnector(Connector con) {
        return con.GetSubtype().equalsIgnoreCase("class") && !con.MiscData(0).isEmpty();
    }

    public static int navigability(Connector con) {
        int result = 0;
        String dirText = con.GetDirection();
        if (dirText.equals("Source -> Destination")) {
            result = 1;
        } else if (dirText.equals("Destination -> Source")) {
            result = -1;
        }
        return result;
    }

    public static String message(int mnr) {
        switch (mnr) {
            case 101: {
                return "EA error encountered while updating EA tagged value '$1$' on connector '$2$' with value '$3$'. Error message is: $4$";
            }
            case 102: {
                return "EA error encountered while updating 'Name' on connector '$1$'. Error message is: $2$";
            }
            case 103: {
                return "EA error encountered while updating 'Stereotype' on connector '$1$'. Error message is: $2$";
            }
            case 104: {
                return "EA error encountered while updating 'Direction' on connector '$1$'. Error message is: $2$";
            }
            case 105: {
                return "EA error encountered while updating 'StereotypeEx' on connector '$1$'. Error message is: $2$";
            }
            case 106: {
                return "EA error encountered while updating 'StyleEx' on connector '$1$'. Error message is: $2$";
            }
            case 107: {
                return "EA error encountered while updating 'Alias' of EA connector '$1$'. Error message is: $2$";
            }
            case 108: {
                return "EA error encountered while updating 'Notes' of EA connector '$1$'. Error message is: $2$";
            }
            case 109: {
                return "EA error encountered while updating 'SupplierID' of EA connector '$1$'. Error message is: $2$";
            }
        }
        return "(" + EAConnectorUtil.class.getName() + ") Unknown message with number: " + mnr;
    }
}

