/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Util.ea.AbstractEAUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAAggregation;
import de.interactive_instruments.ShapeChange.Util.ea.EAConnectorUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EANavigable;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.ConnectorEnd;
import org.sparx.RoleTag;

public class EAConnectorEndUtil
extends AbstractEAUtil {
    public static void addTaggedValue(ConnectorEnd end, EATaggedValue tv) throws EAException {
        Collection cTV = end.GetTaggedValues();
        String name = tv.getName();
        List<String> values = tv.getValues();
        if (values != null) {
            for (String v : values) {
                RoleTag eaTv = (RoleTag)cTV.AddNew(name, "");
                cTV.Refresh();
                if (tv.createAsMemoField() || v.length() > 255) {
                    if (v.length() == 0) {
                        eaTv.SetValue("<memo>");
                    } else {
                        eaTv.SetValue("<memo>$ea_notes=" + v);
                    }
                } else {
                    eaTv.SetValue(v);
                }
                if (eaTv.Update()) continue;
                throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(101), name, end.GetRole(), v, eaTv.GetLastError()));
            }
        }
    }

    public static void addTaggedValues(ConnectorEnd end, TaggedValues tvs) throws EAException {
        if (tvs != null && !tvs.isEmpty()) {
            Collection cTV = end.GetTaggedValues();
            for (Map.Entry<String, List<String>> e : tvs.asMap().entrySet()) {
                String name = e.getKey();
                List<String> values = e.getValue();
                if (values == null) continue;
                for (String v : values) {
                    RoleTag eaTv = (RoleTag)cTV.AddNew(name, "");
                    cTV.Refresh();
                    if (v.length() > 255) {
                        eaTv.SetValue("<memo>$ea_notes=" + v);
                    } else {
                        eaTv.SetValue(v);
                    }
                    if (eaTv.Update()) continue;
                    throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(101), name, end.GetRole(), v, eaTv.GetLastError()));
                }
            }
        }
    }

    public static void deleteTaggedValue(ConnectorEnd ce, String nameOfTVToDelete) {
        Collection cTV = ce.GetTaggedValues();
        cTV.Refresh();
        for (short i = 0; i < cTV.GetCount(); i = (short)(i + 1)) {
            RoleTag tv = (RoleTag)cTV.GetAt(i);
            if (!tv.GetTag().equalsIgnoreCase(nameOfTVToDelete)) continue;
            cTV.Delete(i);
        }
        cTV.Refresh();
    }

    public static void setEACardinality(ConnectorEnd conEnd, String cardinalityAsString) throws EAException {
        conEnd.SetCardinality(cardinalityAsString);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(102), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEARole(ConnectorEnd conEnd, String role) throws EAException {
        conEnd.SetRole(role);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(103), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEAAlias(ConnectorEnd conEnd, String alias) throws EAException {
        conEnd.SetAlias(alias);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(106), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEARoleNote(ConnectorEnd conEnd, String note) throws EAException {
        conEnd.SetRoleNote(note);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(107), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEAStereotype(ConnectorEnd conEnd, String stereotype) throws EAException {
        conEnd.SetStereotype(stereotype);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(112), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEAStereotypeEx(ConnectorEnd conEnd, String stereotypeEx) throws EAException {
        conEnd.SetStereotypeEx(stereotypeEx);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(108), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEAOrdering(ConnectorEnd conEnd, boolean isOrdered) throws EAException {
        conEnd.SetOrdering(isOrdered ? 1 : 0);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(109), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEAOwnedByClassifier(ConnectorEnd conEnd, boolean isOwned) throws EAException {
        conEnd.SetOwnedByClassifier(isOwned);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(113), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEAAllowDuplicates(ConnectorEnd conEnd, boolean allowDuplicates) throws EAException {
        conEnd.SetAllowDuplicates(allowDuplicates);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(110), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEADerived(ConnectorEnd conEnd, boolean isDerived) throws EAException {
        conEnd.SetDerived(isDerived);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(114), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEAAggregation(ConnectorEnd conEnd, EAAggregation aggregation) throws EAException {
        conEnd.SetAggregation(aggregation.getEAValue());
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(111), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setEAContainment(ConnectorEnd conEnd, String containment) throws EAException {
        conEnd.SetContainment(containment);
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(105), conEnd.GetRole(), containment, conEnd.GetLastError()));
        }
    }

    public static void setEANavigable(ConnectorEnd conEnd, EANavigable navigable) throws EAException {
        conEnd.SetNavigable(navigable.getEAValue());
        if (!conEnd.Update()) {
            throw new EAException(EAConnectorEndUtil.createMessage(EAConnectorEndUtil.message(104), conEnd.GetRole(), conEnd.GetLastError()));
        }
    }

    public static void setTaggedValue(ConnectorEnd ce, EATaggedValue tv) throws EAException {
        EAConnectorEndUtil.deleteTaggedValue(ce, tv.getName());
        EAConnectorEndUtil.addTaggedValue(ce, tv);
    }

    public static void setTaggedValue(ConnectorEnd end, String name, String value) throws EAException {
        EATaggedValue tv = new EATaggedValue(name, value);
        EAConnectorEndUtil.deleteTaggedValue(end, tv.getName());
        EAConnectorEndUtil.addTaggedValue(end, tv);
    }

    public static String taggedValue(ConnectorEnd end, String tvName) {
        Collection tvs = end.GetTaggedValues();
        for (RoleTag tv : tvs) {
            if (!tvName.equals(tv.GetTag())) continue;
            String v = tv.GetValue();
            if (v.startsWith("<memo>$ea_notes=")) {
                v = v.substring(16);
            } else if (v.startsWith("<memo>")) {
                v = "";
            } else if (v.contains("$ea_notes=")) {
                v = v.substring(0, v.indexOf("$ea_notes="));
            }
            return v;
        }
        return null;
    }

    public static void setTaggedValues(ConnectorEnd ce, TaggedValues tvs) throws EAException {
        for (String tvName : tvs.asMap().keySet()) {
            EAConnectorEndUtil.deleteTaggedValue(ce, tvName);
        }
        EAConnectorEndUtil.addTaggedValues(ce, tvs);
    }

    public static SortedMap<String, EATaggedValue> getEATaggedValues(ConnectorEnd elmt) {
        TreeMap<String, EATaggedValue> result = new TreeMap<String, EATaggedValue>();
        Collection tvs = elmt.GetTaggedValues();
        for (short i = 0; i < tvs.GetCount(); i = (short)(i + 1)) {
            RoleTag tv = (RoleTag)tvs.GetAt(i);
            String name = tv.GetTag();
            String fqName = tv.GetFQName();
            String value = tv.GetValue();
            if (value.startsWith("<memo>$ea_notes=")) {
                value = value.substring(16);
            } else if (value.startsWith("<memo>")) {
                value = "";
            } else if (value.contains("$ea_notes=")) {
                value = value.substring(0, value.indexOf("$ea_notes="));
            }
            String key = name + "#" + fqName;
            if (result.containsKey(key)) {
                EATaggedValue eatv = (EATaggedValue)result.get(key);
                eatv.addValue(value);
                continue;
            }
            result.put(key, new EATaggedValue(name, fqName, value));
        }
        return result;
    }

    public static String getRoleName(ConnectorEnd ce, String eaPropertyId) {
        Object name = ce.GetRole();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "role_" + eaPropertyId;
        }
        return ((String)name).trim();
    }

    public static boolean isNavigable(ConnectorEnd ce, Connector con) {
        String ceName;
        boolean nav = ce.GetIsNavigable();
        if (!nav) {
            boolean bl = nav = EAConnectorUtil.navigability(con) == 0;
        }
        if ((ceName = EAConnectorEndUtil.getRoleName(ce, "" + con.GetConnectorID())) == null || StringUtils.startsWith((CharSequence)ceName, (CharSequence)"role_")) {
            nav = false;
        }
        return nav;
    }

    public static String message(int mnr) {
        switch (mnr) {
            case 101: {
                return "EA error encountered while updating EA tagged value '$1$' of connector end '$2$' with value '$3$'. Error message is: $4$";
            }
            case 102: {
                return "EA error encountered while updating 'Cardinality' of EA connector end '$1$'. Error message is: $2$";
            }
            case 103: {
                return "EA error encountered while updating 'Role' of EA connector end '$1$'. Error message is: $2$";
            }
            case 104: {
                return "EA error encountered while updating 'Navigable' of EA connector end '$1$'. Error message is: $2$";
            }
            case 105: {
                return "EA error encountered while updating 'Containment' of EA connector end '$1$' with value '$2$'. Error message is: $3$";
            }
            case 106: {
                return "EA error encountered while updating 'Alias' of EA connector end '$1$'. Error message is: $2$";
            }
            case 107: {
                return "EA error encountered while updating 'Notes' of EA connector end '$1$'. Error message is: $2$";
            }
            case 108: {
                return "EA error encountered while updating 'StereotypeEx' of EA connector end '$1$'. Error message is: $2$";
            }
            case 109: {
                return "EA error encountered while updating 'Ordering' of EA connector end '$1$'. Error message is: $2$";
            }
            case 110: {
                return "EA error encountered while updating 'AllowDuplicates' of EA connector end '$1$'. Error message is: $2$";
            }
            case 111: {
                return "EA error encountered while updating 'Aggregation' of EA connector end '$1$'. Error message is: $2$";
            }
            case 112: {
                return "EA error encountered while updating 'Stereotype' of EA connector end '$1$'. Error message is: $2$";
            }
            case 113: {
                return "EA error encountered while updating 'OwnedByClassifier' of EA connector end '$1$'. Error message is: $2$";
            }
            case 114: {
                return "EA error encountered while updating 'Derived' of EA connector end '$1$'. Error message is: $2$";
            }
        }
        return "(" + EAConnectorUtil.class.getName() + ") Unknown message with number: " + mnr;
    }
}

