/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.ea;

import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Util.ea.AbstractEAUtil;
import de.interactive_instruments.ShapeChange.Util.ea.EAException;
import de.interactive_instruments.ShapeChange.Util.ea.EATaggedValue;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sparx.Attribute;
import org.sparx.AttributeConstraint;
import org.sparx.AttributeTag;
import org.sparx.Collection;

public class EAAttributeUtil
extends AbstractEAUtil {
    public static void addTaggedValue(Attribute att, EATaggedValue tv) throws EAException {
        if (tv != null) {
            Collection cTV = att.GetTaggedValues();
            String tag = tv.getName();
            List<String> values = tv.getValues();
            if (values != null) {
                for (String v : values) {
                    AttributeTag at = (AttributeTag)cTV.AddNew(tag, "");
                    cTV.Refresh();
                    if (v.length() > 255) {
                        at.SetValue("<memo>");
                        at.SetNotes(v);
                    } else {
                        at.SetValue(v);
                        at.SetNotes("");
                    }
                    if (at.Update()) continue;
                    throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(102), tag, att.GetName(), v, at.GetLastError()));
                }
            }
        }
    }

    public static void addTaggedValues(Attribute att, List<EATaggedValue> tvs) throws EAException {
        if (tvs != null && !tvs.isEmpty()) {
            Collection cTV = att.GetTaggedValues();
            String attName = att.GetName();
            for (EATaggedValue tv : tvs) {
                String name = tv.getName();
                List<String> values = tv.getValues();
                if (values == null) continue;
                for (String v : values) {
                    AttributeTag eaTv = (AttributeTag)cTV.AddNew(name, "");
                    cTV.Refresh();
                    if (tv.createAsMemoField() || v.length() > 255) {
                        eaTv.SetValue("<memo>");
                        eaTv.SetNotes(v);
                    } else {
                        eaTv.SetValue(v);
                        eaTv.SetNotes("");
                    }
                    if (eaTv.Update()) continue;
                    throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(102), name, attName, v, eaTv.GetLastError()));
                }
            }
        }
    }

    public static void addTaggedValues(Attribute att, TaggedValues tvs) throws EAException {
        if (tvs != null && !tvs.isEmpty()) {
            Collection cTV = att.GetTaggedValues();
            String attName = att.GetName();
            for (String tag : tvs.keySet()) {
                String[] values;
                for (String v : values = tvs.get(tag)) {
                    AttributeTag tv = (AttributeTag)cTV.AddNew(tag, "");
                    cTV.Refresh();
                    if (v.length() > 255) {
                        tv.SetValue("<memo>");
                        tv.SetNotes(v);
                    } else {
                        tv.SetValue(v);
                        tv.SetNotes("");
                    }
                    if (tv.Update()) continue;
                    throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(102), tag, attName, v, tv.GetLastError()));
                }
            }
        }
    }

    public static void deleteTaggedValue(Attribute a, String nameOfTVToDelete) {
        Collection cTV = a.GetTaggedValues();
        cTV.Refresh();
        for (short i = 0; i < cTV.GetCount(); i = (short)(i + 1)) {
            AttributeTag tv = (AttributeTag)cTV.GetAt(i);
            if (!tv.GetName().equalsIgnoreCase(nameOfTVToDelete)) continue;
            cTV.Delete(i);
        }
        cTV.Refresh();
    }

    public static void setEAAllowDuplicates(Attribute att, boolean allowDuplicates) throws EAException {
        att.SetAllowDuplicates(allowDuplicates);
        if (!att.Update()) {
            throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(101), att.GetName(), att.GetLastError()));
        }
    }

    public static void setEAIsCollection(Attribute att, boolean isCollection) throws EAException {
        att.SetIsCollection(isCollection);
        if (!att.Update()) {
            throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(103), att.GetName(), att.GetLastError()));
        }
    }

    public static void setEAIsOrdered(Attribute att, boolean isOrdered) throws EAException {
        att.SetIsOrdered(isOrdered);
        if (!att.Update()) {
            throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(104), att.GetName(), att.GetLastError()));
        }
    }

    public static void setEALength(Attribute att, String length) throws EAException {
        att.SetLength(length);
        if (!att.Update()) {
            throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(105), att.GetName(), length, att.GetLastError()));
        }
    }

    public static void setEAPrecision(Attribute att, int precision) throws EAException {
        att.SetPrecision("" + precision);
        if (!att.Update()) {
            throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(106), att.GetName(), att.GetLastError()));
        }
    }

    public static void setEAScale(Attribute att, int scale) throws EAException {
        att.SetScale("" + scale);
        if (!att.Update()) {
            throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(107), att.GetName(), att.GetLastError()));
        }
    }

    public static void setTaggedValue(Attribute att, EATaggedValue tv) throws EAException {
        EAAttributeUtil.deleteTaggedValue(att, tv.getName());
        EAAttributeUtil.addTaggedValue(att, tv);
    }

    public static void setTaggedValue(Attribute att, String name, String value) throws EAException {
        EATaggedValue tv = new EATaggedValue(name, value);
        EAAttributeUtil.deleteTaggedValue(att, tv.getName());
        EAAttributeUtil.addTaggedValue(att, tv);
    }

    public static void setTaggedValues(Attribute att, List<EATaggedValue> tvs) throws EAException {
        for (EATaggedValue tv : tvs) {
            EAAttributeUtil.deleteTaggedValue(att, tv.getName());
        }
        EAAttributeUtil.addTaggedValues(att, tvs);
    }

    public static void setTaggedValues(Attribute att, TaggedValues tvs) throws EAException {
        for (String tvName : tvs.asMap().keySet()) {
            EAAttributeUtil.deleteTaggedValue(att, tvName);
        }
        EAAttributeUtil.addTaggedValues(att, tvs);
    }

    public static String taggedValue(Attribute att, String tvName) {
        Collection tvs = att.GetTaggedValues();
        for (AttributeTag tv : tvs) {
            if (!tvName.equals(tv.GetName())) continue;
            String v = tv.GetValue();
            if (v.equals("<memo>")) {
                v = tv.GetNotes();
            }
            return v;
        }
        return null;
    }

    public static SortedMap<String, EATaggedValue> getEATaggedValuesWithCombinedKeys(Attribute att) {
        TreeMap<String, EATaggedValue> result = new TreeMap<String, EATaggedValue>();
        Collection tvs = att.GetTaggedValues();
        for (short i = 0; i < tvs.GetCount(); i = (short)(i + 1)) {
            AttributeTag tv = (AttributeTag)tvs.GetAt(i);
            String name = tv.GetName();
            String fqName = tv.GetFQName();
            String tvValue = tv.GetValue();
            String value = tvValue.equals("<memo>") ? tv.GetNotes() : tvValue;
            String key = name + "#" + fqName;
            if (result.containsKey(key)) {
                EATaggedValue eatv = (EATaggedValue)result.get(key);
                eatv.addValue(value);
                continue;
            }
            result.put(key, new EATaggedValue(name, fqName, value));
        }
        return result;
    }

    public static SortedMap<String, EATaggedValue> getEATaggedValuesWithPlainKeys(Attribute att) {
        TreeMap<String, EATaggedValue> result = new TreeMap<String, EATaggedValue>();
        Collection tvs = att.GetTaggedValues();
        for (short i = 0; i < tvs.GetCount(); i = (short)(i + 1)) {
            AttributeTag tv = (AttributeTag)tvs.GetAt(i);
            String name = tv.GetName();
            String tvValue = tv.GetValue();
            String value = tvValue.equals("<memo>") ? tv.GetNotes() : tvValue;
            String key = name;
            if (result.containsKey(key)) {
                EATaggedValue eatv = (EATaggedValue)result.get(key);
                eatv.addValue(value);
                continue;
            }
            result.put(key, new EATaggedValue(name, value));
        }
        return result;
    }

    public static AttributeConstraint addConstraint(Attribute att, String name, String type, String text) throws EAException {
        Collection cons = att.GetConstraints();
        AttributeConstraint con = (AttributeConstraint)cons.AddNew(name, type);
        cons.Refresh();
        con.SetNotes(text);
        if (!con.Update()) {
            throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(108), name, att.GetName(), con.GetLastError()));
        }
        return con;
    }

    public static void updateTaggedValue(Attribute att, String name, String value, boolean createAsMemoField) throws EAException {
        boolean isQualifiedName = name.contains("::");
        Collection cTV = att.GetTaggedValues();
        cTV.Refresh();
        for (short i = 0; i < cTV.GetCount(); i = (short)(i + 1)) {
            AttributeTag tv = (AttributeTag)cTV.GetAt(i);
            if ((!isQualifiedName || !tv.GetFQName().equalsIgnoreCase(name)) && !tv.GetName().equalsIgnoreCase(name)) continue;
            if (createAsMemoField || value.length() > 255) {
                tv.SetValue("<memo>");
                tv.SetNotes(value);
            } else {
                tv.SetValue(value);
                tv.SetNotes("");
            }
            if (tv.Update()) continue;
            throw new EAException(EAAttributeUtil.createMessage(EAAttributeUtil.message(102), name, att.GetName(), value, tv.GetLastError()));
        }
        cTV.Refresh();
    }

    public static String message(int mnr) {
        switch (mnr) {
            case 101: {
                return "EA error encountered while updating 'AllowDuplicates' on EA attribute '$1$'. Error message is: $2$";
            }
            case 102: {
                return "EA error encountered while updating EA tagged value '$1$' on attribute '$2$' with value '$3$'. Error message is: $4$";
            }
            case 103: {
                return "EA error encountered while updating 'IsCollection' on EA attribute '$1$'. Error message is: $2$";
            }
            case 104: {
                return "EA error encountered while updating 'IsOrdered' on EA attribute '$1$'. Error message is: $2$";
            }
            case 105: {
                return "EA error encountered while updating 'Length' on EA attribute '$1$' with value '$2$'. Error message is: $3$";
            }
            case 106: {
                return "EA error encountered while updating 'Precision' on EA attribute '$1$'. Error message is: $2$";
            }
            case 107: {
                return "EA error encountered while updating 'Scale' on EA attribute '$1$'. Error message is: $2$";
            }
            case 108: {
                return "EA error encountered while updating new EA constraint '$1$' for attribute '$2$'. Error message is: $3$";
            }
        }
        return "(" + EAAttributeUtil.class.getName() + ") Unknown message with number: " + mnr;
    }
}

