/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util.docx;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.Parts;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.org.apache.poi.util.IOUtils;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTAltChunk;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.Text;

public class DocxUtil {
    private static final String CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";

    public static File merge(WordprocessingMLPackage topPackage, File bottomFile, File outputFile) throws Exception {
        return DocxUtil.mergeUsingCTAltChunk(topPackage, bottomFile, outputFile);
    }

    protected static File mergeUsingCTAltChunk(WordprocessingMLPackage topPackage, File bottomFile, File outputFile) throws Exception {
        FileInputStream bottomIs = new FileInputStream(bottomFile);
        MainDocumentPart topMainPart = topPackage.getMainDocumentPart();
        byte[] bottomAsBytes = IOUtils.toByteArray((InputStream)bottomIs);
        Parts docParts = topPackage.getParts();
        Set docPartsNames = docParts.getParts().keySet();
        HashSet<String> plainPartNames = new HashSet<String>();
        for (PartName pn : docPartsNames) {
            plainPartNames.add(pn.getName());
        }
        String partName = null;
        int index = 0;
        do {
            partName = "/part" + index + ".docx";
            ++index;
        } while (plainPartNames.contains(partName));
        AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(new PartName(partName));
        afiPart.setContentType(new ContentType(CONTENT_TYPE));
        afiPart.setBinaryData(bottomAsBytes);
        Relationship altChunkRel = topMainPart.addTargetPart((Part)afiPart);
        CTAltChunk chunk = Context.getWmlObjectFactory().createCTAltChunk();
        chunk.setId(altChunkRel.getId());
        topMainPart.addObject((Object)chunk);
        topMainPart.convertAltChunks();
        topPackage.save(outputFile);
        return outputFile;
    }

    public static P createPageBreak() {
        ObjectFactory wmlObjectFactory = new ObjectFactory();
        P p = wmlObjectFactory.createP();
        R r = wmlObjectFactory.createR();
        p.getContent().add(r);
        Br br = wmlObjectFactory.createBr();
        r.getContent().add(br);
        br.setType(STBrType.PAGE);
        return p;
    }

    public static P createHorizontalLine() {
        ObjectFactory wmlObjectFactory = new ObjectFactory();
        P p = wmlObjectFactory.createP();
        PPr ppr = wmlObjectFactory.createPPr();
        p.setPPr(ppr);
        PPrBase.PBdr pprbasepbdr = wmlObjectFactory.createPPrBasePBdr();
        ppr.setPBdr(pprbasepbdr);
        CTBorder border = wmlObjectFactory.createCTBorder();
        pprbasepbdr.setBottom(border);
        border.setVal(STBorder.SINGLE);
        border.setSz(BigInteger.valueOf(6L));
        border.setColor("auto");
        border.setSpace(BigInteger.valueOf(1L));
        return p;
    }

    public static P createText(String text) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        P p = factory.createP();
        if (text != null) {
            Text t = factory.createText();
            t.setValue(text);
            R run = factory.createR();
            run.getContent().add(t);
            p.getContent().add(run);
        }
        return p;
    }
}

