/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipHandler {
    public void unzip(File zipfile, File directory) throws Exception {
        ZipFile zipFile = new ZipFile(zipfile);
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            this.extractEntry(zipFile, zipEntry, directory);
        }
        zipFile.close();
    }

    public void zip(File directoryToZip, File toFile) throws Exception {
        FileOutputStream fos = new FileOutputStream(toFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        this.addDirectory(directoryToZip, zos, "");
        zos.close();
        fos.close();
    }

    public static void zipFile(File fileToZip, File toFile) throws IOException {
        int len;
        FileOutputStream fout = new FileOutputStream(toFile);
        ZipOutputStream zout = new ZipOutputStream(fout);
        byte[] tmpBuf = new byte[1024];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileToZip));
        zout.putNextEntry(new ZipEntry(fileToZip.getName()));
        while ((len = bis.read(tmpBuf)) != -1) {
            zout.write(tmpBuf, 0, len);
        }
        zout.closeEntry();
        bis.close();
        zout.close();
        fout.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEntry(ZipFile zipFile, ZipEntry entry, File destDir) throws IOException {
        byte[] buffer = new byte[65535];
        File file = new File(destDir, entry.getName());
        if (entry.isDirectory()) {
            file.mkdirs();
        } else {
            new File(file.getParent()).mkdirs();
            InputStream is = null;
            OutputStream os = null;
            try {
                int len;
                is = zipFile.getInputStream(entry);
                os = new FileOutputStream(file);
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    private void addDirectory(File dir, ZipOutputStream zout, String basePathSoFar) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (file.list() == null || file.list().length == 0) {
                        zout.putNextEntry(new ZipEntry(basePathSoFar + file.getName() + "/"));
                        zout.closeEntry();
                        continue;
                    }
                    this.addDirectory(file, zout, basePathSoFar + file.getName() + "/");
                    continue;
                }
                this.addFile(file, zout, basePathSoFar);
            }
        }
    }

    private void addFile(File fileToZip, ZipOutputStream zout, String basePath) throws IOException {
        int len;
        byte[] tmpBuf = new byte[1024];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileToZip));
        zout.putNextEntry(new ZipEntry(basePath + fileToZip.getName()));
        while ((len = bis.read(tmpBuf)) != -1) {
            zout.write(tmpBuf, 0, len);
        }
        zout.closeEntry();
        bis.close();
    }
}

