/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util;

import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Util.XsltUriResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class XsltWriter {
    public static Charset ENCODING_CHARSET = Charset.forName("UTF-8");
    public static final String PARAM_xslTransformerFactory = "-xslTransformerFactory";
    public static final String PARAM_hrefMappings = "-hrefMappings";
    public static final String PARAM_transformationParameters = "-transformationParameters";
    public static final String PARAM_transformationSourcePath = "-transformationSourcePath";
    public static final String PARAM_xsltMainFileUri = "-xsltMainFileUri";
    public static final String PARAM_transformationTargetPath = "-transformationTargetPath";
    private String xslTransformerFactory;
    private Map<String, URI> hrefMappings;
    private Map<String, String> transformationParameters = new HashMap<String, String>();
    private ShapeChangeResult result;

    public XsltWriter(String xslTransformerFactory, Map<String, URI> hrefMappings, Map<String, String> transformationParameters, ShapeChangeResult result) {
        this.xslTransformerFactory = xslTransformerFactory;
        this.hrefMappings = hrefMappings;
        if (transformationParameters != null) {
            this.transformationParameters = transformationParameters;
        }
        this.result = result;
    }

    public static void main(String[] args) {
        String xslTransformerFactory = null;
        String hrefMappingsString = null;
        String transformationParametersString = null;
        String transformationSourcePath = null;
        String xsltMainFileUriString = null;
        String transformationTargetPath = null;
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            arg = args[i];
            if (arg.equals(PARAM_xslTransformerFactory)) {
                if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                    System.err.println("No value provided for invocation parameter -xslTransformerFactory");
                    return;
                }
                xslTransformerFactory = args[i + 1];
                ++i;
                continue;
            }
            if (arg.equals(PARAM_hrefMappings)) {
                if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                    System.err.println("No value provided for invocation parameter -hrefMappings");
                    return;
                }
                hrefMappingsString = args[i + 1];
                ++i;
                continue;
            }
            if (arg.equals(PARAM_transformationParameters)) {
                if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                    System.err.println("No value provided for invocation parameter -transformationParameters");
                    return;
                }
                transformationParametersString = args[i + 1];
                ++i;
                continue;
            }
            if (arg.equals(PARAM_transformationSourcePath)) {
                if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                    System.err.println("No value provided for invocation parameter -transformationSourcePath");
                    return;
                }
                transformationSourcePath = args[i + 1];
                ++i;
                continue;
            }
            if (arg.equals(PARAM_transformationTargetPath)) {
                if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                    System.err.println("No value provided for invocation parameter -transformationTargetPath");
                    return;
                }
                transformationTargetPath = args[i + 1];
                ++i;
                continue;
            }
            if (!arg.equals(PARAM_xsltMainFileUri)) continue;
            if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                System.err.println("No value provided for invocation parameter -xsltMainFileUri");
                return;
            }
            xsltMainFileUriString = args[i + 1];
            ++i;
        }
        try {
            HashMap<String, URI> hrefMappings = new HashMap<String, URI>();
            if (hrefMappingsString != null) {
                List hrefMappingsList = URLEncodedUtils.parse(hrefMappingsString, (Charset)ENCODING_CHARSET);
                for (NameValuePair nvp : hrefMappingsList) {
                    hrefMappings.put(nvp.getName(), new URI(nvp.getValue()));
                }
            }
            HashMap<String, String> transformationParameters = new HashMap<String, String>();
            if (transformationParametersString != null) {
                List transParamList = URLEncodedUtils.parse(transformationParametersString, (Charset)ENCODING_CHARSET);
                for (NameValuePair nvp : transParamList) {
                    transformationParameters.put(nvp.getName(), nvp.getValue());
                }
            }
            boolean invalidParameters = false;
            if (transformationSourcePath == null) {
                invalidParameters = true;
                System.err.println("Path to transformation source file was not provided.");
            }
            if (xsltMainFileUriString == null) {
                invalidParameters = true;
                System.err.println("Path to main XSLT file was not provided.");
            }
            if (transformationTargetPath == null) {
                invalidParameters = true;
                System.err.println("Path to transformation target file was not provided.");
            }
            if (!invalidParameters) {
                XsltWriter writer = new XsltWriter(xslTransformerFactory, hrefMappings, transformationParameters, null);
                File transformationSource = new File(transformationSourcePath);
                URI xsltMainFileUri = new URI(xsltMainFileUriString);
                File transformationTarget = new File(transformationTargetPath);
                writer.xsltWrite(transformationSource, xsltMainFileUri, transformationTarget);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            } else {
                System.err.println("Exception occurred while processing the XSL transformation.");
            }
            e.printStackTrace(System.err);
        }
    }

    public void xsltWrite(File transformationSource, URI xsltMainFileUri, File transformationTarget) {
        try {
            InputStream stream = null;
            if (xsltMainFileUri.getScheme().startsWith("http")) {
                URL url = xsltMainFileUri.toURL();
                URLConnection urlConnection = url.openConnection();
                stream = urlConnection.getInputStream();
            } else {
                File xsl = new File(xsltMainFileUri);
                stream = new FileInputStream(xsl);
            }
            if (this.xslTransformerFactory != null) {
                System.setProperty("javax.xml.transform.TransformerFactory", this.xslTransformerFactory);
            }
            TransformerFactory transFact = TransformerFactory.newInstance();
            StreamSource xsltSource = new StreamSource(stream);
            xsltSource.setSystemId(xsltMainFileUri.toString());
            StreamSource xmlSource = new StreamSource(transformationSource);
            StreamResult res = transFact.getClass().getName().equalsIgnoreCase("org.apache.xalan.processor.TransformerFactoryImpl") ? new StreamResult(transformationTarget.getPath()) : new StreamResult(transformationTarget);
            transFact.setURIResolver(new XsltUriResolver(this.hrefMappings));
            Transformer trans = transFact.newTransformer(xsltSource);
            for (String key : this.transformationParameters.keySet()) {
                trans.setParameter(key, this.transformationParameters.get(key));
            }
            trans.transform(xmlSource, res);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                if (this.result != null) {
                    this.result.addError(m);
                } else {
                    System.err.println(m);
                }
            }
            String msg = "Exception occurred while processing the XSL transformation.";
            if (this.result != null) {
                this.result.addError(msg);
            }
            System.err.println(msg);
        }
    }
}

