/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class XsltUriResolver
implements URIResolver {
    private Map<String, URI> hrefMappings = null;

    public XsltUriResolver(Map<String, URI> hrefMappings) {
        this.hrefMappings = hrefMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Source resolve(String href, String base) throws TransformerException {
        InputStream inputStream = null;
        StreamSource source = null;
        try {
            if (this.hrefMappings != null && this.hrefMappings.containsKey(href)) {
                inputStream = this.hrefMappings.get(href).toURL().openStream();
                source = new StreamSource(inputStream);
                source.setSystemId(this.hrefMappings.get(href).toString());
                return source;
            } else if (base == null || base.trim().length() == 0) {
                URI resourceUri = new URI(href);
                if (!resourceUri.isAbsolute()) throw new TransformerException("Relative URI encountered by XsltUriResolver: " + href);
                inputStream = resourceUri.toURL().openStream();
                source = new StreamSource(inputStream);
                source.setSystemId(resourceUri.toString());
                return source;
            } else {
                URI resolvedUri = new URI(base).resolve(href);
                inputStream = resolvedUri.toURL().openStream();
                source = new StreamSource(inputStream);
                source.setSystemId(resolvedUri.toString());
            }
            return source;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

