/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util;

import de.interactive_instruments.ShapeChange.ModelDiff.DiffElement;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl {
    private State state = State.SEEN_NOTHING;
    private Stack<State> stateStack = new Stack();
    private boolean lastElementWasStart = false;
    private int indentStep = 2;
    private int depth = 0;
    private final Attributes EMPTY_ATTS = new AttributesImpl();
    private Hashtable<String, String> prefixTable;
    private Hashtable<String, Boolean> forcedDeclTable;
    private Hashtable<String, String> doneDeclTable;
    protected Writer output;
    private NamespaceSupport nsSupport;
    private int prefixCounter = 0;
    private String encoding;
    private String LINESEPARATOR = System.getProperty("line.separator");
    private StringBuilder sb;

    public XMLWriter(Writer writer, String encoding) {
        this.init(writer, encoding);
    }

    public XMLWriter(XMLReader xmlreader, Writer writer, String encoding) {
        super(xmlreader);
        this.init(writer, encoding);
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public void setIndentStep(int indentStep) {
        this.indentStep = indentStep;
    }

    private void init(Writer writer, String encoding) {
        this.setOutput(writer);
        this.encoding = encoding != null ? encoding : "UTF-8";
        this.nsSupport = new NamespaceSupport();
        this.prefixTable = new Hashtable();
        this.forcedDeclTable = new Hashtable();
        this.doneDeclTable = new Hashtable();
    }

    public void reset() {
        this.prefixCounter = 0;
        this.nsSupport.reset();
        this.depth = 0;
        this.state = State.SEEN_NOTHING;
        this.stateStack = new Stack();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void close() throws IOException {
        this.output.close();
    }

    protected void setOutput(Writer writer) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    public void setPrefix(String uri, String prefix) {
        this.prefixTable.put(uri, prefix);
    }

    public String getPrefix(String uri) {
        return this.prefixTable.get(uri);
    }

    public void forceNSDecl(String uri) {
        this.forcedDeclTable.put(uri, Boolean.TRUE);
    }

    public void forceNSDecl(String uri, String prefix) {
        this.setPrefix(uri, prefix);
        this.forceNSDecl(uri);
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        this.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
        this.newLine();
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.sb = new StringBuilder();
        this.stateStack.push(State.SEEN_ELEMENT);
        this.state = State.SEEN_NOTHING;
        this.lastElementWasStart = true;
        if (this.depth > 0) {
            this.newLine();
        }
        this.doIndent();
        ++this.depth;
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(uri, localName, qName, true);
        this.writeAttributes(atts);
        if (this.depth == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write('>');
        super.startElement(uri, localName, qName, atts);
    }

    public void startElement(String localName, String attributeName, String attributeValue) throws SAXException {
        this.startElement("", localName, attributeName, attributeValue);
    }

    public void startElement(String uri, String localName, String attributeName, String attributeValue) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", attributeName, "", "CDATA", attributeValue);
        this.startElement(uri, localName, "", atts);
    }

    public void startElement(String localName, String attributeName, String attributeValue, DiffElement.Operation op) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", attributeName, "", "CDATA", attributeValue);
        if (op != null) {
            atts.addAttribute("", "mode", "", "CDATA", op.toString());
        }
        this.startElement("", localName, "", atts);
    }

    private void newLine() throws SAXException {
        char[] tmp = this.LINESEPARATOR.toCharArray();
        this.write(this.LINESEPARATOR);
        super.characters(tmp, 0, tmp.length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        if (State.SEEN_ELEMENT.equals((Object)this.state)) {
            this.newLine();
            this.doIndent();
        } else if (this.lastElementWasStart && State.SEEN_DATA.equals((Object)this.state)) {
            String tmp = this.sb.toString();
            char[] newChars = tmp.toCharArray();
            this.writeEsc(newChars, 0, newChars.length, false);
            super.characters(newChars, 0, newChars.length);
        }
        this.write("</");
        this.writeName(uri, localName, qName, true);
        this.write('>');
        this.state = this.stateStack.pop();
        this.nsSupport.popContext();
        this.lastElementWasStart = false;
        super.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.lastElementWasStart) {
            this.state = State.SEEN_DATA;
            this.sb.append(ch, start, len);
        }
    }

    private void doIndent() throws SAXException {
        if (this.indentStep > 0 && this.depth > 0) {
            int n = this.indentStep * this.depth;
            char[] ch = new char[n];
            for (int i = 0; i < n; ++i) {
                ch[i] = 32;
            }
            this.writeEsc(ch, 0, ch.length, false);
            super.characters(ch, 0, ch.length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.write("<?");
        this.write(target);
        this.write(' ');
        this.write(data);
        this.write("?>");
        if (this.depth < 1) {
            this.newLine();
        }
        super.processingInstruction(target, data);
    }

    public void comment(String comment) throws SAXException {
        if (this.depth > 0) {
            this.newLine();
        }
        this.doIndent();
        this.write("<!--");
        this.write(comment);
        this.write("-->");
        this.newLine();
    }

    public void startElement(String uri, String localName) throws SAXException {
        this.startElement(uri, localName, "", this.EMPTY_ATTS);
    }

    public void startElement(String localName) throws SAXException {
        this.startElement("", localName, "", this.EMPTY_ATTS);
    }

    public void endElement(String uri, String localName) throws SAXException {
        this.endElement(uri, localName, "");
    }

    public void endElement(String localName) throws SAXException {
        this.endElement("", localName, "");
    }

    private void forceNSDecls() {
        Enumeration<String> prefixes = this.forcedDeclTable.keys();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            this.doPrefix(prefix, null, true);
        }
    }

    private String doPrefix(String uri, String qName, boolean isElement) {
        String defaultNS = this.nsSupport.getURI("");
        if ("".equals(uri)) {
            if (isElement && defaultNS != null) {
                this.nsSupport.declarePrefix("", "");
            }
            return null;
        }
        Object prefix = isElement && defaultNS != null && uri.equals(defaultNS) ? "" : this.nsSupport.getPrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.doneDeclTable.get(uri);
        if (prefix != null && ((!isElement || defaultNS != null) && "".equals(prefix) || this.nsSupport.getURI((String)prefix) != null)) {
            prefix = null;
        }
        if (prefix == null && (prefix = this.prefixTable.get(uri)) != null && ((!isElement || defaultNS != null) && "".equals(prefix) || this.nsSupport.getURI((String)prefix) != null)) {
            prefix = null;
        }
        if (prefix == null && qName != null && !"".equals(qName)) {
            int i = qName.indexOf(58);
            if (i == -1) {
                if (isElement && defaultNS == null) {
                    prefix = "";
                }
            } else {
                prefix = qName.substring(0, i);
            }
        }
        while (prefix == null || this.nsSupport.getURI((String)prefix) != null) {
            prefix = "__NS" + ++this.prefixCounter;
        }
        this.nsSupport.declarePrefix((String)prefix, uri);
        this.doneDeclTable.put(uri, (String)prefix);
        return prefix;
    }

    private void write(char c) throws SAXException {
        try {
            this.output.write(c);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void write(String s) throws SAXException {
        try {
            this.output.write(s);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeAttributes(Attributes atts) throws SAXException {
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            char[] ch = atts.getValue(i).toCharArray();
            this.write(' ');
            this.writeName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), false);
            this.write("=\"");
            this.writeEsc(ch, 0, ch.length, true);
            this.write('\"');
        }
    }

    private void writeEsc(char[] ch, int start, int length, boolean isAttVal) throws SAXException {
        block8: for (int i = start; i < start + length; ++i) {
            switch (ch[i]) {
                case '&': {
                    this.write("&amp;");
                    continue block8;
                }
                case '<': {
                    this.write("&lt;");
                    continue block8;
                }
                case '>': {
                    this.write("&gt;");
                    continue block8;
                }
                case '\r': {
                    this.write("&#xD;");
                    continue block8;
                }
                case '\n': {
                    this.write("&#xA;");
                    continue block8;
                }
                case '\"': {
                    if (isAttVal) {
                        this.write("&quot;");
                        continue block8;
                    }
                    this.write('\"');
                    continue block8;
                }
                default: {
                    this.write(ch[i]);
                }
            }
        }
    }

    private void writeNSDecls() throws SAXException {
        Enumeration<String> prefixes = this.nsSupport.getDeclaredPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            String uri = this.nsSupport.getURI(prefix);
            if (uri == null) {
                uri = "";
            }
            char[] ch = uri.toCharArray();
            this.write(' ');
            if ("".equals(prefix)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(prefix);
                this.write("=\"");
            }
            this.writeEsc(ch, 0, ch.length, true);
            this.write('\"');
        }
    }

    private void writeName(String uri, String localName, String qName, boolean isElement) throws SAXException {
        String prefix = this.doPrefix(uri, qName, isElement);
        if (prefix != null && !"".equals(prefix)) {
            this.write(prefix);
            this.write(':');
        }
        this.write(localName);
    }

    public void dataElement(String uri, String localName, String qName, Attributes atts, String content) throws SAXException {
        this.startElement(uri, localName, qName, atts);
        if (content != null) {
            this.characters(content);
        }
        this.endElement(uri, localName, qName);
    }

    public void emptyElement(String localName, Attributes atts) throws SAXException {
        this.emptyElement("", localName, "", atts);
    }

    public void emptyElement(String localName, String attributeName, String attributeValue) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", attributeName, "", "CDATA", attributeValue);
        this.emptyElement(localName, atts);
    }

    public void emptyElement(String localName, String attributeName, String attributeValue, DiffElement.Operation op) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", attributeName, "", "CDATA", attributeValue);
        if (op != null) {
            atts.addAttribute("", "mode", "", "CDATA", op.toString());
        }
        this.emptyElement(localName, atts);
    }

    public void emptyElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.startElement(uri, localName, qName, atts);
        this.endElement(uri, localName, qName);
    }

    public void dataElement(String uri, String localName, String content) throws SAXException {
        this.dataElement(uri, localName, "", this.EMPTY_ATTS, content);
    }

    public void dataElement(String localName, String content) throws SAXException {
        this.dataElement("", localName, "", this.EMPTY_ATTS, content);
    }

    public void dataElement(String localName, String content, DiffElement.Operation op) throws SAXException {
        if (op != null) {
            this.dataElement(localName, content, "mode", op.toString());
        } else {
            this.dataElement("", localName, "", this.EMPTY_ATTS, content);
        }
    }

    public void dataElement(String localName, String content, String attributeName, String attributeValue) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", attributeName, "", "CDATA", attributeValue);
        this.dataElement("", localName, "", atts, content);
    }

    public void dataElement(String uri, String localName, String content, String attributeName, String attributeValue) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", attributeName, "", "CDATA", attributeValue);
        this.dataElement(uri, localName, "", atts, content);
    }

    public void dataElement(String localName, String content, String attributeName, String attributeValue, DiffElement.Operation op) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", attributeName, "", "CDATA", attributeValue);
        if (op != null) {
            atts.addAttribute("", "mode", "", "CDATA", op.toString());
        }
        this.dataElement("", localName, "", atts, content);
    }

    public void characters(String data) throws SAXException {
        char[] ch = data.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    private static enum State {
        SEEN_NOTHING,
        SEEN_DATA,
        SEEN_ELEMENT;

    }
}

