/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util;

import de.interactive_instruments.ShapeChange.ShapeChangeErrorHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Element getFirstElement(Element parent, String elementName) {
        NodeList nl = parent.getElementsByTagName(elementName);
        if (nl != null && nl.getLength() != 0) {
            for (int k = 0; k < nl.getLength(); ++k) {
                Node n = nl.item(k);
                if (n.getNodeType() != 1) continue;
                return (Element)n;
            }
        }
        return null;
    }

    public static String getTextContentOfFirstElement(Element parent, String elementName) {
        Element e = XMLUtil.getFirstElement(parent, elementName);
        return e != null ? e.getTextContent() : null;
    }

    public static String getTrimmedTextContentOfFirstElement(Element parent, String elementName) {
        return StringUtils.trim((String)XMLUtil.getTextContentOfFirstElement(parent, elementName));
    }

    public static List<Element> getChildElements(Element parentElement, String elementName) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nl = parentElement.getElementsByTagName(elementName);
        if (nl != null && nl.getLength() != 0) {
            for (int k = 0; k < nl.getLength(); ++k) {
                Node n = nl.item(k);
                if (n.getNodeType() != 1) continue;
                result.add((Element)n);
            }
        }
        return result;
    }

    public static List<String> getTextContentOfChildElements(Element parentElement, String elementName) {
        ArrayList<String> result = new ArrayList<String>();
        List<Element> elements = XMLUtil.getChildElements(parentElement, elementName);
        for (Element e : elements) {
            result.add(e.getTextContent());
        }
        return result;
    }

    public static boolean parseBoolean(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return false;
        }
        return s.trim().equalsIgnoreCase("true") || s.trim().equals("1");
    }

    public static Document loadXml(String xmlPath) throws Exception {
        InputStream xmlStream = null;
        File file = new File(xmlPath);
        if (file == null || !file.exists()) {
            try {
                xmlStream = new URL(xmlPath).openStream();
            }
            catch (MalformedURLException e) {
                throw new Exception("No XML file found at " + xmlPath + " (malformed URL)");
            }
            catch (IOException e) {
                throw new Exception("No XML file found at " + xmlPath + " (IO exception)");
            }
        }
        try {
            xmlStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new Exception("No XML file found at " + xmlPath);
        }
        if (xmlStream == null) {
            throw new Exception("No XML file found at " + xmlPath);
        }
        DocumentBuilder builder = null;
        ShapeChangeErrorHandler handler = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setXIncludeAware(true);
            factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            builder = factory.newDocumentBuilder();
            handler = new ShapeChangeErrorHandler();
            builder.setErrorHandler(handler);
        }
        catch (FactoryConfigurationError e) {
            throw new Exception("Unable to get a document builder factory.");
        }
        catch (ParserConfigurationException e) {
            throw new Exception("XML Parser was unable to be configured.");
        }
        try {
            Document document = builder.parse(xmlStream);
            if (handler.errorsFound()) {
                throw new Exception("Invalid XML file.");
            }
            return document;
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                throw new Exception("Error while loading XML file: " + m);
            }
            e.printStackTrace(System.err);
            throw new Exception("Error while loading XML file");
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                throw new Exception("Error while loading XML file: " + m);
            }
            e.printStackTrace(System.err);
            throw new Exception("Error while loading XML file");
        }
    }

    public static void writeXml(Document doc, File destination) throws Exception {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            FileWriter writer = new FileWriter(destination);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new Exception("Error while writing XML file. Exception message is: " + e.getMessage(), e);
        }
    }

    public static List<Element> getElementNodes(NodeList nl) {
        ArrayList<Element> result = new ArrayList<Element>();
        if (nl != null && nl.getLength() != 0) {
            for (int k = 0; k < nl.getLength(); ++k) {
                Node n = nl.item(k);
                if (n.getNodeType() != 1) continue;
                result.add((Element)n);
            }
        }
        return result;
    }

    public static void addAttribute(Document document, Element e, String attName, String attValue) {
        Attr att = document.createAttribute(attName);
        att.setValue(attValue);
        e.setAttributeNode(att);
    }
}

