/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ValueTypeOptions {
    protected SortedMap<String, SortedSet<String>> valueTypeOptionsByPropName = new TreeMap<String, SortedSet<String>>();
    protected SortedSet<String> associationClassRoles = new TreeSet<String>();

    public ValueTypeOptions() {
    }

    public ValueTypeOptions(String vto_tag_value) {
        if (StringUtils.isNotBlank((CharSequence)vto_tag_value)) {
            String[] propValueTypeOptions;
            for (String propValueTypeOption : propValueTypeOptions = StringUtils.split((String)vto_tag_value, (String)";")) {
                String[] optionFacets = StringUtils.split((String)propValueTypeOption, (String)"=");
                String propertyNamePart = optionFacets[0].trim();
                String propertyName = null;
                if (propertyNamePart.contains("(")) {
                    int bracketStartIndex = propertyNamePart.indexOf("(");
                    propertyName = propertyNamePart.substring(0, bracketStartIndex);
                    String qualifier = propertyNamePart.substring(bracketStartIndex + 1, propertyNamePart.length() - 1);
                    if ("associationClassRole".equalsIgnoreCase(qualifier)) {
                        this.associationClassRoles.add(propertyName);
                    }
                } else {
                    propertyName = propertyNamePart;
                }
                SortedSet valueTypes = Arrays.stream(optionFacets[1].split(",")).map(s -> s.trim()).collect(Collectors.toCollection(TreeSet::new));
                this.valueTypeOptionsByPropName.put(propertyName, valueTypes);
            }
        }
    }

    public void setAssociationClassRole(String propertyName) {
        this.associationClassRoles.add(propertyName);
    }

    public boolean isAssociationClassRole(String propertyName) {
        return this.associationClassRoles.contains(propertyName);
    }

    public boolean hasValueTypeOptions(String propertyName) {
        return this.valueTypeOptionsByPropName.containsKey(propertyName);
    }

    public SortedSet<String> getValueTypeOptions(String propertyName) {
        return (SortedSet)this.valueTypeOptionsByPropName.get(propertyName);
    }

    public Set<String> getPropertiesWithValueTypeOptions() {
        return this.valueTypeOptionsByPropName.keySet();
    }

    public boolean isEmpty() {
        return this.valueTypeOptionsByPropName.isEmpty();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, SortedSet<String>> e : this.valueTypeOptionsByPropName.entrySet()) {
            String propertyName = e.getKey();
            SortedSet<String> valueTypeOptions = e.getValue();
            boolean isAssociationClassRole = this.associationClassRoles.contains(propertyName);
            sb.append(propertyName);
            if (isAssociationClassRole) {
                sb.append("(").append("associationClassRole").append(")");
            }
            sb.append("=");
            sb.append(String.join((CharSequence)",", valueTypeOptions));
            sb.append(";");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void add(String propertyName, boolean isAssociationClassRole, SortedSet<String> valueTypeOptions) {
        this.valueTypeOptionsByPropName.put(propertyName, valueTypeOptions);
        if (isAssociationClassRole) {
            this.associationClassRoles.add(propertyName);
        }
    }

    public void remove(String propertyName) {
        this.associationClassRoles.remove(propertyName);
        this.valueTypeOptionsByPropName.remove(propertyName);
    }
}

