/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class ShapeChangeClassFinder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<?>> findClassesImplementing(String interfaceName) {
        String[] packageBlacklist = null;
        InputStream stream = ShapeChangeClassFinder.class.getResourceAsStream("/sc.properties");
        if (stream != null) {
            Properties properties = new Properties();
            try {
                properties.load(stream);
                packageBlacklist = properties.getProperty("sc.targetScanBlacklistPackages").split(",");
            }
            catch (IOException e) {
                System.err.println("Could not load sc.properties file and property sc.targetScanBlacklistPackages. Reverting to default package blacklist.");
                packageBlacklist = new String[]{"java.*", "antlr*", "com.fasterxml.*", "com.github.andrewoma.*", "com.github.jsonldjava.*", "com.google.*", "com.graphbuilder.*", "com.ibm.*", "com.microsoft.*", "com.sun.*", "com.thedeanda*", "com.topologi.*", "io.github.classgraph*", "java_cup*", "javax.*", "junit.*", "name.fraser*", "net.arnx*", "net.engio*", "net.sf.saxon*", "nonapi.io.github.classgraph.*", "org.antlr.*", "org.apache.*", "org.checkerframework.*", "org.codehaus.jackson*", "org.codehaus.mojo*", "org.custommonkey*", "org.docx4j*", "org.eclipse.*", "org.etsi.uri.*", "org.glox4j.*", "org.hamcrest*", "org.jgrapht*", "org.jheaps*", "org.json*", "org.junit*", "org.jvunit*", "org.jvnet", "org.merlin*", "org.opendope.*", "org.openxmlformats.*", "org.plutext*", "org.pptx4j*", "org.slf4j*", "org.sparx*", "org.w3*", "org.xlsx4j.*", "org.xml*", "schemaorg_apache_xmlbeans.*"};
            }
        }
        long scanStart = System.currentTimeMillis();
        try (ScanResult scanResult = null;){
            scanResult = new ClassGraph().enableAllInfo().blacklistPackages(packageBlacklist).scan();
            long scanTime = (System.currentTimeMillis() - scanStart) / 1000L;
            ClassInfoList targetClassInfos = scanResult.getClassesImplementing(interfaceName).filter(classInfo -> !classInfo.isInterface() && !classInfo.isAbstract());
            List list = targetClassInfos.loadClasses();
            return list;
        }
    }
}

