/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Util;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import org.apache.commons.lang3.StringUtils;

public class ArcGISUtil {
    public static boolean hasArcGISDefaultSubtypeAttribute(ClassInfo ci) {
        for (PropertyInfo pi : ci.properties().values()) {
            if (!StringUtils.isNotBlank((CharSequence)pi.taggedValue("arcgisDefaultSubtype"))) continue;
            return true;
        }
        return false;
    }

    public static boolean isArcGISSubtype(ClassInfo ci) {
        Model model = ci.model();
        for (String supertypeID : ci.supertypes()) {
            ClassInfo supertype = model.classById(supertypeID);
            if (supertype == null || !ArcGISUtil.hasArcGISDefaultSubtypeAttribute(supertype)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasArcGISSubtype(ClassInfo ci) {
        Model model = ci.model();
        for (String subtypeID : ci.subtypes()) {
            ClassInfo subtype = model.classById(subtypeID);
            if (subtype == null || !ArcGISUtil.isArcGISSubtype(subtype)) continue;
            return true;
        }
        return false;
    }
}

