/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.TaggedValueConfigurationEntry;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class TransformerConfiguration
extends ProcessConfiguration {
    private String id;
    private String inputId;
    private Map<String, Map<String, ProcessMapEntry>> mapEntriesByRule = new HashMap<String, Map<String, ProcessMapEntry>>();
    private List<TaggedValueConfigurationEntry> taggedValues;

    public TransformerConfiguration(String id, String className, ProcessMode processMode, Map<String, String> parameters, Map<String, ProcessRuleSet> ruleSets, List<ProcessMapEntry> mapEntries, List<TaggedValueConfigurationEntry> taggedValues, String inputId, Element advancedProcessConfigurations) {
        super(className, processMode, parameters, ruleSets, mapEntries, advancedProcessConfigurations);
        this.id = id;
        this.inputId = inputId;
        if (mapEntries != null) {
            for (ProcessMapEntry mapEntry : mapEntries) {
                if (!this.mapEntriesByRule.containsKey(mapEntry.getRule())) {
                    this.mapEntriesByRule.put(mapEntry.getRule(), new HashMap());
                }
                this.mapEntriesByRule.get(mapEntry.getRule()).put(mapEntry.getType(), mapEntry);
            }
        }
        this.taggedValues = taggedValues;
    }

    public String getId() {
        return this.id;
    }

    public String getInputId() {
        return this.inputId;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TransformerConfiguration:\r\n");
        sb.append("\tid: " + this.id);
        sb.append("--- with process configuration:\r\n");
        sb.append(super.toString());
        return sb.toString();
    }

    public ProcessMapEntry getMappingForType(String rule, String type) {
        if (rule == null || type == null) {
            return null;
        }
        Map<String, ProcessMapEntry> pme = this.mapEntriesByRule.get(rule);
        if (pme == null) {
            return null;
        }
        return pme.get(type);
    }

    public boolean hasMappingForType(String rule, String type) {
        if (this.mapEntriesByRule.containsKey(rule)) {
            return this.mapEntriesByRule.get(rule).get(type) != null;
        }
        return false;
    }

    public boolean hasTaggedValues() {
        return this.taggedValues != null;
    }

    public List<TaggedValueConfigurationEntry> getTaggedValues() {
        return this.taggedValues;
    }

    public List<TargetConfiguration> getAllTargets() {
        ArrayList<TargetConfiguration> targets = new ArrayList<TargetConfiguration>();
        if (this.getTargets() != null) {
            targets.addAll(this.getTargets());
        }
        if (this.getTransformers() != null) {
            for (TransformerConfiguration trfChild : this.getTransformers()) {
                List<TargetConfiguration> targetsOftrfChild = trfChild.getAllTargets();
                targets.addAll(targetsOftrfChild);
            }
        }
        return targets;
    }

    public boolean hasRule(String ruleID) {
        return this.getAllRules().contains(ruleID);
    }
}

