/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.TypeConversion;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TypeConverterConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("defaultMetadataType", "defaultVoidReasonType", "attributeNameSuffix", "attributeType", "toCodelistExclusionRegex", "metadataPropertyInlineOrByReference", "metadataPropertyNameSuffix", "nilReasonPropertyNameSuffix", "toFeatureTypeNameRegex", "toFeatureTypeTaggedValueName").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        String mdpInlineOrByRef;
        TransformerConfiguration trfConfig = (TransformerConfiguration)config;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTransformerParameters());
        boolean bl = isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        if (trfConfig.hasParameter("metadataPropertyInlineOrByReference") && !"inlineOrByReference".equalsIgnoreCase(mdpInlineOrByRef = config.parameterAsString("metadataPropertyInlineOrByReference", "inlineOrByReference", false, true)) && !"byReference".equalsIgnoreCase(mdpInlineOrByRef) && !"inline".equalsIgnoreCase(mdpInlineOrByRef)) {
            result.addError(this, 101, mdpInlineOrByRef, "metadataPropertyInlineOrByReference", "inline, byReference, inlineOrByReference");
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 10: {
                return "Syntax exception for regular expression '$1$' of parameter '$2$'. Message is: $3$.";
            }
            case 100: {
                return "Parameter '$1$' is required for rule '$2$' but no actual value was found in the configuration.";
            }
            case 101: {
                return "Value '$1$' of parameter '$2$' is not allowed. It must be one of: $3$";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

