/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.TypeConversion;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericAssociationInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class TypeConverter
implements Transformer,
MessageSource {
    public static final String TV_DISSOLVE_ASSOCIATION = "dissolveAssociation";
    public static final String TV_TO_CODELIST = "toCodelist";
    public static final String TV_DISSOLVE_ASSOCIATION_ATTRIBUTE_TYPE = "dissolveAssociationAttributeType";
    public static final String TV_DISSOLVE_ASSOCIATION_IORBR = "dissolveAssociationInlineOrByReference";
    public static final String PARAM_DISSOLVE_ASSOCIATIONS_ATTRIBUTE_NAME_SUFFIX = "attributeNameSuffix";
    public static final String PARAM_DISSOLVE_ASSOCIATIONS_ATTRIBUTE_TYPE = "attributeType";
    public static final String DEFAULT_DISSOLVE_ASSOCIATIONS_ATTRIBUTE_TYPE = "CharacterString";
    public static final String PARAM_TO_FEATURE_TYPE_NAME_REGEX = "toFeatureTypeNameRegex";
    public static final String PARAM_ENUMERATION_TO_CODELIST_EXCLUSION_REGEX = "toCodelistExclusionRegex";
    public static final String PARAM_TO_FEATURE_TYPE_TAGGED_VALUE_NAME = "toFeatureTypeTaggedValueName";
    public static final String RULE_ENUMERATION_TO_CODELIST = "rule-trf-enumeration-to-codelist";
    public static final String RULE_TO_FEATURETYPE = "rule-trf-toFeatureType";
    public static final String RULE_OBJECTTYPES_TO_FEATURETYPES = "rule-trf-objectTypesToFeatureTypes";
    public static final String RULE_SWITCH_VALUE_TYPES = "rule-trf-switchValueTypes";
    public static final String RULE_DISSOLVE_ASSOCIATIONS = "rule-trf-dissolveAssociations";
    public static final String RULE_DISSOLVE_ASSOCIATIONS_EXCLUDE_MANYTOMANY_RELATIONSHIPS = "rule-trf-dissolveAssociations-excludeManyToManyRelationships";
    public static final String RULE_DISSOLVE_ASSOCIATIONS_REMOVE_TRANSFORMED_ROLE_IF_MULTIPLE = "rule-trf-dissolveAssociations-removeTransformedAttributeIfMultiple";
    public static final String RULE_DISSOLVE_ASSOCIATIONS_KEEP_TYPE = "rule-trf-dissolveAssociations-keepType";
    public static final String RULE_PROPERTYMETADATA_STEREOTYPE_TO_PROPERTY = "rule-trf-propertyMetadata-stereotype-to-metadata-property";
    public static final String PARAM_DEFAULT_METADATA_TYPE = "defaultMetadataType";
    public static final String PARAM_METADATA_PROPERTY_NAME_SUFFIX = "metadataPropertyNameSuffix";
    public static final String PARAM_METADATA_PROPERTY_INLINEORBYREFERENCE = "metadataPropertyInlineOrByReference";
    public static final String RULE_NILREASON_PROPERTY_FOR_NILLABLE_PROPERTY = "rule-trf-nilReason-property-for-nillable-property";
    public static final String PARAM_NILREASON_PROPERTY_NAME_SUFFIX = "nilReasonPropertyNameSuffix";
    public static final String PARAM_DEFAULT_VOID_REASON_TYPE = "defaultVoidReasonType";
    private GenericModel genModel = null;
    private Options options = null;
    private TransformerConfiguration trfConfig = null;
    private ShapeChangeResult result = null;

    @Override
    public void process(GenericModel genModel, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.genModel = genModel;
        this.options = options;
        this.trfConfig = trfConfig;
        this.result = result;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (rules.isEmpty()) {
            return;
        }
        if (rules.contains(RULE_ENUMERATION_TO_CODELIST)) {
            result.addProcessFlowInfo(null, 20103, RULE_ENUMERATION_TO_CODELIST);
            this.applyRuleEnumerationToCodelist(genModel, trfConfig);
        }
        if (rules.contains(RULE_DISSOLVE_ASSOCIATIONS)) {
            result.addProcessFlowInfo(null, 20103, RULE_DISSOLVE_ASSOCIATIONS);
            this.applyRuleDissolveAssociations(genModel, trfConfig);
        }
        if (rules.contains(RULE_TO_FEATURETYPE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TO_FEATURETYPE);
            this.applyRuleToFeatureType(genModel, trfConfig);
        }
        if (rules.contains(RULE_OBJECTTYPES_TO_FEATURETYPES)) {
            result.addProcessFlowInfo(null, 20103, RULE_OBJECTTYPES_TO_FEATURETYPES);
            this.applyRuleObjectTypesToFeatureTypes();
        }
        if (rules.contains(RULE_PROPERTYMETADATA_STEREOTYPE_TO_PROPERTY)) {
            result.addProcessFlowInfo(null, 20103, RULE_PROPERTYMETADATA_STEREOTYPE_TO_PROPERTY);
            this.applyRulePropertyMetadataStereotypeToProperty();
        }
        if (rules.contains(RULE_NILREASON_PROPERTY_FOR_NILLABLE_PROPERTY)) {
            result.addProcessFlowInfo(null, 20103, RULE_NILREASON_PROPERTY_FOR_NILLABLE_PROPERTY);
            this.applyRuleNilReasonPropertyForNillableProperty();
        }
        if (rules.contains(RULE_SWITCH_VALUE_TYPES)) {
            result.addProcessFlowInfo(null, 20103, RULE_SWITCH_VALUE_TYPES);
            this.applyRuleSwitchValueTypes();
        }
    }

    private void applyRuleSwitchValueTypes() {
        List<ProcessMapEntry> mapEntries = this.trfConfig.getMapEntries();
        for (ProcessMapEntry pme : mapEntries) {
            String type = pme.getType();
            String target = pme.getTargetType();
            Type targetType = this.genModel.typeByName(target);
            for (GenericPropertyInfo genPi : this.genModel.selectedSchemaProperties()) {
                if (genPi.inClass().category() == 2 || genPi.inClass().category() == 3 || !genPi.typeInfo().name.equals(type)) continue;
                genPi.copyTypeInfo(targetType);
                if (genPi.isAttribute()) continue;
                GenericClassInfo targetCi = (GenericClassInfo)this.genModel.classById(targetType.id);
                if (targetCi == null) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 400, target);
                    if (mc == null) continue;
                    mc.addDetail(this, 0, genPi.fullName());
                    continue;
                }
                GenericAssociationInfo ai = (GenericAssociationInfo)genPi.association();
                GenericPropertyInfo otherEnd = ai.end1() == genPi ? (GenericPropertyInfo)ai.end2() : (GenericPropertyInfo)ai.end1();
                GenericClassInfo otherEndInClass = (GenericClassInfo)otherEnd.inClass();
                if (otherEndInClass != null) {
                    otherEnd.setInClass(targetCi);
                }
                if (!otherEnd.isNavigable()) continue;
                otherEndInClass.removePropertyById(otherEnd.id());
                targetCi.addPropertyAtBottom(otherEnd, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
            }
        }
    }

    private void applyRuleNilReasonPropertyForNillableProperty() {
        String paramDefaultVoidReasonType = this.trfConfig.parameterAsString(PARAM_DEFAULT_VOID_REASON_TYPE, null, false, true);
        ClassInfo defaultVoidReasonType = null;
        if (paramDefaultVoidReasonType != null && (defaultVoidReasonType = paramDefaultVoidReasonType.contains(":") ? this.genModel.classByFullNameInSchema(paramDefaultVoidReasonType) : this.genModel.classByName(paramDefaultVoidReasonType)) == null) {
            this.result.addWarning(this, 300, paramDefaultVoidReasonType);
        }
        Type characterStringType = Type.from(DEFAULT_DISSOLVE_ASSOCIATIONS_ATTRIBUTE_TYPE, this.genModel);
        String nameSuffix = this.trfConfig.parameterAsString(PARAM_NILREASON_PROPERTY_NAME_SUFFIX, "_nilReason", false, true);
        SortedSet<GenericClassInfo> selCis = this.genModel.selectedSchemaClasses();
        for (GenericClassInfo genCi : selCis) {
            ArrayList<PropertyInfo> classPis = new ArrayList<PropertyInfo>(genCi.properties().values());
            ArrayList<GenericPropertyInfo> newPisToAdd = new ArrayList<GenericPropertyInfo>();
            for (PropertyInfo pi : classPis) {
                Type nilReasonPropValueType;
                if (!pi.voidable()) continue;
                ClassInfo voidReasonType = null;
                String vrtTv = pi.taggedValue("voidReasonType");
                if (StringUtils.isNotBlank((CharSequence)vrtTv)) {
                    String className = vrtTv.trim();
                    if (className.contains(":")) {
                        voidReasonType = this.genModel.classByFullNameInSchema(className);
                    } else {
                        PackageInfo schemaPkg = this.genModel.schemaPackage(genCi);
                        if (schemaPkg != null) {
                            voidReasonType = this.genModel.classes(schemaPkg).stream().filter(ci -> ci.name().equals(className)).findFirst().orElse(null);
                        }
                    }
                }
                if (voidReasonType == null) {
                    voidReasonType = defaultVoidReasonType;
                }
                if (voidReasonType == null) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 301, pi.name(), genCi.name());
                    if (mc != null) {
                        mc.addDetail(this, 0, pi.fullNameInSchema());
                    }
                    nilReasonPropValueType = characterStringType.createCopy();
                } else {
                    nilReasonPropValueType = new Type(voidReasonType.id(), voidReasonType.name());
                }
                GenericPropertyInfo vrtPi = new GenericPropertyInfo(this.genModel, pi.id() + "_nilReasonProperty", pi.name() + nameSuffix);
                vrtPi.setCardinality(new Multiplicity(0, 1));
                vrtPi.setTypeInfo(nilReasonPropValueType);
                vrtPi.setInClass(genCi);
                vrtPi.setTaggedValue("inlineOrByReference", "inline", true);
                vrtPi.setSequenceNumber(pi.sequenceNumber().createCopyWithSuffix(1), true);
                newPisToAdd.add(vrtPi);
            }
            genCi.addPropertiesInSequence(newPisToAdd, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
        }
    }

    private void applyRulePropertyMetadataStereotypeToProperty() {
        String paramMetadataType = this.trfConfig.parameterAsString(PARAM_DEFAULT_METADATA_TYPE, "MD_Metadata", false, true);
        ClassInfo defaultMetadataType = null;
        defaultMetadataType = paramMetadataType.contains(":") ? this.genModel.classByFullNameInSchema(paramMetadataType) : this.genModel.classByName(paramMetadataType);
        if (defaultMetadataType == null) {
            this.result.addWarning(this, 200, paramMetadataType);
        }
        String nameSuffix = this.trfConfig.parameterAsString(PARAM_METADATA_PROPERTY_NAME_SUFFIX, "_metadata", false, true);
        String inlineOrByReference = this.trfConfig.parameterAsString(PARAM_METADATA_PROPERTY_INLINEORBYREFERENCE, "inlineOrByReference", false, true);
        SortedSet<GenericClassInfo> selCis = this.genModel.selectedSchemaClasses();
        for (GenericClassInfo genCi : selCis) {
            ArrayList<PropertyInfo> classPis = new ArrayList<PropertyInfo>(genCi.properties().values());
            ArrayList<GenericPropertyInfo> newPisToAdd = new ArrayList<GenericPropertyInfo>();
            for (PropertyInfo pi : classPis) {
                if (!pi.propertyMetadata()) continue;
                pi.stereotypes().remove("propertymetadata");
                ClassInfo mdt = pi.propertyMetadataType();
                if (mdt == null) {
                    mdt = defaultMetadataType;
                }
                if (mdt == null) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 201, pi.name(), genCi.name());
                    if (mc == null) continue;
                    mc.addDetail(this, 0, pi.fullNameInSchema());
                    continue;
                }
                GenericPropertyInfo mdPi = new GenericPropertyInfo(this.genModel, pi.id() + "_metadataProperty", pi.name() + nameSuffix);
                mdPi.setCardinality(new Multiplicity(0, 1));
                mdPi.setTypeInfo(new Type(mdt.id(), mdt.name()));
                mdPi.setInClass(genCi);
                mdPi.setSequenceNumber(pi.sequenceNumber().createCopyWithSuffix(1), true);
                newPisToAdd.add(mdPi);
                if (mdt.category() == 1 || mdt.category() == 6) {
                    mdPi.setAttribute(false);
                    mdPi.setTaggedValue("inlineOrByReference", inlineOrByReference, true);
                    String otherRoleIdAndName = pi.id() + "_metadataProperty_otherRole";
                    GenericPropertyInfo otherRole = new GenericPropertyInfo(this.genModel, otherRoleIdAndName, otherRoleIdAndName);
                    otherRole.setNavigable(false);
                    otherRole.setAttribute(false);
                    otherRole.setCardinality(new Multiplicity("0..*"));
                    otherRole.setTypeInfo(new Type(genCi.id(), genCi.name()));
                    otherRole.setInClass(mdt);
                    otherRole.setSequenceNumber(new StructuredNumber(otherRole.getNextNumberForAssociationRoleWithoutExplicitSequenceNumber()), true);
                    this.genModel.register(otherRole);
                    GenericAssociationInfo genAi = new GenericAssociationInfo();
                    genAi.setId("association_for_" + mdPi.id());
                    genAi.setEnd1(mdPi);
                    mdPi.setAssociation(genAi);
                    genAi.setEnd2(otherRole);
                    otherRole.setAssociation(genAi);
                    genAi.setModel(this.genModel);
                    genAi.setOptions(this.options);
                    genAi.setResult(this.result);
                    this.genModel.addAssociation(genAi);
                    continue;
                }
                mdPi.setTaggedValue("inlineOrByReference", "inline", true);
            }
            genCi.addPropertiesInSequence(newPisToAdd, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
        }
    }

    private void applyRuleObjectTypesToFeatureTypes() {
        TreeSet<GenericClassInfo> relevantTypes = new TreeSet<GenericClassInfo>();
        SortedSet<GenericClassInfo> selCis = this.genModel.selectedSchemaClasses();
        for (GenericClassInfo genCi : selCis) {
            if (genCi.category() != 6) continue;
            relevantTypes.add(genCi);
            SortedSet<ClassInfo> allSubtypes = genCi.subtypesInCompleteHierarchy();
            for (ClassInfo subtype : allSubtypes) {
                if (!selCis.contains(subtype)) continue;
                relevantTypes.add((GenericClassInfo)subtype);
            }
        }
        for (GenericClassInfo type : relevantTypes) {
            Stereotypes stereo = this.options.stereotypesFactory();
            stereo.add("featuretype");
            type.setStereotypes(stereo);
            type.setCategory(1);
        }
    }

    private void applyRuleToFeatureType(GenericModel genModel, TransformerConfiguration trfConfig) {
        String typeNameRegexParamValue = trfConfig.parameterAsString(PARAM_TO_FEATURE_TYPE_NAME_REGEX, null, false, true);
        String toFeatureTypeTVName = trfConfig.parameterAsString(PARAM_TO_FEATURE_TYPE_TAGGED_VALUE_NAME, "toFeatureType", false, true);
        try {
            Pattern typeNameRegex = null;
            if (typeNameRegexParamValue != null) {
                typeNameRegex = Pattern.compile(typeNameRegexParamValue);
            }
            TreeSet<GenericClassInfo> relevantTypes = new TreeSet<GenericClassInfo>();
            SortedSet<GenericClassInfo> selCis = genModel.selectedSchemaClasses();
            for (GenericClassInfo genCi : selCis) {
                if ((typeNameRegex == null || !typeNameRegex.matcher(genCi.name()).matches()) && !"true".equalsIgnoreCase(genCi.taggedValue(toFeatureTypeTVName))) continue;
                relevantTypes.add(genCi);
                SortedSet<ClassInfo> allSubtypes = genCi.subtypesInCompleteHierarchy();
                for (ClassInfo subtype : allSubtypes) {
                    if (!selCis.contains(subtype)) continue;
                    relevantTypes.add((GenericClassInfo)subtype);
                }
            }
            for (GenericClassInfo type : relevantTypes) {
                Stereotypes stereo = this.options.stereotypesFactory();
                stereo.add("featuretype");
                type.setStereotypes(stereo);
                type.setCategory(1);
            }
        }
        catch (PatternSyntaxException e) {
            this.result.addError(this, 10, typeNameRegexParamValue, PARAM_TO_FEATURE_TYPE_NAME_REGEX, e.getMessage(), RULE_TO_FEATURETYPE);
        }
    }

    private void applyRuleDissolveAssociations(GenericModel genModel, TransformerConfiguration trfConfig) {
        String attributeNameSuffix = trfConfig.parameterAsString(PARAM_DISSOLVE_ASSOCIATIONS_ATTRIBUTE_NAME_SUFFIX, "", false, true);
        String attributeTypeName = trfConfig.parameterAsString(PARAM_DISSOLVE_ASSOCIATIONS_ATTRIBUTE_TYPE, DEFAULT_DISSOLVE_ASSOCIATIONS_ATTRIBUTE_TYPE, false, true);
        Type attributeTypeFromParameter = genModel.typeByName(attributeTypeName);
        boolean keepType = trfConfig.hasRule(RULE_DISSOLVE_ASSOCIATIONS_KEEP_TYPE);
        TreeSet<GenericAssociationInfo> associations = new TreeSet<GenericAssociationInfo>();
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if (genPi.isAttribute()) continue;
            associations.add((GenericAssociationInfo)genPi.association());
        }
        TreeSet<GenericAssociationInfo> associationsToExclude = new TreeSet<GenericAssociationInfo>();
        for (GenericAssociationInfo genAi : associations) {
            if ("false".equalsIgnoreCase(genAi.taggedValue(TV_DISSOLVE_ASSOCIATION))) {
                associationsToExclude.add(genAi);
            }
            if (!trfConfig.hasRule(RULE_DISSOLVE_ASSOCIATIONS_EXCLUDE_MANYTOMANY_RELATIONSHIPS) || genAi.end1().isNavigable() && genAi.end1().cardinality().maxOccurs <= 1 || genAi.end2().isNavigable() && genAi.end2().cardinality().maxOccurs <= 1) continue;
            associationsToExclude.add(genAi);
        }
        associations.removeAll(associationsToExclude);
        for (GenericAssociationInfo genAi : associations) {
            ShapeChangeResult.MessageContext mc;
            if (genAi.assocClass() != null && (mc = this.result.addWarning(this, 100, genAi.assocClass().name())) != null) {
                mc.addDetail(this, 2, genAi.assocClass().fullNameInSchema());
            }
            GenericPropertyInfo end1 = (GenericPropertyInfo)genAi.end1();
            GenericPropertyInfo end2 = (GenericPropertyInfo)genAi.end2();
            genModel.dissolveAssociation(genAi);
            if (end1.isNavigable()) {
                this.handleAttributeAfterDissolvingAssociation(end1, attributeTypeFromParameter, attributeNameSuffix, keepType);
            }
            if (!end2.isNavigable()) continue;
            this.handleAttributeAfterDissolvingAssociation(end2, attributeTypeFromParameter, attributeNameSuffix, keepType);
        }
    }

    private void handleAttributeAfterDissolvingAssociation(GenericPropertyInfo attribute, Type attributeTypeFromParameter, String attributeNameSuffix, boolean keepType) {
        if (attribute.cardinality().maxOccurs > 1 && this.trfConfig.hasRule(RULE_DISSOLVE_ASSOCIATIONS_REMOVE_TRANSFORMED_ROLE_IF_MULTIPLE)) {
            this.genModel.remove(attribute, false);
        } else {
            String newIobr;
            Type newAttributeType = attributeTypeFromParameter;
            String dissolveAssociationAttributeType = attribute.taggedValue(TV_DISSOLVE_ASSOCIATION_ATTRIBUTE_TYPE);
            if (StringUtils.isNotBlank((CharSequence)dissolveAssociationAttributeType)) {
                newAttributeType = this.genModel.typeByName(dissolveAssociationAttributeType);
            }
            attribute.setName(attribute.name() + attributeNameSuffix);
            if (!keepType) {
                attribute.setTypeInfo(newAttributeType.createCopy());
            }
            if (StringUtils.isNotBlank((CharSequence)(newIobr = attribute.taggedValue(TV_DISSOLVE_ASSOCIATION_IORBR)))) {
                attribute.setTaggedValue("inlineOrByReference", newIobr, true);
            }
        }
    }

    private void applyRuleEnumerationToCodelist(GenericModel genModel, TransformerConfiguration trfConfig) {
        String exclusionRegexParamValue = trfConfig.parameterAsString(PARAM_ENUMERATION_TO_CODELIST_EXCLUSION_REGEX, null, false, true);
        Pattern exclusionRegex = null;
        if (exclusionRegexParamValue != null) {
            exclusionRegex = Pattern.compile(exclusionRegexParamValue);
        }
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            if (genCi.category() != 3 || exclusionRegex != null && exclusionRegex.matcher(genCi.name()).matches() || "false".equalsIgnoreCase(genCi.taggedValue(TV_TO_CODELIST))) continue;
            genCi.setCategory(2);
            Stereotypes st = genCi.stereotypes();
            st.remove("enumeration");
            st.add("codelist");
            genCi.setStereotypes(st);
            genCi.setTaggedValue("asDictionary", "false", false);
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 10: {
                return "Syntax exception for regular expression '$1$' of parameter '$2$'. Message is: $3$. $4$ will not have any effect.";
            }
            case 100: {
                return "Association class '$1$' will be removed.";
            }
            case 200: {
                return "Metadata type '$1$' identified by configuration parameter defaultMetadataType was not found in the model. This is ok if all <<propertyMetadata>> properties have their metadata type correctly defined via tagged value 'metadataType'. Otherwise, i.e. the tagged value is not set correctly on such a property, a new metadata property will not be created for the property.";
            }
            case 201: {
                return "Property '$1$' of class '$2$' has the property metadata stereotype. However, no metadata type was defined for the property (by tagged value 'metadataType' or via configuration parameter 'defaultMetadataType'), or the type could not be found in the model (using the defined identification process). A new metadata property will NOT be created for property '$1$'.";
            }
            case 300: {
                return "Void reason type '$1$' identified by configuration parameter defaultVoidReasonType was not found in the model. This is ok if all nillable properties have their void reason type correctly defined via tagged value 'voidReasonType'. Otherwise, i.e. the tagged value is not set correctly on such a property, a new nil reason property will not be created for the property.";
            }
            case 301: {
                return "Property '$1$' of class '$2$' is nillable. However, no void reason type was defined for the property (by tagged value 'voidReasonType' or via configuration parameter 'defaultVoidReasonType'), or the type could not be found in the model (using the defined identification process). A new nil reason property will be created for property '$1$', with value type 'CharacterString'.";
            }
            case 400: {
                return "Value type '$1$' of association role '$2$' was not found in the model. Cannot move the association.";
            }
        }
        return "(" + TypeConverter.class.getName() + ") Unknown message with number: " + mnr;
    }
}

