/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericAssociationInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPackageInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.TaggedValueConfigurationEntry;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class TransformationManager
implements MessageSource {
    public static final String REQ_ALL_TYPES_IDENTIFY_FEATURE_AND_OBJECT_ASSOCIATIONS = "req-trf-all-identify-feature-and-object-associations";
    public static final String RULE_SKIP_CONSTRAINT_VALIDATION = "rule-trf-all-postprocess-skip-constraint-validation";
    private Options options = null;
    private ShapeChangeResult result = null;
    private Set<String> rules = null;

    public GenericModel process(GenericModel genModel, Options o, TransformerConfiguration trfConfig, ShapeChangeResult r) throws ShapeChangeAbortException {
        Transformer transformer;
        this.options = o;
        this.result = r;
        try {
            Class<?> theClass = Class.forName(trfConfig.getClassName());
            transformer = (Transformer)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ShapeChangeAbortException("Could not load transformer class '" + trfConfig.getClassName() + " for transformer ID '" + trfConfig.getId() + "'. Exception message is: " + StringUtils.defaultString((String)e.getMessage(), (String)"<null>"));
        }
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        this.rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                this.rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        this.preprocess(genModel, trfConfig);
        transformer.process(genModel, o, trfConfig, r);
        this.postprocess(genModel, trfConfig);
        return genModel;
    }

    private void preprocess(GenericModel genModel, TransformerConfiguration trfConfig) {
        if (this.rules.contains(REQ_ALL_TYPES_IDENTIFY_FEATURE_AND_OBJECT_ASSOCIATIONS)) {
            this.result.addProcessFlowInfo(null, 20103, REQ_ALL_TYPES_IDENTIFY_FEATURE_AND_OBJECT_ASSOCIATIONS);
            this.identifyFeatureAndObjectAssociations(genModel, trfConfig);
        }
    }

    private void identifyFeatureAndObjectAssociations(GenericModel genModel, TransformerConfiguration trfConfig) {
        SortedSet<PackageInfo> selSchemas = genModel.selectedSchemas();
        for (PackageInfo selSchema : selSchemas) {
            TreeMap schemaAssocsByKey = new TreeMap();
            SortedSet<ClassInfo> cis = genModel.classes(selSchema);
            for (ClassInfo ci : cis) {
                SortedMap<StructuredNumber, PropertyInfo> pis = ci.properties();
                for (PropertyInfo pi : pis.values()) {
                    String pi2CiName;
                    if (pi.association() == null) continue;
                    AssociationInfo ai = pi.association();
                    PropertyInfo pi1 = ai.end1();
                    PropertyInfo pi2 = ai.end2();
                    if (pi1.inClass().category() != 1 && pi1.inClass().category() != 6 || pi2.inClass().category() != 1 && pi2.inClass().category() != 6) continue;
                    String pi1CiName = pi1.inClass().name();
                    String key = pi1CiName.compareTo(pi2CiName = pi2.inClass().name()) <= 0 ? pi1CiName + "::" + pi2CiName : pi2CiName + "::" + pi1CiName;
                    if (schemaAssocsByKey.containsKey(key)) {
                        ((Set)schemaAssocsByKey.get(key)).add(ai);
                        continue;
                    }
                    HashSet<AssociationInfo> aiSet = new HashSet<AssociationInfo>();
                    aiSet.add(ai);
                    schemaAssocsByKey.put((CallSite)((Object)key), aiSet);
                }
            }
            if (schemaAssocsByKey.isEmpty()) {
                this.result.addInfo(this, 20104, selSchema.name());
                continue;
            }
            int countAssocs = 0;
            for (Set aiSet : schemaAssocsByKey.values()) {
                countAssocs += aiSet.size();
            }
            this.result.addInfo(this, 20108, "" + countAssocs, selSchema.name());
            for (Set aiSet : schemaAssocsByKey.values()) {
                for (AssociationInfo ai : aiSet) {
                    PropertyInfo pi2;
                    PropertyInfo pi1;
                    String end2CiName;
                    String end1CiName = ai.end1().inClass().name();
                    if (end1CiName.compareTo(end2CiName = ai.end2().inClass().name()) <= 0) {
                        pi1 = ai.end1();
                        pi2 = ai.end2();
                    } else {
                        pi1 = ai.end2();
                        pi2 = ai.end1();
                    }
                    StringBuilder sb = new StringBuilder();
                    if (pi1.inClass().stereotypes().size() == 1) {
                        sb.append("<<");
                        sb.append(pi1.inClass().stereotypes().toString());
                        sb.append(">> ");
                    }
                    sb.append(pi1.inClass().name());
                    String pi1Ci = sb.toString();
                    sb = new StringBuilder();
                    if (pi2.inClass().stereotypes().size() == 1) {
                        sb.append("<<");
                        sb.append(pi2.inClass().stereotypes().toString());
                        sb.append(">> ");
                    }
                    sb.append(pi2.inClass().name());
                    String pi2Ci = sb.toString();
                    boolean logLevelWarn = false;
                    if (pi1.isNavigable() && pi1.inClass().category() == 6 && pi1.categoryOfValue() == 1 || pi2.isNavigable() && pi2.inClass().category() == 6 && pi2.categoryOfValue() == 1) {
                        logLevelWarn = true;
                    }
                    ShapeChangeResult.MessageContext mc = logLevelWarn ? this.result.addWarning(this, 20105, pi1Ci, pi2Ci) : this.result.addInfo(this, 20105, pi1Ci, pi2Ci);
                    if (pi1.isNavigable()) {
                        mc.addDetail(this, 20107, pi1.name(), pi1.inClass().name());
                    }
                    if (!pi2.isNavigable()) continue;
                    mc.addDetail(this, 20107, pi2.name(), pi2.inClass().name());
                }
            }
        }
    }

    private void postprocess(GenericModel genModel, TransformerConfiguration trfConfig) {
        if (trfConfig.hasParameter("setGenerationDateTimeTaggedValue") && trfConfig.getParameterValue("setGenerationDateTimeTaggedValue").trim().equalsIgnoreCase("true")) {
            this.setGenerationDateTimeTaggedValue(genModel);
        }
        if (trfConfig.hasTaggedValues()) {
            this.setTaggedValues(genModel, trfConfig.getTaggedValues());
        }
        if (!trfConfig.getAllRules().contains(RULE_SKIP_CONSTRAINT_VALIDATION)) {
            this.result.addProcessFlowInfo(this, 20109);
            genModel.validateConstraints();
        }
    }

    private void setTaggedValues(GenericModel genModel, List<TaggedValueConfigurationEntry> taggedValues) {
        for (PackageInfo pi : genModel.allPackagesFromSelectedSchemas()) {
            GenericPackageInfo genPackage = (GenericPackageInfo)pi;
            TaggedValues genPaTVs = genPackage.taggedValuesAll();
            for (TaggedValueConfigurationEntry tvce : taggedValues) {
                if (!tvce.getModelElementSelectionInfo().matches(genPackage)) continue;
                if (genPaTVs.containsKey(tvce.getName())) {
                    if (!tvce.hasValue()) continue;
                    genPaTVs.put(tvce.getName(), tvce.getValue());
                    continue;
                }
                genPaTVs.put(tvce.getName(), tvce.hasValue() ? tvce.getValue() : "");
            }
            genPackage.setTaggedValues(genPaTVs, true);
        }
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            TaggedValues genCiTVs = genCi.taggedValuesAll();
            for (TaggedValueConfigurationEntry tvce : taggedValues) {
                if (!tvce.getModelElementSelectionInfo().matches(genCi)) continue;
                if (genCiTVs.containsKey(tvce.getName())) {
                    if (!tvce.hasValue()) continue;
                    genCiTVs.put(tvce.getName(), tvce.getValue());
                    continue;
                }
                genCiTVs.put(tvce.getName(), tvce.hasValue() ? tvce.getValue() : "");
            }
            genCi.setTaggedValues(genCiTVs, true);
        }
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            TaggedValues genPiTVs = genPi.taggedValuesAll();
            for (TaggedValueConfigurationEntry tvce : taggedValues) {
                if (!tvce.getModelElementSelectionInfo().matches(genPi)) continue;
                if (genPiTVs.containsKey(tvce.getName())) {
                    if (!tvce.hasValue()) continue;
                    genPiTVs.put(tvce.getName(), tvce.getValue());
                    continue;
                }
                genPiTVs.put(tvce.getName(), tvce.hasValue() ? tvce.getValue() : "");
            }
            genPi.setTaggedValues(genPiTVs, true);
        }
        for (GenericAssociationInfo genAi : genModel.selectedSchemaAssociations()) {
            TaggedValues genAiTVs = genAi.taggedValuesAll();
            for (TaggedValueConfigurationEntry tvce : taggedValues) {
                if (!tvce.getModelElementSelectionInfo().matches(genAi)) continue;
                if (genAiTVs.containsKey(tvce.getName())) {
                    if (!tvce.hasValue()) continue;
                    genAiTVs.put(tvce.getName(), tvce.getValue());
                    continue;
                }
                genAiTVs.put(tvce.getName(), tvce.hasValue() ? tvce.getValue() : "");
            }
            genAi.setTaggedValues(genAiTVs, true);
        }
    }

    private void setGenerationDateTimeTaggedValue(GenericModel genModel) {
        SortedSet<PackageInfo> appSchema = genModel.selectedSchemas();
        for (PackageInfo pi : appSchema) {
            GenericPackageInfo genPi = (GenericPackageInfo)pi;
            TaggedValues genPiTVs = genPi.taggedValuesAll();
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(tz);
            String currentTime = df.format(new Date());
            String[] val = new String[]{currentTime};
            genPiTVs.put("generationDateTime", val);
            genPi.setTaggedValues(genPiTVs, false);
        }
    }

    public static SortedSet<String> getRecognizedParameters() {
        return new TreeSet<String>(Stream.of("setGenerationDateTimeTaggedValue", "navigatingNonNavigableAssociationsWhenParsingOcl", "appSchemaName", "appSchemaNameRegex", "appSchemaNamespaceRegex").collect(Collectors.toSet()));
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 20104: {
                return "No associations between feature and feature / object types found in schema '$1$'.";
            }
            case 20105: {
                return "Association exists between '$1$' and '$2$'.";
            }
            case 20107: {
                return "Navigable via property '$1$' of class '$2$'.";
            }
            case 20108: {
                return "$1$ associations between feature and feature / object types found in schema '$2$'.";
            }
            case 20109: {
                return "---------- TransformationManager postprocessing: validating constraints ----------";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

