/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.TaggedValues;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaggedValueTransformerConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("taggedValuesToCopy", "valueTypeNameRegex", "taggedValueInheritanceAppendList", "taggedValueInheritanceAppendSeparator", "taggedValueInheritanceGeneralList", "taggedValueInheritanceOverwriteList").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        TransformerConfiguration trfConfig = (TransformerConfiguration)config;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTransformerParameters());
        boolean bl = isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        if (trfConfig.hasRule("rule-trf-taggedValue-inheritance")) {
            String normalizedTV;
            List<String> generalIn = config.parameterAsStringList("taggedValueInheritanceGeneralList", null, true, true);
            List<String> overwriteIn = config.parameterAsStringList("taggedValueInheritanceOverwriteList", null, true, true);
            List<String> appendIn = config.parameterAsStringList("taggedValueInheritanceAppendList", null, true, true);
            if (generalIn.isEmpty()) {
                isValid = false;
                result.addError(this, 100, "taggedValueInheritanceGeneralList", "rule-trf-taggedValue-inheritance");
            }
            TreeSet<String> generalTVs = new TreeSet<String>();
            TreeSet<String> overwriteTVs = new TreeSet<String>();
            TreeSet<String> appendTVs = new TreeSet<String>();
            for (String tv : generalIn) {
                generalTVs.add(options.normalizeTag(tv));
            }
            for (String tv : overwriteIn) {
                normalizedTV = options.normalizeTag(tv);
                if (generalTVs.contains(normalizedTV)) {
                    if (overwriteTVs.contains(normalizedTV)) {
                        result.addInfo(this, 101, tv);
                        continue;
                    }
                    overwriteTVs.add(normalizedTV);
                    continue;
                }
                result.addWarning(this, 102, tv);
            }
            for (String tv : appendIn) {
                normalizedTV = options.normalizeTag(tv);
                if (generalTVs.contains(normalizedTV)) {
                    if (overwriteTVs.contains(normalizedTV)) {
                        result.addWarning(this, 103, tv);
                        continue;
                    }
                    if (appendTVs.contains(normalizedTV)) {
                        result.addInfo(this, 104, tv);
                        continue;
                    }
                    appendTVs.add(normalizedTV);
                    continue;
                }
                result.addWarning(this, 105, tv);
            }
        }
        if (trfConfig.hasRule("rule-trf-taggedValue-copyFromValueType")) {
            List<String> tvsToCopy = trfConfig.parameterAsStringList("taggedValuesToCopy", null, true, true);
            if (tvsToCopy.isEmpty()) {
                result.addError(this, 100, "taggedValuesToCopy", "rule-trf-taggedValue-copyFromValueType");
                isValid = false;
            }
            String typeNameRegexParamValue = trfConfig.parameterAsString("valueTypeNameRegex", ".*", false, true);
            try {
                Pattern.compile(typeNameRegexParamValue);
            }
            catch (PatternSyntaxException e) {
                result.addError(this, 10, typeNameRegexParamValue, "valueTypeNameRegex", e.getMessage());
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 10: {
                return "Syntax exception for regular expression '$1$' of parameter '$2$'. Message is: $3$.";
            }
            case 100: {
                return "Parameter '$1$' is required for rule '$2$' but no actual value was found in the configuration.";
            }
            case 101: {
                return "?? Duplicate tag in parameter 'taggedValueInheritanceOverwriteList': '$1$'. This is not critical, since duplicate tags are ignored, but you may want to clean up the configuration.";
            }
            case 102: {
                return "?? Tag '$1$' specified by parameter 'taggedValueInheritanceOverwriteList' is not specified by parameter 'taggedValueInheritanceGeneralList'. The tag will be ignored.";
            }
            case 103: {
                return "?? Tag '$1$' specified by parameter 'taggedValueInheritanceAppendList' is also specified by parameter 'taggedValueInheritanceOverwriteList'. The tag will be ignored in the append list. These tags will therefore be overwritten, which may or may not be the intent.";
            }
            case 104: {
                return "?? Duplicate tag in parameter 'taggedValueInheritanceAppendList': '$1$'. This is not critical, since duplicate tags are ignored, but you may want to clean up the configuration.";
            }
            case 105: {
                return "?? Tag '$1$' specified by parameter 'taggedValueInheritanceAppendList' is not specified by parameter 'taggedValueInheritanceGeneralList'. The tag will be ignored.";
            }
            case 200: {
                return "Required parameter 'taggedValuesToCopy' was not set or does not contain any value. '";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

