/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.TaggedValues;

import com.google.common.base.Joiner;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TaggedValueTransformer
implements Transformer,
MessageSource {
    public static final String PARAM_TV_INHERITANCE_GENERAL_LIST = "taggedValueInheritanceGeneralList";
    public static final String PARAM_TV_INHERITANCE_OVERWRITE_LIST = "taggedValueInheritanceOverwriteList";
    public static final String PARAM_TV_INHERITANCE_APPEND_LIST = "taggedValueInheritanceAppendList";
    public static final String PARAM_TV_INHERITANCE_APPEND_SEPARATOR = "taggedValueInheritanceAppendSeparator";
    public static final String DEFAULT_TV_INHERITANCE_APPEND_SEPARATOR = ", ";
    public static final String PARAM_TV_COPYFROMVALUETYPE_TVSTOCOPY = "taggedValuesToCopy";
    public static final String PARAM_TV_COPYFROMVALUETYPE_TYPENAMEREGEX = "valueTypeNameRegex";
    public static final String RULE_TV_INHERITANCE = "rule-trf-taggedValue-inheritance";
    public static final String RULE_TV_COPY_FROM_VALUE_TYPE = "rule-trf-taggedValue-copyFromValueType";
    private GenericModel genModel = null;
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public void process(GenericModel genModel, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.genModel = genModel;
        this.options = options;
        this.result = result;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (rules.isEmpty()) {
            return;
        }
        if (rules.contains(RULE_TV_INHERITANCE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TV_INHERITANCE);
            this.applyRuleTaggedValueInheritance(genModel, trfConfig);
        }
        if (rules.contains(RULE_TV_COPY_FROM_VALUE_TYPE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TV_COPY_FROM_VALUE_TYPE);
            this.applyRuleTaggedValueCopyFromValueType(genModel, trfConfig);
        }
    }

    private void applyRuleTaggedValueCopyFromValueType(GenericModel genModel2, TransformerConfiguration trfConfig) {
        List<String> tvsToCopyAsList = trfConfig.parameterAsStringList(PARAM_TV_COPYFROMVALUETYPE_TVSTOCOPY, null, true, true);
        if (tvsToCopyAsList.isEmpty()) {
            this.result.addError(this, 200);
            return;
        }
        Joiner joiner = Joiner.on((String)",");
        String tvsToCopy = joiner.join(tvsToCopyAsList);
        String typeNameRegexParamValue = trfConfig.parameterAsString(PARAM_TV_COPYFROMVALUETYPE_TYPENAMEREGEX, ".*", false, true);
        Pattern typeNameRegex = null;
        try {
            typeNameRegex = Pattern.compile(typeNameRegexParamValue);
        }
        catch (PatternSyntaxException e) {
            this.result.addError(this, 10, typeNameRegexParamValue, PARAM_TV_COPYFROMVALUETYPE_TYPENAMEREGEX, e.getMessage(), RULE_TV_COPY_FROM_VALUE_TYPE);
            return;
        }
        for (GenericPropertyInfo genPi : this.genModel.selectedSchemaProperties()) {
            ClassInfo valueType;
            Type ti = genPi.typeInfo();
            if (ti.name == null || !typeNameRegex.matcher(ti.name).matches() || (valueType = this.genModel.classByIdOrName(ti)) == null) continue;
            TaggedValues valueTypeTVs = valueType.taggedValuesForTagList(tvsToCopy);
            TaggedValues genPiTVsCopy = genPi.taggedValuesAll();
            genPiTVsCopy.putAll(valueTypeTVs);
            genPi.setTaggedValues(genPiTVsCopy, true);
        }
    }

    private void applyRuleTaggedValueInheritance(GenericModel genModel, TransformerConfiguration trfConfig) {
        String normalizedTV;
        List<String> generalIn = trfConfig.parameterAsStringList(PARAM_TV_INHERITANCE_GENERAL_LIST, null, true, true);
        if (generalIn.isEmpty()) {
            return;
        }
        List<String> overwriteIn = trfConfig.parameterAsStringList(PARAM_TV_INHERITANCE_OVERWRITE_LIST, null, true, true);
        List<String> appendIn = trfConfig.parameterAsStringList(PARAM_TV_INHERITANCE_APPEND_LIST, null, true, true);
        String appendSeparator = trfConfig.parameterAsString(PARAM_TV_INHERITANCE_APPEND_SEPARATOR, DEFAULT_TV_INHERITANCE_APPEND_SEPARATOR, true, false);
        TreeSet<String> generalTVs = new TreeSet<String>();
        TreeSet<String> overwriteTVs = new TreeSet<String>();
        TreeSet<String> appendTVs = new TreeSet<String>();
        for (String tv : generalIn) {
            generalTVs.add(this.options.normalizeTag(tv));
        }
        for (String tv : overwriteIn) {
            normalizedTV = this.options.normalizeTag(tv);
            if (!generalTVs.contains(normalizedTV)) continue;
            overwriteTVs.add(normalizedTV);
        }
        for (String tv : appendIn) {
            normalizedTV = this.options.normalizeTag(tv);
            if (!generalTVs.contains(normalizedTV) || overwriteTVs.contains(normalizedTV)) continue;
            appendTVs.add(normalizedTV);
        }
        TreeSet<GenericClassInfo> topLevelSupertypes = new TreeSet<GenericClassInfo>();
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            if (genCi.hasSupertypes() || !genCi.hasSubtypes()) continue;
            topLevelSupertypes.add(genCi);
        }
        for (GenericClassInfo genCi : topLevelSupertypes) {
            this.applyTaggedValueInheritance(genCi, generalTVs, overwriteTVs, appendTVs, appendSeparator);
        }
    }

    private void applyTaggedValueInheritance(GenericClassInfo genCi, SortedSet<String> generalTVs, SortedSet<String> overwriteTVs, SortedSet<String> appendTVs, String appendSeparator) {
        for (String subtypeId : genCi.subtypes()) {
            GenericClassInfo subtype = (GenericClassInfo)this.genModel.classById(subtypeId);
            for (String tv : generalTVs) {
                ShapeChangeResult.MessageContext mc;
                String tvValue = genCi.taggedValue(tv);
                if (tvValue == null) continue;
                String subtypeTvValue = subtype.taggedValue(tv);
                if (subtypeTvValue == null) {
                    subtype.setTaggedValue(tv, tvValue, false);
                    mc = this.result.addInfo(this, 100, tv, tvValue, subtype.name());
                    if (mc == null) continue;
                    mc.addDetail(this, 4, genCi.fullName());
                    mc.addDetail(this, 5, subtype.fullName());
                    continue;
                }
                if (overwriteTVs.contains(tv)) {
                    subtype.setTaggedValue(tv, tvValue, false);
                    mc = this.result.addInfo(this, 101, tv, tvValue, subtype.name(), subtypeTvValue);
                    if (mc == null) continue;
                    mc.addDetail(this, 4, genCi.fullName());
                    mc.addDetail(this, 5, subtype.fullName());
                    continue;
                }
                if (appendTVs.contains(tv)) {
                    String newSubtypeTvValue = subtypeTvValue + appendSeparator + tvValue;
                    subtype.setTaggedValue(tv, newSubtypeTvValue, false);
                    ShapeChangeResult.MessageContext mc2 = this.result.addInfo(this, 102, tvValue, tv, subtype.name(), newSubtypeTvValue);
                    if (mc2 == null) continue;
                    mc2.addDetail(this, 4, genCi.fullName());
                    mc2.addDetail(this, 5, subtype.fullName());
                    continue;
                }
                mc = this.result.addInfo(this, 103, tv, subtypeTvValue, subtype.name());
                if (mc == null) continue;
                mc.addDetail(this, 4, genCi.fullName());
                mc.addDetail(this, 5, subtype.fullName());
            }
            this.applyTaggedValueInheritance(subtype, generalTVs, overwriteTVs, appendTVs, appendSeparator);
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 4: {
                return "Context: supertype '$1$'";
            }
            case 5: {
                return "Context: subtype '$1$'";
            }
            case 10: {
                return "Syntax exception for regular expression '$1$' of parameter '$2$'. Message is: $3$. $4$ will not have any effect.";
            }
            case 100: {
                return "Adding tagged value $1$=$2$ to $3$.";
            }
            case 101: {
                return "Overwriting tagged value $1$=$2$ in $3$. Previous value was: $4$";
            }
            case 102: {
                return "Appending '$1$' to tagged value $2$ in $3$. New value is: $4$.";
            }
            case 103: {
                return "Retaining tagged value $1$=$2$ in $3$.";
            }
            case 200: {
                return "Required parameter 'taggedValuesToCopy' was not set or does not contain any value. 'rule-trf-taggedValue-copyFromValueType' will not have any effect.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

