/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Profiling;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Model.MalformedProfileIdentifierException;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Profiling.Profiler;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProfilerConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("constraintHandling", "profiles", "residualTypeRemoval_includeSubtypesFor").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTransformerParameters());
        boolean bl = isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        if (!config.hasParameter("profiles")) {
            isValid = false;
            result.addError(this, 100);
        } else {
            String profilesParameterValue = config.getParameterValue("profiles");
            try {
                Profiles.parse(profilesParameterValue, true);
            }
            catch (MalformedProfileIdentifierException e) {
                isValid = false;
                result.addError(this, 20206, "profiles", e.getMessage());
            }
        }
        String constraintHandlingValue = config.getParameterValue("constraintHandling");
        if (constraintHandlingValue != null && constraintHandlingValue.length() > 0) {
            boolean validConstraintHandlingParameter = false;
            for (Profiler.ConstraintHandling conHandlingEnum : Profiler.ConstraintHandling.values()) {
                if (!conHandlingEnum.name().equalsIgnoreCase(constraintHandlingValue)) continue;
                validConstraintHandlingParameter = true;
                break;
            }
            if (!validConstraintHandlingParameter) {
                isValid = false;
                result.addError(this, 20221, "constraintHandling");
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 100: {
                return "Required parameter 'profiles' not set.";
            }
            case 20206: {
                return "Error parsing component of '$1$' configuration parameter: $2$";
            }
            case 20221: {
                return "Value of configuration parameter '$1$' does not match one of the defined values (was: '$2$').";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

