/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Profiling;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericFolConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericOclConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPackageInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericTextConstraint;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.MalformedProfileIdentifierException;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Model.TextConstraint;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.Profile.ModelProfileValidator;
import de.interactive_instruments.ShapeChange.Profile.ProfileIdentifier;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Profiler
implements Transformer,
MessageSource {
    private static final Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Joiner commaJoiner = Joiner.on((String)",").skipNulls();
    public static final int STATUS_PREPROCESSING_PROFILESVALUECONSISTENCYCHECK = 200100;
    public static final int STATUS_PREPROCESSING_MODELCONSISTENCYCHECK = 200101;
    public static final int STATUS_PROCESSING_PROFILING = 200130;
    public static final int STATUS_POSTPROCESSING_REMOVERESIDUALTYPES = 200170;
    public static final int STATUS_POSTPROCESSING_REMOVEEMPTYPACKAGES = 200171;
    public static final String RULE_TRF_PROFILING_PREPROCESSING_MODELCONSISTENCYCHECK = "rule-trf-profiling-preprocessing-modelConsistencyCheck";
    public static final String RULE_TRF_PROFILING_POSTPROCESSING_REMOVERESIDUALTYPES = "rule-trf-profiling-postprocessing-removeResidualTypes";
    public static final String RULE_TRF_PROFILING_POSTPROCESSING_REMOVEEMPTYPACKAGES = "rule-trf-profiling-postprocessing-removeEmptyPackages";
    public static final String RULE_TRF_PROFILING_PROCESSING_EXPLICITPROFILESETTINGS = "rule-trf-profiling-processing-explicitProfileSettings";
    public static final String RULE_TRF_PROFILING_PROCESSING_CLASS_REMOVAL_INCLUDES_ALL_SUBTYPES = "rule-trf-profiling-processing-classRemovalIncludesAllSubtypes";
    public static final String RULE_TRF_PROFILING_PROCESSING_KEEP_ASSOCIATION_AS_IS = "rule-trf-profiling-processing-keepAssociationAsIs";
    public static final String RULE_TRF_PROFILING_POSTPROCESSING_REMOVE_PROFILE_INFOS = "rule-trf-profiling-postprocessing-removeProfileInfos";
    public static final String PARAM_RESIDUALTYPEREMOVAL_INCLUDESUBTYPESFOR = "residualTypeRemoval_includeSubtypesFor";
    public static final String PARAM_PROFILES = "profiles";
    public static final String PARAM_CONSTRAINTHANDLING = "constraintHandling";
    public static final String PROFILE_PARAMETER_MULTIPLICITY = "multiplicity";
    public static final String PROFILE_PARAMETER_ISABSTRACT = "isAbstract";
    public static final String PROFILE_PARAMETER_ISNAVIGABLE = "isNavigable";
    public static final String PROFILE_PARAMETER_ISORDERED = "isOrdered";
    public static final String PROFILE_PARAMETER_ISUNIQUE = "isUnique";
    public static final String PROFILE_PARAMETER_GEOMETRY = "geometry";
    ConstraintHandling constraintHandling = ConstraintHandling.keep;
    Profiles profilesFromConfig = null;
    private boolean isExplicitProfileSettingsRuleEnabled = false;
    private ShapeChangeResult result;

    @Override
    public void process(GenericModel genModel, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.result = result;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        this.isExplicitProfileSettingsRuleEnabled = rules.contains(RULE_TRF_PROFILING_PROCESSING_EXPLICITPROFILESETTINGS);
        String profilesParameterValue = trfConfig.getParameterValue(PARAM_PROFILES);
        Pattern residualTypeRemoval_includeSubtypesFor = trfConfig.hasParameter(PARAM_RESIDUALTYPEREMOVAL_INCLUDESUBTYPESFOR) ? Pattern.compile(trfConfig.getParameterValue(PARAM_RESIDUALTYPEREMOVAL_INCLUDESUBTYPESFOR)) : null;
        try {
            this.profilesFromConfig = Profiles.parse(profilesParameterValue, true);
        }
        catch (MalformedProfileIdentifierException e) {
            this.profilesFromConfig = new Profiles();
            result.addError(this, 20219, PARAM_PROFILES, e.getMessage());
        }
        String constraintHandlingValue = trfConfig.getParameterValue(PARAM_CONSTRAINTHANDLING);
        if (constraintHandlingValue != null && constraintHandlingValue.length() > 0) {
            boolean validConstraintHandlingParameter = false;
            for (ConstraintHandling constraintHandling : ConstraintHandling.values()) {
                if (!constraintHandling.name().equalsIgnoreCase(constraintHandlingValue)) continue;
                this.constraintHandling = constraintHandling;
                validConstraintHandlingParameter = true;
                break;
            }
            if (!validConstraintHandlingParameter) {
                result.addError(this, 20220, PARAM_CONSTRAINTHANDLING, constraintHandlingValue);
                this.constraintHandling = ConstraintHandling.keep;
            }
        }
        if (rules.contains(RULE_TRF_PROFILING_PREPROCESSING_MODELCONSISTENCYCHECK)) {
            StatusBoard.getStatusBoard().statusChanged(200101);
            ModelProfileValidator mpv = new ModelProfileValidator(genModel, result);
            boolean warnIfSupertypeProfilesDoNotContainSubtypeProfiles = rules.contains(RULE_TRF_PROFILING_PROCESSING_CLASS_REMOVAL_INCLUDES_ALL_SUBTYPES);
            mpv.validateModelConsistency(this.isExplicitProfileSettingsRuleEnabled, warnIfSupertypeProfilesDoNotContainSubtypeProfiles, true);
        }
        StatusBoard.getStatusBoard().statusChanged(200130);
        HashSet<GenericClassInfo> cisToRemove = new HashSet<GenericClassInfo>();
        for (GenericClassInfo ci : genModel.selectedSchemaClasses()) {
            if (cisToRemove.contains(ci) || ci.profiles().contains(null, this.profilesFromConfig, null, this.isExplicitProfileSettingsRuleEnabled, false, null)) continue;
            cisToRemove.add(ci);
            if (!rules.contains(RULE_TRF_PROFILING_PROCESSING_CLASS_REMOVAL_INCLUDES_ALL_SUBTYPES)) continue;
            cisToRemove.addAll(this.getAllSubtypes(ci));
        }
        for (GenericClassInfo ci : cisToRemove) {
            genModel.remove(ci);
        }
        ArrayList<PropertyInfo> pisToRemove = new ArrayList<PropertyInfo>();
        for (GenericClassInfo ci : genModel.selectedSchemaClasses()) {
            for (PropertyInfo propertyInfo : ci.properties().values()) {
                if (!propertyInfo.isAttribute() && rules.contains(RULE_TRF_PROFILING_PROCESSING_KEEP_ASSOCIATION_AS_IS) || this.contains(propertyInfo, this.profilesFromConfig, this.isExplicitProfileSettingsRuleEnabled, null)) continue;
                pisToRemove.add(propertyInfo);
            }
        }
        for (PropertyInfo pi : pisToRemove) {
            genModel.remove((GenericPropertyInfo)pi, true);
            GenericClassInfo genericClassInfo = (GenericClassInfo)pi.inClass();
            if (this.constraintHandling.equals((Object)ConstraintHandling.remove)) {
                if (!genericClassInfo.hasDirectConstraints()) continue;
                genericClassInfo.setDirectConstraints(new Vector<Constraint>());
                continue;
            }
            if (!this.constraintHandling.equals((Object)ConstraintHandling.removeByPropertyNameInConstraintName)) continue;
            this.removeConstraintByPropertyNameInTypeTree(genericClassInfo, pi.name(), genModel);
        }
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            if (this.constraintHandling.equals((Object)ConstraintHandling.remove)) {
                if (!genCi.hasDirectConstraints()) continue;
                genCi.setDirectConstraints(new Vector<Constraint>());
                continue;
            }
            genCi.setDirectConstraints(this.validateConstraintContext(genCi.directConstraints(), genCi, result, genModel));
            if (genCi.properties() != null) {
                for (PropertyInfo propertyInfo : genCi.properties().values()) {
                    GenericPropertyInfo genericPropertyInfo = (GenericPropertyInfo)propertyInfo;
                    List<Constraint> list = genericPropertyInfo.constraints();
                    genericPropertyInfo.setConstraints(this.validateConstraintContext(list, genericPropertyInfo, result, genModel));
                }
            }
            if (!this.constraintHandling.equals((Object)ConstraintHandling.removeByPropertyNameInConstraintName) || !genCi.hasDirectConstraints()) continue;
            Vector<Constraint> vector = new Vector<Constraint>();
            for (Constraint constraint : genCi.directConstraints()) {
                if (constraint.name().endsWith("_Type")) {
                    String string = constraint.name().replace("_Type", "");
                    if (genCi.property(string) == null) {
                        result.addInfo(this, 20207, constraint.name(), genCi.name());
                        continue;
                    }
                    vector.add(constraint);
                    continue;
                }
                vector.add(constraint);
            }
            genCi.setDirectConstraints(vector);
        }
        if (this.profilesFromConfig.size() > 1) {
            result.addWarning(this, 100, "" + this.profilesFromConfig.size());
        } else {
            Iterator<GenericPropertyInfo> nameOfProfileFromConfig = this.profilesFromConfig.get(0).getName();
            for (GenericClassInfo genericClassInfo : genModel.selectedSchemaClasses()) {
                ProfileIdentifier profileIdentifier = genericClassInfo.profiles().getProfile((String)((Object)nameOfProfileFromConfig));
                if (profileIdentifier != null && profileIdentifier.hasParameters()) {
                    for (Map.Entry<String, String> entry : profileIdentifier.getParameter().entrySet()) {
                        String parameterName = entry.getKey();
                        String parameterValue = entry.getValue();
                        if (parameterName.equalsIgnoreCase(PROFILE_PARAMETER_GEOMETRY)) {
                            if (parameterValue == null) continue;
                            String geometryTV = genericClassInfo.taggedValue(PROFILE_PARAMETER_GEOMETRY);
                            if (StringUtils.isBlank((CharSequence)geometryTV)) {
                                genericClassInfo.setTaggedValue(PROFILE_PARAMETER_GEOMETRY, parameterValue, false);
                                continue;
                            }
                            TreeSet geometryTVValues = new TreeSet(commaSplitter.splitToList((CharSequence)geometryTV));
                            TreeSet geometryProfileValues = new TreeSet(commaSplitter.splitToList((CharSequence)parameterValue));
                            Sets.SetView intersection = Sets.intersection(geometryProfileValues, geometryTVValues);
                            if (intersection.isEmpty()) continue;
                            genericClassInfo.setTaggedValue(PROFILE_PARAMETER_GEOMETRY, commaJoiner.join((Iterable)intersection), false);
                            continue;
                        }
                        if (parameterName.equalsIgnoreCase(PROFILE_PARAMETER_ISABSTRACT)) {
                            if (!"true".equalsIgnoreCase(parameterValue)) continue;
                            genericClassInfo.setIsAbstract(true);
                            continue;
                        }
                        String newTagName = parameterName;
                        String newTagValue = parameterValue == null ? "" : parameterValue;
                        genericClassInfo.setTaggedValue(newTagName, newTagValue, false);
                    }
                }
                HashSet<AssociationInfo> hashSet = new HashSet<AssociationInfo>();
                for (PropertyInfo pi : genericClassInfo.properties().values()) {
                    String parameterValue;
                    String parameterName;
                    GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                    ProfileIdentifier profileOfPi = genPi.profiles().getProfile((String)((Object)nameOfProfileFromConfig));
                    if (profileOfPi == null || !profileOfPi.hasParameters()) continue;
                    for (Map.Entry<String, String> parameterEntry3 : profileOfPi.getParameter().entrySet()) {
                        parameterName = parameterEntry3.getKey();
                        parameterValue = parameterEntry3.getValue();
                        if (parameterName.equalsIgnoreCase(PROFILE_PARAMETER_MULTIPLICITY)) {
                            if (parameterValue == null) continue;
                            Multiplicity multProfile = new Multiplicity(parameterValue);
                            Multiplicity multPi = genPi.cardinality();
                            int newMin = multProfile.minOccurs < multPi.minOccurs ? multPi.minOccurs : multProfile.minOccurs;
                            int newMax = multProfile.maxOccurs > multPi.maxOccurs ? multPi.maxOccurs : multProfile.maxOccurs;
                            multPi.minOccurs = newMin;
                            multPi.maxOccurs = newMax;
                            if (newMax != 1) continue;
                            genPi.setOrdered(false);
                            genPi.setUnique(true);
                            continue;
                        }
                        if (parameterName.equalsIgnoreCase(PROFILE_PARAMETER_ISNAVIGABLE)) {
                            if (parameterValue == null || genPi.isAttribute()) continue;
                            Boolean isNavigable = Boolean.parseBoolean(parameterValue);
                            if (!isNavigable.booleanValue()) {
                                genPi.setNavigable(isNavigable);
                            }
                            AssociationInfo ai = genPi.association();
                            boolean aiEnd1IsNavigable = ai.end1().isNavigable();
                            boolean aiEnd2IsNavigable = ai.end2().isNavigable();
                            if (aiEnd1IsNavigable || aiEnd2IsNavigable) continue;
                            hashSet.add(ai);
                            continue;
                        }
                        if (parameterName.equalsIgnoreCase(PROFILE_PARAMETER_ISORDERED) || parameterName.equalsIgnoreCase(PROFILE_PARAMETER_ISUNIQUE)) continue;
                        String newTagName = parameterName;
                        String newTagValue = parameterValue == null ? "" : parameterValue;
                        genPi.setTaggedValue(newTagName, newTagValue, false);
                    }
                    for (Map.Entry<String, String> parameterEntry : profileOfPi.getParameter().entrySet()) {
                        parameterName = parameterEntry.getKey();
                        parameterValue = parameterEntry.getValue();
                        if (parameterName.equalsIgnoreCase(PROFILE_PARAMETER_ISORDERED) && genPi.cardinality().maxOccurs > 1) {
                            genPi.setOrdered("true".equalsIgnoreCase(parameterValue));
                            continue;
                        }
                        if (!parameterName.equalsIgnoreCase(PROFILE_PARAMETER_ISUNIQUE) || genPi.cardinality().maxOccurs <= 1) continue;
                        genPi.setUnique("true".equalsIgnoreCase(parameterValue));
                    }
                }
                for (AssociationInfo aiToRemove : hashSet) {
                    genModel.remove(aiToRemove);
                }
            }
        }
        if (rules.contains(RULE_TRF_PROFILING_POSTPROCESSING_REMOVE_PROFILE_INFOS)) {
            for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
                genCi.setProfiles(new Profiles());
                TaggedValues taggedValues = genCi.taggedValuesAll();
                taggedValues.remove(PARAM_PROFILES);
                genCi.setTaggedValues(taggedValues, false);
            }
            for (GenericPropertyInfo genPi : genModel.getGenProperties().values()) {
                genPi.setProfiles(new Profiles());
                TaggedValues taggedValues = genPi.taggedValuesAll();
                taggedValues.remove(PARAM_PROFILES);
                genPi.setTaggedValues(taggedValues, false);
            }
        }
        if (rules.contains(RULE_TRF_PROFILING_POSTPROCESSING_REMOVERESIDUALTYPES)) {
            StatusBoard.getStatusBoard().statusChanged(200170);
            SortedSet<GenericClassInfo> genCis = genModel.selectedSchemaClasses();
            if (genCis != null && !genCis.isEmpty()) {
                ArrayList<GenericClassInfo> featureTypes = new ArrayList<GenericClassInfo>();
                TreeMap<String, GenericClassInfo> treeMap = new TreeMap<String, GenericClassInfo>();
                for (GenericClassInfo genericClassInfo : genCis) {
                    if (genericClassInfo.category() == 1) {
                        featureTypes.add(genericClassInfo);
                        continue;
                    }
                    treeMap.put(genericClassInfo.id(), genericClassInfo);
                }
                HashSet<String> hashSet = new HashSet<String>();
                for (GenericClassInfo genericClassInfo : featureTypes) {
                    this.deepSearchForTypesUsedByClass(genericClassInfo, hashSet, genModel, residualTypeRemoval_includeSubtypesFor);
                }
                for (String string : hashSet) {
                    treeMap.remove(string);
                }
                genModel.remove(treeMap.values());
            }
        }
        if (rules.contains(RULE_TRF_PROFILING_POSTPROCESSING_REMOVEEMPTYPACKAGES)) {
            StatusBoard.getStatusBoard().statusChanged(200171);
            SortedSet<PackageInfo> appSchemaPackages = genModel.selectedSchemas();
            for (PackageInfo packageInfo : appSchemaPackages) {
                GenericPackageInfo genericPackageInfo = (GenericPackageInfo)packageInfo;
                HashSet<PackageInfo> hashSet = new HashSet<PackageInfo>();
                genericPackageInfo.getEmptyPackages(hashSet);
                if (hashSet.contains(genericPackageInfo)) {
                    result.addWarning(this, 20205, genericPackageInfo.name());
                    hashSet.remove(genericPackageInfo);
                }
                genModel.remove((Set<PackageInfo>)hashSet);
            }
        }
    }

    private void removeConstraintByPropertyNameInTypeTree(GenericClassInfo genCi, String propertyName, GenericModel genModel) {
        if (genCi.hasDirectConstraints()) {
            List<Constraint> constraints = genCi.directConstraints();
            for (int i = 0; i < constraints.size(); ++i) {
                if (!constraints.get(i).name().contains(propertyName + "_Type")) continue;
                constraints.remove(i);
                break;
            }
        }
        SortedSet subtypeIds = genCi.subtypes();
        for (String subtypeId : subtypeIds) {
            GenericClassInfo subtype = genModel.getGenClasses().get(subtypeId);
            this.removeConstraintByPropertyNameInTypeTree(subtype, propertyName, genModel);
        }
    }

    private void deepSearchForTypesUsedByClass(ClassInfo ci, Set<String> usedCisById, GenericModel genModel, Pattern residualTypeRemoval_includeSubtypesFor) {
        SortedSet<String> sortedSet;
        SortedSet<String> supertypeIds;
        if (usedCisById.contains(ci.id())) {
            return;
        }
        usedCisById.add(ci.id());
        SortedMap<StructuredNumber, PropertyInfo> ciPis = ci.properties();
        if (ciPis != null && !ciPis.isEmpty()) {
            for (PropertyInfo propertyInfo : ciPis.values()) {
                ClassInfo assoClass;
                ClassInfo typeCi = genModel.classById(propertyInfo.typeInfo().id);
                if (typeCi == null || usedCisById.contains(propertyInfo.typeInfo().id)) continue;
                this.deepSearchForTypesUsedByClass(typeCi, usedCisById, genModel, residualTypeRemoval_includeSubtypesFor);
                if (propertyInfo.association() == null || (assoClass = propertyInfo.association().assocClass()) == null || usedCisById.contains(assoClass.id())) continue;
                this.deepSearchForTypesUsedByClass(assoClass, usedCisById, genModel, residualTypeRemoval_includeSubtypesFor);
            }
        }
        if ((supertypeIds = ci.supertypes()) != null && !supertypeIds.isEmpty()) {
            for (String supertypeId : supertypeIds) {
                ClassInfo supertype = genModel.classById(supertypeId);
                if (supertype == null || usedCisById.contains(supertype.id())) continue;
                this.deepSearchForTypesUsedByClass(supertype, usedCisById, genModel, residualTypeRemoval_includeSubtypesFor);
            }
        }
        if (residualTypeRemoval_includeSubtypesFor != null && residualTypeRemoval_includeSubtypesFor.matcher(ci.name()).matches() && (sortedSet = ci.subtypes()) != null && !sortedSet.isEmpty()) {
            for (String subtypeId : sortedSet) {
                ClassInfo subtype = genModel.classById(subtypeId);
                if (subtype == null || usedCisById.contains(subtype.id())) continue;
                this.deepSearchForTypesUsedByClass(subtype, usedCisById, genModel, residualTypeRemoval_includeSubtypesFor);
            }
        }
    }

    private boolean contains(PropertyInfo pi, Profiles profilesFromConfig, boolean isExplicitProfileSettingsRuleEnabled, List<String> messages) {
        Profiles propertyProfiles = pi.profiles();
        Profiles classProfiles = pi.inClass().profiles();
        if (propertyProfiles.isEmpty() && !isExplicitProfileSettingsRuleEnabled) {
            return classProfiles.contains(pi.inClass().name(), profilesFromConfig, "profiles_config_parameter", isExplicitProfileSettingsRuleEnabled, false, messages);
        }
        return propertyProfiles.contains(pi.name() + " (property in class '" + pi.inClass().name() + "')", profilesFromConfig, "profiles_config_parameter", isExplicitProfileSettingsRuleEnabled, false, messages);
    }

    private Vector<Constraint> validateConstraintContext(List<Constraint> constraints, Info owner, ShapeChangeResult result, GenericModel genModel) {
        Vector<Constraint> results = new Vector<Constraint>();
        if (constraints != null) {
            for (Constraint con : constraints) {
                if (!(con instanceof GenericTextConstraint || con instanceof GenericOclConstraint || con instanceof GenericFolConstraint)) {
                    result.addError(this, 20208, con.name(), con.contextModelElmt().name());
                    continue;
                }
                Info contextModelElement = con.contextModelElmt();
                if (contextModelElement == null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("(Profiler) contextModelElement for constraint named '" + con.name() + "' [" + con.text() + "] is null.");
                    if (owner instanceof PropertyInfo) {
                        PropertyInfo pi = (PropertyInfo)owner;
                        sb.append(" Omitting constraint in property '" + pi.name() + "' of class '" + pi.inClass().name() + "'.");
                    } else if (owner instanceof ClassInfo) {
                        ClassInfo ci = (ClassInfo)owner;
                        sb.append(" Omitting constraint in class '" + ci.name() + "'.");
                    } else {
                        sb.append(" Omitting constraint in Info class '" + owner.name() + "'.");
                    }
                    result.addWarning(this, 20209, sb.toString());
                    continue;
                }
                if (con instanceof TextConstraint || con instanceof OclConstraint) {
                    if (con.contextModelElmtType().equals((Object)Constraint.ModelElmtContextType.ATTRIBUTE)) {
                        GenericPropertyInfo genPi = genModel.getGenProperties().get(contextModelElement.id());
                        if (genPi == null) {
                            result.addError(this, 20210, contextModelElement.name(), con.name());
                            continue;
                        }
                        results.add(con);
                        continue;
                    }
                    if (con.contextModelElmtType().equals((Object)Constraint.ModelElmtContextType.CLASS)) {
                        GenericClassInfo genCi = genModel.getGenClasses().get(contextModelElement.id());
                        if (genCi == null) {
                            result.addError(this, 20211, contextModelElement.name(), con.name());
                            continue;
                        }
                        results.add(con);
                        continue;
                    }
                    result.addWarning(this, 20212, con.contextModelElmtType().name());
                    continue;
                }
                result.addWarning(this, 20213, con.getClass().getName());
            }
        }
        return results;
    }

    public Set<GenericClassInfo> getAllSubtypes(GenericClassInfo genCi) {
        HashSet<GenericClassInfo> subtypes = new HashSet<GenericClassInfo>();
        if (genCi == null) {
            return subtypes;
        }
        SortedSet directSubtypes = genCi.subtypes();
        if (directSubtypes != null && !directSubtypes.isEmpty()) {
            HashSet<GenericClassInfo> directGenSubtypes = new HashSet<GenericClassInfo>();
            for (String subtypeId : directSubtypes) {
                GenericModel genModel = genCi.model();
                ClassInfo ciSub = genModel.classById(subtypeId);
                if (ciSub instanceof GenericClassInfo) {
                    GenericClassInfo genCiSub = (GenericClassInfo)ciSub;
                    directGenSubtypes.add(genCiSub);
                    if (ciSub == null || !(ciSub instanceof GenericClassInfo)) continue;
                    subtypes.addAll(this.getAllSubtypes(genCiSub));
                    continue;
                }
                this.result.addInfo(this, 20215, ciSub.name(), genCi.name());
            }
            subtypes.addAll(directGenSubtypes);
        }
        return subtypes;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: class $1$";
            }
            case 2: {
                return "Context: property $1$";
            }
            case 100: {
                return "??Configuration parameter 'profiles' specifies more than one profile (found: $1$ profiles). Profile metadata is only processed if the parameter identifies exactly one profile.";
            }
            case 101: {
                return "";
            }
            case 102: {
                return "";
            }
            case 103: {
                return "";
            }
            case 20205: {
                return "The application schema package '$1$' is completely empty after profiling.";
            }
            case 20207: {
                return "Removing constraint '$1$' from class '$2$' because the constraint targets a property that is missing in the class or its supertypes (to highest level)";
            }
            case 20208: {
                return "System Error: Constraint '$1$' in Class '$2$' not of type 'GenericText/OclConstraint'.";
            }
            case 20209: {
                return "$1$";
            }
            case 20210: {
                return "GenericPropertyInfo '$1$' is the context model element of the constraint named '$2$'. The property does no longer exist in the model after profiling, thus the constraint is removed.";
            }
            case 20211: {
                return "GenericClassInfo '$1$' is the context model element of the constraint named '$2$'. The class does no longer exist in the model after profiling, thus the constraint is removed.";
            }
            case 20212: {
                return "Unrecognized constraint context model element type: '$1$'.";
            }
            case 20213: {
                return "Unrecognized constraint type: '$1$'.";
            }
            case 20215: {
                return "??Class '$1$' - which is a subtype of '$2$' - is not an instance of GenericClassInfo (likely reason: it belongs to a package that is not part of the schema selected for processing). It (and its possibly existing subtypes) won't be removed from the model (which should be ok, given that it is (likely) not part of the selected schema destined for final processing in target(s)).";
            }
            case 20219: {
                return "Error parsing transformation parameter '$1$': '$2$'. Assuming no profiles as value for the parameter. This may lead to unexpected results.";
            }
            case 20220: {
                return "Value of configuration parameter '$1$' does not match one of the defined values (was: '$2$'). Using default value.";
            }
        }
        return "(Unknown message in " + this.getClass().getName() + ". Message number was: " + mnr + ")";
    }

    public static enum ConstraintHandling {
        remove,
        keep,
        removeByPropertyNameInConstraintName;

    }
}

