/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Profiling;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.ModelDiff.DiffElement;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Profiling.ProfileLoader;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class ProfileLoaderConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("diffElementTypes", "profilesInModelSetExplicitly", "directoryWithProfilesToLoad", "regexToFilterProfilesToLoad", "processAllSchemas", "profilesForClassesWithoutExplicitProfileAssignments", "profilesToLoad").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTransformerParameters());
        boolean bl = isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        if (config.hasParameter("regexToFilterProfilesToLoad")) {
            try {
                Pattern.compile(config.parameterAsString("regexToFilterProfilesToLoad", "", false, true));
            }
            catch (PatternSyntaxException e) {
                isValid = false;
                result.addError(this, 103, "regexToFilterProfilesToLoad", e.getMessage());
            }
        }
        if (!config.hasParameter("directoryWithProfilesToLoad")) {
            isValid = false;
            result.addError(this, 100, "directoryWithProfilesToLoad");
        } else {
            String loadModelDirectory = config.getParameterValue("directoryWithProfilesToLoad");
            File loadModelDirectoryFile = new File(loadModelDirectory);
            boolean exi = loadModelDirectoryFile.exists();
            boolean dir = loadModelDirectoryFile.isDirectory();
            boolean rea = loadModelDirectoryFile.canRead();
            if (!(exi && dir && rea)) {
                isValid = false;
                result.addError(this, 101, "directoryWithProfilesToLoad", loadModelDirectory);
            } else {
                Collection files = FileUtils.listFiles((File)loadModelDirectoryFile, (String[])new String[]{"xml", "zip"}, (boolean)false);
                if (files.isEmpty()) {
                    result.addWarning(this, 102, loadModelDirectory);
                }
            }
        }
        List<String> diffElementTypeNames = config.parameterAsStringList("diffElementTypes", ProfileLoader.DEFAULT_DIFF_ELEMENT_TYPES, true, true);
        Collections.sort(diffElementTypeNames);
        for (String detn : diffElementTypeNames) {
            try {
                DiffElement.ElementType.valueOf(detn.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                result.addWarning(this, 104, "diffElementTypes", detn);
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: class $1$";
            }
            case 2: {
                return "Context: property $1$";
            }
            case 3: {
                return "Context: association role (end1) '$1$'";
            }
            case 4: {
                return "Context: association role (end2) '$1$'";
            }
            case 100: {
                return "Transformation parameter '$1$' is required, but was not found in the configuration.";
            }
            case 101: {
                return "Value '$1$' of transformation parameter '$2$' does not identify an existing directory that can be read.";
            }
            case 102: {
                return "The directory '$1$', from which profiles shall be loaded, is empty.";
            }
            case 103: {
                return "Syntax exception while compiling the regular expression defined by transformation parameter '$1$': '$2$'.";
            }
            case 104: {
                return "Element '$2$' from the value of transformation parameter '$1$' is unknown (even when ignoring case). The element will be ignored.";
            }
        }
        return "(Unknown message in " + this.getClass().getName() + ". Message number was: " + mnr + ")";
    }
}

