/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Profiling;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.ModelDiff.DiffElement;
import de.interactive_instruments.ShapeChange.ModelDiff.Differ;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.Profile.ModelProfileValidator;
import de.interactive_instruments.ShapeChange.Profile.ProfileUtil;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class ProfileLoader
implements Transformer,
MessageSource {
    public static final String RULE_PRE_DELETE_INPUT_MODEL_PROFILES = "rule-trf-profileLoader-preProcessing-deleteInputModelProfiles";
    public static final String RULE_PRE_VALIDATE_INPUT_MODEL_PROFILES = "rule-trf-profileLoader-preProcessing-validateInputModelProfiles";
    public static final String RULE_POST_VALIDATE_RESULTING_MODEL_PROFILES = "rule-trf-profileLoader-postProcessing-validateResultingModelProfiles";
    public static final String RULE_VALIDATE_LOADED_MODEL_PROFILES = "rule-trf-profileLoader-validateLoadedModelProfiles";
    public static final String RULE_DIFF_MODELS = "rule-trf-profileLoader-diffModels";
    public static final String PARAM_PROCESS_ALL_SCHEMAS = "processAllSchemas";
    public static final String PARAM_INPUT_MODEL_EXPLICIT_PROFILES = "profilesInModelSetExplicitly";
    public static final String PARAM_LOAD_MODEL_FILE_REGEX = "regexToFilterProfilesToLoad";
    public static final String PARAM_PROFILES_FOR_CLASSES_WITHOUT_EXPLICIT_PROFILES = "profilesForClassesWithoutExplicitProfileAssignments";
    public static final String PARAM_PROFILES_TO_LOAD = "profilesToLoad";
    public static final String PARAM_LOAD_MODEL_DIRECTORY = "directoryWithProfilesToLoad";
    public static final String PARAM_DIFF_ELEMENT_TYPES = "diffElementTypes";
    public static final String[] DEFAULT_DIFF_ELEMENT_TYPES = new String[]{"CLASS", "ENUM", "MULTIPLICITY", "PROPERTY", "NAME", "STEREOTYPE", "SUPERTYPE", "SUBPACKAGE", "VALUETYPE"};
    private ShapeChangeResult result = null;
    private Options options = null;
    private GenericModel inputModel = null;
    private Set<String> rules = new HashSet<String>();

    @Override
    public void process(GenericModel m, Options o, TransformerConfiguration trfConfig, ShapeChangeResult r) throws ShapeChangeAbortException {
        ModelProfileValidator mpv;
        this.result = r;
        this.options = o;
        this.inputModel = m;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        if (ruleSets != null && !ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                this.rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        boolean processAllSchemas = trfConfig.parameterAsBoolean(PARAM_PROCESS_ALL_SCHEMAS, false);
        TreeSet<String> profilesToLoad = null;
        if (trfConfig.hasParameter(PARAM_PROFILES_TO_LOAD)) {
            profilesToLoad = new TreeSet<String>(trfConfig.parameterAsStringList(PARAM_PROFILES_TO_LOAD, null, true, true));
        }
        boolean removeProfilesInInputModel = this.rules.contains(RULE_PRE_DELETE_INPUT_MODEL_PROFILES);
        boolean inputModelExplicitProfiles = trfConfig.parameterAsBoolean(PARAM_INPUT_MODEL_EXPLICIT_PROFILES, true);
        TreeSet loadedProfileFiles = null;
        String loadedModelDirectory = trfConfig.getParameterValue(PARAM_LOAD_MODEL_DIRECTORY);
        Pattern loadModelFilePattern = null;
        if (trfConfig.hasParameter(PARAM_LOAD_MODEL_FILE_REGEX)) {
            try {
                loadModelFilePattern = Pattern.compile(trfConfig.parameterAsString(PARAM_LOAD_MODEL_FILE_REGEX, "", false, true));
            }
            catch (PatternSyntaxException e) {
                this.result.addError(this, 100, PARAM_LOAD_MODEL_FILE_REGEX, e.getMessage());
            }
        }
        File loadedModelDirectoryFile = new File(loadedModelDirectory);
        boolean exi = loadedModelDirectoryFile.exists();
        boolean dir = loadedModelDirectoryFile.isDirectory();
        boolean rea = loadedModelDirectoryFile.canRead();
        if (!(exi && dir && rea)) {
            this.result.addError(this, 101, PARAM_LOAD_MODEL_DIRECTORY, loadedModelDirectory);
        } else {
            if (loadModelFilePattern == null) {
                loadedProfileFiles = new TreeSet(FileUtils.listFiles((File)loadedModelDirectoryFile, (String[])new String[]{"xml", "zip"}, (boolean)false));
            } else {
                RegexFileFilter fileFilter = new RegexFileFilter(loadModelFilePattern);
                loadedProfileFiles = new TreeSet(FileUtils.listFiles((File)loadedModelDirectoryFile, (IOFileFilter)fileFilter, null));
            }
            if (loadedProfileFiles.isEmpty()) {
                this.result.addWarning(this, 102, loadedModelDirectory);
            }
        }
        List<String> diffElementTypeNames = trfConfig.parameterAsStringList(PARAM_DIFF_ELEMENT_TYPES, DEFAULT_DIFF_ELEMENT_TYPES, true, true);
        HashSet<DiffElement.ElementType> relevantDiffElementTypes = new HashSet<DiffElement.ElementType>();
        for (String detn : diffElementTypeNames) {
            try {
                DiffElement.ElementType et = DiffElement.ElementType.valueOf(detn.toUpperCase(Locale.ENGLISH));
                relevantDiffElementTypes.add(et);
            }
            catch (IllegalArgumentException et) {}
        }
        if (removeProfilesInInputModel) {
            this.result.addInfo(this, 112);
            ProfileUtil.removeProfiles(this.inputModel);
        } else {
            if (this.rules.contains(RULE_PRE_VALIDATE_INPUT_MODEL_PROFILES)) {
                this.result.addProcessFlowInfo(this, 111);
                mpv = new ModelProfileValidator(this.inputModel, this.result);
                mpv.validateModelConsistency(inputModelExplicitProfiles, true, !processAllSchemas);
                this.result.addProcessFlowInfo(this, 115);
            }
            if (!inputModelExplicitProfiles) {
                this.result.addInfo(this, 113);
                SortedSet<String> profilesForClassesWithoutExplicitProfiles = null;
                profilesForClassesWithoutExplicitProfiles = trfConfig.hasParameter(PARAM_PROFILES_FOR_CLASSES_WITHOUT_EXPLICIT_PROFILES) ? new TreeSet<String>(trfConfig.parameterAsStringList(PARAM_PROFILES_FOR_CLASSES_WITHOUT_EXPLICIT_PROFILES, null, true, true)) : ProfileUtil.findNamesOfAllProfiles(this.inputModel, processAllSchemas);
                Profiles profilesForClassesBelongingToAllProfiles = new Profiles();
                for (String profileName : profilesForClassesWithoutExplicitProfiles) {
                    profilesForClassesBelongingToAllProfiles.put(profileName);
                }
                Pattern schemaNameRegex = null;
                ProfileUtil.convertToExplicitProfileDefinitions(this.inputModel, profilesForClassesBelongingToAllProfiles, schemaNameRegex, processAllSchemas);
            }
        }
        if (loadedProfileFiles != null && !loadedProfileFiles.isEmpty()) {
            HashMap inputModelClassesByNameBySchemaName = new HashMap();
            for (PackageInfo pi : this.inputModel.schemas(null)) {
                HashMap<String, GenericClassInfo> genClassesByClassName = new HashMap<String, GenericClassInfo>();
                for (ClassInfo ci : this.inputModel.classes(pi)) {
                    genClassesByClassName.put(ci.name(), (GenericClassInfo)ci);
                }
                inputModelClassesByNameBySchemaName.put(pi.name(), genClassesByClassName);
            }
            for (File loadedProfileFile : loadedProfileFiles) {
                String loadedProfileFileLocation = loadedProfileFile.getAbsolutePath();
                try {
                    this.result.addInfo(this, 114, loadedProfileFileLocation);
                    GenericModel loadedModel = new GenericModel();
                    loadedModel.initialise(this.result, this.options, loadedProfileFileLocation);
                    TreeMap loadedModelClassesBySchemaName = new TreeMap();
                    for (PackageInfo packageInfo : loadedModel.schemas(null)) {
                        TreeSet<GenericClassInfo> genClasses = new TreeSet<GenericClassInfo>();
                        for (ClassInfo ci : loadedModel.classes(packageInfo)) {
                            genClasses.add((GenericClassInfo)ci);
                        }
                        loadedModelClassesBySchemaName.put(packageInfo.name(), genClasses);
                    }
                    if (this.rules.contains(RULE_VALIDATE_LOADED_MODEL_PROFILES)) {
                        this.result.addProcessFlowInfo(this, 110, loadedProfileFileLocation);
                        ModelProfileValidator mpv2 = new ModelProfileValidator(loadedModel, this.result);
                        mpv2.validateModelConsistency(true, true, !processAllSchemas);
                        this.result.addProcessFlowInfo(this, 116, loadedProfileFileLocation);
                    }
                    if (this.rules.contains(RULE_DIFF_MODELS)) {
                        this.result.addProcessFlowInfo(this, 105, loadedProfileFileLocation);
                        SortedSet<PackageInfo> schemasToDiff = processAllSchemas ? this.inputModel.schemas(null) : this.inputModel.selectedSchemas();
                        for (PackageInfo inputSchema : schemasToDiff) {
                            SortedSet<PackageInfo> set = loadedModel.schemas(inputSchema.name());
                            if (set.size() == 1) {
                                String refSchemaVersion;
                                Differ differ = new Differ();
                                PackageInfo refSchema = (PackageInfo)set.iterator().next();
                                String inputSchemaVersion = inputSchema.version();
                                if (inputSchemaVersion == null) {
                                    inputSchemaVersion = "";
                                }
                                if ((refSchemaVersion = refSchema.version()) == null) {
                                    refSchemaVersion = "";
                                }
                                if (!inputSchemaVersion.equals(refSchemaVersion)) {
                                    this.result.addInfo(this, 107, inputSchema.fullName(), inputSchemaVersion, refSchemaVersion);
                                }
                                SortedMap<Info, SortedSet<DiffElement>> pi_diffs = differ.diff(inputSchema, refSchema);
                                for (Map.Entry<Info, SortedSet<DiffElement>> me : pi_diffs.entrySet()) {
                                    TreeSet<DiffElement> relevantDiffs = new TreeSet<DiffElement>();
                                    for (DiffElement diff : me.getValue()) {
                                        if (!relevantDiffElementTypes.contains((Object)diff.subElementType)) continue;
                                        relevantDiffs.add(diff);
                                    }
                                    if (relevantDiffs.isEmpty()) continue;
                                    ShapeChangeResult.MessageContext mc = this.result.addInfo(this, 108, me.getKey().fullName().replace(inputSchema.fullName(), inputSchema.name()));
                                    for (DiffElement diff : relevantDiffs) {
                                        String s = diff.change + " " + diff.subElementType;
                                        if (diff.subElementType == DiffElement.ElementType.TAG) {
                                            s = s + "(" + diff.tag + ")";
                                        }
                                        s = diff.subElement != null ? s + " " + diff.subElement.name() : (diff.diff != null ? s + " " + diff.diff_from_to() : s + " ???");
                                        mc.addDetail(s);
                                    }
                                }
                                continue;
                            }
                            this.result.addWarning(this, 104, inputSchema.name());
                        }
                        this.result.addProcessFlowInfo(this, 106, loadedProfileFileLocation);
                    }
                    for (Map.Entry entry : loadedModelClassesBySchemaName.entrySet()) {
                        String schemaName = (String)entry.getKey();
                        if (!inputModelClassesByNameBySchemaName.containsKey(schemaName)) continue;
                        SortedSet loadedSchemaCis = (SortedSet)entry.getValue();
                        Map inputSchemaCisByClassName = (Map)inputModelClassesByNameBySchemaName.get(schemaName);
                        for (GenericClassInfo loadedCi : loadedSchemaCis) {
                            if (!processAllSchemas && !loadedModel.isInSelectedSchemas(loadedCi) || loadedCi.profiles().isEmpty() || profilesToLoad != null && loadedCi.profiles().getProfiles(profilesToLoad).isEmpty() || !inputSchemaCisByClassName.containsKey(loadedCi.name())) continue;
                            GenericClassInfo inputCi = (GenericClassInfo)inputSchemaCisByClassName.get(loadedCi.name());
                            ProfileUtil.transferProfiles(profilesToLoad, loadedCi, inputCi);
                            for (PropertyInfo loadedCiPi : loadedCi.properties().values()) {
                                GenericPropertyInfo inputCiPi = (GenericPropertyInfo)inputCi.ownedProperty(loadedCiPi.name());
                                if (inputCiPi == null) continue;
                                ProfileUtil.transferProfiles(profilesToLoad, loadedCiPi, inputCiPi);
                            }
                        }
                    }
                }
                catch (ShapeChangeAbortException e) {
                    this.result.addError(this, 103, loadedProfileFileLocation, e.getMessage());
                }
            }
        }
        if (this.rules.contains(RULE_POST_VALIDATE_RESULTING_MODEL_PROFILES)) {
            this.result.addInfo(this, 109);
            mpv = new ModelProfileValidator(this.inputModel, this.result);
            mpv.validateModelConsistency(true, true, !processAllSchemas);
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: class $1$";
            }
            case 2: {
                return "Context: property $1$";
            }
            case 100: {
                return "Syntax exception while compiling the regular expression defined by transformation parameter '$1$': '$2$'. The parameter will be ignored.";
            }
            case 101: {
                return "Value '$1$' of transformation parameter '$2$' does not identify an existing directory that can be read.";
            }
            case 102: {
                return "The directory '$1$', from which profiles shall be loaded, is empty.";
            }
            case 103: {
                return "Model could not be loaded from '$1$'. It will be ignored. Details: $2$";
            }
            case 104: {
                return "Schema from input model with name '$1$' has no equivalent package in the loaded model. Consequently, no diff was performed.";
            }
            case 105: {
                return "------ Start model diff (compare model loaded from '$1$' against input model)";
            }
            case 106: {
                return "------ End model diff (compare model loaded from '$1$' against input model)";
            }
            case 107: {
                return "Model difference - version of schema '$1$' from input model is '$2$', version of reference schema from loaded model is '$3$'.";
            }
            case 108: {
                return "Model difference - $1$";
            }
            case 109: {
                return "Validating profiles in resulting model.";
            }
            case 110: {
                return "------ Start validating profiles in model loaded from '$1$'.";
            }
            case 111: {
                return "------ Start validating profiles in input model.";
            }
            case 112: {
                return "Removing profiles in input model.";
            }
            case 113: {
                return "Converting profile definitions in input model to explicit definitions.";
            }
            case 114: {
                return "Loading profiles from model located at '$1$'.";
            }
            case 115: {
                return "------ End validating profiles in input model.";
            }
            case 116: {
                return "------ End validating profiles in model loaded from '$1$'.";
            }
        }
        return "(Unknown message in " + this.getClass().getName() + ". Message number was: " + mnr + ")";
    }
}

