/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Profiling;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ProfileConstraintTransformerConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("baseSchemaClassesNotToBeProhibitedRegex", "baseSchemaName", "baseSchemaNameRegex", "baseSchemaNamespaceRegex", "profileName", "profileSchemaName", "subtypeNamePrefix").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTransformerParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        Map<String, ProcessRuleSet> ruleSets = config.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (rules.contains("rule-trf-cls-createGeneralOutOfScopeConstraints")) {
            isValid &= this.checkCombinationOfParameters("rule-trf-cls-createGeneralOutOfScopeConstraints", config, result, "baseSchemaName", "baseSchemaNameRegex", "baseSchemaNamespaceRegex");
            isValid &= this.checkRequiredParameter("profileSchemaName", "rule-trf-cls-createGeneralOutOfScopeConstraints", config, result);
            isValid &= this.checkRequiredParameter("profileName", "rule-trf-cls-createGeneralOutOfScopeConstraints", config, result);
        }
        if (rules.contains("rule-trf-cls-prohibitBaseSchemaTypesWithDirectUnsuppressedProfileSchemaSubtypes")) {
            isValid &= this.checkCombinationOfParameters("rule-trf-cls-prohibitBaseSchemaTypesWithDirectUnsuppressedProfileSchemaSubtypes", config, result, "baseSchemaName", "baseSchemaNameRegex", "baseSchemaNamespaceRegex");
            isValid &= this.checkRequiredParameter("profileSchemaName", "rule-trf-cls-prohibitBaseSchemaTypesWithDirectUnsuppressedProfileSchemaSubtypes", config, result);
            isValid &= this.checkRequiredParameter("profileName", "rule-trf-cls-prohibitBaseSchemaTypesWithDirectUnsuppressedProfileSchemaSubtypes", config, result);
        }
        return isValid;
    }

    private boolean checkCombinationOfParameters(String ruleName, ProcessConfiguration config, ShapeChangeResult result, String ... parameterNames) {
        for (String pn : parameterNames) {
            String paramValue = config.parameterAsString(pn, null, false, true);
            if (paramValue == null) continue;
            return true;
        }
        result.addError(this, 101, StringUtils.join((Object[])parameterNames, (String)", "));
        return false;
    }

    private boolean checkRequiredParameter(String parameterName, String ruleName, ProcessConfiguration config, ShapeChangeResult result) {
        String paramValue = config.parameterAsString(parameterName, null, false, true);
        if (paramValue == null) {
            result.addError(this, 100, parameterName, ruleName);
            return false;
        }
        return true;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 4: {
                return "Syntax exception for regular expression value of configuration parameter '$1$'. Regular expression value was: $2$. Exception message: $3$.";
            }
            case 100: {
                return "Parameter '$1$' is required for rule '$2$' but no actual value was found in the configuration.";
            }
            case 101: {
                return "At least one of the parameters '$1$' must be provided.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

