/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Profiling;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericOclConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPackageInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ProfileConstraintTransformer
implements Transformer,
MessageSource {
    public static final String PARAM_BASE_SCHEMA_NAME = "baseSchemaName";
    public static final String PARAM_BASE_SCHEMA_NAME_REGEX = "baseSchemaNameRegex";
    public static final String PARAM_BASE_SCHEMA_NAMESPACE_REGEX = "baseSchemaNamespaceRegex";
    public static final String PARAM_PROFILE_SCHEMA_NAME = "profileSchemaName";
    public static final String PARAM_PROFILE_NAME = "profileName";
    public static final String PARAM_SUBTYPE_NAME_PREFIX = "subtypeNamePrefix";
    public static final String PARAM_BASE_SCHEMA_CLASSES_NOT_TO_BE_PROHIBITED_REGEX = "baseSchemaClassesNotToBeProhibitedRegex";
    public static final String RULE_TRF_CLS_CREATE_GENERAL_OUT_OF_SCOPE_CONSTRAINTS = "rule-trf-cls-createGeneralOutOfScopeConstraints";
    public static final String RULE_TRF_CLS_PROHIBIT_BASE_SCHEMA_TYPES_WITH_DIRECT_UNSUPPRESSED_PROFILE_SCHEMA_SUBTYPES = "rule-trf-cls-prohibitBaseSchemaTypesWithDirectUnsuppressedProfileSchemaSubtypes";
    public static final String TV_PROHIBITED_IN_PROFILE_SCHEMA = "prohibitedInProfile";
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public void process(GenericModel genModel, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.options = options;
        this.result = result;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (rules.isEmpty()) {
            return;
        }
        if (rules.contains(RULE_TRF_CLS_CREATE_GENERAL_OUT_OF_SCOPE_CONSTRAINTS)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_CREATE_GENERAL_OUT_OF_SCOPE_CONSTRAINTS);
            this.applyRuleCreateGeneralOutOfScopeConstraints(genModel, trfConfig, rules);
        }
        if (rules.contains(RULE_TRF_CLS_PROHIBIT_BASE_SCHEMA_TYPES_WITH_DIRECT_UNSUPPRESSED_PROFILE_SCHEMA_SUBTYPES)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_PROHIBIT_BASE_SCHEMA_TYPES_WITH_DIRECT_UNSUPPRESSED_PROFILE_SCHEMA_SUBTYPES);
            this.applyRuleProhibitBaseSchemaTypesWithDirectUnsuppressedProfileSchemaSubtypes(genModel, trfConfig, rules);
        }
    }

    private void applyRuleProhibitBaseSchemaTypesWithDirectUnsuppressedProfileSchemaSubtypes(GenericModel genModel, TransformerConfiguration config, Set<String> rules) {
        String baseSchemaClassesNotToBeProhibitedRegex = config.getParameterValue(PARAM_BASE_SCHEMA_CLASSES_NOT_TO_BE_PROHIBITED_REGEX);
        SortedSet<PackageInfo> baseSchemas = this.getBaseSchemas(genModel, config);
        if (baseSchemas.isEmpty()) {
            this.result.addError(this, 100);
            return;
        }
        String profileSchemaName = config.getParameterValue(PARAM_PROFILE_SCHEMA_NAME);
        String profileName = config.getParameterValue(PARAM_PROFILE_NAME);
        SortedSet<PackageInfo> profileSchemaSet = genModel.schemas(profileSchemaName);
        if (profileSchemaSet.isEmpty()) {
            this.result.addError(this, 100, profileSchemaName);
            return;
        }
        if (profileSchemaSet.size() > 1) {
            this.result.addError(this, 101, profileSchemaName);
            return;
        }
        GenericPackageInfo profileSchema = (GenericPackageInfo)profileSchemaSet.first();
        SortedSet<GenericClassInfo> baseSchemaClasses = this.getBaseSchemaClasses(genModel, baseSchemas);
        for (GenericClassInfo baseSchemaClass : baseSchemaClasses) {
            SortedSet<GenericClassInfo> profileSchemaSubtypes;
            if (baseSchemaClass.isAbstract() || !baseSchemaClass.profiles().hasProfile(profileName) || baseSchemaClass.category() == 3 || baseSchemaClass.category() == 2 || !StringUtils.isBlank((CharSequence)baseSchemaClassesNotToBeProhibitedRegex) && baseSchemaClass.name().matches(baseSchemaClassesNotToBeProhibitedRegex) || (profileSchemaSubtypes = this.getDirectUnsuppressedSubtypesFromProfileSchema(baseSchemaClass, profileSchema)).isEmpty()) continue;
            String pss_names = profileSchemaSubtypes.stream().map(Info::name).sorted().collect(Collectors.joining(", "));
            GenericClassInfo suppressedSubtype = this.getOrCreateSuppressedSubtypeInProfileSchema(baseSchemaClass, profileSchema, genModel, config);
            String constrName = baseSchemaClass.name() + "_prohibited";
            String constrStatus = "Approved";
            String constrText = "/*" + baseSchemaClass.name() + " is prohibited. Use (one of) the following type(s) instead: " + pss_names + ".*/\r\ninv: self->isEmpty()";
            GenericOclConstraint con = new GenericOclConstraint(suppressedSubtype, constrName, constrStatus, constrText);
            ArrayList<Constraint> newCons = new ArrayList<Constraint>();
            newCons.add(con);
            suppressedSubtype.addConstraints(newCons);
            baseSchemaClass.setTaggedValue(TV_PROHIBITED_IN_PROFILE_SCHEMA, "true", false);
        }
    }

    private SortedSet<GenericClassInfo> getBaseSchemaClasses(GenericModel genModel, SortedSet<PackageInfo> baseSchemas) {
        TreeSet<GenericClassInfo> result = new TreeSet<GenericClassInfo>();
        for (PackageInfo bs : baseSchemas) {
            for (ClassInfo ci : genModel.classes(bs)) {
                result.add((GenericClassInfo)ci);
            }
        }
        return result;
    }

    private SortedSet<PackageInfo> getBaseSchemas(GenericModel genModel, TransformerConfiguration config) {
        String baseSchemaName = config.getParameterValue(PARAM_BASE_SCHEMA_NAME);
        String baseSchemaNameRegex = config.getParameterValue(PARAM_BASE_SCHEMA_NAME_REGEX);
        String baseSchemaNamespaceRegex = config.getParameterValue(PARAM_BASE_SCHEMA_NAMESPACE_REGEX);
        TreeSet<PackageInfo> baseSchemas = new TreeSet<PackageInfo>();
        for (PackageInfo schema : genModel.schemas(null)) {
            String name = schema.name();
            String ns = schema.targetNamespace();
            if (StringUtils.isNotBlank((CharSequence)baseSchemaName) && !baseSchemaName.equals(name) || StringUtils.isNotBlank((CharSequence)baseSchemaNameRegex) && !name.matches(baseSchemaNameRegex) || StringUtils.isNotBlank((CharSequence)baseSchemaNamespaceRegex) && !ns.matches(baseSchemaNamespaceRegex)) continue;
            baseSchemas.add(schema);
        }
        return baseSchemas;
    }

    private boolean hasDirectUnsuppressedSubtypeFromProfileSchema(ClassInfo ci, GenericPackageInfo profileSchema) {
        return !this.getDirectUnsuppressedSubtypesFromProfileSchema(ci, profileSchema).isEmpty();
    }

    private SortedSet<GenericClassInfo> getDirectUnsuppressedSubtypesFromProfileSchema(ClassInfo ci, GenericPackageInfo profileSchema) {
        SortedSet<GenericClassInfo> result = this.getDirectSubtypesInProfileSchema(ci, profileSchema);
        result.removeIf(p -> p.suppressed());
        return result;
    }

    private SortedSet<GenericClassInfo> getDirectSuppressedSubtypesFromProfileSchema(ClassInfo ci, GenericPackageInfo profileSchema) {
        SortedSet<GenericClassInfo> result = this.getDirectSubtypesInProfileSchema(ci, profileSchema);
        result.removeIf(p -> !p.suppressed());
        return result;
    }

    private void applyRuleCreateGeneralOutOfScopeConstraints(GenericModel genModel, TransformerConfiguration config, Set<String> rules) {
        String baseSchemaClassesNotToBeProhibitedRegex = config.getParameterValue(PARAM_BASE_SCHEMA_CLASSES_NOT_TO_BE_PROHIBITED_REGEX);
        SortedSet<PackageInfo> baseSchemas = this.getBaseSchemas(genModel, config);
        if (baseSchemas.isEmpty()) {
            this.result.addError(this, 100);
            return;
        }
        String profileSchemaName = config.getParameterValue(PARAM_PROFILE_SCHEMA_NAME);
        String profileName = config.getParameterValue(PARAM_PROFILE_NAME);
        SortedSet<PackageInfo> profileSchemaSet = genModel.schemas(profileSchemaName);
        if (profileSchemaSet.isEmpty()) {
            this.result.addError(this, 100, profileSchemaName);
            return;
        }
        if (profileSchemaSet.size() > 1) {
            this.result.addError(this, 101, profileSchemaName);
            return;
        }
        GenericPackageInfo profileSchema = (GenericPackageInfo)profileSchemaSet.first();
        SortedSet<GenericClassInfo> baseSchemaClasses = this.getBaseSchemaClasses(genModel, baseSchemas);
        for (GenericClassInfo baseSchemaClass : baseSchemaClasses) {
            if (!baseSchemaClass.profiles().hasProfile(profileName)) {
                if (baseSchemaClass.category() == 3 || baseSchemaClass.category() == 2 || baseSchemaClass.isAbstract()) continue;
                SortedSet<GenericClassInfo> profileSchemaSubtypes = this.getDirectUnsuppressedSubtypesFromProfileSchema(baseSchemaClass, profileSchema);
                if (!profileSchemaSubtypes.isEmpty()) {
                    ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 102, baseSchemaClass.name(), profileSchemaSubtypes.stream().map(Info::name).sorted().collect(Collectors.joining(", ")));
                    if (mc == null) continue;
                    mc.addDetail(this, 1, baseSchemaClass.fullNameInSchema());
                    continue;
                }
                GenericClassInfo subtype = this.getOrCreateSuppressedSubtypeInProfileSchema(baseSchemaClass, profileSchema, genModel, config);
                String constrName = baseSchemaClass.name() + "_prohibited";
                String constrStatus = "Approved";
                String constrText = "/*" + baseSchemaClass.name() + " is prohibited.*/\r\ninv: self->isEmpty()";
                GenericOclConstraint con = new GenericOclConstraint(subtype, constrName, constrStatus, constrText);
                ArrayList<Constraint> newCons = new ArrayList<Constraint>();
                newCons.add(con);
                subtype.addConstraints(newCons);
                baseSchemaClass.setTaggedValue(TV_PROHIBITED_IN_PROFILE_SCHEMA, "true", false);
                continue;
            }
            TreeSet<PropertyInfo> irrelevantProps = new TreeSet<PropertyInfo>();
            for (PropertyInfo pi : baseSchemaClass.properties().values()) {
                if (pi.profiles().hasProfile(profileName)) continue;
                irrelevantProps.add(pi);
                ((GenericPropertyInfo)pi).setTaggedValue(TV_PROHIBITED_IN_PROFILE_SCHEMA, "true", false);
            }
            if (irrelevantProps.isEmpty()) continue;
            if (baseSchemaClass.category() == 2 || baseSchemaClass.category() == 3) {
                String namesOfIrrelevantProperties = irrelevantProps.stream().map(Info::name).sorted().collect(Collectors.joining(", "));
                ShapeChangeResult.MessageContext mc = this.result.addInfo(this, 103, baseSchemaClass.name(), namesOfIrrelevantProperties);
                if (mc == null) continue;
                mc.addDetail(this, 1, baseSchemaClass.fullNameInSchema());
                continue;
            }
            SortedSet<ClassInfo> classesInClassHierarchy = baseSchemaClass.subtypesInCompleteHierarchy();
            classesInClassHierarchy.add(baseSchemaClass);
            TreeSet<ClassInfo> relevantBaseClassesInClassHierarchy = new TreeSet<ClassInfo>();
            for (ClassInfo ci : classesInClassHierarchy) {
                if (ci.isAbstract() || !ci.profiles().hasProfile(profileName) || !baseSchemaClasses.contains(ci)) continue;
                relevantBaseClassesInClassHierarchy.add(ci);
            }
            for (ClassInfo relevantBaseClass : relevantBaseClassesInClassHierarchy) {
                SortedSet<GenericClassInfo> profileSchemaSubtypesToCreateOCLConstraintsFor = this.getDirectUnsuppressedSubtypesFromProfileSchema(relevantBaseClass, profileSchema);
                if (!rules.contains(RULE_TRF_CLS_PROHIBIT_BASE_SCHEMA_TYPES_WITH_DIRECT_UNSUPPRESSED_PROFILE_SCHEMA_SUBTYPES) || !this.hasDirectUnsuppressedSubtypeFromProfileSchema(relevantBaseClass, profileSchema) || !StringUtils.isBlank((CharSequence)baseSchemaClassesNotToBeProhibitedRegex) && baseSchemaClass.name().matches(baseSchemaClassesNotToBeProhibitedRegex)) {
                    GenericClassInfo subtype = this.getOrCreateSuppressedSubtypeInProfileSchema((GenericClassInfo)relevantBaseClass, profileSchema, genModel, config);
                    profileSchemaSubtypesToCreateOCLConstraintsFor.add(subtype);
                }
                for (GenericClassInfo profileSchemaSubtype : profileSchemaSubtypesToCreateOCLConstraintsFor) {
                    ArrayList<Constraint> newCons = new ArrayList<Constraint>();
                    for (PropertyInfo pi : irrelevantProps) {
                        String constrName = pi.name() + "_prohibited";
                        String constrStatus = "Approved";
                        String constrText = "/*" + pi.name() + " is prohibited.*/\r\ninv: " + pi.name() + "->isEmpty()";
                        GenericOclConstraint con = new GenericOclConstraint(profileSchemaSubtype, constrName, constrStatus, constrText);
                        newCons.add(con);
                    }
                    profileSchemaSubtype.addConstraints(newCons);
                }
            }
        }
    }

    private SortedSet<GenericClassInfo> getDirectSubtypesInProfileSchema(ClassInfo ci, GenericPackageInfo profileSchema) {
        Model model = ci.model();
        SortedSet<ClassInfo> profileSchemaClasses = model.classes(profileSchema);
        TreeSet<GenericClassInfo> result = new TreeSet<GenericClassInfo>();
        for (String subtypeId : ci.subtypes()) {
            ClassInfo subtype = model.classById(subtypeId);
            if (!profileSchemaClasses.contains(subtype)) continue;
            result.add((GenericClassInfo)subtype);
        }
        return result;
    }

    private GenericClassInfo getOrCreateSuppressedSubtypeInProfileSchema(GenericClassInfo baseClass, GenericPackageInfo profileSchema, GenericModel genModel, TransformerConfiguration config) {
        SortedSet<GenericClassInfo> dss = this.getDirectSuppressedSubtypesFromProfileSchema(baseClass, profileSchema);
        if (!dss.isEmpty()) {
            return dss.first();
        }
        String subtypeNamePrefix = config.parameterAsString(PARAM_SUBTYPE_NAME_PREFIX, null, false, true);
        String baseName = baseClass.name();
        String subtypeName = subtypeNamePrefix == null ? baseName : subtypeNamePrefix + baseName;
        GenericClassInfo subtype = new GenericClassInfo(genModel, baseClass.id() + "_ProfileSchemaSubtype", subtypeName, baseClass.category());
        subtype.setDescriptors(new Descriptors());
        subtype.setProfiles(null);
        subtype.setStereotypes(baseClass.stereotypes());
        subtype.setIsAbstract(false);
        subtype.setIsLeaf(false);
        subtype.setAssocInfo(null);
        subtype.setProperties(new TreeMap<StructuredNumber, PropertyInfo>());
        subtype.setTaggedValue("suppress", "true", false);
        subtype.setPkg(profileSchema);
        subtype.addSupertype(baseClass.id());
        baseClass.addSubtype(subtype.id());
        subtype.setSubtypes(null);
        genModel.register(subtype);
        profileSchema.addClass(subtype);
        return subtype;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 100: {
                return "No base schema found in the model. Rule will not be processed.";
            }
            case 101: {
                return "";
            }
            case 102: {
                return "Base schema class '$1$' is tagged as irrelevant. However, the class has at least one subtype in the profile schema, which indicates that the class is in fact relevant. The (direct and indirect) subtypes in the profile schema are: $2$. No OCL constraint will be created to mark class '$1$' as prohibited.";
            }
            case 103: {
                return "Base schema class '$1$' is tagged as relevant and it contains irrelevant properties ($2$). However, the class is a code list or enumeration. This case is currently not supported. No specific OCL constraints will be created to prohibit these properties.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

