/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Naming;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.ModelElementSelectionInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessRuleModelElementSelectionConfigurationEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeParseException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.StringUtils;

public class NamingModifierConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("camelCaseToUpperCase_taggedValues", "suffix", "modelElementNamesToAddSuffixRegex", "suffixesToIgnore").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTransformerParameters());
        boolean bl = isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        if (config.getAllRules().contains("rule-trf-add-suffix")) {
            List<Object> prmesces = new ArrayList();
            try {
                prmesces = ProcessRuleModelElementSelectionConfigurationEntry.parseAndValidateConfigurationEntries(config.getAdvancedProcessConfigurations());
                List mesi = prmesces.stream().filter(e -> StringUtils.isNotBlank((String)e.getRule()) && e.getRule().equalsIgnoreCase("rule-trf-add-suffix")).map(e -> e.getModelElementSelectionInfo()).collect(Collectors.toList());
                if (config.hasParameter("modelElementNamesToAddSuffixRegex")) {
                    if (mesi.size() > 0) {
                        isValid = false;
                        result.addError(this, 102);
                    } else {
                        try {
                            Pattern pattern = config.parameterAsRegexPattern("modelElementNamesToAddSuffixRegex", null);
                        }
                        catch (PatternSyntaxException e2) {
                            isValid = false;
                            result.addError(this, 103, e2.getMessage());
                        }
                    }
                } else if (mesi.size() == 0) {
                    isValid = false;
                    result.addError(this, 101);
                } else if (mesi.stream().anyMatch(e -> e.getModelElementType() == ModelElementSelectionInfo.ModelElementType.ASSOCIATION || e.getModelElementType() == ModelElementSelectionInfo.ModelElementType.PACKAGE)) {
                    isValid = false;
                    result.addError(this, 105);
                }
            }
            catch (ShapeChangeParseException e3) {
                isValid = false;
                result.addError(this, 100, e3.getMessage());
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 100: {
                return "Parameter 'modelElementNamesToAddSuffixRegex' is required for rule 'rule-trf-add-suffix' if no ProcessRuleModelElementSelection element is defined for that rule in the advanced process configuration, but no actual value was found in the configuration.";
            }
            case 101: {
                return "Neither parameter 'modelElementNamesToAddSuffixRegex' nor any ProcessRuleModelElementSelection element (in the advanced process configuration) is defined for rule 'rule-trf-add-suffix'. Either the (deprecated) parameter or a ProcessRuleModelElementSelection element must be defined.";
            }
            case 102: {
                return "Both parameter 'modelElementNamesToAddSuffixRegex' and one or more ProcessRuleModelElementSelection elements (in the advanced process configuration) are defined for rule 'rule-trf-add-suffix'. Either the (deprecated) parameter or a ProcessRuleModelElementSelection element must be defined - not both.";
            }
            case 103: {
                return "Pattern syntax exception encountered while parsing (deprecated) parameter 'modelElementNamesToAddSuffixRegex' for rule 'rule-trf-add-suffix'. Fix the regular expression. The exception message is: $1$";
            }
            case 104: {
                return "Invalid ProcessRuleModelElementSelection element(s) encountered. Details: $1$";
            }
            case 105: {
                return "ProcessRuleModelElementSelection element(s) for rule-trf-add-suffix with @modelElementType set to association or package encountered, which is invalid for this rule.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

