/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Naming;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.ModelElementSelectionInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleModelElementSelectionConfigurationEntry;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeParseException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.StringUtils;

public class NamingModifier
implements Transformer,
MessageSource {
    public static final String PARAM_SUFFIX = "suffix";
    public static final String PARAM_SUFFIX_REGEX = "modelElementNamesToAddSuffixRegex";
    public static final String PARAM_SUFFIXES_TO_IGNORE = "suffixesToIgnore";
    public static final String PARAM_CAMEL_CASE_TO_UPPER_CASE_TAGGED_VALUES = "camelCaseToUpperCase_taggedValues";
    public static final String RULE_TRF_ADD_SUFFIX = "rule-trf-add-suffix";
    public static final String RULE_TRF_CAMEL_CASE_TO_UPPER_CASE = "rule-trf-camelcase-to-uppercase";
    public static final String RULE_TRF_CAMEL_CASE_TO_UPPER_CASE_INCLUDE_ENUMS = "rule-trf-camelcase-to-uppercase-include-enums";
    public static final String RULE_TRF_CAMEL_CASE_TO_UPPER_CASE_INCLUDE_CODES = "rule-trf-camelcase-to-uppercase-include-codes";
    public static final String RULE_TRF_CAMEL_CASE_TO_UPPER_CASE_INCLUDE_TAGGED_VALUES = "rule-trf-camelcase-to-uppercase-include-taggedTalues";
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public void process(GenericModel genModel, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.options = options;
        this.result = result;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (rules.isEmpty()) {
            return;
        }
        if (rules.contains(RULE_TRF_ADD_SUFFIX)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_ADD_SUFFIX);
            this.applyRuleAddSuffix(genModel, trfConfig);
        }
        if (rules.contains(RULE_TRF_CAMEL_CASE_TO_UPPER_CASE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CAMEL_CASE_TO_UPPER_CASE);
            this.applyRuleCamelCaseToUpperCase(genModel, trfConfig);
        }
    }

    private void applyRuleCamelCaseToUpperCase(GenericModel genModel, TransformerConfiguration trfConfig) {
        TaggedValues tvs;
        boolean includeTaggedValues = trfConfig.hasRule(RULE_TRF_CAMEL_CASE_TO_UPPER_CASE_INCLUDE_TAGGED_VALUES);
        TreeSet<String> suffixesToIgnore = new TreeSet<String>();
        String suffixToIgnore = trfConfig.getParameterValue(PARAM_SUFFIXES_TO_IGNORE);
        if (suffixToIgnore != null) {
            String[] split = suffixToIgnore.split(",");
            for (String s1 : split) {
                String s2 = s1.trim();
                if (s2.isEmpty()) continue;
                suffixesToIgnore.add(s2);
            }
        }
        TreeSet<String> taggedValueNames = new TreeSet<String>(trfConfig.parameterAsStringList(PARAM_CAMEL_CASE_TO_UPPER_CASE_TAGGED_VALUES, null, true, true));
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if (genPi.inClass().category() == 3 && !trfConfig.getAllRules().contains(RULE_TRF_CAMEL_CASE_TO_UPPER_CASE_INCLUDE_ENUMS) || genPi.inClass().category() == 2 && !trfConfig.getAllRules().contains(RULE_TRF_CAMEL_CASE_TO_UPPER_CASE_INCLUDE_CODES)) continue;
            String newName = this.camelCaseToUpperCaseName(genPi.name(), genPi.fullNameInSchema(), suffixesToIgnore);
            genPi.setName(newName);
            if (!includeTaggedValues) continue;
            tvs = this.camelCaseToUpperCaseTaggedValues(genPi.taggedValuesAll(), taggedValueNames, suffixesToIgnore);
            genPi.setTaggedValues(tvs, false);
        }
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            String newName = this.camelCaseToUpperCaseName(genCi.name(), genCi.fullNameInSchema(), suffixesToIgnore);
            genModel.updateClassName(genCi, newName);
            if (!includeTaggedValues) continue;
            tvs = this.camelCaseToUpperCaseTaggedValues(genCi.taggedValuesAll(), taggedValueNames, suffixesToIgnore);
            genCi.setTaggedValues(tvs, false);
        }
    }

    private TaggedValues camelCaseToUpperCaseTaggedValues(TaggedValues tvsIn, SortedSet<String> taggedValueNames, SortedSet<String> suffixesToIgnore) {
        TaggedValues result = this.options.taggedValueFactory(tvsIn);
        for (String tag : result.keySet()) {
            if (!taggedValueNames.contains(tag)) continue;
            ArrayList<String> updatedValues = new ArrayList<String>();
            for (String tagValue : result.get(tag)) {
                String updatedValue = this.camelCaseToUpperCaseName(tagValue, null, suffixesToIgnore);
                updatedValues.add(updatedValue);
            }
            result.put(tag, updatedValues);
        }
        return result;
    }

    private String camelCaseToUpperCaseName(String name, String modelContext, SortedSet<String> suffixesToIgnore) {
        StringBuffer newName = new StringBuffer();
        String identifiedSuffix = null;
        boolean multipleSuffixesMatch = false;
        for (String suffix : suffixesToIgnore) {
            if (!name.endsWith(suffix)) continue;
            if (identifiedSuffix != null) {
                multipleSuffixesMatch = true;
                if (suffix.length() <= identifiedSuffix.length()) continue;
                identifiedSuffix = suffix;
                continue;
            }
            identifiedSuffix = suffix;
        }
        if (multipleSuffixesMatch && modelContext != null) {
            ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 4, identifiedSuffix);
            mc.addDetail(modelContext);
        }
        if (identifiedSuffix != null) {
            name = name.substring(0, name.lastIndexOf(identifiedSuffix));
        }
        if (!name.isEmpty()) {
            for (int i = 0; i < name.length(); ++i) {
                int codePoint2;
                int codePoint1 = name.codePointAt(i);
                int type1 = Character.getType(codePoint1);
                boolean reachedEndOfName = false;
                if (i + 1 < name.length()) {
                    codePoint2 = name.codePointAt(i + 1);
                } else if (identifiedSuffix != null) {
                    codePoint2 = identifiedSuffix.codePointAt(0);
                } else {
                    reachedEndOfName = true;
                    codePoint2 = Integer.MIN_VALUE;
                }
                if (type1 == 2 || type1 == 1) {
                    newName.append((char)Character.toUpperCase(codePoint1));
                } else if (name.charAt(i) == '_') {
                    newName.append("__");
                } else if (type1 == 9) {
                    newName.append((char)codePoint1);
                } else {
                    newName.append("_");
                }
                if (reachedEndOfName) continue;
                int type2 = Character.getType(codePoint2);
                if (type1 != 2 && type1 != 1 && type1 != 9 || type2 != 1) continue;
                newName.append("_");
            }
        }
        if (identifiedSuffix != null) {
            newName = newName.append(identifiedSuffix);
        }
        return newName.toString();
    }

    private void applyRuleAddSuffix(GenericModel genModel, TransformerConfiguration trfConfig) {
        String newName;
        List<Object> prmesces = new ArrayList();
        try {
            prmesces = ProcessRuleModelElementSelectionConfigurationEntry.parseAndValidateConfigurationEntries(trfConfig.getAdvancedProcessConfigurations());
        }
        catch (ShapeChangeParseException e2) {
            this.result.addError(this, 104, e2.getMessage());
            return;
        }
        List mesi = prmesces.stream().filter(e -> StringUtils.isNotBlank((String)e.getRule()) && e.getRule().equalsIgnoreCase(RULE_TRF_ADD_SUFFIX)).map(e -> e.getModelElementSelectionInfo()).filter(e -> e.getModelElementType() != ModelElementSelectionInfo.ModelElementType.ASSOCIATION && e.getModelElementType() != ModelElementSelectionInfo.ModelElementType.PACKAGE).collect(Collectors.toList());
        String suffix = trfConfig.parameterAsString(PARAM_SUFFIX, "_", false, true);
        Pattern suffixPattern = null;
        if (mesi.isEmpty()) {
            String suffixRegex = trfConfig.getParameterValue(PARAM_SUFFIX_REGEX);
            if (suffixRegex != null) {
                if ((suffixRegex = suffixRegex.trim()).length() == 0) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 1, PARAM_SUFFIX_REGEX, RULE_TRF_ADD_SUFFIX);
                    mc.addDetail(this, 0);
                    return;
                }
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 2, PARAM_SUFFIX_REGEX, RULE_TRF_ADD_SUFFIX);
                mc.addDetail(this, 0);
                return;
            }
            try {
                suffixPattern = Pattern.compile(suffixRegex);
            }
            catch (PatternSyntaxException e3) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 3, PARAM_SUFFIX_REGEX, RULE_TRF_ADD_SUFFIX, suffixRegex, e3.getMessage());
                mc.addDetail(this, 0);
                return;
            }
        }
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            if ((suffixPattern == null || !suffixPattern.matcher(genCi.name()).matches()) && !mesi.stream().anyMatch(e -> e.matches(genCi))) continue;
            newName = genCi.name() + suffix;
            genModel.updateClassName(genCi, newName);
        }
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if ((suffixPattern == null || !suffixPattern.matcher(genPi.name()).matches()) && !mesi.stream().anyMatch(e -> e.matches(genPi))) continue;
            newName = genPi.name() + suffix;
            genPi.setName(newName);
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class NamingModifier";
            }
            case 3: {
                return "Syntax exception for regular expression value of configuration parameter '$1$' (required for execution of rule '$2$'). Regular expression value was: $3$. Exception message: $4$. Execution of rule '$2$' aborted.";
            }
            case 4: {
                return "Multiple suffixes (identified by configuration parameter 'suffixesToIgnore' match the end of the model element name. Suffix '$1$' was chosen.";
            }
            case 104: {
                return "Invalid ProcessRuleModelElementSelection element(s) encountered. Details: $1$";
            }
        }
        return "(" + NamingModifier.class.getName() + ") Unknown message with number: " + mnr;
    }
}

