/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.ModelCleaner;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class ModelCleaner
implements Transformer,
MessageSource {
    public static final String PARAM_REASON_PROPERTY_REGEX = "unionDirectReasonPropertyNameRegex";
    public static final String RULE_TRF_CLEANER_FIX_UNION_DIRECT = "rule-trf-cleaner-fix-union-direct";
    public static final String TV_IMPLEMENTED_BY_NILREASON = "gmlImplementedByNilReason";
    public static final String DEFAULT_REASON_PROP_NAME_REGEX = "reason";
    private ShapeChangeResult result = null;

    @Override
    public void process(GenericModel m, Options o, TransformerConfiguration trfConfig, ShapeChangeResult r) throws ShapeChangeAbortException {
        this.result = r;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (rules.isEmpty()) {
            return;
        }
        if (rules.contains(RULE_TRF_CLEANER_FIX_UNION_DIRECT)) {
            this.result.addProcessFlowInfo(null, 20103, RULE_TRF_CLEANER_FIX_UNION_DIRECT);
            this.applyRuleFixUnionDirect(m, trfConfig);
        }
    }

    private void applyRuleFixUnionDirect(GenericModel m, TransformerConfiguration trfConfig) {
        String reasonPropNameRegex = trfConfig.getParameterValue(PARAM_REASON_PROPERTY_REGEX);
        if (reasonPropNameRegex == null) {
            reasonPropNameRegex = DEFAULT_REASON_PROP_NAME_REGEX;
        }
        if ((reasonPropNameRegex = reasonPropNameRegex.trim()).length() == 0) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 1, PARAM_REASON_PROPERTY_REGEX, RULE_TRF_CLEANER_FIX_UNION_DIRECT);
            mc.addDetail(this, 0);
            return;
        }
        Pattern reasonPropNamePattern = null;
        try {
            reasonPropNamePattern = Pattern.compile(reasonPropNameRegex);
        }
        catch (PatternSyntaxException e) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 3, PARAM_REASON_PROPERTY_REGEX, RULE_TRF_CLEANER_FIX_UNION_DIRECT, reasonPropNameRegex, e.getMessage());
            mc.addDetail(this, 0);
            return;
        }
        for (GenericClassInfo genCi : m.selectedSchemaClasses()) {
            if (genCi.category() != 8 || genCi.properties().size() != 2) continue;
            SortedMap<StructuredNumber, PropertyInfo> genPis = genCi.properties();
            ArrayList<PropertyInfo> props = new ArrayList<PropertyInfo>(genPis.values());
            GenericPropertyInfo p1 = (GenericPropertyInfo)props.get(0);
            GenericPropertyInfo p2 = (GenericPropertyInfo)props.get(1);
            if (!(!this.matchesRegex(p1.name(), reasonPropNamePattern) || StringUtils.isNotBlank((CharSequence)p1.taggedValue(TV_IMPLEMENTED_BY_NILREASON)) && Boolean.parseBoolean(p1.taggedValue(TV_IMPLEMENTED_BY_NILREASON).trim()))) {
                p1.setTaggedValue(TV_IMPLEMENTED_BY_NILREASON, "true", true);
                this.result.addDebug(this, 4, genCi.name(), p1.name());
            }
            if (!this.matchesRegex(p2.name(), reasonPropNamePattern) || StringUtils.isNotBlank((CharSequence)p2.taggedValue(TV_IMPLEMENTED_BY_NILREASON)) && Boolean.parseBoolean(p2.taggedValue(TV_IMPLEMENTED_BY_NILREASON).trim())) continue;
            p2.setTaggedValue(TV_IMPLEMENTED_BY_NILREASON, "true", true);
            this.result.addDebug(this, 4, genCi.name(), p2.name());
        }
    }

    private boolean matchesRegex(String s, Pattern p) {
        Matcher matcher = p.matcher(s);
        return matcher.matches();
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class ModelCleaner";
            }
            case 1: {
                return "No non-empty string value provided for configuration parameter '$1$'. Execution of rule '$2$' aborted.";
            }
            case 2: {
                return "Configuration parameter '$1$' required for execution of rule '$2$' was not provided. Execution of rule '$2$' aborted.";
            }
            case 3: {
                return "Syntax exception for regular expression value of configuration parameter '$1$' (required for execution of rule '$2$'). Regular expression value was: $3$. Exception message: $4$. Execution of rule '$2$' aborted.";
            }
            case 4: {
                return "$1$::$2$: set 'gmlImplementedByNilReason' tagged value to true.";
            }
            case 5: {
                return "Union $1$: set 'hasNilReason' field to true.";
            }
            case 6: {
                return "$1$::$2$: set 'implementedByNilReason' field to true.";
            }
        }
        return "(" + ModelCleaner.class.getName() + ") Unknown message with number: " + mnr;
    }
}

