/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.LinkedDocument;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Util.docx.DocxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;

public class LinkedDocumentTransformer
implements Transformer,
MessageSource {
    public static final String PARAM_PREPEND_TEXT_VALUE = "prependTextValue";
    public static final String PARAM_PREPEND_TEXT_HORIZONTALLINE = "prependHorizontalLine";
    public static final String RULE_PREPEND_TEXT = "rule-trf-all-prependText";
    private Options options = null;
    private ShapeChangeResult result = null;
    private Set<String> rules = null;
    private TransformerConfiguration config = null;
    private GenericModel model = null;

    @Override
    public void process(GenericModel model, Options options, TransformerConfiguration config, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.model = model;
        this.options = options;
        this.result = result;
        this.config = config;
        Map<String, ProcessRuleSet> ruleSets = config.getRuleSets();
        this.rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                this.rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (this.rules.contains(RULE_PREPEND_TEXT)) {
            result.addProcessFlowInfo(null, 20103, RULE_PREPEND_TEXT);
            this.applyRulePrependText();
        }
    }

    private void applyRulePrependText() {
        String text = this.config.parameterAsString(PARAM_PREPEND_TEXT_VALUE, null, false, true);
        boolean horizontalLine = this.config.parameterAsBoolean(PARAM_PREPEND_TEXT_HORIZONTALLINE, false);
        if (StringUtils.isBlank((CharSequence)text) && !horizontalLine) {
            return;
        }
        for (GenericClassInfo genCi : this.model.selectedSchemaClasses()) {
            if (genCi.getLinkedDocument() == null) continue;
            String specificText = text == null ? null : text.replaceAll("\\$TYPE\\$", genCi.name());
            try {
                File trfFile = File.createTempFile("transformedLinkedDoc", ".docx", this.options.linkedDocumentsTmpDir());
                trfFile.deleteOnExit();
                FileInputStream linkedDocSupertypeIS = new FileInputStream(genCi.getLinkedDocument());
                WordprocessingMLPackage wmlPackage = WordprocessingMLPackage.load((InputStream)linkedDocSupertypeIS);
                MainDocumentPart mdp = wmlPackage.getMainDocumentPart();
                if (horizontalLine) {
                    P pHorizLine = DocxUtil.createHorizontalLine();
                    mdp.getContent().add(0, pHorizLine);
                }
                if (specificText != null) {
                    P pText = DocxUtil.createText(specificText);
                    mdp.getContent().add(0, pText);
                }
                wmlPackage.save(trfFile);
                genCi.setLinkedDocument(trfFile);
            }
            catch (IOException | Docx4JException e) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 100, genCi.name(), e.getMessage());
                if (mc == null) continue;
                mc.addDetail(this, 2, genCi.fullName());
            }
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: property '$1$'";
            }
            case 2: {
                return "Context: class '$1$'";
            }
            case 100: {
                return "An exception occurred while processing the linked document of type '$1$'. Message is: $2$";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

