/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Flattening;

import java.util.Set;
import org.jgrapht.graph.DefaultEdge;

public class PropertySetEdge
extends DefaultEdge {
    private static final long serialVersionUID = 1L;
    private String source;
    private String target;
    private String label;
    private Set<String> propertyNames;

    public PropertySetEdge(String source, String target, Set<String> propertyNames) {
        this.source = source;
        this.target = target;
        this.propertyNames = propertyNames;
        this.label = PropertySetEdge.join(propertyNames, ",");
    }

    public String getV1() {
        return this.source;
    }

    public String getV2() {
        return this.target;
    }

    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    public String toString() {
        return this.label;
    }

    public static String join(Set<String> parts, String delimiter) {
        if (parts == null || parts.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String delim = delimiter == null ? "" : delimiter;
        for (String part : parts) {
            if (part != null) {
                sb.append(part);
            }
            sb.append(delim);
        }
        return sb.substring(0, sb.length() - delim.length());
    }
}

