/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Flattening;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Flattening.Flattener;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FlattenerConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("aliasForEnumerationValues", "basicTypeSupertypeNames", "codeForEnumerationValues", "codeByTaggedValue", "descriptorModification_geometryTypeAlias", "descriptorModification_geometryTypeSuffixSeparator", "descriptorModification_nonUnionSeparator", "descriptorModification_propertyIndexNumberSeparator", "descriptorModification_unionSeparator", "enforceOptionality", "fixedUomPropertyDefinitions", "flattenDataTypesExcludeRegex", "flattenObjectTypes", "flattenObjectTypesIncludeRegex", "flattenTypesPropertyCopyDuplicateBehavior", "geometryTypeRegex", "applyHomogeneousGeometriesOnSubtypes", "omitHomogeneousGeometriesForTypesWithSingleGeometryProperty", "ignoreFeatureOrObjectTypedProperties", "ignoreFeatureTypedProperties", "ignoreReflexiveRelationshipInTypeFlattening", "includeObjectToObjectNavigability", "includeUnionIdentifierTaggedValue", "flattenInheritanceIncludeRegex", "linkedDocumentPageBreak", "keepOriginalNameAsAlias", "keepOriginalNameAsCode", "lowerCaseAliasForProperties", "lowerCaseCodeForProperties", "maxMultiplicityThreshold", "maxOccurs", "maxOccursForSpecificProperties", "measureTypes", "measureUomTaggedValue", "targetNamespaceSuffix", "removeObjectToFeatureNavRegex", "removeInheritanceIncludeRegex", "removePropertyNameAndAliasComponent", "removePropertyNameAndCodeComponent", "removeType", "replaceUnionExcludeRegex", "separatorForGeometryTypeSuffix", "separatorForPropertyFromNonUnion", "separatorForPropertyFromUnion", "separatorForPropertyIndexNumber", "setMinCardinalityToZeroWhenMergingUnion", "simpleBaseTypes", "typeEnumerationPropertyName", "typeSuffixSeparator", "uomSuffixSeparator", "directPositionRsidSuffix").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration pConfig, Options options, ShapeChangeResult result) {
        String propertyCopyDuplicateBehavior;
        String descModSeparator;
        ShapeChangeResult.MessageContext mc;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTransformerParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, pConfig.getParameters().keySet(), result) && isValid;
        TransformerConfiguration trfConfig = (TransformerConfiguration)pConfig;
        String id = trfConfig.getId();
        Set<String> rules = trfConfig.getAllRules();
        if (rules.contains("rule-trf-all-removeType") && (!trfConfig.hasParameter("removeType") || trfConfig.getParameterValue("removeType").trim().length() == 0) && (mc = result.addWarning(this, 100)) != null) {
            mc.addDetail(this, 0, id);
        }
        if ((descModSeparator = trfConfig.parameterAsString("descriptorModification_nonUnionSeparator", null, false, true)) != null) {
            Matcher matcher = Flattener.descriptorModBasicPattern.matcher(descModSeparator);
            while (matcher.find()) {
                String descriptorAsString = matcher.group(1);
                try {
                    Descriptor.valueOf(descriptorAsString.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    result.addError(this, 20348, "descriptorModification_nonUnionSeparator", descriptorAsString);
                    isValid = false;
                }
            }
        }
        if ((propertyCopyDuplicateBehavior = trfConfig.parameterAsString("flattenTypesPropertyCopyDuplicateBehavior", null, false, true)) != null && !"IGNORE".equals(propertyCopyDuplicateBehavior) && !"OVERWRITE".equals(propertyCopyDuplicateBehavior)) {
            result.addError(this, 101, "flattenTypesPropertyCopyDuplicateBehavior", propertyCopyDuplicateBehavior);
            isValid = false;
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: Transformer configuration element with 'id'='$1$'.";
            }
            case 100: {
                return "Parameter 'removeType' is required for the execution of 'rule-trf-all-removeType'. The configuration does not contain this parameter with a non-empty string.";
            }
            case 101: {
                return "Configuration parameter '$1$' must be 'IGNORE' or 'OVERWRITE'. Found: $2$ ";
            }
            case 20348: {
                return "Configuration parameter '$1$' contains unknown descriptor '$2$'. ";
            }
        }
        return "(" + FlattenerConfigurationValidator.class.getName() + ") Unknown message with number: " + mnr;
    }
}

