/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Flattening;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericAssociationInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPackageInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericTextConstraint;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.InfoImpl;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Transformation.Flattening.PropertySetEdge;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.Util.ArcGISUtil;
import de.interactive_instruments.ShapeChange.Util.docx.DocxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.JohnsonSimpleCycles;
import org.jgrapht.alg.cycle.SzwarcfiterLauerSimpleCycles;
import org.jgrapht.alg.cycle.TarjanSimpleCycles;
import org.jgrapht.alg.cycle.TiernanSimpleCycles;
import org.jgrapht.graph.DirectedMultigraph;

public class Flattener
implements Transformer,
MessageSource {
    private static final Splitter commaSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Joiner commaJoiner = Joiner.on((String)",").skipNulls();
    public static final String PARAM_NAMESPACE_SUFFIX_PARAMETER = "targetNamespaceSuffix";
    public static final String PARAM_REMOVE_TYPE = "removeType";
    public static final String PARAM_LOWER_CASE_ALIAS_FOR_PROPERTIES = "lowerCaseAliasForProperties";
    public static final String PARAM_LOWER_CASE_CODE_FOR_PROPERTIES = "lowerCaseCodeForProperties";
    public static final String PARAM_ALIAS_FOR_ENUMERATION_VALUES = "aliasForEnumerationValues";
    public static final String PARAM_CODE_FOR_ENUMERATION_VALUES = "codeForEnumerationValues";
    public static final String PARAM_ENFORCE_OPTIONALITY = "enforceOptionality";
    public static final String PARAM_KEEP_ORIGINAL_NAME_AS_ALIAS = "keepOriginalNameAsAlias";
    public static final String PARAM_KEEP_ORIGINAL_NAME_AS_CODE = "keepOriginalNameAsCode";
    public static final String PARAM_SEPARATOR_FOR_PROPERTY_FROM_UNION = "separatorForPropertyFromUnion";
    public static final String PARAM_SEPARATOR_FOR_PROPERTY_FROM_NON_UNION = "separatorForPropertyFromNonUnion";
    public static final String PARAM_SEPARATOR_FOR_PROPERTY_INDEX_NUMBER = "separatorForPropertyIndexNumber";
    public static final String PARAM_SEPARATOR_FOR_GEOMETRY_TYPE_SUFFIX = "separatorForGeometryTypeSuffix";
    public static final String PARAM_REMOVE_PROPERTY_NAME_AND_ALIAS_COMPONENT = "removePropertyNameAndAliasComponent";
    public static final String PARAM_REMOVE_PROPERTY_NAME_AND_CODE_COMPONENT = "removePropertyNameAndCodeComponent";
    public static final String PARAM_CODEBY_TAGGEDVALUE = "codeByTaggedValue";
    public static final String PARAM_OBJECT_TO_FEATURE_TYPE_NAV_REGEX = "removeObjectToFeatureNavRegex";
    public static final String PARAM_GEOMETRY_TYPE_REGEX = "geometryTypeRegex";
    public static final String DEFAULT_GEOMETRY_TYPE_REGEX = "^GM_.*";
    public static final String PARAM_INCLUDE_OBJECT_NAV = "includeObjectToObjectNavigability";
    public static final String PARAM_INHERITANCE_INCLUDE_REGEX = "flattenInheritanceIncludeRegex";
    public static final String PARAM_INHERITANCE_LINKED_DOC_PAGEBREAK = "linkedDocumentPageBreak";
    public static final String PARAM_FLATTEN_OBJECT_TYPES = "flattenObjectTypes";
    public static final String PARAM_FLATTEN_OBJECT_TYPES_INCLUDE_REGEX = "flattenObjectTypesIncludeRegex";
    public static final String PARAM_FLATTEN_DATATYPES_EXCLUDE_REGEX = "flattenDataTypesExcludeRegex";
    public static final String PARAM_FLATTEN_TYPES_PROPERTY_COPY_DUPLICATE_BEHAVIOR = "flattenTypesPropertyCopyDuplicateBehavior";
    public static final String PARAM_REPLACE_UNION_EXCLUDE_REGEX = "replaceUnionExcludeRegex";
    public static final String PARAM_INCLUDE_UNION_IDENTIFIER_TV = "includeUnionIdentifierTaggedValue";
    public static final String PARAM_SIMPLE_BASE_TYPES = "simpleBaseTypes";
    public static final String[] DEFAULT_SIMPLE_BASE_TYPES = new String[]{"CharacterString", "Integer", "Measure", "Real"};
    public static final String PARAM_SET_MIN_CARDINALITY_TO_ZERO_WHEN_MERGING_UNION = "setMinCardinalityToZeroWhenMergingUnion";
    public static final String PARAM_IGNORE_REFLEXIVE_RELATIONSHIP_IN_TYPE_FLATTENING = "ignoreReflexiveRelationshipInTypeFlattening";
    public static final String PARAM_MAXOCCURS = "maxOccurs";
    public static final String PARAM_MAXOCCURS_FOR_SPECIFIC_PROPERTIES = "maxOccursForSpecificProperties";
    public static final String PARAM_IGNORE_FEATURE_OR_OBJECT_TYPED_PROPERTIES = "ignoreFeatureOrObjectTypedProperties";
    public static final String PARAM_IGNORE_FEATURE_TYPED_PROPERTIES = "ignoreFeatureTypedProperties";
    public static final String PARAM_MAX_MULTIPLICITY_THRESHOLD = "maxMultiplicityThreshold";
    public static final String PARAM_MEASURE_TYPES = "measureTypes";
    public static final String[] DEFAULT_MEASURE_TYPES = new String[]{"Measure", "Area", "Length", "Distance", "Angle", "Scale", "TimeMeasure", "Volume", "Speed", "AngularSpeed", "Weight", "Currency"};
    public static final String PARAM_FIXED_UOM_PROPERTY_DEFINITIONS = "fixedUomPropertyDefinitions";
    public static final String PARAM_MEASURE_UOM_TV = "measureUomTaggedValue";
    public static final String PARAM_UOM_SUFFIX_SEPARATOR = "uomSuffixSeparator";
    public static final String PARAM_DIRECT_POSITION_RSID_SUFFIX = "directPositionRsidSuffix";
    public static final String PARAM_HOMOGENEOUSGEOMETRIES_APPLY_ON_SUBTYPES = "applyHomogeneousGeometriesOnSubtypes";
    public static final String PARAM_HOMOGENEOUSGEOMETRIES_OMIT_RULE_FOR_CASE_OF_SINGLE_GEOMETRY_PROP = "omitHomogeneousGeometriesForTypesWithSingleGeometryProperty";
    public static final String PARAM_REMOVE_INHERITANCE_INCLUDE_REGEX = "removeInheritanceIncludeRegex";
    public static final String PARAM_DESCRIPTOR_MOD_NON_UNION_SEPARATOR = "descriptorModification_nonUnionSeparator";
    public static final String PARAM_DESCRIPTOR_MOD_UNION_SEPARATOR = "descriptorModification_unionSeparator";
    public static final String PARAM_DESCRIPTOR_MOD_PROPERTY_INDEX_NUMBER = "descriptorModification_propertyIndexNumberSeparator";
    public static final String PARAM_DESCRIPTOR_MOD_GEOMETRY_TYPE_SUFFIX_SEPARATOR = "descriptorModification_geometryTypeSuffixSeparator";
    public static final String PARAM_DESCRIPTOR_MOD_GEOM_TYPE_ALIAS = "descriptorModification_geometryTypeAlias";
    public static final String PARAM_BASIC_TYPE_SUPERTYPE_NAMES = "basicTypeSupertypeNames";
    public static final String[] DEFAULT_BASIC_TYPE_SUPERTYPE_NAMES = new String[]{"Character", "CharacterString", "Number", "Real", "Integer", "Decimal", "Date", "DateTime", "Boolean", "Measure", "Length", "Distance", "Area", "Velocity", "Volume"};
    public static final String PARAM_TYPE_SUFFIX_SEPARATOR = "typeSuffixSeparator";
    public static final String PARAM_TYPE_ENUMERATION_PROPERTY_NAME = "typeEnumerationPropertyName";
    public static final String RULE_TRF_ALL_FLATTEN_CODELISTS = "rule-trf-prop-flatten-codelists";
    public static final String RULE_TRF_ALL_FLATTEN_CONSTRAINTS = "rule-trf-all-flatten-constraints";
    public static final String RULE_TRF_ALL_FLATTEN_REMOVE_CONSTRAINTS = "rule-trf-all-flatten-removeConstraints";
    public static final String RULE_TRF_ALL_FLATTEN_NAME = "rule-trf-all-flatten-name";
    public static final String RULE_TRF_ALL_REMOVETYPE = "rule-trf-all-removeType";
    public static final String RULE_TRF_ALL_REMOVE_FEATURETYPE_RELATIONSHIPS = "rule-trf-all-removeFeatureTypeRelationships";
    public static final String RULE_TRF_CLS_FLATTEN_REVERSE_INHERITANCE = "rule-trf-cls-flatten-reverse-inheritance";
    public static final String RULE_TRF_CLS_FLATTEN_INHERITANCE = "rule-trf-cls-flatten-inheritance";
    public static final String RULE_TRF_CLS_FLATTEN_INHERITANCE_ADD_ATTRIBUTES_AT_BOTTOM = "rule-trf-cls-flatten-inheritance-add-attributes-at-bottom";
    public static final String RULE_TRF_CLS_FLATTEN_INHERITANCE_IGNORE_ARCGIS_SUBTYPES = "rule-trf-cls-flatten-inheritance-ignore-arcgis-subtypes";
    public static final String RULE_TRF_CLS_FLATTEN_INHERITANCE_ASSOCIATIONROLENAME_USING_CODE_OF_VALUETYPE = "rule-trf-cls-flatten-inheritance-associationRoleNameUsingCodeOfValueType";
    public static final String RULE_TRF_CLS_FLATTEN_INHERITANCE_MERGE_LINKED_DOCUMENTS = "rule-trf-cls-flatten-inheritance-mergeLinkedDocuments";
    public static final String RULE_TRF_PROP_FLATTEN_HOMOGENEOUSGEOMETRIES = "rule-trf-prop-flatten-homogeneousgeometries";
    public static final String RULE_TRF_PROP_FLATTEN_MEASURE_TYPED_PROPERTIES = "rule-trf-prop-flatten-measure-typed-properties";
    public static final String RULE_TRF_PROP_FLATTEN_MEASURE_TYPED_PROPERTIES_ADD_UOM_PROPERTY = "rule-trf-prop-flatten-measure-typed-properties-add-uom-property";
    public static final String RULE_TRF_PROP_FLATTEN_MEASURE_TYPED_PROPERTIES_FIXED_UOM_SUFFIX = "rule-trf-prop-flatten-measure-typed-properties-fixed-uom-suffix";
    public static final String RULE_TRF_PROP_FLATTEN_DIRECTPOSITION_TYPED_PROPERTIES = "rule-trf-prop-flatten-directposition-typed-properties";
    public static final String RULE_TRF_PROP_FLATTEN_DIRECTPOSITION_TYPED_PROPERTIES_ADD_RSID_PROPERTY = "rule-trf-prop-flatten-directposition-typed-properties-add-rsid-property";
    public static final String RULE_TRF_PROP_FLATTEN_MEDIATYPE_TYPED_PROPERTIES = "rule-trf-prop-flatten-mediatype-typed-properties";
    public static final String RULE_TRF_PROP_FLATTEN_MULTIPLICITY = "rule-trf-prop-flatten-multiplicity";
    public static final String RULE_TRF_PROP_FLATTEN_MULTIPLICITY_WITHMAXMULTTHRESHOLD = "rule-trf-prop-flatten-multiplicity-withMaxMultiplicityThreshold";
    public static final String RULE_TRF_PROP_FLATTEN_MULTIPLICITY_KEEPBIDIRECTIONALASSOCIATIONS = "rule-trf-prop-flatten-multiplicity-keepBiDirectionalAssociations";
    public static final String RULE_TRF_PROP_FLATTEN_ONINAS = "rule-trf-prop-flatten-ONINAs";
    public static final String RULE_TRF_PROP_FLATTEN_ONINAS_ONLY_REMOVE_REASONS = "rule-trf-prop-flatten-ONINAs-onlyRemoveReasons";
    public static final String RULE_TRF_PROP_FLATTEN_TYPES = "rule-trf-prop-flatten-types";
    public static final String RULE_TRF_PROP_FLATTEN_EXPLICIT_TIME_INTERVAL = "rule-trf-prop-flatten-explicit-time-interval";
    public static final String RULE_TRF_PROP_FLATTEN_TYPE_MAP_TO_SIMPLEBASETYPE = "rule-trf-all-flatten-type-mapToSimpleBaseType";
    public static final String RULE_TRF_PROP_FLATTEN_TYPES_IGNORE_SELF_REF_BY_PROP_WITH_ASSO_CLASS_ORIGIN = "rule-trf-prop-flatten-types-ignoreSelfReferenceByPropertyWithAssociationClassOrigin";
    public static final String RULE_TRF_PROP_FLATTEN_TYPES_IGNORE_UNIONS_REPRESENTING_FEATURE_TYPE_SETS = "rule-trf-prop-flatten-types-ignoreUnionsRepresentingFeatureTypeSets";
    public static final String RULE_TRF_PROP_FLATTEN_TYPES_REMOVE_MAPPED_TYPES = "rule-trf-prop-flatten-types-removeMappedTypes";
    public static final String RULE_TRF_PROP_OPTIONALITY = "rule-trf-prop-optionality";
    public static final String RULE_TRF_PROP_REMOVE_OBJECT_TO_FEATURE_TYPE_NAVIGABILITY = "rule-trf-prop-removeObjectToFeatureTypeNavigability";
    public static final String RULE_TRF_PROP_REMOVE_NAVIGABILITY_BASEDON_ISFLATTARGET = "rule-trf-prop-removeNavigabilityBasedOnIsFlatTarget";
    public static final String RULE_TRF_PROP_REMOVE_NAME_AND_ALIAS_COMPONENT = "rule-trf-prop-remove-name-and-alias-component";
    public static final String RULE_TRF_PROP_REMOVE_NAME_AND_CODE_COMPONENT = "rule-trf-prop-remove-name-and-code-component";
    public static final String RULE_TRF_PROP_UNION_DIRECT_OPTIONALITY = "rule-trf-prop-union-direct-optionality";
    public static final String RULE_TRF_CLS_DISSOLVE_MIXINS = "rule-trf-cls-dissolve-mixins";
    public static final String RULE_TRF_CLS_REMOVE_INHERITANCE_RELATIONSHIP = "rule-trf-cls-remove-inheritance-relationship";
    public static final String RULE_TRF_CLS_REPLACE_WITH_UNION_PROPERTIES = "rule-trf-cls-replace-with-union-properties";
    public static final String RULE_TRF_CLS_NON_DEFAULT_GEOMETRY_TO_FEATURE_TYPE = "rule-trf-cls-non-default-geometry-to-feature-type";
    public static final String RULE_TRF_CLS_FLATTEN_GEOMETRY_TYPE_INHERITANCE = "rule-trf-cls-flatten-geometryTypeInheritance";
    public static final String REQ_FLATTEN_TYPES_IDENTIFY_CIRCULAR_DEPENDENCIES = "req-flattener-flattenTypes-identify-circular-dependencies";
    public static final String TAGGED_VALUE_IS_FLAT_TARGET = "isFlatTarget";
    public static final String UNION_SET_TAG_NAME = "SC_UNION_SET";
    private static final String UNKNOWN = "UNKNOWN";
    private Options options = null;
    private ShapeChangeResult result = null;
    private Set<String> rules = null;
    private String separatorForPropertyFromUnion = "-";
    private String separatorForPropertyFromNonUnion = ".";
    private String separatorForPropertyIndexNumber = "_";
    private String tvNameForCodeValue = null;
    private boolean flattenObjectTypes = true;
    private boolean ignoreReflexiveRelationshipInTypeFlattening = false;
    private String includeObjectTypeRegex = null;
    private Pattern includeObjectTypePattern = null;
    private String excludeDataTypeRegex = null;
    private Pattern excludeDataTypePattern = null;
    public static final Pattern descriptorModBasicPattern = Pattern.compile("(\\w+)\\{([^}]+)}");
    public static final Pattern descriptorModValKvpPattern = Pattern.compile("(\\w+)=([^,]+)");

    @Override
    public void process(GenericModel genModel, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        String tmp;
        String separatorForPropertyFromNonUnionParam;
        String separatorForPropertyFromUnionParam;
        SortedSet<PackageInfo> appSchemas;
        String targetNamespaceSuffix;
        this.options = options;
        this.result = result;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        this.rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                this.rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (this.rules.isEmpty()) {
            return;
        }
        result.addProcessFlowInfo(this, 20317, "processing");
        if (trfConfig.hasParameter(PARAM_NAMESPACE_SUFFIX_PARAMETER) && (targetNamespaceSuffix = trfConfig.getParameterValue(PARAM_NAMESPACE_SUFFIX_PARAMETER)) != null && targetNamespaceSuffix.trim().length() != 0 && (appSchemas = genModel.selectedSchemas()) != null) {
            for (PackageInfo as : appSchemas) {
                GenericPackageInfo appSchema = (GenericPackageInfo)as;
                String targetNamespace = appSchema.targetNamespace();
                if (targetNamespace.endsWith(targetNamespaceSuffix)) continue;
                appSchema.setTargetNamespace(targetNamespace + targetNamespaceSuffix);
            }
        }
        if (trfConfig.hasParameter(PARAM_CODEBY_TAGGEDVALUE)) {
            this.tvNameForCodeValue = trfConfig.getParameterValue(PARAM_CODEBY_TAGGEDVALUE);
            if (this.tvNameForCodeValue == null || this.tvNameForCodeValue.trim().length() == 0) {
                result.addError(this, 20309, PARAM_CODEBY_TAGGEDVALUE);
                return;
            }
        }
        if ((separatorForPropertyFromUnionParam = trfConfig.getParameterValue(PARAM_SEPARATOR_FOR_PROPERTY_FROM_UNION)) != null && separatorForPropertyFromUnionParam.trim().length() > 0) {
            this.separatorForPropertyFromUnion = separatorForPropertyFromUnionParam;
        }
        if ((separatorForPropertyFromNonUnionParam = trfConfig.getParameterValue(PARAM_SEPARATOR_FOR_PROPERTY_FROM_NON_UNION)) != null && separatorForPropertyFromNonUnionParam.trim().length() > 0) {
            this.separatorForPropertyFromNonUnion = separatorForPropertyFromNonUnionParam;
        }
        if (this.separatorForPropertyFromUnion.equals(this.separatorForPropertyFromNonUnion)) {
            // empty if block
        }
        if (trfConfig.hasParameter(PARAM_FLATTEN_OBJECT_TYPES) && (tmp = trfConfig.getParameterValue(PARAM_FLATTEN_OBJECT_TYPES)) != null && tmp.trim().equalsIgnoreCase("false")) {
            this.flattenObjectTypes = false;
        }
        if (trfConfig.hasParameter(PARAM_IGNORE_REFLEXIVE_RELATIONSHIP_IN_TYPE_FLATTENING) && (tmp = trfConfig.getParameterValue(PARAM_IGNORE_REFLEXIVE_RELATIONSHIP_IN_TYPE_FLATTENING)) != null && tmp.trim().equalsIgnoreCase("true")) {
            this.ignoreReflexiveRelationshipInTypeFlattening = true;
        }
        if (trfConfig.hasParameter(PARAM_FLATTEN_OBJECT_TYPES_INCLUDE_REGEX)) {
            this.includeObjectTypeRegex = trfConfig.getParameterValue(PARAM_FLATTEN_OBJECT_TYPES_INCLUDE_REGEX);
            this.includeObjectTypePattern = Pattern.compile(this.includeObjectTypeRegex);
        }
        if (trfConfig.hasParameter(PARAM_FLATTEN_DATATYPES_EXCLUDE_REGEX)) {
            this.excludeDataTypeRegex = trfConfig.getParameterValue(PARAM_FLATTEN_DATATYPES_EXCLUDE_REGEX);
            this.excludeDataTypePattern = Pattern.compile(this.excludeDataTypeRegex);
        }
        if (this.rules.contains(RULE_TRF_ALL_REMOVETYPE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_ALL_REMOVETYPE);
            this.applyRuleRemoveType(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_CLS_DISSOLVE_MIXINS)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_DISSOLVE_MIXINS);
            this.applyRuleDissolveMixins(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_REMOVE_OBJECT_TO_FEATURE_TYPE_NAVIGABILITY)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_REMOVE_OBJECT_TO_FEATURE_TYPE_NAVIGABILITY);
            this.applyRuleRemoveObjectToFeatureTypeNavigability(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_ALL_REMOVE_FEATURETYPE_RELATIONSHIPS)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_ALL_REMOVE_FEATURETYPE_RELATIONSHIPS);
            this.applyRuleRemoveFeatureTypeRelationships(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_REMOVE_NAVIGABILITY_BASEDON_ISFLATTARGET)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_REMOVE_NAVIGABILITY_BASEDON_ISFLATTARGET);
            this.applyRuleRemoveNavigabilityBasedOnFlatTargetSetting(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_ALL_FLATTEN_CONSTRAINTS)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_ALL_FLATTEN_CONSTRAINTS);
            this.applyRuleClsFlattenConstraints(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_ALL_FLATTEN_REMOVE_CONSTRAINTS)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_ALL_FLATTEN_REMOVE_CONSTRAINTS);
            this.applyRuleClsFlattenRemoveConstraints(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_ALL_FLATTEN_CODELISTS)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_ALL_FLATTEN_CODELISTS);
            this.applyRuleFlattenCodeLists(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_ONINAS)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_FLATTEN_ONINAS);
            this.applyRuleONINAs(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_OPTIONALITY)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_OPTIONALITY);
            this.applyRuleOptionality(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_TYPE_MAP_TO_SIMPLEBASETYPE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_FLATTEN_TYPE_MAP_TO_SIMPLEBASETYPE);
            this.applyRuleBasicTypeToSimpleBaseType(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_CLS_FLATTEN_INHERITANCE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_FLATTEN_INHERITANCE);
            this.applyRuleInheritance(genModel, trfConfig);
        }
        if (this.rules.contains(REQ_FLATTEN_TYPES_IDENTIFY_CIRCULAR_DEPENDENCIES)) {
            this.identifyCircularDependencies(this.computeTypesToProcessForFlattenTypes(genModel, trfConfig));
            result.addProcessFlowInfo("req-flattener-flattenTypes-identify-circular-dependencies completed.");
        }
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_MULTIPLICITY)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_FLATTEN_MULTIPLICITY);
            this.applyRuleMultiplicity(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_CLS_REPLACE_WITH_UNION_PROPERTIES)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_REPLACE_WITH_UNION_PROPERTIES);
            this.applyRuleUnionReplace(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_TYPES)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_FLATTEN_TYPES);
            this.applyRuleFlattenTypes(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_ALL_FLATTEN_NAME)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_ALL_FLATTEN_NAME);
            this.applyRuleAllFlattenName(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_REMOVE_NAME_AND_CODE_COMPONENT) || this.rules.contains(RULE_TRF_PROP_REMOVE_NAME_AND_ALIAS_COMPONENT)) {
            result.addProcessFlowInfo(null, 20103, "rule-trf-prop-remove-name-and-code-component/rule-trf-prop-remove-name-and-alias-component");
            this.applyRulePropFlattenRemoveNameAndCodeComponent(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_HOMOGENEOUSGEOMETRIES)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_FLATTEN_HOMOGENEOUSGEOMETRIES);
            this.applyRulePropFlattenHomogeneousGeometries(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_UNION_DIRECT_OPTIONALITY)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_UNION_DIRECT_OPTIONALITY);
            this.applyRulePropUnionDirectOptionality(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_CLS_REMOVE_INHERITANCE_RELATIONSHIP)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_REMOVE_INHERITANCE_RELATIONSHIP);
            this.applyRuleRemoveInheritanceRelationship(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_CLS_FLATTEN_GEOMETRY_TYPE_INHERITANCE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_FLATTEN_GEOMETRY_TYPE_INHERITANCE);
            this.applyRuleFlattenGeometryTypeInheritance(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_MEASURE_TYPED_PROPERTIES)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_FLATTEN_MEASURE_TYPED_PROPERTIES);
            this.applyRuleFlattenMeasureTypedProperties(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_DIRECTPOSITION_TYPED_PROPERTIES)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_FLATTEN_DIRECTPOSITION_TYPED_PROPERTIES);
            this.applyRuleFlattenDirectPositionTypedProperties(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_MEDIATYPE_TYPED_PROPERTIES)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_FLATTEN_MEDIATYPE_TYPED_PROPERTIES);
            this.applyRuleFlattenMediaTypeTypedProperties(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_EXPLICIT_TIME_INTERVAL)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_PROP_FLATTEN_EXPLICIT_TIME_INTERVAL);
            this.applyRuleFlattenExplicitTimeIntervals(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_CLS_FLATTEN_REVERSE_INHERITANCE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_FLATTEN_REVERSE_INHERITANCE);
            this.applyRule_cls_flatten_reverseInheritance(genModel, trfConfig);
        }
        if (this.rules.contains(RULE_TRF_CLS_NON_DEFAULT_GEOMETRY_TO_FEATURE_TYPE)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_NON_DEFAULT_GEOMETRY_TO_FEATURE_TYPE);
            this.applyRuleNonDefaultGeometryToFeatureType(genModel, trfConfig);
        }
        result.addProcessFlowInfo(this, 20317, "postprocessing");
        if (this.rules.contains(RULE_TRF_ALL_FLATTEN_CONSTRAINTS)) {
            for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
                if (genCi.hasDirectConstraints()) {
                    List<Constraint> classConstraints = genCi.directConstraints();
                    Vector<Constraint> newConstraints = new Vector<Constraint>(classConstraints.size());
                    TreeSet constraintTexts = new TreeSet();
                    for (Constraint con : classConstraints) {
                        if (constraintTexts.contains(con.text())) continue;
                        newConstraints.add(con);
                    }
                    genCi.setDirectConstraints(newConstraints);
                }
                for (PropertyInfo pi : genCi.properties().values()) {
                    GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                    if (!genPi.hasConstraints()) continue;
                    List<Constraint> propConstraints = genPi.constraints();
                    Vector<Constraint> newConstraints = new Vector<Constraint>(propConstraints.size());
                    TreeSet constraintTexts = new TreeSet();
                    for (Constraint con : propConstraints) {
                        if (constraintTexts.contains(con.text())) continue;
                        newConstraints.add(con);
                    }
                    genPi.setConstraints(newConstraints);
                }
            }
        }
    }

    private void applyRuleNonDefaultGeometryToFeatureType(GenericModel genModel, TransformerConfiguration trfConfig) {
        String separator = "_";
        Pattern geometryTypePattern = trfConfig.parameterAsRegexPattern(PARAM_GEOMETRY_TYPE_REGEX, DEFAULT_GEOMETRY_TYPE_REGEX);
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            ArrayList<GenericPropertyInfo> nonDefaultGeomProps = new ArrayList<GenericPropertyInfo>();
            for (PropertyInfo pi : genCi.properties().values()) {
                if (!geometryTypePattern.matcher(pi.typeInfo().name).matches() || "true".equalsIgnoreCase(pi.taggedValue("defaultGeometry"))) continue;
                nonDefaultGeomProps.add((GenericPropertyInfo)pi);
            }
            for (GenericPropertyInfo genPi : nonDefaultGeomProps) {
                GenericClassInfo geomCi = new GenericClassInfo(genModel, genCi.id() + "_geomTypeFor_" + genPi.name(), genCi.name() + separator + genPi.name(), 1);
                geomCi.setStereotype("featuretype");
                if (this.hasCode(genCi) && this.hasCode(genPi)) {
                    this.setCode(geomCi, this.getCode(genCi) + separator + this.getCode(genPi));
                }
                geomCi.setPkg(genCi.pkg());
                ((GenericPackageInfo)genCi.pkg()).addClass(geomCi);
                genModel.register(geomCi);
                GenericPropertyInfo geomPi = new GenericPropertyInfo(genModel, geomCi.id() + "_geometry", "geometry");
                geomPi.setStereotype("property");
                geomPi.setSequenceNumber(new StructuredNumber(1), true);
                geomPi.setCardinality(new Multiplicity(1, 1));
                geomPi.setInClass(geomCi);
                geomCi.addProperty(geomPi, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
                geomPi.setTypeInfo(genPi.typeInfo().createCopy());
                GenericAssociationInfo genAi = new GenericAssociationInfo();
                GenericPropertyInfo genPiCopy = genPi.createCopy(genPi.id() + "_copyForGeomCi");
                genPiCopy.setTypeInfo(Type.from(geomCi));
                genPiCopy.setAttribute(false);
                genPiCopy.setAssociation(genAi);
                genAi.setOptions(this.options);
                genAi.setResult(this.result);
                genAi.setModel(genModel);
                genAi.setId("association_" + genCi.name() + "_to_" + geomCi.name() + "_for_" + genPiCopy.name());
                genAi.setEnd2(genPiCopy);
                genModel.remove(genPi, false);
                genCi.addProperty(genPiCopy, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
                GenericPropertyInfo nonNavPi = new GenericPropertyInfo(genModel, geomCi.id() + "_nonNavEnd_for_" + genPi.name(), StringUtils.uncapitalize((String)genCi.name()));
                nonNavPi.setCardinality(new Multiplicity(1, 1));
                nonNavPi.setInClass(geomCi);
                StructuredNumber lastGeomCiProp = geomCi.properties().lastKey();
                StructuredNumber nonNavPiSeqNbr = lastGeomCiProp.createCopy();
                nonNavPiSeqNbr.components[0] = nonNavPiSeqNbr.components[0] + 1;
                nonNavPi.setSequenceNumber(nonNavPiSeqNbr, true);
                nonNavPi.setTypeInfo(Type.from(genCi));
                nonNavPi.setAttribute(false);
                nonNavPi.setAssociation(genAi);
                genAi.setEnd1(nonNavPi);
                genModel.register(nonNavPi);
                nonNavPi.setNavigable(false);
                genModel.addAssociation(genAi);
            }
        }
    }

    private void applyRuleFlattenExplicitTimeIntervals(GenericModel genModel, TransformerConfiguration trfConfig) {
        String endPropNameSuffix = "End";
        String startPropNameSuffix = "Start";
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            String timeIntervalBoundaryTypeName;
            if (!genPi.isAttribute() || !StringUtils.isNotBlank((CharSequence)(timeIntervalBoundaryTypeName = genPi.taggedValue("timeIntervalBoundaryType")))) continue;
            ClassInfo tibCi = genModel.classByName(timeIntervalBoundaryTypeName.trim());
            Type tibType = new Type();
            tibType.id = tibCi != null ? tibCi.id() : "unknown";
            tibType.name = timeIntervalBoundaryTypeName.trim();
            genPi.setTypeInfo(tibType);
            GenericPropertyInfo endPi = genPi.createCopy(genPi.id() + endPropNameSuffix);
            endPi.setSequenceNumber(genPi.sequenceNumber().createCopyWithSuffix(1), false);
            endPi.setName(genPi.name() + endPropNameSuffix);
            if (this.hasCode(endPi)) {
                this.setCode(endPi, this.getCode(endPi) + endPropNameSuffix);
            }
            GenericClassInfo genCi = (GenericClassInfo)genPi.inClass();
            genCi.addProperty(endPi, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
            genPi.setName(genPi.name() + startPropNameSuffix);
            if (!this.hasCode(genPi)) continue;
            this.setCode(genPi, this.getCode(genPi) + startPropNameSuffix);
        }
    }

    private void applyRuleFlattenMeasureTypedProperties(GenericModel genModel, TransformerConfiguration trfConfig) {
        TreeSet<String> measureTypes = new TreeSet<String>(trfConfig.parameterAsStringList(PARAM_MEASURE_TYPES, DEFAULT_MEASURE_TYPES, true, true));
        Type realType = Type.from("Real", genModel);
        Type characterStringType = Type.from("CharacterString", genModel);
        HashMap<String, String> uomSuffixByPropertyKey = new HashMap<String, String>();
        List<String> fixedUomPropDefinitions = trfConfig.parameterAsStringList(PARAM_FIXED_UOM_PROPERTY_DEFINITIONS, null, true, true);
        for (String def : fixedUomPropDefinitions) {
            String[] parts = def.split("=");
            String propKey = parts[0].trim();
            String uomSuffix = parts[1].trim();
            uomSuffixByPropertyKey.put(propKey, uomSuffix);
        }
        String uomSuffixTv = trfConfig.parameterAsString(PARAM_MEASURE_UOM_TV, null, false, true);
        String uomSuffixSeparator = trfConfig.parameterAsString(PARAM_UOM_SUFFIX_SEPARATOR, "_", true, true);
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            ArrayList<GenericPropertyInfo> newPis = new ArrayList<GenericPropertyInfo>();
            for (PropertyInfo pi : genCi.properties().values()) {
                if (!measureTypes.contains(pi.typeInfo().name)) continue;
                GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                genPi.setTypeInfo(realType);
                if (trfConfig.hasRule(RULE_TRF_PROP_FLATTEN_MEASURE_TYPED_PROPERTIES_FIXED_UOM_SUFFIX)) {
                    String uomSuffix = null;
                    if (uomSuffixTv != null) {
                        uomSuffix = genPi.taggedValue(uomSuffixTv);
                    }
                    if (StringUtils.isBlank(uomSuffix)) {
                        uomSuffix = (String)uomSuffixByPropertyKey.get(genPi.name());
                    }
                    if (StringUtils.isBlank((CharSequence)uomSuffix)) {
                        uomSuffix = (String)uomSuffixByPropertyKey.get(genPi.inClass().name() + "." + genPi.name());
                    }
                    if (StringUtils.isNotBlank((CharSequence)uomSuffix)) {
                        genPi.setName(genPi.name() + uomSuffixSeparator + uomSuffix);
                        if (this.hasCode(genPi)) {
                            String code = this.getCode(genPi);
                            this.setCode(genPi, code + uomSuffixSeparator + uomSuffix);
                        }
                    }
                }
                if (!trfConfig.hasRule(RULE_TRF_PROP_FLATTEN_MEASURE_TYPED_PROPERTIES_ADD_UOM_PROPERTY)) continue;
                GenericPropertyInfo uomPi = this.createExtraProperty(genPi, "_uom", characterStringType, genCi, genModel, RULE_TRF_PROP_FLATTEN_MEASURE_TYPED_PROPERTIES_ADD_UOM_PROPERTY);
                newPis.add(uomPi);
            }
            if (newPis.isEmpty()) continue;
            genCi.addPropertiesInSequence(newPis, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
        }
    }

    private GenericPropertyInfo createExtraProperty(GenericPropertyInfo genPi, String suffix, Type type, GenericClassInfo genCi, GenericModel genModel, String rule) {
        GenericPropertyInfo newPi = new GenericPropertyInfo(genModel, genPi.id() + suffix, genPi.name() + suffix);
        if (genPi.cardinality().minOccurs == 0) {
            newPi.setCardinality(new Multiplicity(0, 1));
        } else if (genPi.cardinality().minOccurs == 1) {
            newPi.setCardinality(new Multiplicity(1, 1));
        } else {
            newPi.setCardinality(new Multiplicity(1, 1));
            this.result.addWarning(this, 20350, genPi.fullName(), Integer.toString(genPi.cardinality().minOccurs), rule);
        }
        if (genPi.cardinality().maxOccurs != 1) {
            this.result.addWarning(this, 20351, genPi.fullName(), Integer.toString(genPi.cardinality().maxOccurs), rule);
        }
        newPi.setSequenceNumber(genPi.sequenceNumber().createCopyWithSuffix(1), false);
        newPi.setInlineOrByReference("inline");
        newPi.setTypeInfo(type);
        newPi.setInClass(genCi);
        if (this.hasCode(genPi)) {
            String code = this.getCode(genPi);
            this.setCode(newPi, code + suffix);
        }
        return newPi;
    }

    private void applyRuleFlattenDirectPositionTypedProperties(GenericModel genModel, TransformerConfiguration trfConfig) {
        Type realType = Type.from("Real", genModel);
        Type characterStringType = Type.from("CharacterString", genModel);
        String referenceSystemSuffix = trfConfig.parameterAsString(PARAM_DIRECT_POSITION_RSID_SUFFIX, "_srsName", false, true);
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            ArrayList<GenericPropertyInfo> newPis = new ArrayList<GenericPropertyInfo>();
            for (PropertyInfo pi : genCi.properties().values()) {
                if (!"DirectPosition".equals(pi.typeInfo().name)) continue;
                GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                genPi.setTypeInfo(realType);
                if (!trfConfig.hasRule(RULE_TRF_PROP_FLATTEN_DIRECTPOSITION_TYPED_PROPERTIES_ADD_RSID_PROPERTY)) continue;
                GenericPropertyInfo crsPi = this.createExtraProperty(genPi, referenceSystemSuffix, characterStringType, genCi, genModel, RULE_TRF_PROP_FLATTEN_DIRECTPOSITION_TYPED_PROPERTIES_ADD_RSID_PROPERTY);
                newPis.add(crsPi);
            }
            if (newPis.isEmpty()) continue;
            genCi.addPropertiesInSequence(newPis, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
        }
    }

    private void applyRuleFlattenMediaTypeTypedProperties(GenericModel genModel, TransformerConfiguration trfConfig) {
        Type characterStringType = Type.from("CharacterString", genModel);
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            ArrayList<GenericPropertyInfo> newPis = new ArrayList<GenericPropertyInfo>();
            for (PropertyInfo pi : genCi.properties().values()) {
                if (!"MediaType".equals(pi.typeInfo().name)) continue;
                GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                genPi.setTypeInfo(characterStringType);
                GenericPropertyInfo typePi = this.createExtraProperty(genPi, "_type", characterStringType, genCi, genModel, RULE_TRF_PROP_FLATTEN_MEDIATYPE_TYPED_PROPERTIES);
                newPis.add(typePi);
            }
            if (newPis.isEmpty()) continue;
            genCi.addPropertiesInSequence(newPis, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
        }
    }

    private void applyRuleBasicTypeToSimpleBaseType(GenericModel genModel, TransformerConfiguration trfConfig) {
        TreeSet<String> simpleBaseTypes = new TreeSet<String>(trfConfig.parameterAsStringList(PARAM_SIMPLE_BASE_TYPES, DEFAULT_SIMPLE_BASE_TYPES, true, true));
        ArrayList<GenericClassInfo> typesToRemove = new ArrayList<GenericClassInfo>();
        HashMap<String, Type> typeNameToSimpleBaseType = new HashMap<String, Type>();
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            String simpleBaseTypeName = this.identifySimpleBaseType(genCi, simpleBaseTypes);
            if (simpleBaseTypeName == null) continue;
            ClassInfo simpleBaseType = genModel.classByName(simpleBaseTypeName);
            Type typeInfo = new Type();
            if (simpleBaseType == null) {
                typeInfo.id = UNKNOWN;
                typeInfo.name = simpleBaseTypeName;
            } else {
                typeInfo.id = simpleBaseType.id();
                typeInfo.name = simpleBaseType.name();
            }
            typesToRemove.add(genCi);
            typeNameToSimpleBaseType.put(genCi.name(), typeInfo);
        }
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if (!typeNameToSimpleBaseType.containsKey(genPi.typeInfo().name)) continue;
            genPi.setTypeInfo(((Type)typeNameToSimpleBaseType.get(genPi.typeInfo().name)).createCopy());
        }
        genModel.remove(typesToRemove);
    }

    private void applyRuleFlattenGeometryTypeInheritance(GenericModel genModel, TransformerConfiguration trfConfig) {
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            HashSet<String> supertypeIdsToRemove = new HashSet<String>();
            for (String supertypeId : genCi.supertypes()) {
                GenericClassInfo supertype = (GenericClassInfo)genModel.classById(supertypeId);
                if (!supertype.name().startsWith("GM_")) continue;
                supertypeIdsToRemove.add(supertypeId);
                supertype.removeSubtype(genCi.id());
                GenericPropertyInfo genPi = new GenericPropertyInfo(genModel, genCi.id() + "_propForGeomSupertype_" + supertype.name(), "geometry");
                genPi.setInClass(genCi);
                genPi.setComposition(true);
                genPi.setSequenceNumber(new StructuredNumber(1), false);
                Type typeInfo = new Type();
                typeInfo.id = supertype.id();
                typeInfo.name = supertype.name();
                genPi.setTypeInfo(typeInfo);
                genCi.addPropertyAtBottom(genPi, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
            }
            for (String supertypeIdToRemove : supertypeIdsToRemove) {
                genCi.removeSupertype(supertypeIdToRemove);
            }
        }
    }

    private void applyRuleDissolveMixins(GenericModel genModel, TransformerConfiguration trfConfig) {
        HashSet<GenericClassInfo> mixinsToRemove = new HashSet<GenericClassInfo>();
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            if (genCi.category() != 4) continue;
            mixinsToRemove.add(genCi);
        }
        TreeSet<String> idsOfUnprocessedMixins = new TreeSet<String>();
        for (GenericClassInfo mixin : mixinsToRemove) {
            idsOfUnprocessedMixins.add(mixin.id());
        }
        for (AssociationInfo ai : genModel.associations()) {
            ClassInfo mixin = null;
            if (ai.end1() != null && idsOfUnprocessedMixins.contains(ai.end1().inClass().id())) {
                mixin = ai.end1().inClass();
            } else if (ai.end2() != null && idsOfUnprocessedMixins.contains(ai.end2().inClass().id())) {
                mixin = ai.end2().inClass();
            }
            if (mixin == null) continue;
            this.result.addWarning(this, 20349, mixin.name());
        }
        while (!idsOfUnprocessedMixins.isEmpty()) {
            block4: for (GenericClassInfo mixin : mixinsToRemove) {
                if (!idsOfUnprocessedMixins.contains(mixin.id())) continue;
                for (ClassInfo stCi : mixin.supertypeClasses()) {
                    if (stCi.category() != 4 || !idsOfUnprocessedMixins.contains(stCi.id())) continue;
                    continue block4;
                }
                idsOfUnprocessedMixins.remove(mixin.id());
                this.copyContentToSubtypes(genModel, mixin);
            }
        }
        for (GenericClassInfo mixin : mixinsToRemove) {
            genModel.remove(mixin);
        }
    }

    private void applyRuleRemoveInheritanceRelationship(GenericModel genModel, TransformerConfiguration trfConfig) {
        if (!trfConfig.hasParameter(PARAM_REMOVE_INHERITANCE_INCLUDE_REGEX) || trfConfig.getParameterValue(PARAM_REMOVE_INHERITANCE_INCLUDE_REGEX).trim().isEmpty()) {
            this.result.addWarning(this, 20343, PARAM_REMOVE_INHERITANCE_INCLUDE_REGEX, RULE_TRF_CLS_REMOVE_INHERITANCE_RELATIONSHIP);
            return;
        }
        String includeRegex = trfConfig.getParameterValue(PARAM_REMOVE_INHERITANCE_INCLUDE_REGEX).trim();
        Pattern includePattern = Pattern.compile(includeRegex);
        HashSet<String> idsOfRelevantSupertypes = new HashSet<String>();
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            Matcher m = includePattern.matcher(genCi.name());
            if (m.matches()) {
                idsOfRelevantSupertypes.add(genCi.id());
                genCi.setSubtypes(null);
                this.result.addDebug(this, 20344, genCi.name(), includeRegex, PARAM_REMOVE_INHERITANCE_INCLUDE_REGEX);
                continue;
            }
            this.result.addDebug(this, 20345, genCi.name(), includeRegex, PARAM_REMOVE_INHERITANCE_INCLUDE_REGEX);
        }
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            TreeSet<String> idsOfSupertypesToKeep = new TreeSet<String>();
            for (String supertypeId : genCi.supertypes()) {
                if (idsOfRelevantSupertypes.contains(supertypeId)) continue;
                idsOfSupertypesToKeep.add(supertypeId);
            }
            genCi.setSupertypes(idsOfSupertypesToKeep);
        }
    }

    private void applyRuleRemoveFeatureTypeRelationships(GenericModel genModel, TransformerConfiguration trfConfig) {
        HashSet<GenericPropertyInfo> relsToRemove = new HashSet<GenericPropertyInfo>();
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if (genPi.inClass().category() != 1 || genPi.categoryOfValue() != 1) continue;
            relsToRemove.add(genPi);
        }
        for (GenericPropertyInfo genPi : relsToRemove) {
            genModel.remove(genPi, false);
        }
    }

    private void applyRuleFlattenCodeLists(GenericModel genModel, TransformerConfiguration trfConfig) {
        ArrayList<GenericClassInfo> codeListCisToRemove = new ArrayList<GenericClassInfo>();
        Map<String, GenericClassInfo> genCisById = genModel.getGenClasses();
        Type characterStringType = Type.from("CharacterString", genModel);
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            Type genPiType = genPi.typeInfo();
            ClassInfo typeCi = genModel.classById(genPiType.id);
            if (typeCi == null || typeCi.category() != 2) continue;
            genPiType.id = characterStringType.id;
            genPiType.name = characterStringType.name;
            if (!genCisById.containsKey(typeCi.id())) continue;
            codeListCisToRemove.add(genCisById.get(typeCi.id()));
        }
        genModel.remove(codeListCisToRemove);
    }

    private void applyRulePropFlattenRemoveNameAndCodeComponent(GenericModel genModel, TransformerConfiguration trfConfig) {
        String[] propNameCodeComponentsToRemove = trfConfig.getListParameterValue(PARAM_REMOVE_PROPERTY_NAME_AND_CODE_COMPONENT);
        if (propNameCodeComponentsToRemove == null) {
            propNameCodeComponentsToRemove = trfConfig.getListParameterValue(PARAM_REMOVE_PROPERTY_NAME_AND_ALIAS_COMPONENT);
        }
        if (propNameCodeComponentsToRemove == null || propNameCodeComponentsToRemove.length == 0) {
            return;
        }
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            for (String compToRemove : propNameCodeComponentsToRemove) {
                genPi.setName(genPi.name().replaceAll(compToRemove, ""));
                if (!this.hasCode(genPi)) continue;
                String oldCode = this.getCode(genPi);
                String newCode = oldCode.replaceAll(compToRemove, "");
                this.setCode(genPi, newCode);
            }
        }
        boolean resultContainsDuplicatePropertyNames = false;
        Joiner joiner = Joiner.on((String)", ");
        for (GenericClassInfo ci : genModel.selectedSchemaClasses()) {
            TreeSet<String> duplicatePropertyNames = new TreeSet<String>();
            for (PropertyInfo pi : ci.properties().values()) {
                PropertyInfo otherPropertyWithSameName = null;
                for (PropertyInfo otherPi : ci.properties().values()) {
                    if (otherPi == pi || !otherPi.name().equals(pi.name())) continue;
                    otherPropertyWithSameName = otherPi;
                    break;
                }
                if (otherPropertyWithSameName == null) {
                    block5: for (ClassInfo supertype : ci.supertypesInCompleteHierarchy()) {
                        for (PropertyInfo supertypePi : supertype.properties().values()) {
                            if (!supertypePi.name().equals(pi.name())) continue;
                            otherPropertyWithSameName = supertypePi;
                            break block5;
                        }
                    }
                }
                if (otherPropertyWithSameName == null) continue;
                resultContainsDuplicatePropertyNames = true;
                duplicatePropertyNames.add(pi.name());
            }
            if (duplicatePropertyNames.isEmpty()) continue;
            this.result.addInfo(this, 20346, ci.name(), joiner.join(duplicatePropertyNames));
        }
        if (resultContainsDuplicatePropertyNames) {
            this.result.addError(this, 20347);
        }
    }

    private void applyRuleRemoveType(GenericModel genModel, TransformerConfiguration trfConfig) {
        String[] typesToRemove = trfConfig.getListParameterValue(PARAM_REMOVE_TYPE);
        if (typesToRemove == null || typesToRemove.length == 0) {
            this.result.addWarning(this, 20324);
            return;
        }
        HashSet<String> typesToRemoveAsSet = new HashSet<String>(Arrays.asList(typesToRemove));
        ArrayList<GenericClassInfo> cisToRemove = new ArrayList<GenericClassInfo>();
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            if (!typesToRemoveAsSet.contains(genCi.name())) continue;
            cisToRemove.add(genCi);
        }
        for (GenericClassInfo ciToRemove : cisToRemove) {
            genModel.remove(ciToRemove);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyRulePropFlattenHomogeneousGeometries(GenericModel genModel, TransformerConfiguration trfConfig) {
        GenericClassInfo copiedClassUnion;
        ShapeChangeResult result = genModel.result();
        boolean applyOnSubtypes = false;
        if (trfConfig.hasParameter(PARAM_HOMOGENEOUSGEOMETRIES_APPLY_ON_SUBTYPES)) {
            String paramValue = trfConfig.getParameterValue(PARAM_HOMOGENEOUSGEOMETRIES_APPLY_ON_SUBTYPES);
            Boolean b = Boolean.valueOf(paramValue);
            result.addDebug(this, 20102, PARAM_HOMOGENEOUSGEOMETRIES_APPLY_ON_SUBTYPES, b.toString());
            applyOnSubtypes = b;
        }
        boolean omitHomogeneousGeometriesForTypesWithSingleGeometryProperty = false;
        if (trfConfig.hasParameter(PARAM_HOMOGENEOUSGEOMETRIES_OMIT_RULE_FOR_CASE_OF_SINGLE_GEOMETRY_PROP)) {
            String paramValue = trfConfig.getParameterValue(PARAM_HOMOGENEOUSGEOMETRIES_OMIT_RULE_FOR_CASE_OF_SINGLE_GEOMETRY_PROP);
            Boolean b = Boolean.valueOf(paramValue);
            result.addDebug(this, 20102, PARAM_HOMOGENEOUSGEOMETRIES_OMIT_RULE_FOR_CASE_OF_SINGLE_GEOMETRY_PROP, b.toString());
            omitHomogeneousGeometriesForTypesWithSingleGeometryProperty = b;
        }
        String separatorForGeometryTypeSuffix = trfConfig.parameterAsString(PARAM_SEPARATOR_FOR_GEOMETRY_TYPE_SUFFIX, "", true, false);
        EnumMap<Descriptor, String> geometryTypeSuffixSeparatorByDescriptor = this.parseDescriptorModificationParameterUsingBasicPattern(PARAM_DESCRIPTOR_MOD_GEOMETRY_TYPE_SUFFIX_SEPARATOR, trfConfig);
        EnumMap<Descriptor, String> unionSeparatorByDescriptor = this.parseDescriptorModificationParameterUsingBasicPattern(PARAM_DESCRIPTOR_MOD_UNION_SEPARATOR, trfConfig);
        EnumMap<Descriptor, String> geomTypeAliasesByDescriptor = this.parseDescriptorModificationParameterUsingBasicPattern(PARAM_DESCRIPTOR_MOD_GEOM_TYPE_ALIAS, trfConfig);
        EnumMap<Descriptor, Map<String, String>> suffixByGeometryTypeByDescriptor = new EnumMap<Descriptor, Map<String, String>>(Descriptor.class);
        for (Map.Entry<Descriptor, String> entry : geomTypeAliasesByDescriptor.entrySet()) {
            Map<String, String> suffixByGeometryType = this.parseDescriptorModificationValueUsingKvpPattern(entry.getValue());
            if (suffixByGeometryType.isEmpty()) continue;
            suffixByGeometryTypeByDescriptor.put(entry.getKey(), suffixByGeometryType);
        }
        HashSet<GenericClassInfo> classesToAdd = new HashSet<GenericClassInfo>();
        HashSet<GenericClassInfo> classesToRemove = new HashSet<GenericClassInfo>();
        HashMap<GenericClassInfo, Map<String, GenericClassInfo>> classCopiesByGeometryTypeByOriginalClass = new HashMap<GenericClassInfo, Map<String, GenericClassInfo>>();
        for (GenericClassInfo genericClassInfo : genModel.selectedSchemaClasses()) {
            Object geomTypeProp22;
            Object propInfoSetForGeomTypeName;
            TreeMap<String, Object> propMapByGeomTypeName = new TreeMap<String, Object>();
            HashMap propInfoSetsByGeomProperty = new HashMap();
            if (genericClassInfo.category() != 1) continue;
            TreeSet geometryTVValues = new TreeSet();
            String geometryTV = genericClassInfo.taggedValue("geometry");
            if (StringUtils.isNotBlank((CharSequence)geometryTV)) {
                geometryTVValues = new TreeSet(commaSplitter.splitToList((CharSequence)geometryTV));
            }
            for (PropertyInfo pi : genericClassInfo.properties().values()) {
                String piTypeName = pi.typeInfo().name;
                if (!piTypeName.startsWith("GM_")) continue;
                propInfoSetsByGeomProperty.put((GenericPropertyInfo)pi, new HashSet());
                if (propMapByGeomTypeName.containsKey(piTypeName)) {
                    ((Set)propMapByGeomTypeName.get(piTypeName)).add((GenericPropertyInfo)pi);
                    continue;
                }
                propInfoSetForGeomTypeName = new HashSet();
                propInfoSetForGeomTypeName.add((GenericPropertyInfo)pi);
                propMapByGeomTypeName.put(piTypeName, propInfoSetForGeomTypeName);
            }
            if (omitHomogeneousGeometriesForTypesWithSingleGeometryProperty && propMapByGeomTypeName.size() <= 1) continue;
            if (applyOnSubtypes && !propInfoSetsByGeomProperty.isEmpty()) {
                Object names;
                SortedSet<ClassInfo> supertypesAll = genericClassInfo.supertypesInCompleteHierarchy();
                TreeSet<ClassInfo> supertypesWithGeometryProperty = new TreeSet<ClassInfo>();
                TreeSet<ClassInfo> supertypesWithOtherGeometryDefinition = new TreeSet<ClassInfo>();
                propInfoSetForGeomTypeName = supertypesAll.iterator();
                while (propInfoSetForGeomTypeName.hasNext()) {
                    void var25_49;
                    ClassInfo classInfo = (ClassInfo)propInfoSetForGeomTypeName.next();
                    for (PropertyInfo pi : classInfo.properties().values()) {
                        if (!pi.typeInfo().name.startsWith("GM_")) continue;
                        supertypesWithGeometryProperty.add(classInfo);
                        break;
                    }
                    if (geometryTV == null || geometryTVValues.isEmpty()) continue;
                    TreeSet treeSet = new TreeSet();
                    String supertypeGeometryTV = classInfo.taggedValue("geometry");
                    if (StringUtils.isNotBlank((CharSequence)supertypeGeometryTV)) {
                        TreeSet treeSet2 = new TreeSet(commaSplitter.splitToList((CharSequence)supertypeGeometryTV));
                    }
                    if (var25_49.isEmpty()) {
                        supertypesWithOtherGeometryDefinition.add(classInfo);
                        continue;
                    }
                    if (var25_49.equals(geometryTVValues)) continue;
                    supertypesWithOtherGeometryDefinition.add(classInfo);
                }
                if (!supertypesWithOtherGeometryDefinition.isEmpty()) {
                    names = new ArrayList();
                    for (ClassInfo classInfo : supertypesWithOtherGeometryDefinition) {
                        names.add(classInfo.name());
                    }
                    result.addWarning(this, 20316, genericClassInfo.name(), commaJoiner.join((Iterable)names));
                }
                if (!supertypesWithGeometryProperty.isEmpty()) {
                    names = new ArrayList();
                    for (ClassInfo classInfo : supertypesWithGeometryProperty) {
                        names.add(classInfo.name());
                    }
                    result.addWarning(this, 20313, genericClassInfo.name(), commaJoiner.join((Iterable)names));
                    continue;
                }
            }
            for (Object geomTypeProp22 : propInfoSetsByGeomProperty.keySet()) {
                if (!((GenericPropertyInfo)geomTypeProp22).name().contains(this.separatorForPropertyFromNonUnion)) continue;
                String prefix = ((GenericPropertyInfo)geomTypeProp22).name().substring(0, ((GenericPropertyInfo)geomTypeProp22).name().lastIndexOf(this.separatorForPropertyFromNonUnion));
                for (PropertyInfo propertyInfo : genericClassInfo.properties().values()) {
                    if (!propertyInfo.name().startsWith(prefix) || propertyInfo.name() == ((GenericPropertyInfo)geomTypeProp22).name()) continue;
                    ((Set)propInfoSetsByGeomProperty.get(geomTypeProp22)).add((GenericPropertyInfo)propertyInfo);
                }
            }
            TreeMap ftCopiesByGeometryTypeSuffix = new TreeMap();
            geomTypeProp22 = propMapByGeomTypeName.keySet().iterator();
            while (geomTypeProp22.hasNext()) {
                String geomType = (String)geomTypeProp22.next();
                if (!trfConfig.hasMappingForType(RULE_TRF_PROP_FLATTEN_HOMOGENEOUSGEOMETRIES, geomType)) continue;
                ProcessMapEntry mapEntry = trfConfig.getMappingForType(RULE_TRF_PROP_FLATTEN_HOMOGENEOUSGEOMETRIES, geomType);
                if (!mapEntry.hasTargetType() || !mapEntry.hasParam() || !geometryTVValues.isEmpty() && !geometryTVValues.contains(mapEntry.getParam())) {
                    for (GenericPropertyInfo genericPropertyInfo : (Set)propMapByGeomTypeName.get(geomType)) {
                        for (Object relatedProp : (Set)propInfoSetsByGeomProperty.get(genericPropertyInfo)) {
                            genModel.remove((GenericPropertyInfo)relatedProp, false);
                        }
                        genModel.remove(genericPropertyInfo, false);
                    }
                    continue;
                }
                GenericClassInfo genericClassInfo2 = genericClassInfo.createCopy(genericClassInfo.id() + separatorForGeometryTypeSuffix + mapEntry.getParam(), genericClassInfo.name() + separatorForGeometryTypeSuffix + mapEntry.getParam(), 1);
                ftCopiesByGeometryTypeSuffix.put(mapEntry.getParam(), genericClassInfo2);
                classCopiesByGeometryTypeByOriginalClass.put(genericClassInfo, ftCopiesByGeometryTypeSuffix);
                if (!geometryTypeSuffixSeparatorByDescriptor.isEmpty()) {
                    EnumMap<Descriptor, Pair<String, String>> enumMap = this.determineSeparatorAndSuffixForDescriptors(geometryTypeSuffixSeparatorByDescriptor, mapEntry.getParam(), suffixByGeometryTypeByDescriptor);
                    genericClassInfo2.descriptors().appendSuffix(enumMap, false);
                } else if (this.hasCode(genericClassInfo)) {
                    this.setCode(genericClassInfo2, this.getCode(genericClassInfo) + separatorForGeometryTypeSuffix + mapEntry.getParam());
                } else {
                    this.setCode(genericClassInfo2, genericClassInfo.name() + separatorForGeometryTypeSuffix + mapEntry.getParam());
                }
                for (String geomTypeToRemove : propMapByGeomTypeName.keySet()) {
                    Object relatedProp;
                    if (geomTypeToRemove.equals(geomType)) continue;
                    relatedProp = ((Set)propMapByGeomTypeName.get(geomTypeToRemove)).iterator();
                    while (relatedProp.hasNext()) {
                        GenericPropertyInfo geomTypePropertyToRemove = (GenericPropertyInfo)relatedProp.next();
                        for (GenericPropertyInfo relatedPropToRemove : (Set)propInfoSetsByGeomProperty.get(geomTypePropertyToRemove)) {
                            genericClassInfo2.removeByStructuredNumber(relatedPropToRemove.sequenceNumber());
                        }
                        genericClassInfo2.removeByStructuredNumber(geomTypePropertyToRemove.sequenceNumber());
                    }
                }
                for (PropertyInfo piFromFeatureCopy : genericClassInfo2.properties().values()) {
                    Type typeOfPi = piFromFeatureCopy.typeInfo();
                    if (!typeOfPi.name.equals(geomType) || mapEntry.getTargetType().equals(typeOfPi.name)) continue;
                    ClassInfo targetTypeCi = genModel.classByName(mapEntry.getTargetType());
                    if (targetTypeCi != null) {
                        typeOfPi.id = targetTypeCi.id();
                        typeOfPi.name = targetTypeCi.name();
                        continue;
                    }
                    ShapeChangeResult.MessageContext mc = result.addWarning(this, 20302, mapEntry.getTargetType(), typeOfPi.name);
                    if (mc != null) {
                        mc.addDetail(this, 20308, "Property", piFromFeatureCopy.fullName());
                    }
                    typeOfPi.name = mapEntry.getTargetType();
                }
                classesToAdd.add(genericClassInfo2);
                classesToRemove.add(genericClassInfo);
            }
            if (!applyOnSubtypes || propInfoSetsByGeomProperty.isEmpty()) continue;
            TreeSet<String> idsOfGenCiSupertypes = new TreeSet<String>();
            SortedSet genCiSupertypes = genericClassInfo.supertypes();
            if (genCiSupertypes != null) {
                idsOfGenCiSupertypes.addAll(genCiSupertypes);
            }
            if (genericClassInfo.baseClass() != null) {
                idsOfGenCiSupertypes.add(genericClassInfo.baseClass().id());
            }
            for (String string : idsOfGenCiSupertypes) {
                ClassInfo classInfo = genModel.classById(string);
                if (classInfo instanceof GenericClassInfo) {
                    GenericClassInfo supertypeGenCi = (GenericClassInfo)classInfo;
                    SortedSet subtypesOfSupertype = supertypeGenCi.subtypes();
                    subtypesOfSupertype.remove(genericClassInfo.id());
                    for (Object genCiCopy : ftCopiesByGeometryTypeSuffix.values()) {
                        subtypesOfSupertype.add(((GenericClassInfo)genCiCopy).id());
                    }
                    continue;
                }
                result.addWarning(this, 20312, classInfo.name(), genericClassInfo.name());
            }
            for (String string : ftCopiesByGeometryTypeSuffix.keySet()) {
                GenericClassInfo genericClassInfo3 = (GenericClassInfo)ftCopiesByGeometryTypeSuffix.get(string);
                this.createSubtypeHierarchyCopyForClassCopy(genericClassInfo, genericClassInfo3, separatorForGeometryTypeSuffix, string, classesToAdd, classesToRemove, classCopiesByGeometryTypeByOriginalClass, geometryTypeSuffixSeparatorByDescriptor, suffixByGeometryTypeByDescriptor);
            }
        }
        TreeMap<String, GenericClassInfo> copiedClassUnionsByOriginalClassId = new TreeMap<String, GenericClassInfo>();
        for (GenericClassInfo copiedClass : classCopiesByGeometryTypeByOriginalClass.keySet()) {
            Map classCopiesByGeometryType = (Map)classCopiesByGeometryTypeByOriginalClass.get(copiedClass);
            copiedClassUnion = new GenericClassInfo(genModel, copiedClass.id() + "_union", copiedClass.name() + "Union", 8);
            if (this.hasCode(copiedClass)) {
                this.setCode(copiedClassUnion, this.getCode(copiedClass) + "_U");
            } else {
                this.setCode(copiedClassUnion, copiedClass.name() + "Union");
            }
            copiedClassUnion.setStereotype("union");
            copiedClassUnion.setPkg(copiedClass.pkg());
            ((GenericPackageInfo)copiedClassUnion.pkg()).addClass(copiedClassUnion);
            copiedClassUnion.setTaggedValue("representsFeatureTypeSet", "true", false);
            int seqNumIndex = 1;
            for (String suffix : classCopiesByGeometryType.keySet()) {
                GenericClassInfo classCopy = (GenericClassInfo)classCopiesByGeometryType.get(suffix);
                GenericPropertyInfo copiedClassUnionProp = new GenericPropertyInfo(genModel, copiedClassUnion.id() + "_choice" + seqNumIndex, this.normaliseGeometryTypeSuffix(suffix));
                copiedClassUnionProp.setStereotype("");
                Type type = new Type();
                type.id = classCopy.id();
                type.name = classCopy.name();
                copiedClassUnionProp.setTypeInfo(type);
                TaggedValues taggedValues = this.options.taggedValueFactory();
                taggedValues.add("gmlImplementedByNilReason", "false");
                taggedValues.add("inlineOrByReference", "inlineOrByReference");
                taggedValues.add("isMetadata", "false");
                taggedValues.add(PARAM_MAXOCCURS, "");
                taggedValues.add("modified", "");
                taggedValues.add("name", "");
                taggedValues.add("physicalQuantity", "");
                taggedValues.add("profiles", "");
                taggedValues.add("recommendedMeasure", "");
                taggedValues.add("securityClassification", "");
                taggedValues.add("sequenceNumber", "" + seqNumIndex);
                taggedValues.add("xsdEncodingRule", "");
                copiedClassUnionProp.setTaggedValues(taggedValues, false);
                copiedClassUnionProp.setSequenceNumber(new StructuredNumber("" + seqNumIndex), false);
                copiedClassUnionProp.setInClass(copiedClassUnion);
                copiedClassUnion.addProperty(copiedClassUnionProp, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
                ++seqNumIndex;
            }
            copiedClassUnionsByOriginalClassId.put(copiedClass.id(), copiedClassUnion);
            classesToAdd.add(copiedClassUnion);
        }
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if (!genPi.isAttribute()) continue;
            Type type = genPi.typeInfo();
            if (!copiedClassUnionsByOriginalClassId.containsKey(type.id)) continue;
            copiedClassUnion = (GenericClassInfo)copiedClassUnionsByOriginalClassId.get(type.id);
            type.name = copiedClassUnion.name();
            type.id = copiedClassUnion.id();
        }
        for (GenericClassInfo genCiToAdd : classesToAdd) {
            for (PropertyInfo pi : genCiToAdd.properties().values()) {
                if (!pi.isAttribute()) continue;
                Type type = pi.typeInfo();
                if (!copiedClassUnionsByOriginalClassId.containsKey(type.id)) continue;
                GenericClassInfo copiedClassUnion2 = (GenericClassInfo)copiedClassUnionsByOriginalClassId.get(type.id);
                type.name = copiedClassUnion2.name();
                type.id = copiedClassUnion2.id();
            }
        }
        HashSet<GenericAssociationInfo> hashSet = new HashSet<GenericAssociationInfo>();
        HashSet<GenericPropertyInfo> propertiesToRemove = new HashSet<GenericPropertyInfo>();
        for (GenericAssociationInfo genAi : genModel.selectedSchemaAssociations()) {
            GenericAssociationInfo aiCopy;
            StructuredNumber newSnPi2;
            StructuredNumber newSnPi1;
            EnumMap<Descriptor, Pair<String, String>> separatorAndSuffixByDescriptor;
            PropertyInfo pi1 = genAi.end1();
            PropertyInfo pi2 = genAi.end2();
            String name1 = pi1.inClass().name();
            String name2 = pi2.inClass().name();
            if (!classCopiesByGeometryTypeByOriginalClass.containsKey(pi1.inClass()) && !classCopiesByGeometryTypeByOriginalClass.containsKey(pi2.inClass())) continue;
            if (!(pi1 instanceof GenericPropertyInfo) || !(pi2 instanceof GenericPropertyInfo)) {
                if (!(pi1 instanceof GenericPropertyInfo)) {
                    result.addWarning(this, 20333, name1.compareTo(name2) <= 0 ? name1 : name2, name1.compareTo(name2) <= 0 ? name2 : name1, name1);
                    continue;
                }
                result.addWarning(this, 20333, name1.compareTo(name2) <= 0 ? name1 : name2, name1.compareTo(name2) <= 0 ? name2 : name1, name2);
                continue;
            }
            GenericPropertyInfo genPi1Orig = (GenericPropertyInfo)pi1;
            GenericPropertyInfo genericPropertyInfo = (GenericPropertyInfo)pi2;
            propertiesToRemove.add(genPi1Orig);
            propertiesToRemove.add(genericPropertyInfo);
            if (classCopiesByGeometryTypeByOriginalClass.containsKey(pi1.inClass()) && classCopiesByGeometryTypeByOriginalClass.containsKey(pi2.inClass())) {
                Map map = (Map)classCopiesByGeometryTypeByOriginalClass.get(pi1.inClass());
                Map classCopiesByGeometryTypeForPi2InClass = (Map)classCopiesByGeometryTypeByOriginalClass.get(pi2.inClass());
                boolean checkFailed = false;
                if (map == null || map.isEmpty()) {
                    checkFailed = true;
                    result.addError(this, 20335, pi1.inClass().name());
                }
                if (classCopiesByGeometryTypeForPi2InClass == null || classCopiesByGeometryTypeForPi2InClass.isEmpty()) {
                    checkFailed = true;
                    result.addError(this, 20335, pi2.inClass().name());
                }
                if (checkFailed) continue;
                int sequencNumberIndex = 1;
                for (String geometryTypeSuffix1 : map.keySet()) {
                    GenericClassInfo copyPi1InClass = (GenericClassInfo)map.get(geometryTypeSuffix1);
                    for (String geometryTypeSuffix2 : classCopiesByGeometryTypeForPi2InClass.keySet()) {
                        GenericClassInfo copyPi2InClass = (GenericClassInfo)classCopiesByGeometryTypeForPi2InClass.get(geometryTypeSuffix2);
                        Multiplicity mPi1 = new Multiplicity(pi1.cardinality().toString());
                        mPi1.minOccurs = 0;
                        Multiplicity mPi2 = new Multiplicity(pi2.cardinality().toString());
                        mPi2.minOccurs = 0;
                        String newNamePi1 = pi1.name() + this.separatorForPropertyFromUnion + geometryTypeSuffix2;
                        String newNamePi2 = pi2.name() + this.separatorForPropertyFromUnion + geometryTypeSuffix1;
                        String newAliasPi1 = this.hasCode(pi1) ? this.getCode(pi1) + this.separatorForPropertyFromUnion + geometryTypeSuffix2 : null;
                        String newAliasPi2 = this.hasCode(pi2) ? this.getCode(pi2) + this.separatorForPropertyFromUnion + geometryTypeSuffix1 : null;
                        Descriptors newDescriptorsPi1 = null;
                        if (!geometryTypeSuffixSeparatorByDescriptor.isEmpty()) {
                            EnumMap<Descriptor, Pair<String, String>> separatorAndSuffixByDescriptor2 = this.determineSeparatorAndSuffixForDescriptors(unionSeparatorByDescriptor, geometryTypeSuffix2, suffixByGeometryTypeByDescriptor);
                            newDescriptorsPi1 = pi1.descriptors().createCopy();
                            newDescriptorsPi1.appendSuffix(separatorAndSuffixByDescriptor2, false);
                        }
                        Descriptors newDescriptorsPi2 = null;
                        if (!geometryTypeSuffixSeparatorByDescriptor.isEmpty()) {
                            EnumMap<Descriptor, Pair<String, String>> separatorAndSuffixByDescriptor3 = this.determineSeparatorAndSuffixForDescriptors(unionSeparatorByDescriptor, geometryTypeSuffix1, suffixByGeometryTypeByDescriptor);
                            newDescriptorsPi2 = pi2.descriptors().createCopy();
                            newDescriptorsPi2.appendSuffix(separatorAndSuffixByDescriptor3, false);
                        }
                        StructuredNumber newSnPi12 = pi1.sequenceNumber().createCopyWithSuffix(sequencNumberIndex);
                        StructuredNumber newSnPi22 = pi2.sequenceNumber().createCopyWithSuffix(sequencNumberIndex);
                        ++sequencNumberIndex;
                        GenericAssociationInfo aiCopy2 = this.createCopyAndSetEnds(genModel, genAi, newNamePi1, newAliasPi1, newDescriptorsPi1, copyPi1InClass, mPi1, newSnPi12, newNamePi2, newAliasPi2, newDescriptorsPi2, copyPi2InClass, mPi2, newSnPi22, false);
                        hashSet.add(aiCopy2);
                    }
                }
                continue;
            }
            if (classCopiesByGeometryTypeByOriginalClass.containsKey(pi1.inClass())) {
                Map map = (Map)classCopiesByGeometryTypeByOriginalClass.get(pi1.inClass());
                if (map == null || map.isEmpty()) {
                    result.addError(this, 20335, pi1.inClass().name());
                    continue;
                }
                int sequencNumberIndex = 1;
                for (String geometryTypeSuffix1 : map.keySet()) {
                    GenericClassInfo copyPi1InClass = (GenericClassInfo)map.get(geometryTypeSuffix1);
                    Multiplicity mPi2 = new Multiplicity(pi2.cardinality().toString());
                    mPi2.minOccurs = 0;
                    GenericClassInfo pi2InClass = (GenericClassInfo)pi2.inClass();
                    String newNamePi2 = pi2.name() + this.separatorForPropertyFromUnion + geometryTypeSuffix1;
                    String newAliasPi2 = this.hasCode(pi2) ? this.getCode(pi2) + this.separatorForPropertyFromUnion + geometryTypeSuffix1 : null;
                    Descriptors newDescriptorsPi2 = null;
                    if (!geometryTypeSuffixSeparatorByDescriptor.isEmpty()) {
                        separatorAndSuffixByDescriptor = this.determineSeparatorAndSuffixForDescriptors(unionSeparatorByDescriptor, geometryTypeSuffix1, suffixByGeometryTypeByDescriptor);
                        newDescriptorsPi2 = pi2.descriptors().createCopy();
                        newDescriptorsPi2.appendSuffix(separatorAndSuffixByDescriptor, false);
                    }
                    newSnPi1 = pi1.sequenceNumber().createCopyWithSuffix(sequencNumberIndex);
                    newSnPi2 = pi2.sequenceNumber().createCopyWithSuffix(sequencNumberIndex);
                    ++sequencNumberIndex;
                    aiCopy = this.createCopyAndSetEnds(genModel, genAi, null, null, null, copyPi1InClass, null, newSnPi1, newNamePi2, newAliasPi2, newDescriptorsPi2, pi2InClass, mPi2, newSnPi2, false);
                    hashSet.add(aiCopy);
                }
                continue;
            }
            Map map = (Map)classCopiesByGeometryTypeByOriginalClass.get(pi2.inClass());
            if (map == null || map.isEmpty()) {
                result.addError(this, 20335, pi2.inClass().name());
                continue;
            }
            int sequencNumberIndex = 1;
            for (String geometryTypeSuffix2 : map.keySet()) {
                GenericClassInfo copyPi2InClass = (GenericClassInfo)map.get(geometryTypeSuffix2);
                Multiplicity mPi1 = new Multiplicity(pi1.cardinality().toString());
                mPi1.minOccurs = 0;
                GenericClassInfo pi1InClass = (GenericClassInfo)pi1.inClass();
                String newNamePi1 = pi1.name() + this.separatorForPropertyFromUnion + geometryTypeSuffix2;
                String newAliasPi1 = this.hasCode(pi1) ? this.getCode(pi1) + this.separatorForPropertyFromUnion + geometryTypeSuffix2 : null;
                Descriptors newDescriptorsPi1 = null;
                if (!geometryTypeSuffixSeparatorByDescriptor.isEmpty()) {
                    separatorAndSuffixByDescriptor = this.determineSeparatorAndSuffixForDescriptors(unionSeparatorByDescriptor, geometryTypeSuffix2, suffixByGeometryTypeByDescriptor);
                    newDescriptorsPi1 = pi1.descriptors().createCopy();
                    newDescriptorsPi1.appendSuffix(separatorAndSuffixByDescriptor, false);
                }
                newSnPi1 = pi1.sequenceNumber().createCopyWithSuffix(sequencNumberIndex);
                newSnPi2 = pi2.sequenceNumber().createCopyWithSuffix(sequencNumberIndex);
                ++sequencNumberIndex;
                aiCopy = this.createCopyAndSetEnds(genModel, genAi, newNamePi1, newAliasPi1, newDescriptorsPi1, pi1InClass, mPi1, newSnPi1, null, null, null, copyPi2InClass, null, newSnPi2, false);
                hashSet.add(aiCopy);
            }
        }
        for (GenericClassInfo featureCopy : classesToAdd) {
            genModel.addClass(featureCopy);
        }
        for (GenericPropertyInfo piToRemove : propertiesToRemove) {
            genModel.remove(piToRemove, false);
        }
        for (GenericAssociationInfo aiCopy : hashSet) {
            genModel.addAssociation(aiCopy);
        }
        for (GenericClassInfo copiedFeature : classesToRemove) {
            genModel.remove(copiedFeature);
        }
    }

    private EnumMap<Descriptor, Pair<String, String>> determineSeparatorAndSuffixForDescriptors(EnumMap<Descriptor, String> geometryTypeSuffixSeparatorByDescriptor, String geometryTypeIdentifier, EnumMap<Descriptor, Map<String, String>> suffixByGeometryTypeByDescriptor) {
        EnumMap<Descriptor, Pair<String, String>> separatorAndSuffixByDescriptor = new EnumMap<Descriptor, Pair<String, String>>(Descriptor.class);
        for (Descriptor descriptor : geometryTypeSuffixSeparatorByDescriptor.keySet()) {
            Map<String, String> suffixByGeometryType;
            String separator = geometryTypeSuffixSeparatorByDescriptor.get((Object)descriptor);
            String suffix = geometryTypeIdentifier;
            if (suffixByGeometryTypeByDescriptor.containsKey((Object)descriptor) && (suffixByGeometryType = suffixByGeometryTypeByDescriptor.get((Object)descriptor)).containsKey(geometryTypeIdentifier)) {
                suffix = suffixByGeometryType.get(geometryTypeIdentifier);
            }
            separatorAndSuffixByDescriptor.put(descriptor, (Pair<String, String>)new ImmutablePair((Object)separator, (Object)suffix));
        }
        return separatorAndSuffixByDescriptor;
    }

    private Map<String, String> parseDescriptorModificationValueUsingKvpPattern(String value) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (value != null) {
            Matcher matcher = descriptorModValKvpPattern.matcher(value);
            while (matcher.find()) {
                res.put(matcher.group(1), matcher.group(2));
            }
        }
        return res;
    }

    private String normaliseGeometryTypeSuffix(String suffix) {
        String result = suffix.replaceAll("\\W|_", "");
        result = result.toLowerCase(Locale.ENGLISH);
        return result;
    }

    private void createSubtypeHierarchyCopyForClassCopy(GenericClassInfo genCi, GenericClassInfo genCiCopy, String separatorForGeometryTypeSuffix, String geometryTypeSuffix, Set<GenericClassInfo> classesToAdd, Set<GenericClassInfo> classesToRemove, Map<GenericClassInfo, Map<String, GenericClassInfo>> classCopiesByGeometryTypeByOriginalClass, EnumMap<Descriptor, String> geometryTypeSuffixSeparatorByDescriptor, EnumMap<Descriptor, Map<String, String>> suffixByGeometryTypeByDescriptor) {
        GenericModel genModel = genCiCopy.model();
        TreeSet subtypeIds = (TreeSet)((TreeSet)genCiCopy.subtypes()).clone();
        for (String subtypeId : subtypeIds) {
            Map<Object, Object> classCopiesByGeometryType;
            ClassInfo subCi = genModel.classById(subtypeId);
            if (subCi == null || !(subCi instanceof GenericClassInfo)) {
                this.result.addError(this, 20311, genCi.name(), subtypeId);
                continue;
            }
            GenericClassInfo subGenCi = (GenericClassInfo)subCi;
            GenericClassInfo subtypeCopy = subGenCi.createCopy(subGenCi.id() + separatorForGeometryTypeSuffix + geometryTypeSuffix, subGenCi.name() + separatorForGeometryTypeSuffix + geometryTypeSuffix, subGenCi.category());
            classesToAdd.add(subtypeCopy);
            classesToRemove.add(subGenCi);
            if (classCopiesByGeometryTypeByOriginalClass.containsKey(subGenCi)) {
                classCopiesByGeometryType = classCopiesByGeometryTypeByOriginalClass.get(subGenCi);
            } else {
                classCopiesByGeometryType = new TreeMap();
                classCopiesByGeometryTypeByOriginalClass.put(subGenCi, classCopiesByGeometryType);
            }
            classCopiesByGeometryType.put(geometryTypeSuffix, subtypeCopy);
            if (!geometryTypeSuffixSeparatorByDescriptor.isEmpty()) {
                EnumMap<Descriptor, Pair<String, String>> separatorAndSuffixByDescriptor = this.determineSeparatorAndSuffixForDescriptors(geometryTypeSuffixSeparatorByDescriptor, geometryTypeSuffix, suffixByGeometryTypeByDescriptor);
                subtypeCopy.descriptors().appendSuffix(separatorAndSuffixByDescriptor, false);
            } else if (this.hasCode(subGenCi)) {
                this.setCode(subtypeCopy, this.getCode(subGenCi) + separatorForGeometryTypeSuffix + geometryTypeSuffix);
            } else {
                this.setCode(subtypeCopy, subGenCi.name() + separatorForGeometryTypeSuffix + geometryTypeSuffix);
            }
            subtypeCopy.updateSupertypeId(genCi.id(), genCiCopy.id());
            SortedSet idsOfSubtypeCopySupertypes = subtypeCopy.supertypes();
            for (String idOfSubtypeCopySupertype : idsOfSubtypeCopySupertypes) {
                ClassInfo supertypeOfSubtypeCopy = genModel.classById(idOfSubtypeCopySupertype);
                if (supertypeOfSubtypeCopy == null) {
                    for (GenericClassInfo classToAdd : classesToAdd) {
                        if (!classToAdd.id().equals(idOfSubtypeCopySupertype)) continue;
                        supertypeOfSubtypeCopy = classToAdd;
                    }
                }
                if (supertypeOfSubtypeCopy == null) {
                    this.result.addError(this, 20314, idOfSubtypeCopySupertype, subtypeCopy.name());
                    continue;
                }
                if (!(supertypeOfSubtypeCopy instanceof GenericClassInfo)) {
                    this.result.addError(this, 20322, supertypeOfSubtypeCopy.name(), subtypeCopy.name(), subGenCi.id(), subtypeCopy.id());
                    continue;
                }
                ((GenericClassInfo)supertypeOfSubtypeCopy).updateSubtypeId(subGenCi.id(), subtypeCopy.id());
            }
            this.createSubtypeHierarchyCopyForClassCopy(subGenCi, subtypeCopy, separatorForGeometryTypeSuffix, geometryTypeSuffix, classesToAdd, classesToRemove, classCopiesByGeometryTypeByOriginalClass, geometryTypeSuffixSeparatorByDescriptor, suffixByGeometryTypeByDescriptor);
        }
    }

    private void applyRuleClsFlattenConstraints(GenericModel genModel, TransformerConfiguration trfConfig) {
        GenericTextConstraint genCon;
        String textUpdate;
        String text;
        Vector<Constraint> newConstraints;
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            if (!genCi.hasDirectConstraints()) continue;
            List<Constraint> classConstraints = genCi.directConstraints();
            newConstraints = new Vector<Constraint>();
            for (Constraint origCon : classConstraints) {
                text = origCon.text();
                if (text == null || !text.contains("/*")) continue;
                textUpdate = text.replaceAll("/\\*|\\*/[\\w|\\W]*", "");
                genCon = new GenericTextConstraint(genCi, origCon);
                genCon.setText(textUpdate);
                newConstraints.add(genCon);
            }
            genCi.setDirectConstraints(newConstraints);
        }
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if (!genPi.hasConstraints()) continue;
            List<Constraint> propConstraints = genPi.constraints();
            newConstraints = new Vector();
            for (Constraint origCon : propConstraints) {
                text = origCon.text();
                if (text == null || !text.contains("/*")) continue;
                textUpdate = text.substring(text.indexOf("/*"), text.indexOf("*/") + 2);
                genCon = new GenericTextConstraint(genPi, origCon);
                genCon.setText(textUpdate);
                newConstraints.add(genCon);
            }
            genPi.setConstraints(newConstraints);
        }
    }

    private void applyRuleClsFlattenRemoveConstraints(GenericModel genModel, TransformerConfiguration trfConfig) {
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            genCi.setDirectConstraints(null);
        }
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            genPi.setConstraints(null);
        }
    }

    private void applyRuleAllFlattenName(GenericModel genModel, TransformerConfiguration trfConfig) {
        boolean lowerCaseCodeForProperties = false;
        if (trfConfig.hasParameter(PARAM_LOWER_CASE_ALIAS_FOR_PROPERTIES) || trfConfig.hasParameter(PARAM_LOWER_CASE_CODE_FOR_PROPERTIES)) {
            String paramValue_alias = trfConfig.getParameterValue(PARAM_LOWER_CASE_ALIAS_FOR_PROPERTIES);
            String paramValue_code = trfConfig.getParameterValue(PARAM_LOWER_CASE_CODE_FOR_PROPERTIES);
            if (paramValue_alias != null) {
                lowerCaseCodeForProperties |= Boolean.parseBoolean(paramValue_alias);
            } else if (paramValue_code != null) {
                lowerCaseCodeForProperties |= Boolean.parseBoolean(paramValue_code);
            }
        }
        boolean codeForEnumerationValues = true;
        if (trfConfig.hasParameter(PARAM_ALIAS_FOR_ENUMERATION_VALUES) || trfConfig.hasParameter(PARAM_CODE_FOR_ENUMERATION_VALUES)) {
            String paramValue_alias = trfConfig.getParameterValue(PARAM_ALIAS_FOR_ENUMERATION_VALUES);
            String paramValue_code = trfConfig.getParameterValue(PARAM_CODE_FOR_ENUMERATION_VALUES);
            if (paramValue_alias != null) {
                codeForEnumerationValues &= Boolean.parseBoolean(paramValue_alias);
            } else if (paramValue_code != null) {
                codeForEnumerationValues &= Boolean.parseBoolean(paramValue_code);
            }
        }
        boolean keepOriginalNameAsCode = true;
        if (trfConfig.hasParameter(PARAM_KEEP_ORIGINAL_NAME_AS_ALIAS) || trfConfig.hasParameter(PARAM_KEEP_ORIGINAL_NAME_AS_CODE)) {
            String paramValue_alias = trfConfig.getParameterValue(PARAM_KEEP_ORIGINAL_NAME_AS_ALIAS);
            String paramValue_code = trfConfig.getParameterValue(PARAM_KEEP_ORIGINAL_NAME_AS_CODE);
            if (paramValue_alias != null) {
                keepOriginalNameAsCode &= Boolean.parseBoolean(paramValue_alias);
            }
            if (paramValue_code != null) {
                keepOriginalNameAsCode &= Boolean.parseBoolean(paramValue_code);
            }
        }
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            String string = this.getCode(genCi);
            if (string == null) continue;
            String oldName = genCi.name();
            if (keepOriginalNameAsCode) {
                this.setCode(genCi, oldName);
            }
            genModel.updateClassName(genCi, string);
        }
        HashSet<GenericPropertyInfo> genPis = new HashSet<GenericPropertyInfo>();
        for (PropertyInfo propertyInfo : genModel.selectedSchemaProperties()) {
            GenericPropertyInfo genPi = (GenericPropertyInfo)propertyInfo;
            genPis.add(genPi);
            if (genPi.reverseProperty() == null) continue;
            GenericPropertyInfo revGenPi = (GenericPropertyInfo)genPi.reverseProperty();
            genPis.add(revGenPi);
        }
        for (GenericPropertyInfo genericPropertyInfo : genPis) {
            String code = this.getCode(genericPropertyInfo);
            if (code == null || genericPropertyInfo.inClass().category() == 3 && !codeForEnumerationValues) continue;
            String name = genericPropertyInfo.name();
            if (lowerCaseCodeForProperties) {
                code = code.toLowerCase(Locale.ENGLISH);
            }
            genericPropertyInfo.setName(code);
            if (!keepOriginalNameAsCode) continue;
            this.setCode(genericPropertyInfo, name);
        }
    }

    private void setCode(GenericPropertyInfo genPi, String codeValue) {
        if (this.tvNameForCodeValue == null) {
            genPi.descriptors().put(Descriptor.ALIAS, codeValue);
        } else {
            genPi.setTaggedValue(this.tvNameForCodeValue, codeValue, false);
        }
    }

    private void setCode(GenericClassInfo genCi, String codeValue) {
        if (this.tvNameForCodeValue == null) {
            genCi.descriptors().put(Descriptor.ALIAS, codeValue);
        } else {
            genCi.setTaggedValue(this.tvNameForCodeValue, codeValue, false);
        }
    }

    private String getCode(Info info) {
        String code = null;
        code = this.tvNameForCodeValue != null ? info.taggedValue(this.tvNameForCodeValue) : info.aliasName();
        code = StringUtils.stripToNull((String)code);
        return code;
    }

    private void applyRuleUnionReplace(GenericModel genModel, TransformerConfiguration trfConfig) {
        String tmp;
        boolean includeUnionIdentifierTV = false;
        if (trfConfig.hasParameter(PARAM_INCLUDE_UNION_IDENTIFIER_TV) && (tmp = trfConfig.getParameterValue(PARAM_INCLUDE_UNION_IDENTIFIER_TV)).trim().equalsIgnoreCase("true")) {
            includeUnionIdentifierTV = true;
        }
        Pattern replaceUnionExcludePattern = null;
        if (trfConfig.hasParameter(PARAM_REPLACE_UNION_EXCLUDE_REGEX)) {
            String replaceUnionExcludeRegex = trfConfig.getParameterValue(PARAM_REPLACE_UNION_EXCLUDE_REGEX);
            replaceUnionExcludePattern = Pattern.compile(replaceUnionExcludeRegex);
        }
        TreeSet<GenericClassInfo> unionsToProcess = new TreeSet<GenericClassInfo>();
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            if (genCi.category() != 8) continue;
            if (replaceUnionExcludePattern != null) {
                Matcher m = replaceUnionExcludePattern.matcher(genCi.name());
                if (m.matches()) {
                    this.result.addDebug(this, 20344, genCi.name(), replaceUnionExcludePattern.pattern(), PARAM_REPLACE_UNION_EXCLUDE_REGEX);
                    continue;
                }
                this.result.addDebug(this, 20345, genCi.name(), replaceUnionExcludePattern.pattern(), PARAM_REPLACE_UNION_EXCLUDE_REGEX);
                unionsToProcess.add(genCi);
                continue;
            }
            unionsToProcess.add(genCi);
        }
        HashMap<String, GenericClassInfo> processedUnionsById = new HashMap<String, GenericClassInfo>();
        for (GenericClassInfo union : unionsToProcess) {
            ArrayList<GenericPropertyInfo> propsToAdd = new ArrayList<GenericPropertyInfo>();
            HashSet<GenericPropertyInfo> propsToRemove = new HashSet<GenericPropertyInfo>();
            for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
                if (genCi == union) continue;
                int countPropsWithUnionAsValueType = 0;
                GenericPropertyInfo relPi = null;
                for (PropertyInfo pi : genCi.properties().values()) {
                    if (!pi.isNavigable() || !pi.typeInfo().id.equals(union.id())) continue;
                    ++countPropsWithUnionAsValueType;
                    if (pi.cardinality().maxOccurs != 1) continue;
                    relPi = (GenericPropertyInfo)pi;
                }
                if (countPropsWithUnionAsValueType != true || relPi == null) continue;
                processedUnionsById.put(union.id(), union);
                int seqNumIndex = 1;
                for (PropertyInfo uPi : union.properties().values()) {
                    GenericPropertyInfo uGPi = (GenericPropertyInfo)uPi;
                    GenericPropertyInfo copy = uGPi.createCopy(relPi.id() + "_replacedByUnionProperty_" + uGPi.name());
                    copy.setInClass(genCi);
                    if (genCi.globalIdentifier() != null) {
                        if (uGPi.globalIdentifier() == null) {
                            genCi.descriptors().put(Descriptor.GLOBALIDENTIFIER, relPi.globalIdentifier());
                        } else {
                            genCi.descriptors().put(Descriptor.GLOBALIDENTIFIER, relPi.globalIdentifier() + "." + uGPi.globalIdentifier());
                        }
                    }
                    if (relPi.isDerived()) {
                        copy.setDerived(true);
                    }
                    copy.setAttribute(true);
                    copy.setAssociation(null);
                    if (includeUnionIdentifierTV && genCi.category() != 8) {
                        TaggedValues tvs = copy.taggedValuesAll();
                        tvs.put(UNION_SET_TAG_NAME, relPi.name());
                        copy.setTaggedValues(tvs, false);
                    }
                    copy.setSequenceNumber(relPi.sequenceNumber().createCopyWithSuffix(seqNumIndex), true);
                    ++seqNumIndex;
                    int minOccurs = relPi.cardinality().minOccurs * uGPi.cardinality().minOccurs;
                    int genPiMaxOccurs = relPi.cardinality().maxOccurs;
                    int typeGPiMaxOccurs = uGPi.cardinality().maxOccurs;
                    int maxOccurs = 0;
                    maxOccurs = genPiMaxOccurs == Integer.MAX_VALUE || typeGPiMaxOccurs == Integer.MAX_VALUE ? Integer.MAX_VALUE : genPiMaxOccurs * typeGPiMaxOccurs;
                    copy.setCardinality(new Multiplicity(minOccurs, maxOccurs));
                    propsToAdd.add(copy);
                }
                propsToRemove.add(relPi);
            }
            genModel.add(propsToAdd, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
            for (GenericPropertyInfo propToRemove : propsToRemove) {
                genModel.remove(propToRemove, false);
            }
        }
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if (!processedUnionsById.containsKey(genPi.typeInfo().id)) continue;
            processedUnionsById.remove(genPi.typeInfo().id);
        }
        for (GenericClassInfo unusedUnion : processedUnionsById.values()) {
            genModel.remove(unusedUnion);
        }
    }

    private void applyRuleFlattenTypes(GenericModel genModel, TransformerConfiguration trfConfig) {
        TreeMap<String, GenericClassInfo> typesToProcessById = this.computeTypesToProcessForFlattenTypes(genModel, trfConfig);
        ArrayList<String> idsOfTypesToProcess = new ArrayList<String>();
        for (String key : typesToProcessById.keySet()) {
            idsOfTypesToProcess.add(key);
        }
        HashSet<String> idsOfObjectTypesToProcess = new HashSet<String>();
        HashSet<String> idsOfDataTypesToProcess = new HashSet<String>();
        for (GenericClassInfo typeCi : typesToProcessById.values()) {
            if (typeCi.category() == 6) {
                idsOfObjectTypesToProcess.add(typeCi.id());
                continue;
            }
            if (this.excludeDataTypePattern == null || typeCi.category() != 5) continue;
            idsOfDataTypesToProcess.add(typeCi.id());
        }
        boolean includeUnionIdentifierTV = trfConfig.parameterAsBoolean(PARAM_INCLUDE_UNION_IDENTIFIER_TV, false);
        boolean setMinCardinalityToZeroWhenMergingUnion = trfConfig.parameterAsBoolean(PARAM_SET_MIN_CARDINALITY_TO_ZERO_WHEN_MERGING_UNION, true);
        String propertyCopyDuplicateBehavior_s = trfConfig.parameterAsString(PARAM_FLATTEN_TYPES_PROPERTY_COPY_DUPLICATE_BEHAVIOR, "IGNORE", false, true);
        GenericModel.PropertyCopyDuplicatBehaviorIndicator propertyCopyDuplicateBehavior = GenericModel.PropertyCopyDuplicatBehaviorIndicator.valueOf(propertyCopyDuplicateBehavior_s);
        EnumMap<Descriptor, String> nonUnionSeparatorByDescriptor = this.parseDescriptorModificationParameterUsingBasicPattern(PARAM_DESCRIPTOR_MOD_NON_UNION_SEPARATOR, trfConfig);
        EnumMap<Descriptor, String> unionSeparatorByDescriptor = this.parseDescriptorModificationParameterUsingBasicPattern(PARAM_DESCRIPTOR_MOD_UNION_SEPARATOR, trfConfig);
        boolean nonUnionSeparatorMapEmpty = nonUnionSeparatorByDescriptor.isEmpty();
        boolean unionSeparatorMapEmpty = unionSeparatorByDescriptor.isEmpty();
        if (!nonUnionSeparatorByDescriptor.containsKey((Object)Descriptor.GLOBALIDENTIFIER)) {
            nonUnionSeparatorByDescriptor.put(Descriptor.GLOBALIDENTIFIER, ".");
        }
        if (!unionSeparatorByDescriptor.containsKey((Object)Descriptor.GLOBALIDENTIFIER)) {
            unionSeparatorByDescriptor.put(Descriptor.GLOBALIDENTIFIER, ".");
        }
        boolean ignoreSelfReferenceByPropertyWithAssociationClassOrigin = trfConfig.hasRule(RULE_TRF_PROP_FLATTEN_TYPES_IGNORE_SELF_REF_BY_PROP_WITH_ASSO_CLASS_ORIGIN);
        for (String string : idsOfTypesToProcess) {
            GenericClassInfo typeToProcess = typesToProcessById.get(string);
            int omitWhenFlattened = 0;
            String tvOmitWhenFlattened = typeToProcess.taggedValue("omitWhenFlattened");
            if ("true".equalsIgnoreCase(StringUtils.strip((String)tvOmitWhenFlattened))) {
                omitWhenFlattened = 1;
            }
            String separator = this.separatorForPropertyFromNonUnion;
            EnumMap<Descriptor, String> separatorByDescriptor = nonUnionSeparatorByDescriptor;
            boolean separatorMapEmpty = nonUnionSeparatorMapEmpty;
            if (typeToProcess.category() == 8) {
                separator = this.separatorForPropertyFromUnion;
                separatorByDescriptor = unionSeparatorByDescriptor;
                separatorMapEmpty = unionSeparatorMapEmpty;
            }
            for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
                int categoryOfClass = genCi.category();
                if (categoryOfClass != 1 && categoryOfClass != 6 && categoryOfClass != 8 && categoryOfClass != 5 && categoryOfClass != 4) continue;
                ArrayList<GenericPropertyInfo> propsToAdd = new ArrayList<GenericPropertyInfo>();
                HashSet<GenericPropertyInfo> propsToRemove = new HashSet<GenericPropertyInfo>();
                for (PropertyInfo pi : genCi.properties().values()) {
                    if (!pi.isNavigable()) continue;
                    GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                    Type type = genPi.typeInfo();
                    if (!typeToProcess.name().equals(type.name)) continue;
                    if (this.ignoreReflexiveRelationshipInTypeFlattening && this.representsReflexiveRelationship(genPi, genModel)) {
                        propsToRemove.add(genPi);
                        this.result.addInfo(this, 20338, genPi.name(), genPi.inClass().name());
                        continue;
                    }
                    propsToRemove.add(genPi);
                    int seqNumIndex = 1;
                    for (PropertyInfo typePi : typeToProcess.properties().values()) {
                        GenericPropertyInfo typeGPi = (GenericPropertyInfo)typePi;
                        if (ignoreSelfReferenceByPropertyWithAssociationClassOrigin && StringUtils.isNotBlank((CharSequence)genPi.taggedValue("toAssociationClassFrom")) && StringUtils.isNotBlank((CharSequence)typeGPi.taggedValue("fromAssociationClassTo")) && genPi.taggedValue("toAssociationClassFrom").equals(typeGPi.taggedValue("fromAssociationClassTo"))) continue;
                        String id = genPi.id() + "_replacedBy_" + typeGPi.name();
                        GenericPropertyInfo copy = typeGPi.createCopy(id);
                        if (genPi.isDerived()) {
                            copy.setDerived(true);
                        }
                        copy.setAttribute(true);
                        copy.setAssociation(null);
                        if (separatorByDescriptor.containsKey((Object)Descriptor.GLOBALIDENTIFIER)) {
                            this.mergeDescriptorsAndAssignToCopy(Descriptor.GLOBALIDENTIFIER, genPi, copy, separatorByDescriptor, separator);
                        }
                        if (!separatorMapEmpty) {
                            if (omitWhenFlattened == 0) {
                                this.mergeDescriptorsAndAssignToCopy(Descriptor.DEFINITION, genPi, copy, separatorByDescriptor, separator);
                                this.mergeDescriptorsAndAssignToCopy(Descriptor.DESCRIPTION, genPi, copy, separatorByDescriptor, separator);
                                this.mergeDescriptorsAndAssignToCopy(Descriptor.PRIMARYCODE, genPi, copy, separatorByDescriptor, separator);
                                this.mergeDescriptorsAndAssignToCopy(Descriptor.LEGALBASIS, genPi, copy, separatorByDescriptor, separator);
                                this.mergeDescriptorsAndAssignToCopy(Descriptor.DATACAPTURESTATEMENT, genPi, copy, separatorByDescriptor, separator);
                                this.mergeDescriptorsAndAssignToCopy(Descriptor.EXAMPLE, genPi, copy, separatorByDescriptor, separator);
                            }
                        } else {
                            String s = copy.derivedDocumentation("[[definition]][[description]]", "");
                            if (s == null || s.length() == 0) {
                                Descriptor[] descriptorsToCopy = new Descriptor[]{Descriptor.DEFINITION, Descriptor.DESCRIPTION, Descriptor.PRIMARYCODE, Descriptor.LANGUAGE, Descriptor.LEGALBASIS, Descriptor.DATACAPTURESTATEMENT, Descriptor.EXAMPLE};
                                copy.descriptors().putCopy(descriptorsToCopy, genPi.descriptors());
                            }
                        }
                        String piName = pi.name();
                        String piCode = this.getCode(pi);
                        String typeGPiName = typeGPi.name();
                        String typeGPiCode = this.getCode(typeGPi);
                        Object newCode = null;
                        Object newName = omitWhenFlattened != 0 ? (piName.contains(this.separatorForPropertyFromNonUnion) ? piName.substring(0, piName.lastIndexOf(this.separatorForPropertyFromNonUnion)) + separator + typeGPiName : typeGPiName) : piName + separator + typeGPiName;
                        copy.setName((String)newName);
                        if (!separatorMapEmpty) {
                            if (separatorByDescriptor.containsKey((Object)Descriptor.ALIAS) && omitWhenFlattened == 0) {
                                this.mergeDescriptorsAndAssignToCopy(Descriptor.ALIAS, genPi, copy, separatorByDescriptor, separator);
                            }
                        } else {
                            newCode = this.hasCode(pi) ? (this.hasCode(typeGPi) ? (omitWhenFlattened != 0 ? (piCode.contains(this.separatorForPropertyFromNonUnion) ? piCode.substring(0, piCode.lastIndexOf(this.separatorForPropertyFromNonUnion)) + separator + typeGPiCode : typeGPiCode) : piCode + separator + typeGPiCode) : (omitWhenFlattened != 0 ? (piCode.contains(this.separatorForPropertyFromNonUnion) ? piCode.substring(0, piCode.lastIndexOf(this.separatorForPropertyFromNonUnion)) + separator + typeGPiName : typeGPiName) : piCode + separator + typeGPiName)) : (this.hasCode(typeGPi) ? (omitWhenFlattened != 0 ? (piName.contains(this.separatorForPropertyFromNonUnion) ? piName.substring(0, piName.lastIndexOf(this.separatorForPropertyFromNonUnion)) + separator + typeGPiCode : typeGPiCode) : piName + separator + typeGPiCode) : (omitWhenFlattened != 0 ? (piName.contains(this.separatorForPropertyFromNonUnion) ? piName.substring(0, piName.lastIndexOf(this.separatorForPropertyFromNonUnion)) + separator + typeGPiName : typeGPiName) : piName + separator + typeGPiName));
                            this.setCode(copy, (String)newCode);
                        }
                        String piNameTV = pi.taggedValue("name");
                        String typeGPiNameTV = typeGPi.taggedValue("name");
                        if (StringUtils.isNotBlank((CharSequence)piNameTV)) {
                            Object newNameTV = piNameTV;
                            if (StringUtils.isNotBlank((CharSequence)typeGPiNameTV)) {
                                newNameTV = piNameTV + " - " + typeGPiNameTV;
                            }
                            copy.setTaggedValue("name", (String)newNameTV, false);
                        }
                        copy.setInClass(genCi);
                        if (includeUnionIdentifierTV) {
                            TaggedValues tvs;
                            if (genPi.cardinality().maxOccurs > 1) {
                                tvs = copy.taggedValuesAll();
                                tvs.remove(UNION_SET_TAG_NAME);
                                copy.setTaggedValues(tvs, false);
                            } else if (typeToProcess.category() != 8 || genCi.category() != 8) {
                                if (genCi.category() == 8) {
                                    tvs = copy.taggedValuesAll();
                                    tvs.remove(UNION_SET_TAG_NAME);
                                    copy.setTaggedValues(tvs, false);
                                } else if (typeToProcess.category() == 8) {
                                    int lastIndexOfNonUnionSeparator;
                                    tvs = copy.taggedValuesAll();
                                    int lastIndexOfUnionSeparator = pi.name().lastIndexOf(this.separatorForPropertyFromUnion);
                                    String setName = lastIndexOfUnionSeparator > (lastIndexOfNonUnionSeparator = pi.name().lastIndexOf(this.separatorForPropertyFromNonUnion)) ? pi.name().substring(0, lastIndexOfUnionSeparator) : pi.name();
                                    tvs.put(UNION_SET_TAG_NAME, setName);
                                    copy.setTaggedValues(tvs, false);
                                } else if (StringUtils.isNotBlank((CharSequence)copy.taggedValue(UNION_SET_TAG_NAME))) {
                                    tvs = copy.taggedValuesAll();
                                    String tmp = tvs.getFirstValue(UNION_SET_TAG_NAME);
                                    tvs.put(UNION_SET_TAG_NAME, pi.name() + separator + tmp);
                                    copy.setTaggedValues(tvs, false);
                                }
                            }
                        }
                        copy.setSequenceNumber(pi.sequenceNumber().createCopyWithSuffix(seqNumIndex), true);
                        ++seqNumIndex;
                        int minOccurs = typeToProcess.category() == 8 && (setMinCardinalityToZeroWhenMergingUnion || pi.cardinality().maxOccurs > 1) ? 0 : pi.cardinality().minOccurs * typeGPi.cardinality().minOccurs;
                        int piMaxOccurs = pi.cardinality().maxOccurs;
                        int typeGPiMaxOccurs = typeGPi.cardinality().maxOccurs;
                        int maxOccurs = 0;
                        maxOccurs = piMaxOccurs == Integer.MAX_VALUE || typeGPiMaxOccurs == Integer.MAX_VALUE ? Integer.MAX_VALUE : piMaxOccurs * typeGPiMaxOccurs;
                        copy.setCardinality(new Multiplicity(minOccurs, maxOccurs));
                        propsToAdd.add(copy);
                    }
                    genCi.addConstraints(typeToProcess.constraints());
                }
                genModel.add(propsToAdd, propertyCopyDuplicateBehavior);
                for (GenericPropertyInfo propToRemove : propsToRemove) {
                    genModel.remove(propToRemove, false);
                }
            }
            genModel.remove(typeToProcess);
            typesToProcessById.remove(string);
        }
        if (this.excludeDataTypePattern != null) {
            for (String string : idsOfDataTypesToProcess) {
                genModel.removeByClassId(string);
            }
        } else {
            genModel.removeByClassCategory(5);
        }
        if (this.flattenObjectTypes) {
            genModel.removeByClassCategory(6);
        } else if (this.includeObjectTypeRegex != null) {
            for (String string : idsOfObjectTypesToProcess) {
                genModel.removeByClassId(string);
            }
        }
        boolean ignoreUnionsRepresentingFeatureTypeSets = trfConfig.hasRule(RULE_TRF_PROP_FLATTEN_TYPES_IGNORE_UNIONS_REPRESENTING_FEATURE_TYPE_SETS);
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses().toArray(new GenericClassInfo[genModel.selectedSchemaClasses().size()])) {
            if (genCi.category() != 8 || ignoreUnionsRepresentingFeatureTypeSets && Boolean.parseBoolean(genCi.taggedValue("representsFeatureTypeSet"))) continue;
            genModel.remove(genCi);
        }
        if (trfConfig.hasRule(RULE_TRF_PROP_FLATTEN_TYPES_REMOVE_MAPPED_TYPES)) {
            List<ProcessMapEntry> list = trfConfig.getMapEntries();
            for (ProcessMapEntry pme : list) {
                if (!pme.getRule().equalsIgnoreCase(RULE_TRF_PROP_FLATTEN_TYPES)) continue;
                String mappedTypeName = pme.getType();
                ClassInfo mappedType = genModel.classByName(mappedTypeName);
                genModel.remove((GenericClassInfo)mappedType);
            }
        }
    }

    private void mergeDescriptorsAndAssignToCopy(Descriptor descriptor, GenericPropertyInfo genPi, GenericPropertyInfo copy, EnumMap<Descriptor, String> separatorByDescriptor, String separator) {
        List<LangString> mergedDescriptorValues = Descriptors.merge(descriptor, genPi, copy, separatorByDescriptor, separator);
        copy.descriptors().put(descriptor, mergedDescriptorValues);
    }

    private boolean representsReflexiveRelationship(GenericPropertyInfo genPi, GenericModel genModel) {
        String typeId = genPi.typeInfo().id;
        ClassInfo typeCi = genModel.classById(typeId);
        if (typeCi == null) {
            return false;
        }
        return genModel.isKindOf(genPi.inClass(), typeCi);
    }

    private TreeMap<String, GenericClassInfo> computeTypesToProcessForFlattenTypes(GenericModel genModel, TransformerConfiguration trfConfig) {
        TreeMap<String, GenericClassInfo> typesToProcessById = new TreeMap<String, GenericClassInfo>();
        boolean ignoreUnionsRepresentingFeatureTypeSets = trfConfig.hasRule(RULE_TRF_PROP_FLATTEN_TYPES_IGNORE_UNIONS_REPRESENTING_FEATURE_TYPE_SETS);
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            Matcher m;
            int categoryOfInClass = genPi.inClass().category();
            if (categoryOfInClass != 1 && categoryOfInClass != 6 && categoryOfInClass != 8 && categoryOfInClass != 5) continue;
            Type type = genPi.typeInfo();
            if (trfConfig.hasMappingForType(RULE_TRF_PROP_FLATTEN_TYPES, type.name)) {
                ClassInfo targetCi = genModel.classByName(trfConfig.getMappingForType(RULE_TRF_PROP_FLATTEN_TYPES, type.name).getTargetType());
                if (targetCi == null) {
                    String targetTypeName = trfConfig.getMappingForType(RULE_TRF_PROP_FLATTEN_TYPES, type.name).getTargetType();
                    this.result.addDebug(this, 20318, targetTypeName, genPi.name(), genPi.inClass().name());
                    type.id = UNKNOWN;
                    type.name = targetTypeName;
                    continue;
                }
                type.id = targetCi.id();
                type.name = targetCi.name();
                continue;
            }
            if (type.id.equals(UNKNOWN)) continue;
            ClassInfo typeCi = genModel.classById(type.id);
            if (typeCi == null) {
                ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 20301, genPi.inClass().name() + "." + genPi.name(), type.name);
                if (mc != null) {
                    mc.addDetail(this, 20308, "Property", genPi.fullName());
                }
                type.id = UNKNOWN;
                continue;
            }
            boolean processType = false;
            if (!(typeCi.category() != 8 || ignoreUnionsRepresentingFeatureTypeSets && Boolean.parseBoolean(typeCi.taggedValue("representsFeatureTypeSet")))) {
                processType = true;
            } else if (typeCi.category() == 5) {
                if (this.excludeDataTypeRegex != null) {
                    m = this.excludeDataTypePattern.matcher(typeCi.name());
                    if (m.matches()) {
                        processType = false;
                        this.result.addDebug(this, 20344, typeCi.name(), this.excludeDataTypeRegex, PARAM_FLATTEN_DATATYPES_EXCLUDE_REGEX);
                    } else {
                        processType = true;
                        this.result.addDebug(this, 20345, typeCi.name(), this.excludeDataTypeRegex, PARAM_FLATTEN_DATATYPES_EXCLUDE_REGEX);
                    }
                } else {
                    processType = true;
                }
            } else if (typeCi.category() == 6) {
                if (this.flattenObjectTypes) {
                    processType = true;
                } else if (this.includeObjectTypeRegex != null) {
                    m = this.includeObjectTypePattern.matcher(typeCi.name());
                    if (m.matches()) {
                        processType = true;
                        this.result.addDebug(this, 20344, typeCi.name(), this.includeObjectTypeRegex, PARAM_FLATTEN_OBJECT_TYPES_INCLUDE_REGEX);
                    } else {
                        processType = false;
                        this.result.addDebug(this, 20345, typeCi.name(), this.includeObjectTypeRegex, PARAM_FLATTEN_OBJECT_TYPES_INCLUDE_REGEX);
                    }
                } else {
                    processType = false;
                }
            }
            if (!processType || !genModel.isInAppSchema(typeCi)) continue;
            typesToProcessById.put(typeCi.id(), (GenericClassInfo)typeCi);
        }
        return typesToProcessById;
    }

    private String identifySimpleBaseType(ClassInfo ci, SortedSet<String> simpleBaseTypes) {
        if (simpleBaseTypes.contains(ci.name())) {
            return ci.name();
        }
        for (String supertypeId : ci.supertypes()) {
            String res;
            ClassInfo supertype = ci.model().classById(supertypeId);
            if (supertype == null || (res = this.identifySimpleBaseType(supertype, simpleBaseTypes)) == null) continue;
            return res;
        }
        return null;
    }

    private void identifyCircularDependencies(Map<String, GenericClassInfo> typesToProcessById) {
        this.result.addInfo(this, 20329);
        DirectedMultigraph graph = new DirectedMultigraph(PropertySetEdge.class);
        for (GenericClassInfo genericClassInfo : typesToProcessById.values()) {
            graph.addVertex((Object)(genericClassInfo.pkg().name() + "::" + genericClassInfo.name()));
        }
        TreeMap<CallSite, Set> refTypeInfo = new TreeMap<CallSite, Set>();
        for (GenericClassInfo typeToProcess : typesToProcessById.values()) {
            String typeToProcessKey = typeToProcess.pkg().name() + "::" + typeToProcess.name();
            HashMap propertiesByValueTypeName = new HashMap();
            for (PropertyInfo pi : typeToProcess.properties().values()) {
                Set<String> props;
                if (!pi.isNavigable() || !typesToProcessById.containsKey(pi.typeInfo().id)) continue;
                GenericClassInfo targetType = typesToProcessById.get(pi.typeInfo().id);
                String key = targetType.pkg().name() + "::" + targetType.name();
                if (propertiesByValueTypeName.containsKey(key)) {
                    props = (Set)propertiesByValueTypeName.get(key);
                } else {
                    props = new TreeSet();
                    propertiesByValueTypeName.put((CallSite)((Object)key), props);
                }
                props.add(pi.name());
            }
            for (String targetKey : propertiesByValueTypeName.keySet()) {
                Set props = (Set)propertiesByValueTypeName.get(targetKey);
                if (typeToProcessKey.equals(targetKey)) {
                    refTypeInfo.put((CallSite)((Object)typeToProcessKey), props);
                    continue;
                }
                graph.addEdge((Object)typeToProcessKey, (Object)targetKey, (Object)new PropertySetEdge(typeToProcessKey, targetKey, props));
            }
        }
        if (refTypeInfo.isEmpty()) {
            this.result.addInfo(this, 20331);
        } else {
            for (String key : refTypeInfo.keySet()) {
                this.result.addInfo(this, 20330, key, this.join((Set)refTypeInfo.get(key), ","));
            }
        }
        TiernanSimpleCycles tiernanSimpleCycles = new TiernanSimpleCycles((Graph)graph);
        List cycles = tiernanSimpleCycles.findSimpleCycles();
        if (cycles != null && cycles.size() > 0) {
            for (List cycle : cycles) {
                this.result.addInfo(this, 20326);
                for (int i = 0; i < cycle.size(); ++i) {
                    String target;
                    String source;
                    if (tiernanSimpleCycles instanceof JohnsonSimpleCycles) {
                        source = (String)cycle.get(i);
                        target = i == 0 ? (String)cycle.get(cycle.size() - 1) : (String)cycle.get(i - 1);
                    } else if (tiernanSimpleCycles instanceof SzwarcfiterLauerSimpleCycles) {
                        source = (String)cycle.get(i);
                        target = i == cycle.size() - 1 ? (String)cycle.get(0) : (String)cycle.get(i + 1);
                    } else if (tiernanSimpleCycles instanceof TarjanSimpleCycles) {
                        source = (String)cycle.get(i);
                        target = i == cycle.size() - 1 ? (String)cycle.get(0) : (String)cycle.get(i + 1);
                    } else {
                        source = (String)cycle.get(i);
                        target = i == cycle.size() - 1 ? (String)cycle.get(0) : (String)cycle.get(i + 1);
                    }
                    PropertySetEdge edge = (PropertySetEdge)((Object)graph.getEdge((Object)source, (Object)target));
                    this.result.addInfo(this, 20327, source, target, edge.toString());
                }
            }
        } else {
            this.result.addInfo(this, 20328);
        }
        Object var4_9 = null;
        graph = null;
    }

    private void applyRuleMultiplicity(GenericModel genModel, TransformerConfiguration trfConfig) {
        String b;
        String b2;
        String separatorForPropertyIndexNumberParam;
        boolean applyMaxMultThreshold = false;
        int maxMultiplicityThreshold = -1;
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_MULTIPLICITY_WITHMAXMULTTHRESHOLD)) {
            boolean isInvalidThresholdValue;
            block38: {
                String thresholdValue = trfConfig.getParameterValue(PARAM_MAX_MULTIPLICITY_THRESHOLD);
                isInvalidThresholdValue = false;
                if (thresholdValue != null && thresholdValue.trim().length() > 0) {
                    try {
                        int mmt = Integer.parseInt(thresholdValue);
                        if (mmt <= 1) {
                            isInvalidThresholdValue = true;
                            break block38;
                        }
                        applyMaxMultThreshold = true;
                        maxMultiplicityThreshold = mmt;
                    }
                    catch (NumberFormatException e) {
                        isInvalidThresholdValue = true;
                    }
                } else {
                    isInvalidThresholdValue = true;
                }
            }
            if (isInvalidThresholdValue) {
                this.result.addError(this, 20341, RULE_TRF_PROP_FLATTEN_MULTIPLICITY_WITHMAXMULTTHRESHOLD, PARAM_MAX_MULTIPLICITY_THRESHOLD);
            }
        }
        boolean keepBiDirectionalAssociations = false;
        if (this.rules.contains(RULE_TRF_PROP_FLATTEN_MULTIPLICITY_KEEPBIDIRECTIONALASSOCIATIONS)) {
            keepBiDirectionalAssociations = true;
        }
        ShapeChangeResult result = genModel.result();
        int maxOccursGlobal = 3;
        String maxOccParam = trfConfig.getParameterValue(PARAM_MAXOCCURS);
        if (maxOccParam != null && maxOccParam.trim().length() > 0 && (maxOccursGlobal = Integer.parseInt(maxOccParam)) < 1) {
            result.addWarning(this, 20304, "" + maxOccursGlobal);
            maxOccursGlobal = 3;
        }
        HashMap<CallSite, Integer> specificMaxOccursByIdPattern = new HashMap<CallSite, Integer>();
        String[] specificMaxOccurs = trfConfig.getListParameterValue(PARAM_MAXOCCURS_FOR_SPECIFIC_PROPERTIES);
        if (specificMaxOccurs != null && specificMaxOccurs.length > 0) {
            for (String smo : specificMaxOccurs) {
                String[] smoParts = smo.split("::");
                if (smoParts.length != 3 || smoParts[0].length() == 0 || smoParts[1].length() == 0) {
                    result.addError(this, 20310, PARAM_MAXOCCURS_FOR_SPECIFIC_PROPERTIES, smo);
                    continue;
                }
                try {
                    Integer i = Integer.valueOf(smoParts[2]);
                    specificMaxOccursByIdPattern.put((CallSite)((Object)(smoParts[0] + "::" + smoParts[1])), i);
                }
                catch (NumberFormatException e) {
                    result.addError(this, 20310, PARAM_MAXOCCURS_FOR_SPECIFIC_PROPERTIES, smo);
                }
            }
        }
        if ((separatorForPropertyIndexNumberParam = trfConfig.getParameterValue(PARAM_SEPARATOR_FOR_PROPERTY_INDEX_NUMBER)) != null) {
            this.separatorForPropertyIndexNumber = separatorForPropertyIndexNumberParam;
        }
        EnumMap<Descriptor, String> separatorByDescriptor = this.parseDescriptorModificationParameterUsingBasicPattern(PARAM_DESCRIPTOR_MOD_PROPERTY_INDEX_NUMBER, trfConfig);
        boolean ignoreFeatureOrObjectTypedProperties = false;
        if (trfConfig.hasParameter(PARAM_IGNORE_FEATURE_OR_OBJECT_TYPED_PROPERTIES) && (b2 = trfConfig.getParameterValue(PARAM_IGNORE_FEATURE_OR_OBJECT_TYPED_PROPERTIES)).trim().equalsIgnoreCase("true")) {
            ignoreFeatureOrObjectTypedProperties = true;
        }
        boolean ignoreFeatureTypedProperties = false;
        if (trfConfig.hasParameter(PARAM_IGNORE_FEATURE_TYPED_PROPERTIES) && (b = trfConfig.getParameterValue(PARAM_IGNORE_FEATURE_TYPED_PROPERTIES)).trim().equalsIgnoreCase("true")) {
            ignoreFeatureTypedProperties = true;
        }
        ArrayList<GenericAssociationInfo> associationsToDissolve = new ArrayList<GenericAssociationInfo>();
        for (GenericAssociationInfo genAI : genModel.selectedSchemaAssociations()) {
            PropertyInfo end1 = genAI.end1();
            PropertyInfo end2 = genAI.end2();
            if (end1.inClass() != null && genModel.isInAppSchema(end1.inClass()) && end2.inClass() != null && genModel.isInAppSchema(end2.inClass()) && (ignoreFeatureTypedProperties && end1.categoryOfValue() == 1 && end2.categoryOfValue() == 1 || ignoreFeatureOrObjectTypedProperties && (end1.categoryOfValue() == 1 || end1.categoryOfValue() == 6 || end1.categoryOfValue() == 6 || end1.categoryOfValue() == 4) && (end2.categoryOfValue() == 1 || end2.categoryOfValue() == 6 || end2.categoryOfValue() == 6 || end2.categoryOfValue() == 4))) continue;
            boolean end1ShallBeFlattened = false;
            boolean end2ShallBeFlattened = false;
            if (end1 != null && end1.isNavigable() && end1.cardinality().maxOccurs > 1 && (!applyMaxMultThreshold || end1.cardinality().maxOccurs <= maxMultiplicityThreshold)) {
                end1ShallBeFlattened = true;
            }
            if (end2 != null && end2.isNavigable() && end2.cardinality().maxOccurs > 1 && (!applyMaxMultThreshold || end2.cardinality().maxOccurs <= maxMultiplicityThreshold)) {
                end2ShallBeFlattened = true;
            }
            if (!end1ShallBeFlattened && !end2ShallBeFlattened) continue;
            if (keepBiDirectionalAssociations && end1.isNavigable() && end2.isNavigable()) {
                result.addWarning(this, 20342, end1.inClass().name(), end1.name(), end2.inClass().name(), end2.name());
                continue;
            }
            associationsToDissolve.add(genAI);
        }
        for (GenericAssociationInfo genAI : associationsToDissolve) {
            genModel.dissolveAssociation(genAI);
        }
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            SortedMap<StructuredNumber, PropertyInfo> properties = genCi.properties();
            if (properties == null || properties.isEmpty()) continue;
            ArrayList<GenericPropertyInfo> propsToAdd = new ArrayList<GenericPropertyInfo>();
            ArrayList<GenericPropertyInfo> propsToRemove = new ArrayList<GenericPropertyInfo>();
            for (PropertyInfo pi : properties.values()) {
                String specMaxOccursId;
                Type piType = pi.typeInfo();
                ClassInfo typeCi = genModel.classById(piType.id);
                if ((ignoreFeatureTypedProperties && pi.categoryOfValue() == 1 || ignoreFeatureOrObjectTypedProperties && (pi.categoryOfValue() == 1 || pi.categoryOfValue() == 6 || pi.categoryOfValue() == 6 || pi.categoryOfValue() == 4)) && typeCi != null && genModel.isInAppSchema(typeCi)) continue;
                GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                if (genPi.cardinality().maxOccurs <= 1 || applyMaxMultThreshold && genPi.cardinality().maxOccurs > maxMultiplicityThreshold || !genPi.isAttribute() && keepBiDirectionalAssociations && genPi.reverseProperty() != null && genPi.reverseProperty().isNavigable()) continue;
                int maxOccurs = maxOccursGlobal;
                String piMaxOccTaggedValue = genPi.taggedValue(PARAM_MAXOCCURS);
                if (StringUtils.isNotBlank((CharSequence)piMaxOccTaggedValue)) {
                    int piMaxOcc = Integer.parseInt(piMaxOccTaggedValue);
                    if (piMaxOcc < 1) {
                        result.addWarning(this, 20305, pi.name(), genCi.name(), "" + piMaxOcc, "" + maxOccursGlobal);
                    } else {
                        maxOccurs = piMaxOcc;
                    }
                }
                if (specificMaxOccursByIdPattern.containsKey(specMaxOccursId = pi.inClass().name() + "::" + pi.name())) {
                    maxOccurs = (Integer)specificMaxOccursByIdPattern.get(specMaxOccursId);
                }
                if (maxOccurs > genPi.cardinality().maxOccurs) {
                    maxOccurs = genPi.cardinality().maxOccurs;
                }
                if (maxOccurs == 1) {
                    genPi.cardinality().maxOccurs = 1;
                    continue;
                }
                for (int i = 1; i <= maxOccurs; ++i) {
                    String newId = genPi.id() + i;
                    String newName = genPi.name() + this.separatorForPropertyIndexNumber + i;
                    GenericPropertyInfo copy = genPi.createCopy(newId);
                    copy.setName(newName);
                    if (!separatorByDescriptor.isEmpty()) {
                        EnumMap<Descriptor, Pair<String, String>> separatorAndSuffixByDescriptor = new EnumMap<Descriptor, Pair<String, String>>(Descriptor.class);
                        for (Map.Entry<Descriptor, String> entry : separatorByDescriptor.entrySet()) {
                            separatorAndSuffixByDescriptor.put(entry.getKey(), (Pair<String, String>)new ImmutablePair((Object)entry.getValue(), (Object)("" + i)));
                        }
                        copy.descriptors().appendSuffix(separatorAndSuffixByDescriptor, true);
                    } else if (this.hasCode(genPi)) {
                        this.setCode(copy, this.getCode(genPi) + this.separatorForPropertyIndexNumber + i);
                    }
                    Multiplicity card = new Multiplicity();
                    card.minOccurs = genPi.cardinality().minOccurs != 0 ? (i <= genPi.cardinality().minOccurs ? 1 : 0) : 0;
                    card.maxOccurs = 1;
                    copy.setCardinality(card);
                    copy.setSequenceNumber(genPi.sequenceNumber().createCopyWithSuffix(i), true);
                    if (genPi.globalIdentifier() != null) {
                        String newGlobalId = genPi.globalIdentifier().concat("[" + i + "]");
                        copy.descriptors().put(Descriptor.GLOBALIDENTIFIER, newGlobalId);
                    }
                    propsToAdd.add(copy);
                    propsToRemove.add(genPi);
                }
            }
            for (GenericPropertyInfo piToAdd : propsToAdd) {
                genModel.add(piToAdd, genCi);
            }
            for (GenericPropertyInfo piToRemove : propsToRemove) {
                genModel.remove(piToRemove, false);
            }
        }
    }

    private EnumMap<Descriptor, String> parseDescriptorModificationParameterUsingBasicPattern(String parameter, TransformerConfiguration trfConfig) {
        EnumMap<Descriptor, String> res = new EnumMap<Descriptor, String>(Descriptor.class);
        String paramValue = trfConfig.parameterAsString(parameter, null, false, true);
        if (paramValue != null) {
            Matcher matcher = descriptorModBasicPattern.matcher(paramValue);
            while (matcher.find()) {
                String descriptorAsString = matcher.group(1);
                try {
                    Descriptor descriptor = Descriptor.valueOf(descriptorAsString.toUpperCase(Locale.ENGLISH));
                    res.put(descriptor, matcher.group(2));
                }
                catch (IllegalArgumentException e) {
                    this.result.addError(this, 20348, parameter, descriptorAsString);
                }
            }
        }
        return res;
    }

    private void applyRule_cls_flatten_reverseInheritance(GenericModel genModel, TransformerConfiguration trfConfig) {
        ClassInfo rootClass;
        String piKey;
        TreeSet<String> basicTypeSupertypeNames = new TreeSet<String>(trfConfig.parameterAsStringList(PARAM_BASIC_TYPE_SUPERTYPE_NAMES, DEFAULT_BASIC_TYPE_SUPERTYPE_NAMES, true, true));
        String typeSuffixSeparator = trfConfig.parameterAsString(PARAM_TYPE_SUFFIX_SEPARATOR, "_", true, true);
        String typeEnumerationPropertyName = trfConfig.parameterAsString(PARAM_TYPE_ENUMERATION_PROPERTY_NAME, "_type", false, true);
        HashMap<String, GenericClassInfo> genSuperclassesById = new HashMap<String, GenericClassInfo>();
        HashMap<String, GenericClassInfo> genRootclassesById = new HashMap<String, GenericClassInfo>();
        for (ClassInfo cls : genModel.classes()) {
            if (cls.subtypes().isEmpty()) continue;
            boolean hasSupertypeInSelectedSchemas = false;
            boolean isBasicType = false;
            boolean isInSelectedSchemas = genModel.isInSelectedSchemas(cls);
            for (ClassInfo classInfo : cls.supertypesInCompleteHierarchy()) {
                if (genModel.isInSelectedSchemas(classInfo)) {
                    hasSupertypeInSelectedSchemas = true;
                }
                if (!basicTypeSupertypeNames.contains(classInfo.name())) continue;
                isBasicType = true;
            }
            if (basicTypeSupertypeNames.contains(cls.name())) {
                isBasicType = true;
            }
            if (isBasicType) continue;
            if (isInSelectedSchemas || hasSupertypeInSelectedSchemas) {
                genSuperclassesById.put(cls.id(), (GenericClassInfo)cls);
            }
            if (!isInSelectedSchemas || hasSupertypeInSelectedSchemas) continue;
            genRootclassesById.put(cls.id(), (GenericClassInfo)cls);
        }
        for (Object genRootclass : genRootclassesById.values()) {
            GenericClassInfo genEnumeration = new GenericClassInfo(genModel, ((GenericClassInfo)genRootclass).id() + "_typeEnumeration", ((GenericClassInfo)genRootclass).name() + "Type", 3);
            if (this.hasCode((Info)genRootclass)) {
                this.setCode(genEnumeration, this.getCode((Info)genRootclass) + "_TE");
            } else {
                this.setCode(genEnumeration, ((GenericClassInfo)genRootclass).name() + "TypeEnumeration");
            }
            genEnumeration.setStereotype("enumeration");
            genEnumeration.setPkg(((GenericClassInfo)genRootclass).pkg());
            ((GenericPackageInfo)((GenericClassInfo)genRootclass).pkg()).addClass(genEnumeration);
            TreeMap<String, Object> nonAbstractTypesByName = new TreeMap<String, Object>();
            if (!((GenericClassInfo)genRootclass).isAbstract()) {
                nonAbstractTypesByName.put(((GenericClassInfo)genRootclass).name(), genRootclass);
            }
            for (ClassInfo subtype : ((ClassInfoImpl)genRootclass).subtypesInCompleteHierarchy()) {
                if (subtype.isAbstract()) continue;
                nonAbstractTypesByName.put(subtype.name(), subtype);
            }
            int seqNumIndex = 1;
            ArrayList<GenericPropertyInfo> enums = new ArrayList<GenericPropertyInfo>();
            for (ClassInfo nonAbstractType : nonAbstractTypesByName.values()) {
                GenericPropertyInfo enumProp = this.createEnumerationProperty(genModel, nonAbstractType.name(), nonAbstractType.aliasName(), genEnumeration, new StructuredNumber(seqNumIndex));
                if (this.hasCode(nonAbstractType)) {
                    this.setCode(enumProp, this.getCode(nonAbstractType));
                }
                enumProp.setStereotype("enum");
                enumProp.typeInfo().name = "";
                enumProp.typeInfo().id = "none";
                enums.add(enumProp);
                ++seqNumIndex;
            }
            genEnumeration.addPropertiesInSequence(enums, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
            genModel.register(genEnumeration);
            GenericPropertyInfo genericPropertyInfo = new GenericPropertyInfo(genModel, ((GenericClassInfo)genRootclass).id() + typeEnumerationPropertyName, typeEnumerationPropertyName);
            genericPropertyInfo.setStereotype("property");
            Type propType = new Type();
            propType.id = genEnumeration.id();
            propType.name = genEnumeration.name();
            genericPropertyInfo.setTypeInfo(propType);
            TaggedValues taggedValues = this.options.taggedValueFactory();
            taggedValues.add("inlineOrByReference", "inlineOrByReference");
            taggedValues.add("isMetadata", "false");
            genericPropertyInfo.setTaggedValues(taggedValues, false);
            genericPropertyInfo.setInClass((ClassInfo)genRootclass);
            genericPropertyInfo.setSequenceNumber(new StructuredNumber(0), false);
            ((GenericClassInfo)genRootclass).addPropertiesAtTop(List.of(genericPropertyInfo), GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
            this.setCode(genericPropertyInfo, typeEnumerationPropertyName);
        }
        for (Object genRootclass : genRootclassesById.values()) {
            if (!((GenericClassInfo)genRootclass).isAbstract()) continue;
            ((GenericClassInfo)genRootclass).setIsAbstract(false);
        }
        HashMap<ClassInfo, GenericClassInfo> rootClassBySubtype = new HashMap<ClassInfo, GenericClassInfo>();
        for (GenericClassInfo genRootclass : genRootclassesById.values()) {
            for (ClassInfo subtype : genRootclass.subtypesInCompleteHierarchy()) {
                if (rootClassBySubtype.containsKey(subtype)) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 20500, subtype.name(), genRootclass.name(), ((GenericClassInfo)rootClassBySubtype.get(subtype)).name());
                    if (mc == null) continue;
                    mc.addDetail(this, 2, subtype.fullName());
                    continue;
                }
                rootClassBySubtype.put(subtype, genRootclass);
            }
        }
        HashSet<String> idsOfUnprocessedSupertypes = new HashSet<String>();
        for (String superclassId : genSuperclassesById.keySet()) {
            idsOfUnprocessedSupertypes.add(superclassId);
        }
        HashMap<PropertyInfo, CallSite> propKeyByProp = new HashMap<PropertyInfo, CallSite>();
        for (GenericClassInfo genRootclass : genRootclassesById.values()) {
            for (PropertyInfo propertyInfo : genRootclass.properties().values()) {
                piKey = propertyInfo.name() + "#" + propertyInfo.typeInfo().name + "#" + propertyInfo.cardinality().toString();
                propKeyByProp.put(propertyInfo, (CallSite)((Object)piKey));
            }
        }
        for (ClassInfo subClass : rootClassBySubtype.keySet()) {
            for (PropertyInfo propertyInfo : subClass.properties().values()) {
                piKey = propertyInfo.name() + "#" + propertyInfo.typeInfo().name + "#" + propertyInfo.cardinality().toString();
                propKeyByProp.put(propertyInfo, (CallSite)((Object)piKey));
            }
        }
        HashSet<GenericClassInfo> subtypesToRemove = new HashSet<GenericClassInfo>();
        while (!idsOfUnprocessedSupertypes.isEmpty()) {
            for (String idOfgenSuperclass : genSuperclassesById.keySet()) {
                GenericClassInfo genericClassInfo;
                if (!idsOfUnprocessedSupertypes.contains(idOfgenSuperclass) || ((TreeSet)(genericClassInfo = (GenericClassInfo)genSuperclassesById.get(idOfgenSuperclass)).subtypes()).size() != genericClassInfo.subtypesInCompleteHierarchy().size()) continue;
                idsOfUnprocessedSupertypes.remove(idOfgenSuperclass);
                SortedSet<ClassInfo> subtypes = genericClassInfo.subtypeClasses();
                ArrayList<GenericPropertyInfo> newPropsFromSubtypesToBeUsedAsIs = new ArrayList<GenericPropertyInfo>();
                ArrayList<GenericPropertyInfo> newPropsFromSubtypesToTypeSuffix = new ArrayList<GenericPropertyInfo>();
                HashMap<String, GenericPropertyInfo> newPropsFromSubtypesWithSameNameTypeAndMultiplicity = new HashMap<String, GenericPropertyInfo>();
                for (ClassInfo classInfo : subtypes) {
                    GenericClassInfo genSubtype = (GenericClassInfo)classInfo;
                    for (PropertyInfo subPi : genSubtype.properties().values()) {
                        if (genericClassInfo.property(subPi.name()) != null) continue;
                        String subPiKey = (String)propKeyByProp.get(subPi);
                        boolean otherSubtypeWithSameName = false;
                        boolean onlySubtypePropsWithSameKey = true;
                        for (ClassInfo subtypeB : subtypes) {
                            if (subtypeB == classInfo || subtypeB.property(subPi.name()) == null) continue;
                            otherSubtypeWithSameName = true;
                            PropertyInfo otherSubPi = subtypeB.property(subPi.name());
                            String otherSubPiKey = (String)propKeyByProp.get(otherSubPi);
                            if (otherSubPiKey.equals(subPiKey)) continue;
                            onlySubtypePropsWithSameKey = false;
                            break;
                        }
                        GenericPropertyInfo genSubPi = (GenericPropertyInfo)subPi;
                        if (otherSubtypeWithSameName) {
                            if (onlySubtypePropsWithSameKey) {
                                if (newPropsFromSubtypesWithSameNameTypeAndMultiplicity.containsKey(subPiKey)) continue;
                                newPropsFromSubtypesWithSameNameTypeAndMultiplicity.put(subPiKey, (GenericPropertyInfo)subPi);
                                continue;
                            }
                            newPropsFromSubtypesToTypeSuffix.add(genSubPi);
                            continue;
                        }
                        newPropsFromSubtypesToBeUsedAsIs.add(genSubPi);
                    }
                }
                TreeMap<String, GenericPropertyInfo> newPropsFromSubtypesByName = new TreeMap<String, GenericPropertyInfo>();
                for (GenericPropertyInfo genPi : newPropsFromSubtypesWithSameNameTypeAndMultiplicity.values()) {
                    newPropsFromSubtypesByName.put(genPi.name(), genPi);
                    this.result.addInfo(this, 20501, genPi.name(), genericClassInfo.name());
                }
                for (GenericPropertyInfo genPi : newPropsFromSubtypesToBeUsedAsIs) {
                    newPropsFromSubtypesByName.put(genPi.name(), genPi);
                }
                for (GenericPropertyInfo genPi : newPropsFromSubtypesToTypeSuffix) {
                    ClassInfo subtype3 = genPi.inClass();
                    genPi.setName(genPi.name() + typeSuffixSeparator + subtype3.name());
                    if (this.hasCode(genPi) && this.hasCode(subtype3)) {
                        this.setCode(genPi, this.getCode(genPi) + typeSuffixSeparator + this.getCode(subtype3));
                    }
                    newPropsFromSubtypesByName.put(genPi.name(), genPi);
                }
                for (PropertyInfo pi : newPropsFromSubtypesByName.values()) {
                    GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                    genPi.setInClass(genericClassInfo);
                    genPi.cardinality().minOccurs = 0;
                }
                int n = genericClassInfo.properties().isEmpty() ? 0 : genericClassInfo.properties().lastKey().components[0];
                int counter = 1;
                for (GenericPropertyInfo newProp : newPropsFromSubtypesByName.values()) {
                    StructuredNumber newSn = new StructuredNumber(n + counter);
                    ++counter;
                    newProp.setSequenceNumber(newSn, true);
                }
                genericClassInfo.addPropertiesAtBottom(new ArrayList<GenericPropertyInfo>(newPropsFromSubtypesByName.values()), GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
                for (ClassInfo subtype4 : subtypes) {
                    genericClassInfo.removeSubtype(subtype4.id());
                    GenericClassInfo genSubtype = (GenericClassInfo)subtype4;
                    genSubtype.removeSupertype(genericClassInfo.id());
                    subtypesToRemove.add((GenericClassInfo)subtype4);
                }
            }
        }
        for (PropertyInfo pi : genModel.properties()) {
            GenericPropertyInfo genericPropertyInfo = (GenericPropertyInfo)pi;
            Type type = genericPropertyInfo.typeInfo();
            ClassInfo typeCi = genModel.classByIdOrName(type);
            if (!rootClassBySubtype.containsKey(typeCi)) continue;
            rootClass = (ClassInfo)rootClassBySubtype.get(typeCi);
            genericPropertyInfo.setTypeInfo(Type.from(rootClass));
        }
        for (GenericClassInfo genCi : subtypesToRemove) {
            for (PropertyInfo pi : genCi.properties().values()) {
                GenericPropertyInfo revPi;
                if (pi.isAttribute() || !genRootclassesById.containsKey(pi.inClass().id()) || (revPi = (GenericPropertyInfo)pi.reverseProperty()).isNavigable()) continue;
                revPi.setTypeInfo(Type.from(pi.inClass()));
                if (!subtypesToRemove.contains(revPi.inClass())) continue;
                rootClass = (GenericClassInfo)rootClassBySubtype.get(revPi.inClass());
                revPi.setInClass(rootClass);
            }
        }
        for (GenericClassInfo genCi : subtypesToRemove) {
            ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
            for (PropertyInfo pi : genCi.properties().values()) {
                if (pi.inClass() == genCi) continue;
                arrayList.add(pi);
            }
            for (PropertyInfo pi : arrayList) {
                genCi.removePropertyById(pi.id());
            }
            genModel.remove(genCi);
        }
    }

    private void applyRuleInheritance(GenericModel genModel, TransformerConfiguration trfConfig) {
        HashMap<String, GenericClassInfo> genSuperclassesById = new HashMap<String, GenericClassInfo>();
        HashMap<String, GenericClassInfo> genLeafclassesById = new HashMap<String, GenericClassInfo>();
        TreeMap<String, GenericClassInfo> genSuperclassUnionsBySuperclassName = new TreeMap<String, GenericClassInfo>();
        Pattern inclusionPattern = null;
        if (trfConfig.hasParameter(PARAM_INHERITANCE_INCLUDE_REGEX)) {
            String inclusionRegex = trfConfig.getParameterValue(PARAM_INHERITANCE_INCLUDE_REGEX);
            inclusionPattern = Pattern.compile(inclusionRegex);
        }
        boolean addAttributesAtBottom = trfConfig.hasRule(RULE_TRF_CLS_FLATTEN_INHERITANCE_ADD_ATTRIBUTES_AT_BOTTOM);
        for (GenericClassInfo genericClassInfo : genModel.selectedSchemaClasses()) {
            if (trfConfig.hasRule(RULE_TRF_CLS_FLATTEN_INHERITANCE_IGNORE_ARCGIS_SUBTYPES) && ArcGISUtil.isArcGISSubtype(genericClassInfo)) continue;
            if (!(((TreeSet)genericClassInfo.subtypes()).isEmpty() || this.allSubtypesOutsideSelectedSchemas(genericClassInfo) || trfConfig.hasRule(RULE_TRF_CLS_FLATTEN_INHERITANCE_IGNORE_ARCGIS_SUBTYPES) && ArcGISUtil.hasArcGISDefaultSubtypeAttribute(genericClassInfo))) {
                boolean includeSupertype = true;
                if (inclusionPattern != null) {
                    includeSupertype = this.matchesRegexInSupertypeHierarchy(genericClassInfo, inclusionPattern);
                }
                if (!includeSupertype) continue;
                genSuperclassesById.put(genericClassInfo.id(), genericClassInfo);
                continue;
            }
            if (genericClassInfo.supertypes() == null || ((TreeSet)genericClassInfo.supertypes()).size() <= 0) continue;
            boolean allSupertypesOutsideAppSchema = true;
            for (String supertypeId : genericClassInfo.supertypes()) {
                if (!genModel.isInAppSchema(genModel.classById(supertypeId))) continue;
                allSupertypesOutsideAppSchema = false;
                break;
            }
            if (allSupertypesOutsideAppSchema) continue;
            boolean include = true;
            if (inclusionPattern != null) {
                include = this.matchesRegexInSupertypeHierarchy(genericClassInfo, inclusionPattern);
            }
            if (!include) continue;
            genLeafclassesById.put(genericClassInfo.id(), genericClassInfo);
        }
        HashSet<String> idsOfUnprocessedSupertypes = new HashSet<String>();
        for (String superclassId : genSuperclassesById.keySet()) {
            idsOfUnprocessedSupertypes.add(superclassId);
        }
        while (!idsOfUnprocessedSupertypes.isEmpty()) {
            for (String idOfgenSuperclass : genSuperclassesById.keySet()) {
                if (!idsOfUnprocessedSupertypes.contains(idOfgenSuperclass)) continue;
                GenericClassInfo superclass = (GenericClassInfo)genSuperclassesById.get(idOfgenSuperclass);
                SortedSet supertypesOfSuperclass = superclass.supertypes();
                if (supertypesOfSuperclass == null || supertypesOfSuperclass.size() == 0) {
                    if (addAttributesAtBottom) {
                        this.copyContentToSubtypes(genModel, superclass, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_BOTTOM);
                    } else {
                        this.copyContentToSubtypes(genModel, superclass, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_TOP);
                    }
                    if (trfConfig.hasRule(RULE_TRF_CLS_FLATTEN_INHERITANCE_MERGE_LINKED_DOCUMENTS)) {
                        this.mergeLinkedDocumentsInSubtypes(superclass, trfConfig);
                    }
                    idsOfUnprocessedSupertypes.remove(idOfgenSuperclass);
                    continue;
                }
                boolean noRelevantSupertypes = true;
                for (String supertypeId : supertypesOfSuperclass) {
                    if (!genModel.isInAppSchema(genModel.classById(supertypeId)) || !idsOfUnprocessedSupertypes.contains(supertypeId)) continue;
                    noRelevantSupertypes = false;
                    break;
                }
                if (!noRelevantSupertypes) continue;
                if (addAttributesAtBottom) {
                    this.copyContentToSubtypes(genModel, superclass, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_BOTTOM);
                } else {
                    this.copyContentToSubtypes(genModel, superclass, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_TOP);
                }
                if (trfConfig.hasRule(RULE_TRF_CLS_FLATTEN_INHERITANCE_MERGE_LINKED_DOCUMENTS)) {
                    this.mergeLinkedDocumentsInSubtypes(superclass, trfConfig);
                }
                idsOfUnprocessedSupertypes.remove(idOfgenSuperclass);
            }
        }
        HashMap<Object, ArrayList<GenericClassInfo>> hashMap = new HashMap<Object, ArrayList<GenericClassInfo>>();
        for (Object genSuperclass : genSuperclassesById.values()) {
            Set<GenericClassInfo> subclasses = this.getAllSubclassesFromSchemasSelectedForProcessing((GenericClassInfo)genSuperclass, trfConfig.hasRule(RULE_TRF_CLS_FLATTEN_INHERITANCE_IGNORE_ARCGIS_SUBTYPES));
            ArrayList<GenericClassInfo> subclassesList = new ArrayList<GenericClassInfo>(subclasses);
            Collections.sort(subclassesList, new Comparator<GenericClassInfo>(){

                @Override
                public int compare(GenericClassInfo f1, GenericClassInfo f2) {
                    return f1.name().compareTo(f2.name());
                }
            });
            hashMap.put(genSuperclass, subclassesList);
        }
        for (Object genSuperclass : genSuperclassesById.values()) {
            GenericClassInfo genSuperclassUnion = new GenericClassInfo(genModel, ((GenericClassInfo)genSuperclass).id() + "_union", ((GenericClassInfo)genSuperclass).name() + "Union", 8);
            if (this.hasCode((Info)genSuperclass)) {
                this.setCode(genSuperclassUnion, this.getCode((Info)genSuperclass) + "_U");
            } else {
                this.setCode(genSuperclassUnion, ((GenericClassInfo)genSuperclass).name() + "Union");
            }
            String tvOmitWhenFlattened = ((InfoImpl)genSuperclass).taggedValue("omitWhenFlattened");
            if ("true".equalsIgnoreCase(tvOmitWhenFlattened)) {
                genSuperclassUnion.setTaggedValue("omitWhenFlattened", "true", false);
            }
            genSuperclassUnion.setStereotype("union");
            genSuperclassUnion.setPkg(((GenericClassInfo)genSuperclass).pkg());
            ((GenericPackageInfo)genSuperclassUnion.pkg()).addClass(genSuperclassUnion);
            int seqNumIndex = 1;
            if (!((GenericClassInfo)genSuperclass).isAbstract() && ((ClassInfoImpl)genSuperclass).category() != 4) {
                GenericPropertyInfo genSuperClassUnionProp = this.createPropertyForSuperClassUnion(genModel, genSuperclassUnion, (GenericClassInfo)genSuperclass, seqNumIndex);
                genSuperclassUnion.addProperty(genSuperClassUnionProp, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
                ++seqNumIndex;
            }
            for (GenericClassInfo genCiSub : (List)hashMap.get(genSuperclass)) {
                if (genCiSub.isAbstract() || genCiSub.category() == 4) continue;
                GenericPropertyInfo genSuperClassUnionProp = this.createPropertyForSuperClassUnion(genModel, genSuperclassUnion, genCiSub, seqNumIndex);
                genSuperclassUnion.addProperty(genSuperClassUnionProp, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
                ++seqNumIndex;
            }
            if (((ClassInfoImpl)genSuperclass).category() == 1) {
                genSuperclassUnion.setTaggedValue("representsFeatureTypeSet", "true", false);
            }
            genSuperclassUnionsBySuperclassName.put(((GenericClassInfo)genSuperclass).name(), genSuperclassUnion);
            genModel.addClass(genSuperclassUnion);
        }
        Collection superclassUnions = genSuperclassUnionsBySuperclassName.values();
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if (!genPi.isAttribute()) continue;
            Type type = genPi.typeInfo();
            if (!genSuperclassesById.containsKey(type.id)) continue;
            GenericClassInfo superclassUnion = (GenericClassInfo)genSuperclassUnionsBySuperclassName.get(type.name);
            if (genPi.inClass().id().equals(superclassUnion.id()) || superclassUnions.contains(genPi.inClass())) continue;
            type.name = superclassUnion.name();
            type.id = superclassUnion.id();
        }
        HashSet<GenericAssociationInfo> genAisToAdd = new HashSet<GenericAssociationInfo>();
        for (GenericAssociationInfo genAi : genModel.selectedSchemaAssociations()) {
            GenericAssociationInfo aiCopy;
            StructuredNumber newSnPi2;
            StructuredNumber newSnPi1;
            Multiplicity mPi2;
            List subclassesPi1InClass;
            String newAliasPi2Orig;
            PropertyInfo pi1 = genAi.end1();
            PropertyInfo pi2 = genAi.end2();
            String namePi1InClass = pi1.inClass().name();
            String namePi2InClass = pi2.inClass().name();
            if (!hashMap.containsKey(pi1.inClass()) && !hashMap.containsKey(pi2.inClass())) continue;
            if (!(pi1 instanceof GenericPropertyInfo && pi1.inClass() instanceof GenericClassInfo && pi2 instanceof GenericPropertyInfo && pi2.inClass() instanceof GenericClassInfo)) {
                if (!(pi1 instanceof GenericPropertyInfo) || !(pi1.inClass() instanceof GenericClassInfo)) {
                    this.result.addWarning(this, 20336, namePi1InClass.compareTo(namePi2InClass) <= 0 ? namePi1InClass : namePi2InClass, namePi1InClass.compareTo(namePi2InClass) <= 0 ? namePi2InClass : namePi1InClass, namePi1InClass);
                    continue;
                }
                this.result.addWarning(this, 20336, namePi1InClass.compareTo(namePi2InClass) <= 0 ? namePi1InClass : namePi2InClass, namePi1InClass.compareTo(namePi2InClass) <= 0 ? namePi2InClass : namePi1InClass, namePi2InClass);
                continue;
            }
            String separator = this.separatorForPropertyFromUnion;
            GenericPropertyInfo genPi1Orig = (GenericPropertyInfo)pi1;
            GenericPropertyInfo genPi2Orig = (GenericPropertyInfo)pi2;
            GenericClassInfo genPi1InClass = (GenericClassInfo)pi1.inClass();
            GenericClassInfo genPi2InClass = (GenericClassInfo)pi2.inClass();
            String newGenPi1OrigName = this.computeAssociationRoleNameForFlattenInheritance(pi1, pi2.inClass(), separator);
            String newGenPi2OrigName = this.computeAssociationRoleNameForFlattenInheritance(pi2, pi1.inClass(), separator);
            String codePi1 = this.hasCode(pi1) ? this.getCode(pi1) : pi1.name();
            String codePi2 = this.hasCode(pi2) ? this.getCode(pi2) : pi2.name();
            String codePi1InClass = this.hasCode(genPi1InClass) ? this.getCode(genPi1InClass) : genPi1InClass.name();
            String codePi2InClass = this.hasCode(genPi2InClass) ? this.getCode(genPi2InClass) : genPi2InClass.name();
            String newAliasPi1Orig = this.hasCode(pi1) || this.hasCode(genPi2InClass) ? codePi1 + separator + codePi2InClass : null;
            String string = newAliasPi2Orig = this.hasCode(pi2) || this.hasCode(genPi1InClass) ? codePi2 + separator + codePi1InClass : null;
            if (hashMap.containsKey(pi1.inClass()) && hashMap.containsKey(pi2.inClass())) {
                String newAliasPi2;
                String newAliasPi1;
                String newNamePi2;
                String newNamePi1;
                subclassesPi1InClass = (List)hashMap.get(pi1.inClass());
                List subclassesPi2InClass = (List)hashMap.get(pi2.inClass());
                boolean checkFailed = false;
                if (subclassesPi1InClass == null || subclassesPi1InClass.isEmpty()) {
                    checkFailed = true;
                    this.result.addError(this, 20337, pi1.inClass().name());
                }
                if (subclassesPi2InClass == null || subclassesPi2InClass.isEmpty()) {
                    checkFailed = true;
                    this.result.addError(this, 20337, pi2.inClass().name());
                }
                if (checkFailed) continue;
                Multiplicity mPi1 = new Multiplicity(pi1.cardinality().toString());
                mPi1.minOccurs = 0;
                mPi2 = new Multiplicity(pi2.cardinality().toString());
                mPi2.minOccurs = 0;
                int sequenceNumberIndex = 1;
                for (GenericClassInfo subclassPi1InClass : subclassesPi1InClass) {
                    for (GenericClassInfo subclassPi2InClass : subclassesPi2InClass) {
                        String newNamePi12 = this.computeAssociationRoleNameForFlattenInheritance(pi1, subclassPi2InClass, separator);
                        String newNamePi22 = this.computeAssociationRoleNameForFlattenInheritance(pi2, subclassPi1InClass, separator);
                        String codesubclassPi1InClass = this.hasCode(subclassPi1InClass) ? this.getCode(subclassPi1InClass) : subclassPi1InClass.name();
                        String codesubclassPi2InClass = this.hasCode(subclassPi2InClass) ? this.getCode(subclassPi2InClass) : subclassPi2InClass.name();
                        String newAliasPi12 = this.hasCode(pi1) || this.hasCode(subclassPi2InClass) ? codePi1 + separator + codesubclassPi2InClass : null;
                        String newAliasPi22 = this.hasCode(pi2) || this.hasCode(subclassPi1InClass) ? codePi2 + separator + codesubclassPi1InClass : null;
                        StructuredNumber newSnPi13 = pi1.sequenceNumber().createCopyWithSuffix(sequenceNumberIndex);
                        StructuredNumber newSnPi23 = pi2.sequenceNumber().createCopyWithSuffix(sequenceNumberIndex);
                        ++sequenceNumberIndex;
                        GenericAssociationInfo aiCopy3 = this.createCopyAndSetEnds(genModel, genAi, newNamePi12, newAliasPi12, null, subclassPi1InClass, mPi1, newSnPi13, newNamePi22, newAliasPi22, null, subclassPi2InClass, mPi2, newSnPi23, false);
                        genAisToAdd.add(aiCopy3);
                    }
                }
                if (!pi1.inClass().isAbstract() && pi1.inClass().category() != 4) {
                    sequenceNumberIndex = 1;
                    for (GenericClassInfo subclassPi2InClass : subclassesPi2InClass) {
                        newNamePi1 = this.computeAssociationRoleNameForFlattenInheritance(pi1, subclassPi2InClass, separator);
                        newNamePi2 = this.computeAssociationRoleNameForFlattenInheritance(pi2, genPi1InClass, separator);
                        String codesubclassPi2InClass = this.hasCode(subclassPi2InClass) ? this.getCode(subclassPi2InClass) : subclassPi2InClass.name();
                        newAliasPi1 = this.hasCode(pi1) || this.hasCode(subclassPi2InClass) ? codePi1 + separator + codesubclassPi2InClass : null;
                        newAliasPi2 = this.hasCode(pi2) || this.hasCode(genPi1InClass) ? codePi2 + separator + codePi1InClass : null;
                        StructuredNumber newSnPi12 = pi1.sequenceNumber().createCopyWithSuffix(sequenceNumberIndex);
                        StructuredNumber newSnPi22 = pi2.sequenceNumber().createCopyWithSuffix(0);
                        ++sequenceNumberIndex;
                        GenericAssociationInfo aiCopy2 = this.createCopyAndSetEnds(genModel, genAi, newNamePi1, newAliasPi1, null, genPi1InClass, mPi1, newSnPi12, newNamePi2, newAliasPi2, null, subclassPi2InClass, mPi2, newSnPi22, false);
                        genAisToAdd.add(aiCopy2);
                    }
                }
                if (!pi2.inClass().isAbstract() && pi2.inClass().category() != 4) {
                    sequenceNumberIndex = 1;
                    for (GenericClassInfo subclassPi1InClass : subclassesPi1InClass) {
                        newNamePi1 = this.computeAssociationRoleNameForFlattenInheritance(pi1, genPi2InClass, separator);
                        newNamePi2 = this.computeAssociationRoleNameForFlattenInheritance(pi2, subclassPi1InClass, separator);
                        String codesubclassPi1InClass = this.hasCode(subclassPi1InClass) ? this.getCode(subclassPi1InClass) : subclassPi1InClass.name();
                        newAliasPi1 = this.hasCode(pi1) || this.hasCode(genPi2InClass) ? codePi1 + separator + codePi2InClass : null;
                        newAliasPi2 = this.hasCode(pi2) || this.hasCode(subclassPi1InClass) ? codePi2 + separator + codesubclassPi1InClass : null;
                        StructuredNumber newSnPi12 = pi1.sequenceNumber().createCopyWithSuffix(0);
                        StructuredNumber newSnPi22 = pi2.sequenceNumber().createCopyWithSuffix(sequenceNumberIndex);
                        ++sequenceNumberIndex;
                        GenericAssociationInfo aiCopy2 = this.createCopyAndSetEnds(genModel, genAi, newNamePi1, newAliasPi1, null, subclassPi1InClass, mPi1, newSnPi12, newNamePi2, newAliasPi2, null, genPi2InClass, mPi2, newSnPi22, false);
                        genAisToAdd.add(aiCopy2);
                    }
                }
                genPi1Orig.setName(newGenPi1OrigName);
                genPi2Orig.setName(newGenPi2OrigName);
                this.setCode(genPi1Orig, newAliasPi1Orig);
                this.setCode(genPi2Orig, newAliasPi2Orig);
                genPi1Orig.setCardinality(mPi1);
                genPi2Orig.setCardinality(mPi2);
                continue;
            }
            if (hashMap.containsKey(pi1.inClass())) {
                subclassesPi1InClass = (List)hashMap.get(pi1.inClass());
                if (subclassesPi1InClass == null || subclassesPi1InClass.isEmpty()) {
                    this.result.addError(this, 20337, pi1.inClass().name());
                    continue;
                }
                int sequenceNumberIndex = 1;
                for (GenericClassInfo subclassPi1InClass : subclassesPi1InClass) {
                    mPi2 = new Multiplicity(pi2.cardinality().toString());
                    mPi2.minOccurs = 0;
                    String newNamePi2 = this.computeAssociationRoleNameForFlattenInheritance(pi2, subclassPi1InClass, separator);
                    String codesubclassPi1InClass = this.hasCode(subclassPi1InClass) ? this.getCode(subclassPi1InClass) : subclassPi1InClass.name();
                    String newAliasPi2 = this.hasCode(pi2) || this.hasCode(subclassPi1InClass) ? codePi2 + separator + codesubclassPi1InClass : null;
                    newSnPi1 = pi1.sequenceNumber().createCopyWithSuffix(0);
                    newSnPi2 = pi2.sequenceNumber().createCopyWithSuffix(sequenceNumberIndex);
                    ++sequenceNumberIndex;
                    aiCopy = this.createCopyAndSetEnds(genModel, genAi, null, null, null, subclassPi1InClass, null, newSnPi1, newNamePi2, newAliasPi2, null, genPi2InClass, mPi2, newSnPi2, false);
                    genAisToAdd.add(aiCopy);
                }
                genPi2Orig.setName(newGenPi2OrigName);
                this.setCode(genPi2Orig, newAliasPi2Orig);
                Multiplicity mPi22 = new Multiplicity(pi2.cardinality().toString());
                mPi22.minOccurs = 0;
                genPi2Orig.setCardinality(mPi22);
                continue;
            }
            List subclassesPi2InClass = (List)hashMap.get(pi2.inClass());
            if (subclassesPi2InClass == null || subclassesPi2InClass.isEmpty()) {
                this.result.addError(this, 20337, pi2.inClass().name());
                continue;
            }
            int sequenceNumberIndex = 1;
            for (GenericClassInfo subclassPi2InClass : subclassesPi2InClass) {
                Multiplicity mPi1 = new Multiplicity(pi1.cardinality().toString());
                mPi1.minOccurs = 0;
                String newNamePi1 = this.computeAssociationRoleNameForFlattenInheritance(pi1, subclassPi2InClass, separator);
                String codesubclassPi2InClass = this.hasCode(subclassPi2InClass) ? this.getCode(subclassPi2InClass) : subclassPi2InClass.name();
                String newAliasPi1 = this.hasCode(pi1) || this.hasCode(subclassPi2InClass) ? codePi1 + separator + codesubclassPi2InClass : null;
                newSnPi1 = pi1.sequenceNumber().createCopyWithSuffix(sequenceNumberIndex);
                newSnPi2 = pi2.sequenceNumber().createCopyWithSuffix(0);
                ++sequenceNumberIndex;
                aiCopy = this.createCopyAndSetEnds(genModel, genAi, newNamePi1, newAliasPi1, null, genPi1InClass, mPi1, newSnPi1, null, null, null, subclassPi2InClass, null, newSnPi2, false);
                genAisToAdd.add(aiCopy);
            }
            genPi1Orig.setName(newGenPi1OrigName);
            this.setCode(genPi1Orig, newAliasPi1Orig);
            Multiplicity mPi1 = new Multiplicity(pi1.cardinality().toString());
            mPi1.minOccurs = 0;
            genPi1Orig.setCardinality(mPi1);
        }
        for (GenericAssociationInfo aiCopy : genAisToAdd) {
            genModel.addAssociation(aiCopy);
        }
        for (GenericClassInfo leafCi : genLeafclassesById.values()) {
            TreeSet<String> newSupertypes = new TreeSet<String>();
            for (String supertypeID : leafCi.supertypes()) {
                if (!trfConfig.hasRule(RULE_TRF_CLS_FLATTEN_INHERITANCE_IGNORE_ARCGIS_SUBTYPES) || !ArcGISUtil.isArcGISSubtype(leafCi)) continue;
                newSupertypes.add(supertypeID);
            }
            leafCi.setSupertypes(newSupertypes);
        }
        for (GenericClassInfo superclass : genSuperclassesById.values()) {
            if (superclass.isAbstract() || superclass.category() == 4) {
                genModel.remove(superclass);
                continue;
            }
            superclass.setSupertypes(null);
            superclass.setSubtypes(null);
        }
    }

    private void mergeLinkedDocumentsInSubtypes(GenericClassInfo superclass, TransformerConfiguration trfConfig) {
        boolean pageBreak = trfConfig.parameterAsBoolean(PARAM_INHERITANCE_LINKED_DOC_PAGEBREAK, false);
        if (superclass.getLinkedDocument() != null && !((TreeSet)superclass.subtypes()).isEmpty()) {
            WordprocessingMLPackage topPackage;
            block9: {
                topPackage = null;
                try {
                    File linkedDocSupertype = superclass.getLinkedDocument();
                    FileInputStream linkedDocSupertypeIS = new FileInputStream(linkedDocSupertype);
                    topPackage = WordprocessingMLPackage.load((InputStream)linkedDocSupertypeIS);
                }
                catch (FileNotFoundException | Docx4JException e) {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 20400, superclass.name(), e.getMessage());
                    if (mc == null) break block9;
                    mc.addDetail(this, 2, superclass.fullNameInSchema());
                }
            }
            if (topPackage != null) {
                for (String subtypeId : superclass.subtypes()) {
                    ClassInfo subtype = superclass.model().classById(subtypeId);
                    if (!superclass.model().isInSelectedSchemas(subtype)) continue;
                    if (subtype.getLinkedDocument() == null) {
                        subtype.setLinkedDocument(superclass.getLinkedDocument());
                        continue;
                    }
                    GenericClassInfo genSubtype = (GenericClassInfo)subtype;
                    WordprocessingMLPackage topPackageClone = (WordprocessingMLPackage)topPackage.clone();
                    MainDocumentPart topCloneMainDoc = topPackageClone.getMainDocumentPart();
                    if (pageBreak) {
                        topCloneMainDoc.getContent().add(DocxUtil.createPageBreak());
                    }
                    try {
                        File mergedLinkedDoc = File.createTempFile("transformedLinkedDoc", ".docx", this.options.linkedDocumentsTmpDir());
                        mergedLinkedDoc.deleteOnExit();
                        DocxUtil.merge(topPackageClone, genSubtype.getLinkedDocument(), mergedLinkedDoc);
                        genSubtype.setLinkedDocument(mergedLinkedDoc);
                    }
                    catch (Exception e) {
                        this.result.addError(this, 20401, superclass.name(), genSubtype.name(), e.getMessage());
                    }
                }
            }
        }
    }

    private String computeAssociationRoleNameForFlattenInheritance(PropertyInfo pi, ClassInfo valueType, String separator) {
        String piName = pi.name();
        String valueTypeName = valueType.name();
        if (this.rules.contains(RULE_TRF_CLS_FLATTEN_INHERITANCE_ASSOCIATIONROLENAME_USING_CODE_OF_VALUETYPE) && this.hasCode(valueType)) {
            valueTypeName = this.getCode(valueType);
        }
        return piName + separator + valueTypeName;
    }

    private boolean allSubtypesOutsideSelectedSchemas(GenericClassInfo genCls) {
        GenericModel model = genCls.model();
        for (String subtypeId : genCls.subtypes()) {
            ClassInfo subtype = model.classById(subtypeId);
            if (!model.isInSelectedSchemas(subtype)) continue;
            return false;
        }
        return true;
    }

    private GenericPropertyInfo createPropertyForSuperClassUnion(GenericModel genModel, GenericClassInfo genSuperclassUnion, GenericClassInfo genSuperclass, int seqNumIndex) {
        GenericPropertyInfo genSuperClassUnionProp = new GenericPropertyInfo(genModel, genSuperclassUnion.id() + "_choice" + seqNumIndex, this.toLowerCase(genSuperclass.name()));
        genSuperClassUnionProp.setStereotype("");
        Type propType = new Type();
        propType.id = genSuperclass.id();
        propType.name = genSuperclass.name();
        genSuperClassUnionProp.setTypeInfo(propType);
        TaggedValues taggedValues = this.options.taggedValueFactory();
        taggedValues.add("gmlImplementedByNilReason", "false");
        taggedValues.add("inlineOrByReference", "inlineOrByReference");
        taggedValues.add("isMetadata", "false");
        taggedValues.add(PARAM_MAXOCCURS, "");
        taggedValues.add("modified", "");
        taggedValues.add("name", "");
        taggedValues.add("physicalQuantity", "");
        taggedValues.add("profiles", "");
        taggedValues.add("recommendedMeasure", "");
        taggedValues.add("securityClassification", "");
        taggedValues.add("sequenceNumber", "" + seqNumIndex);
        taggedValues.add("xsdEncodingRule", "");
        genSuperClassUnionProp.setTaggedValues(taggedValues, false);
        genSuperClassUnionProp.setSequenceNumber(new StructuredNumber("" + seqNumIndex), false);
        genSuperClassUnionProp.setInClass(genSuperclassUnion);
        if (this.hasCode(genSuperclass)) {
            this.setCode(genSuperClassUnionProp, this.toLowerCase(this.getCode(genSuperclass)));
        } else {
            this.setCode(genSuperClassUnionProp, this.toLowerCase(genSuperclass.name()));
        }
        return genSuperClassUnionProp;
    }

    private boolean matchesRegexInSupertypeHierarchy(GenericClassInfo genCi, Pattern regex) {
        Matcher m = regex.matcher(genCi.name());
        if (m.matches()) {
            this.result.addDebug(this, 20344, genCi.name(), regex.pattern(), PARAM_INHERITANCE_INCLUDE_REGEX);
            return true;
        }
        this.result.addDebug(this, 20345, genCi.name(), regex.pattern(), PARAM_INHERITANCE_INCLUDE_REGEX);
        GenericModel model = genCi.model();
        SortedSet supertypeIds = genCi.supertypes();
        if (supertypeIds != null && supertypeIds.size() > 0) {
            boolean matchFound = false;
            for (String supertypeId : supertypeIds) {
                GenericClassInfo genSupertype;
                boolean tmp;
                ClassInfo supertype = model.classById(supertypeId);
                if (!model.isInAppSchema(supertype) || !(supertype instanceof GenericClassInfo) || !(tmp = this.matchesRegexInSupertypeHierarchy(genSupertype = (GenericClassInfo)supertype, regex))) continue;
                matchFound = true;
                break;
            }
            return matchFound;
        }
        return false;
    }

    private boolean hasCode(Info info) {
        String codevalue = null;
        codevalue = this.tvNameForCodeValue == null ? info.aliasName() : info.taggedValue(this.tvNameForCodeValue);
        return StringUtils.isNotBlank((CharSequence)codevalue);
    }

    private String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        String c = "" + Character.toLowerCase(s.charAt(0));
        if (s.length() == 1) {
            return c;
        }
        return c + s.substring(1, s.length());
    }

    private GenericAssociationInfo createCopyAndSetEnds(GenericModel genModel, GenericAssociationInfo genAi, String newEnd1Rolename, String newEnd1Alias, Descriptors newEnd1Descriptors, GenericClassInfo newEnd1InClass, Multiplicity newCardinalityEnd1, StructuredNumber newSequenceNumberEnd1, String newEnd2Rolename, String newEnd2Alias, Descriptors newEnd2Descriptors, GenericClassInfo newEnd2InClass, Multiplicity newCardinalityEnd2, StructuredNumber newSequenceNumberEnd2, boolean registerAssociationCopyInModel) {
        String nameRoleEnd2;
        String name1 = newEnd1InClass.name();
        String name2 = newEnd2InClass.name();
        String nameRoleEnd1 = newEnd1Rolename == null ? genAi.end1().name() : newEnd1Rolename;
        String string = nameRoleEnd2 = newEnd2Rolename == null ? genAi.end2().name() : newEnd2Rolename;
        if (genAi.assocClass() != null) {
            this.result.addWarning(this, 20334, name1.compareTo(name2) <= 0 ? name1 : name2, name1.compareTo(name2) <= 0 ? name2 : name1);
        }
        GenericAssociationInfo aiCopy = genModel.createCopy(genAi, genAi.id() + "_copyBetweenClasses_" + name1 + "_and_" + name2 + "_for_roles_" + nameRoleEnd1 + "_and_" + nameRoleEnd2);
        GenericPropertyInfo genPi1 = genModel.createCopy(genAi.end1(), genAi.end1().id() + "_copyForAssociationBetweenClasses_" + name1 + "_and_" + name2);
        genPi1.setSequenceNumber(newSequenceNumberEnd1, true);
        genPi1.setInClass(newEnd1InClass);
        genPi1.setAssociation(aiCopy);
        Type tiOfPi1 = genPi1.typeInfo();
        tiOfPi1.id = newEnd2InClass.id();
        tiOfPi1.name = newEnd2InClass.name();
        if (newEnd1Rolename != null) {
            genPi1.setName(newEnd1Rolename);
        }
        if (newEnd1Descriptors != null) {
            genPi1.setDescriptors(newEnd1Descriptors);
        }
        if (newEnd1Alias != null) {
            this.setCode(genPi1, newEnd1Alias);
        }
        if (newCardinalityEnd1 != null) {
            genPi1.setCardinality(newCardinalityEnd1);
        }
        GenericPropertyInfo genPi2 = genModel.createCopy(genAi.end2(), genAi.end2().id() + "_copyForAssociationBetweenClasses_" + name1 + "_and_" + name2);
        genPi2.setSequenceNumber(newSequenceNumberEnd2, true);
        genPi2.setInClass(newEnd2InClass);
        genPi2.setAssociation(aiCopy);
        Type tiOfPi2 = genPi2.typeInfo();
        tiOfPi2.id = newEnd1InClass.id();
        tiOfPi2.name = newEnd1InClass.name();
        if (newEnd2Rolename != null) {
            genPi2.setName(newEnd2Rolename);
        }
        if (newEnd2Descriptors != null) {
            genPi2.setDescriptors(newEnd1Descriptors);
        }
        if (newEnd2Alias != null) {
            this.setCode(genPi2, newEnd2Alias);
        }
        if (newCardinalityEnd2 != null) {
            genPi2.setCardinality(newCardinalityEnd2);
        }
        aiCopy.setEnd1(genPi1);
        aiCopy.setEnd2(genPi2);
        genModel.getGenProperties().put(genPi1.id(), genPi1);
        genModel.getGenProperties().put(genPi2.id(), genPi2);
        if (registerAssociationCopyInModel) {
            genModel.getGenAssociations().put(aiCopy.id(), aiCopy);
        }
        if (genPi1.isNavigable()) {
            newEnd1InClass.addProperty(genPi1, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
        }
        if (genPi2.isNavigable()) {
            newEnd2InClass.addProperty(genPi2, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
        }
        return aiCopy;
    }

    private Set<GenericClassInfo> getAllSubclassesFromSchemasSelectedForProcessing(GenericClassInfo genCi, boolean ignoreArcGISSubtypes) {
        if (((TreeSet)genCi.subtypes()).isEmpty()) {
            return new HashSet<GenericClassInfo>();
        }
        HashSet<GenericClassInfo> subtypes = new HashSet<GenericClassInfo>();
        for (String subtypeId : genCi.subtypes()) {
            ClassInfo subtype = genCi.model().classById(subtypeId);
            if (!genCi.model().isInSelectedSchemas(subtype)) continue;
            GenericClassInfo genSubtype = (GenericClassInfo)subtype;
            if (ignoreArcGISSubtypes && ArcGISUtil.isArcGISSubtype(genSubtype)) continue;
            subtypes.add(genSubtype);
            Set<GenericClassInfo> subsubtypes = this.getAllSubclassesFromSchemasSelectedForProcessing(genSubtype, ignoreArcGISSubtypes);
            subtypes.addAll(subsubtypes);
        }
        return subtypes;
    }

    private void copyContentToSubtypes(GenericModel genModel, GenericClassInfo genCi, GenericModel.PropertyCopyPositionIndicator pcpi) {
        SortedSet subtypeIds = genCi.subtypes();
        if (subtypeIds == null || subtypeIds.isEmpty()) {
            return;
        }
        for (String subtypeId : subtypeIds) {
            ClassInfo subtype = genCi.model().classById(subtypeId);
            if (subtype instanceof GenericClassInfo) {
                GenericClassInfo genSubtype = (GenericClassInfo)subtype;
                genModel.copyClassContent(genCi, genSubtype, pcpi, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE_UNRESTRICT);
                continue;
            }
            this.result.addInfo(this, 20319, subtype.name(), genCi.name());
        }
    }

    private void copyContentToSubtypes(GenericModel genModel, GenericClassInfo genCi) {
        this.copyContentToSubtypes(genModel, genCi, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_TOP);
    }

    private void applyRuleOptionality(GenericModel genModel, TransformerConfiguration trfConfig) {
        ShapeChangeResult result = genModel.result();
        String[] typesToEnforceOptionality = trfConfig.getListParameterValue(PARAM_ENFORCE_OPTIONALITY);
        if (typesToEnforceOptionality == null) {
            result.addWarning(this, 20306);
            return;
        }
        HashSet<String> typeSet = new HashSet<String>(Arrays.asList(typesToEnforceOptionality));
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            if (!typeSet.contains(genPi.typeInfo().name)) continue;
            genPi.cardinality().minOccurs = 0;
        }
    }

    private void applyRulePropUnionDirectOptionality(GenericModel genModel, TransformerConfiguration trfConfig) {
        ShapeChangeResult result = genModel.result();
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            ClassInfo typeCi = genModel.classById(genPi.typeInfo().id);
            if (typeCi == null) continue;
            if (typeCi.name().endsWith("Meta")) {
                ClassInfo typeCi2;
                PropertyInfo piOfTypeCi = typeCi.property("valueOrReason");
                if (piOfTypeCi == null || (typeCi2 = genModel.classById(piOfTypeCi.typeInfo().id)) == null || typeCi2.category() != 8 || !typeCi2.name().endsWith("Reason") || !typeCi2.hasNilReason() || typeCi2.properties().size() != 2) continue;
                genPi.cardinality().minOccurs = 0;
                continue;
            }
            if (!typeCi.name().endsWith("Reason") || genPi.inClass().name().endsWith("Meta") || typeCi.category() != 8 || !typeCi.hasNilReason() || typeCi.properties().size() != 2) continue;
            genPi.cardinality().minOccurs = 0;
            PropertyInfo valuePi = typeCi.property("value");
            if (valuePi == null) continue;
            genPi.typeInfo().id = valuePi.typeInfo().id;
            genPi.typeInfo().name = valuePi.typeInfo().name;
        }
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            if (!genCi.name().endsWith("Meta") || genCi.properties().size() != 1 || genCi.ownedProperty("valueOrReason") == null) continue;
            GenericPropertyInfo genPi = (GenericPropertyInfo)genCi.ownedProperty("valueOrReason");
            ClassInfo typeCi = genModel.classById(genPi.typeInfo().id);
            PropertyInfo valuePi = typeCi.property("value");
            if (valuePi != null) {
                genPi.typeInfo().id = valuePi.typeInfo().id;
                genPi.typeInfo().name = valuePi.typeInfo().name;
                continue;
            }
            result.addWarning(this, 20307, typeCi.name());
        }
    }

    private void applyRuleONINAs(GenericModel model, TransformerConfiguration trfConfig) {
        Options options = model.options();
        boolean onlyRemoveReasons = trfConfig.hasRule(RULE_TRF_PROP_FLATTEN_ONINAS_ONLY_REMOVE_REASONS);
        SortedSet<PackageInfo> appSchemas = model.selectedSchemas();
        if (appSchemas == null || appSchemas.size() == 0) {
            return;
        }
        for (PackageInfo appSchema : appSchemas) {
            boolean booleanReasonProcessed = false;
            GenericClassInfo booleanWithOninaCi = null;
            Type booleanWithOninaType = null;
            SortedSet<ClassInfo> appSchemaClasses = model.classes(appSchema);
            if (appSchemaClasses == null || appSchemaClasses.size() == 0) continue;
            HashMap<String, Type> reasonTypeIdToValueType = new HashMap<String, Type>();
            HashMap<String, Multiplicity> reasonTypeIdToValuePropMultiplicity = new HashMap<String, Multiplicity>();
            HashMap<String, GenericClassInfo> reasonUnionsByName = new HashMap<String, GenericClassInfo>();
            HashSet<String> reasonTypeValueTypeNames = new HashSet<String>();
            HashSet<String> reasonPropertyValueTypeIds = new HashSet<String>();
            for (ClassInfo ci : appSchemaClasses) {
                if (ci.category() != 8 || !ci.name().endsWith("Reason")) continue;
                reasonUnionsByName.put(ci.name(), (GenericClassInfo)ci);
                if (!ci.name().equals("BooleanReason") || booleanWithOninaCi != null || onlyRemoveReasons) continue;
                booleanWithOninaCi = new GenericClassInfo(model, ci.id() + "_ONINARep", "BooleanWithONINA", 3);
                booleanWithOninaCi.descriptors().put(Descriptor.ALIAS, "");
                this.setCode(booleanWithOninaCi, "");
                booleanWithOninaCi.descriptors().put(Descriptor.DEFINITION, "");
                TaggedValues taggedValues = options.taggedValueFactory();
                taggedValues.add("modified", "");
                if (ci.taggedValue("xsdEncodingRule") != null) {
                    taggedValues.add("xsdEncodingRule", ci.taggedValue("xsdEncodingRule"));
                }
                booleanWithOninaCi.setTaggedValues(taggedValues, false);
                booleanWithOninaCi.setPkg(ci.pkg());
                ((GenericPackageInfo)ci.pkg()).addClass(booleanWithOninaCi);
                booleanWithOninaCi.setIsAbstract(false);
                booleanWithOninaCi.setIsLeaf(false);
                booleanWithOninaCi.setAssocInfo(null);
                booleanWithOninaCi.setSupertypes(new TreeSet<String>());
                booleanWithOninaCi.setSubtypes(null);
                booleanWithOninaCi.setProperties(ci.properties());
                TreeMap<StructuredNumber, PropertyInfo> properties = new TreeMap<StructuredNumber, PropertyInfo>();
                StructuredNumber s1 = new StructuredNumber("1");
                GenericPropertyInfo falseEnumProp = this.createEnumerationProperty(model, "false", "1000", booleanWithOninaCi, s1);
                this.setCode(falseEnumProp, "1000");
                falseEnumProp.descriptors().put(Descriptor.DEFINITION, "False");
                properties.put(s1, falseEnumProp);
                model.register(falseEnumProp);
                StructuredNumber s2 = new StructuredNumber("2");
                GenericPropertyInfo trueEnumProp = this.createEnumerationProperty(model, "true", "1001", booleanWithOninaCi, s2);
                this.setCode(trueEnumProp, "1001");
                trueEnumProp.descriptors().put(Descriptor.DEFINITION, "True");
                properties.put(s2, trueEnumProp);
                model.register(trueEnumProp);
                StructuredNumber s3 = new StructuredNumber("3");
                GenericPropertyInfo noInfoProp = this.createEnumerationProperty(model, "noInformation", "-999999", booleanWithOninaCi, s3);
                this.setCode(noInfoProp, "-999999");
                noInfoProp.descriptors().put(Descriptor.DEFINITION, "No Information");
                properties.put(s3, noInfoProp);
                model.register(noInfoProp);
                booleanWithOninaCi.setProperties(properties);
                booleanWithOninaCi.setDirectConstraints(new Vector<Constraint>());
                model.addClass(booleanWithOninaCi);
                booleanWithOninaType = new Type();
                booleanWithOninaType.id = booleanWithOninaCi.id();
                booleanWithOninaType.name = booleanWithOninaCi.name();
                model.register(booleanWithOninaCi);
            }
            if (reasonUnionsByName.isEmpty() && !booleanReasonProcessed) continue;
            for (GenericClassInfo reasonUnionCi : reasonUnionsByName.values()) {
                PropertyInfo valueP = reasonUnionCi.property("value");
                if (valueP == null) {
                    valueP = reasonUnionCi.property("values");
                }
                if (valueP == null) {
                    this.result.addWarning(this, 20339, reasonUnionCi.name());
                    continue;
                }
                Type valuePType = valueP.typeInfo();
                if (valuePType.name.equalsIgnoreCase("Boolean") && !onlyRemoveReasons) {
                    reasonTypeIdToValueType.put(reasonUnionCi.id(), booleanWithOninaType);
                } else {
                    reasonTypeIdToValueType.put(reasonUnionCi.id(), valuePType);
                    reasonTypeValueTypeNames.add(valuePType.name);
                }
                reasonTypeIdToValuePropMultiplicity.put(reasonUnionCi.id(), valueP.cardinality());
            }
            for (GenericClassInfo reasonUnionCi : reasonUnionsByName.values()) {
                PropertyInfo reasonP = reasonUnionCi.property("reason");
                if (reasonP == null) continue;
                Type reasonPType = reasonP.typeInfo();
                reasonPropertyValueTypeIds.add(reasonPType.id);
            }
            if (!onlyRemoveReasons) {
                for (String typeName : reasonTypeValueTypeNames) {
                    ClassInfo ci = model.classByName(typeName);
                    if (ci == null) {
                        this.result.addWarning(this, 20303, typeName);
                        continue;
                    }
                    if (ci.category() != 3) continue;
                    if (ci instanceof GenericClassInfo) {
                        GenericClassInfo genCi = (GenericClassInfo)ci;
                        int maxSequenceNumber = Integer.MIN_VALUE;
                        Set<StructuredNumber> enumSeqNumbers = genCi.properties().keySet();
                        for (StructuredNumber strucNum : enumSeqNumbers) {
                            if (strucNum.components[0] <= maxSequenceNumber) continue;
                            maxSequenceNumber = strucNum.components[0];
                        }
                        StructuredNumber snNoInformation = new StructuredNumber(++maxSequenceNumber);
                        GenericPropertyInfo noInfoProp = this.createEnumerationProperty(model, "noInformation", "-999999", genCi, snNoInformation);
                        this.setCode(noInfoProp, "-999999");
                        noInfoProp.descriptors().put(Descriptor.DEFINITION, "No Information");
                        model.add(noInfoProp, genCi, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
                        StructuredNumber snNotApplicable = new StructuredNumber(++maxSequenceNumber);
                        GenericPropertyInfo notApplicProp = this.createEnumerationProperty(model, "notApplicable", "998", genCi, snNotApplicable);
                        this.setCode(notApplicProp, "998");
                        notApplicProp.descriptors().put(Descriptor.DEFINITION, "Not Applicable");
                        model.add(notApplicProp, genCi, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
                        StructuredNumber snOther = new StructuredNumber(++maxSequenceNumber);
                        GenericPropertyInfo otherProp = this.createEnumerationProperty(model, "other", "999", genCi, snOther);
                        this.setCode(otherProp, "999");
                        otherProp.descriptors().put(Descriptor.DEFINITION, "Other");
                        model.add(otherProp, genCi, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
                        continue;
                    }
                    this.result.addWarning(this, 20323, ci.name());
                }
            }
            for (ClassInfo ci : appSchemaClasses) {
                Collection<PropertyInfo> ciProperties = ci.properties().values();
                if (ciProperties == null || ciProperties.size() == 0) continue;
                for (PropertyInfo pi : ciProperties) {
                    String propTypeId = pi.typeInfo().id;
                    if (!reasonTypeIdToValueType.containsKey(propTypeId)) continue;
                    GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                    Type valueTypeToUse = (Type)reasonTypeIdToValueType.get(propTypeId);
                    genPi.copyTypeInfo(valueTypeToUse);
                    Multiplicity reasonTypeValuesPropMult = (Multiplicity)reasonTypeIdToValuePropMultiplicity.get(propTypeId);
                    int newMinOccurs = genPi.cardinality().minOccurs * reasonTypeValuesPropMult.minOccurs;
                    int genPiMaxOccurs = genPi.cardinality().maxOccurs;
                    int reasonTypeValuesPropMaxOccurs = reasonTypeValuesPropMult.maxOccurs;
                    int newMaxOccurs = genPiMaxOccurs == Integer.MAX_VALUE || reasonTypeValuesPropMaxOccurs == Integer.MAX_VALUE ? Integer.MAX_VALUE : genPiMaxOccurs * reasonTypeValuesPropMaxOccurs;
                    genPi.setCardinality(new Multiplicity(newMinOccurs, newMaxOccurs));
                }
            }
            model.remove(reasonUnionsByName.values());
            for (String reasonPropertyValueTypeId : reasonPropertyValueTypeIds) {
                model.removeByClassId(reasonPropertyValueTypeId);
            }
        }
    }

    private void applyRuleRemoveObjectToFeatureTypeNavigability(GenericModel genModel, TransformerConfiguration trfConfig) {
        String regex = trfConfig.getParameterValue(PARAM_OBJECT_TO_FEATURE_TYPE_NAV_REGEX);
        if (regex != null) {
            if ((regex = regex.trim()).length() == 0) {
                this.result.addError(this, 20001, PARAM_OBJECT_TO_FEATURE_TYPE_NAV_REGEX, RULE_TRF_PROP_REMOVE_OBJECT_TO_FEATURE_TYPE_NAVIGABILITY);
                return;
            }
        } else {
            this.result.addError(this, 20002, PARAM_OBJECT_TO_FEATURE_TYPE_NAV_REGEX, RULE_TRF_PROP_REMOVE_OBJECT_TO_FEATURE_TYPE_NAVIGABILITY);
            return;
        }
        boolean includeObjectTypes = false;
        String includeObjectTypes_ = trfConfig.getParameterValue(PARAM_INCLUDE_OBJECT_NAV);
        if (includeObjectTypes_ != null && Boolean.parseBoolean(includeObjectTypes_.trim())) {
            includeObjectTypes = true;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            this.result.addError(this, 20003, PARAM_OBJECT_TO_FEATURE_TYPE_NAV_REGEX, RULE_TRF_PROP_REMOVE_OBJECT_TO_FEATURE_TYPE_NAVIGABILITY, regex, e.getMessage());
            return;
        }
        HashSet<GenericPropertyInfo> genPisToRemove = new HashSet<GenericPropertyInfo>();
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            ClassInfo genPiValueType = genModel.classById(genPi.typeInfo().id);
            if (genPiValueType == null) {
                genPiValueType = genModel.classByName(genPi.typeInfo().name);
            }
            if ((genPi.inClass().category() != 6 || genPi.categoryOfValue() != 1 && (!includeObjectTypes || genPi.categoryOfValue() != 6)) && (genPiValueType == null || genPiValueType.category() != 4 || !genPiValueType.stereotype("featuretype"))) continue;
            Matcher matcher = pattern.matcher(genPi.inClass().name());
            if (matcher.matches()) {
                genPisToRemove.add(genPi);
                this.result.addDebug(this, 20344, genPi.inClass().name(), regex, PARAM_OBJECT_TO_FEATURE_TYPE_NAV_REGEX);
                continue;
            }
            this.result.addDebug(this, 20345, genPi.inClass().name(), regex, PARAM_OBJECT_TO_FEATURE_TYPE_NAV_REGEX);
        }
        for (GenericPropertyInfo genPiToRemove : genPisToRemove) {
            genModel.remove(genPiToRemove, true);
        }
    }

    private void applyRuleRemoveNavigabilityBasedOnFlatTargetSetting(GenericModel genModel, TransformerConfiguration trfConfig) {
        HashSet<GenericPropertyInfo> genPisToRemove = new HashSet<GenericPropertyInfo>();
        for (GenericPropertyInfo genPi : genModel.selectedSchemaProperties()) {
            boolean isFlatTarget_pi2;
            PropertyInfo pi2;
            PropertyInfo pi1;
            AssociationInfo ai;
            if (genPi.association() == null) continue;
            String isFlatTarget_genPi = genPi.taggedValue(TAGGED_VALUE_IS_FLAT_TARGET);
            if (StringUtils.isNotBlank((CharSequence)isFlatTarget_genPi) && isFlatTarget_genPi.trim().equalsIgnoreCase("true")) {
                genPisToRemove.add(genPi);
            }
            if ((ai = genPi.association()).end1().id().compareTo(ai.end2().id()) <= 0) {
                pi1 = ai.end1();
                pi2 = ai.end2();
            } else {
                pi1 = ai.end2();
                pi2 = ai.end1();
            }
            String isFlatTarget_pi1_tv = pi1.taggedValue(TAGGED_VALUE_IS_FLAT_TARGET);
            String isFlatTarget_pi2_tv = pi2.taggedValue(TAGGED_VALUE_IS_FLAT_TARGET);
            boolean isFlatTarget_pi1 = StringUtils.isNotBlank((CharSequence)isFlatTarget_pi1_tv) ? Boolean.parseBoolean(isFlatTarget_pi1_tv.trim()) : false;
            boolean bl = isFlatTarget_pi2 = StringUtils.isNotBlank((CharSequence)isFlatTarget_pi2_tv) ? Boolean.parseBoolean(isFlatTarget_pi2_tv.trim()) : false;
            if (!(pi1.isNavigable() && pi2.isNavigable() && isFlatTarget_pi1 && isFlatTarget_pi2 || pi1.isNavigable() && !pi2.isNavigable() && isFlatTarget_pi1) && (!pi2.isNavigable() || pi1.isNavigable() || !isFlatTarget_pi2)) continue;
            this.result.addWarning(this, 20325, pi1.name(), pi1.inClass().name(), pi2.name(), pi2.inClass().name());
        }
        for (GenericPropertyInfo genPiToRemove : genPisToRemove) {
            genModel.remove(genPiToRemove, true);
        }
    }

    private GenericPropertyInfo createEnumerationProperty(GenericModel model, String enumName, String enumAlias, ClassInfo ci, StructuredNumber strucNum) {
        GenericPropertyInfo enumPi = new GenericPropertyInfo(model, ci.id() + "_" + enumName, enumName);
        if (enumAlias != null && enumAlias.trim().length() > 0) {
            enumPi.descriptors().put(Descriptor.ALIAS, enumAlias);
        } else {
            enumPi.descriptors().put(Descriptor.ALIAS, enumName);
        }
        enumPi.descriptors().put(Descriptor.DEFINITION, "");
        TaggedValues taggedValues = this.options.taggedValueFactory();
        taggedValues.add("name", "");
        taggedValues.add("profiles", "");
        enumPi.setTaggedValues(taggedValues, false);
        enumPi.setDerived(false);
        enumPi.setReadOnly(false);
        enumPi.setAttribute(true);
        Type enumPiType = new Type();
        Type characterStringType = Type.from("CharacterString", model);
        enumPiType.id = characterStringType.id;
        enumPiType.name = characterStringType.name;
        enumPi.setTypeInfo(enumPiType);
        enumPi.setNavigable(true);
        enumPi.setOrdered(false);
        enumPi.setUnique(true);
        enumPi.setOwned(false);
        enumPi.setComposition(false);
        enumPi.setAggregation(false);
        Multiplicity mult = new Multiplicity();
        mult.maxOccurs = 1;
        mult.minOccurs = 1;
        enumPi.setCardinality(mult);
        enumPi.setInitialValue(null);
        enumPi.setInlineOrByReference("inlineOrByReference");
        enumPi.setInClass(ci);
        enumPi.setSequenceNumber(strucNum, true);
        enumPi.setConstraints(null);
        enumPi.setAssociation(null);
        enumPi.setRestriction(false);
        enumPi.setNilReasonAllowed(false);
        return enumPi;
    }

    protected String join(Set<String> parts, String delimiter) {
        if (parts == null || parts.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String delim = delimiter == null ? "" : delimiter;
        for (String part : parts) {
            if (part != null) {
                sb.append(part);
            }
            sb.append(delim);
        }
        return sb.substring(0, sb.length() - delim.length());
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: property '$1$'";
            }
            case 2: {
                return "Context: class '$1$'";
            }
            case 20001: {
                return "No non-empty string value provided for configuration parameter '$1$'. Execution of '$2$' aborted.";
            }
            case 20002: {
                return "Configuration parameter '$1$' required for execution of '$2$' was not provided. Execution of '$2$' aborted.";
            }
            case 20003: {
                return "Syntax exception for regular expression value of configuration parameter '$1$' (required for execution of '$2$'). Regular expression value was: $3$. Exception message: $4$. Execution of '$2$' aborted.";
            }
            case 20102: {
                return "Value of configuration parameter '$1$' after parsing is '$2$'.";
            }
            case 20301: {
                return "The type '$2$' of property '$1$' was not found.";
            }
            case 20302: {
                return "The type '$1$' to replace type '$2$' was not found. Replacing type without changing the id.";
            }
            case 20303: {
                return "The ClassInfo for type '$1$' was not found in the model.";
            }
            case 20304: {
                return "maxOccurs parameter configured to be '$1$' - using default value 3";
            }
            case 20305: {
                return "maxOccurs tagged value for property '$1$' in class '$2$' was set to '$3$' - using global value: '$4$'";
            }
            case 20306: {
                return "No type information given via configuration parameter 'enforceOptionality'. Rule will not be executed.";
            }
            case 20307: {
                return "applyRulePropUnionDirectOptionality encountered unknown content model of Union-Direct type for type '$1$'.";
            }
            case 20308: {
                return "Context: $1$ '$2$'";
            }
            case 20309: {
                return "Cannot apply rule for flattening name if no value is provided via the configuration parameter '$1$'.";
            }
            case 20310: {
                return "Invalid pattern encountered for configuration parameter '$1$': $2$";
            }
            case 20311: {
                return "When creating copy of the subtype hierarchy for '$1$', subtype with id '$2$' either was not found in the model or is not an instance of GenericClassInfo (likely reason: it belongs to a package that is not part of the schema selected for processing). A copy won't be created for this subtype.";
            }
            case 20312: {
                return "Class '$1$' is not an instance of GenericClassInfo (likely reason: it belongs to a package that is not part of the schema selected for processing). Cannot reliably update subtype info for this class (removing class '$2$' as subtype, and adding its geometry specific copies).";
            }
            case 20313: {
                return "Class '$1$' has a geometry property. The following supertypes also have one: $2$. Flattening of homogeneous geometries with subtypes is enabled. This only works if all subtypes of a type with geometry do not have a geometry property themselves. The class '$1$' will not be fanned out based upon its own geometry typed properties.";
            }
            case 20314: {
                return "Could not find supertype with id '$1$' for class with name '$2$' in the model.";
            }
            case 20315: {
                return "Cannot properly update type of property named '$1$' to the union type named '$2$'.";
            }
            case 20316: {
                return "Class '$1$' has a geometry property. The following supertypes have a different set of restrictions regarding allowed geometry types: $2$. Flattening of homogeneous geometries with subtypes is enabled. This is a potential inconsistency (potential because the map entries defined for the flattening also influence how a feature type with geometry properties is fanned out).";
            }
            case 20317: {
                return "========== $1$ phase ==========";
            }
            case 20318: {
                return "Model does not contain class '$1$' which is the target type to which the type of property '$2$' (from class '$3$') shall be mapped. Setting type.id of property to UNKNOWN.";
            }
            case 20319: {
                return "??Class '$1$' - which is a subtype of '$2$' - is not an instance of GenericClassInfo (likely reason: it belongs to a package that is not part of the schema selected for processing). The contents of '$2$' won't be copied to '$1$', which should be fine because '$1$' is not part of a schema selected for processing.";
            }
            case 20320: {
                return "??Class '$1$' - which is a subtype of '$2$' - is not an instance of GenericClassInfo (likely reason: it belongs to a package that is not part of the schema selected for processing). It (and its possibly existing subtypes) won't be added to the list of subtypes for class '$2$'. $3$";
            }
            case 20321: {
                return "??Class '$1$' is not an instance of GenericClassInfo (likely reason: it belongs to a package that is not part of the schema selected for processing). Thus it cannot be removed from the model.";
            }
            case 20322: {
                return "Class '$1$' is not an instance of GenericClassInfo (likely reason: it belongs to a package that is not part of the schema selected for processing). Cannot reliably update subtype info for this class (updating the id for subtype '$2$' in $1$'s subtype list from '$3$' to that of its copy, which has id '$4$').";
            }
            case 20323: {
                return "Class '$1$' - which is an enumeration - is not an instance of GenericClassInfo (likely reason: it belongs to a package that is not part of the schema selected for processing). Cannot add ONINA enums to the enumeration.";
            }
            case 20324: {
                return "No type information given via configuration parameter 'removeType'. Rule will not be executed.";
            }
            case 20325: {
                return "??isFlatTarget tagged value setting(s) will lead to removal of whole association (with one end being property '$1$' in class '$2$' - the other end being property '$3$' in class '$4$').";
            }
            case 20326: {
                return "--- Found cycle:";
            }
            case 20327: {
                return "   Class '$1$' -> class '$2$' (via properties: $3$)";
            }
            case 20328: {
                return "--- No cycles found.";
            }
            case 20329: {
                return "---------- Checking for reflexive relationships and cyles in types to process (for type flattening) ----------";
            }
            case 20330: {
                return "--- Reflexive relationship detected for class '$1$' (via properties: $2$).";
            }
            case 20331: {
                return "--- No reflexive relationships detected.";
            }
            case 20332: {
                return "The Flattener configuration lists type '$1$' for removal but could not find it in the model.";
            }
            case 20333: {
                return "??Homogeneous geometry rule would update the association between classes '$1$' and '$2$' but cannot do so because class '$3$' belongs to a schema that has not been selected for processing. The association won't be updated and will thus eventually be removed.";
            }
            case 20334: {
                return "??Creating a copy of an association to connect classes '$1$' and '$2$'. The original association has an association class. Copying the association class is currently not supported. The association copy will therefore not have an association class.";
            }
            case 20335: {
                return "??The map for geometry type specific copies of '$1$' is empty.";
            }
            case 20336: {
                return "??Inheritance rule would create subtype specific copies of the association between classes '$1$' and '$2$' but cannot do so because class '$3$' belongs to a schema that has not been selected for processing. Copies of the association won't be created.";
            }
            case 20337: {
                return "??The list of subtypes of superclass '$1$' is empty.";
            }
            case 20338: {
                return "??Ignoring reflexive relationship that would be caused by property '$1$' in class '$2$'. The property will simply be removed.";
            }
            case 20339: {
                return "??No 'value' or 'values' property found in <<union>> '$1$'. ONINA processing/modelling rules expect that a XxxReason <<union>> class has a 'value' or 'values' property.";
            }
            case 20340: {
                return "??The type of property '$1$' in class '$2$' shall be set to the type '$3$'. That type cannot be found in the model. Setting the category of value of the property to 'unknown'.";
            }
            case 20341: {
                return "Rule '$1$' is enabled but the transformer configuration does not contain parameter '$2$' with a valid integer value greater than 1. Behavior for '$1$' will be ignored.";
            }
            case 20342: {
                return "Multiplicity flattening would usually dissolve the bi-directional association between class '$1$' (property '$2$') and class '$3$' (property '$4$'). Because the rule is to keep all bi-directional associations, the association will not be dissolved and multiplicity flattening won't be applied to it.";
            }
            case 20343: {
                return "Parameter '$1$' is required for the execution of '$2$' but has not been provided. The rule will not be applied.";
            }
            case 20344: {
                return "'$1$' matches regex '$2$', provided in parameter '$3$'";
            }
            case 20345: {
                return "'$1$' does not match regex '$2$', provided in parameter '$3$'";
            }
            case 20346: {
                return "After the transformation, class '$1$' has multiple properties with the same name (either in the class itself, or through inheritance from supertypes). The names of duplicate properties are: '$2$'.";
            }
            case 20347: {
                return "Removing name components resulted in at least one class with properties that have the same name. For further details, consult the messages that were logged on INFO level before this message.";
            }
            case 20348: {
                return "Configuration parameter '$1$' contains unknown descriptor '$2$'. The descriptor will be ignored.";
            }
            case 20349: {
                return "??Dissolving mixins will not take into account associations that reference mixin '$1$'.";
            }
            case 20350: {
                return "The lower bound of the multiplicity of property '$1$' is '$2$', consider flattening the multiplicity before using rule '$3$'";
            }
            case 20351: {
                return "The upper bound of the multiplicity of property '$1$' is '$2$', consider flattening the multiplicity before using rule '$3$'";
            }
            case 20400: {
                return "Exception occurred while loading linked document of type '$1$'. Exception message is: $2$";
            }
            case 20401: {
                return "Exception occurred while merging linked documents of supertype '$1$' and its subtype '$2$'. Exception message is: $3$";
            }
            case 20500: {
                return "Subtype '$1$' is already mapped to root class '$2$'. Ignoring a mapping to root class '$3$'.";
            }
            case 20501: {
                return "Multiple properties with same name '$1$', value type, and multiplicity detected in subtypes of type '$2$'.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

