/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Flattening;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericAssociationInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;

public class AssociationClassMapper
implements Transformer,
MessageSource {
    @Override
    public void process(GenericModel m, Options o, TransformerConfiguration trfConfig, ShapeChangeResult r) throws ShapeChangeAbortException {
        SortedSet<GenericAssociationInfo> associations = m.selectedSchemaAssociations();
        String idSuffix = "_associationClassMapping";
        for (GenericAssociationInfo association : associations) {
            GenericPropertyInfo end1 = (GenericPropertyInfo)association.end1();
            GenericPropertyInfo end2 = (GenericPropertyInfo)association.end2();
            GenericClassInfo assocCi = (GenericClassInfo)association.assocClass();
            if (assocCi == null) continue;
            assocCi.setAssocInfo(null);
            association.setAssocClass(null);
            m.remove(association);
            GenericPropertyInfo navigableRole = null;
            GenericPropertyInfo other = null;
            if (end1.isNavigable()) {
                navigableRole = end1;
                other = end2;
            } else {
                navigableRole = end2;
                other = end1;
            }
            ArrayList<GenericPropertyInfo> newPropsForAssociationClass = new ArrayList<GenericPropertyInfo>();
            GenericPropertyInfo nav_a = m.createCopy(navigableRole, navigableRole.id() + idSuffix + "_a");
            m.register(nav_a);
            ((GenericClassInfo)navigableRole.inClass()).addProperty(nav_a, GenericModel.PropertyCopyDuplicatBehaviorIndicator.OVERWRITE);
            nav_a.setTaggedValue("toAssociationClassFrom", navigableRole.inClass().name(), false);
            Type ti_nav_a = new Type();
            ti_nav_a.id = assocCi.id();
            ti_nav_a.name = assocCi.name();
            nav_a.setTypeInfo(ti_nav_a);
            GenericPropertyInfo other_a = m.createCopy(other, other.id() + idSuffix + "_a");
            other_a.setInClass(assocCi);
            other_a.setTaggedValue("fromAssociationClassTo", navigableRole.inClass().name(), false);
            if (other_a.isNavigable()) {
                other_a.setCardinality(new Multiplicity());
                m.register(other_a);
                newPropsForAssociationClass.add(other_a);
            }
            GenericAssociationInfo ai_a = m.createCopy(association, association.id() + idSuffix + "_a");
            ai_a.setAssocClass(null);
            m.addAssociation(ai_a);
            nav_a.setAssociation(ai_a);
            other_a.setAssociation(ai_a);
            if (ai_a.end1() == navigableRole) {
                ai_a.setEnd1(nav_a);
                ai_a.setEnd2(other_a);
            } else {
                ai_a.setEnd1(other_a);
                ai_a.setEnd2(nav_a);
            }
            GenericPropertyInfo nav_b = m.createCopy(navigableRole, navigableRole.id() + idSuffix + "_b");
            m.register(nav_b);
            newPropsForAssociationClass.add(nav_b);
            nav_b.setInClass(assocCi);
            nav_b.setCardinality(new Multiplicity());
            nav_b.setTaggedValue("fromAssociationClassTo", other.inClass().name(), false);
            GenericPropertyInfo other_b = m.createCopy(other, other.id() + idSuffix + "_b");
            if (other_b.isNavigable()) {
                m.register(other_b);
                ((GenericClassInfo)other.inClass()).addProperty(other_b, GenericModel.PropertyCopyDuplicatBehaviorIndicator.OVERWRITE);
            }
            Type ti_other_b = new Type();
            ti_other_b.id = assocCi.id();
            ti_other_b.name = assocCi.name();
            other_b.setTypeInfo(ti_other_b);
            other_b.setTaggedValue("toAssociationClassFrom", other.inClass().name(), false);
            GenericAssociationInfo ai_b = m.createCopy(association, association.id() + idSuffix + "_b");
            ai_b.setAssocClass(null);
            m.addAssociation(ai_b);
            nav_b.setAssociation(ai_b);
            other_b.setAssociation(ai_b);
            if (ai_b.end1() == navigableRole) {
                ai_b.setEnd1(nav_b);
                ai_b.setEnd2(other_b);
            } else {
                ai_b.setEnd1(other_b);
                ai_b.setEnd2(nav_b);
            }
            Collections.sort(newPropsForAssociationClass, new Comparator<GenericPropertyInfo>(){

                @Override
                public int compare(GenericPropertyInfo o1, GenericPropertyInfo o2) {
                    int tmp = o1.name().compareTo(o2.name());
                    if (tmp == 0) {
                        return o1.compareTo(o2);
                    }
                    return tmp;
                }
            });
            assocCi.addPropertiesAtBottom(newPropsForAssociationClass, GenericModel.PropertyCopyDuplicatBehaviorIndicator.OVERWRITE);
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class AssociationClassMapper";
            }
            case 101: {
                return "";
            }
            case 102: {
                return "Association role: '$1$'";
            }
        }
        return "(" + AssociationClassMapper.class.getName() + ") Unknown message with number: " + mnr;
    }
}

