/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Descriptors;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeParseException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Descriptors.DescriptorTransformer;
import de.interactive_instruments.ShapeChange.Transformation.Descriptors.DescriptorValueConfigurationEntry;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class DescriptorTransformerConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>();
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTransformerParameters());
        boolean bl = isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        if (config.getAllRules().contains("rule-trf-all-updateDescriptors")) {
            try {
                List<DescriptorValueConfigurationEntry> list = DescriptorTransformer.parseAndValidateDescriptorValueConfigurationEntries(config.getAdvancedProcessConfigurations());
            }
            catch (ShapeChangeParseException e) {
                isValid = false;
                result.addError(this, 100, e.getMessage());
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 100: {
                return "Invalid DescriptorValue element(s) encountered. Details: $1$";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

