/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Descriptors;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.ModelElementSelectionInfo;
import de.interactive_instruments.ShapeChange.ModelElementSelectionParseException;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeParseException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Descriptors.DescriptorValueConfigurationEntry;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Util.XMLUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescriptorTransformer
implements MessageSource,
Transformer {
    public static final String RULE_UPDATE_DESCRIPTORS = "rule-trf-all-updateDescriptors";
    private GenericModel genModel = null;
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public void process(GenericModel genModel, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.genModel = genModel;
        this.options = options;
        this.result = result;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (rules.isEmpty()) {
            return;
        }
        if (rules.contains(RULE_UPDATE_DESCRIPTORS)) {
            this.applyRuleUpdateDescriptors(trfConfig);
        }
    }

    private void applyRuleUpdateDescriptors(TransformerConfiguration trfConfig) {
        if (trfConfig.getAdvancedProcessConfigurations() == null) {
            this.result.addWarning(this, 100);
        } else {
            List<DescriptorValueConfigurationEntry> dvcEntries;
            try {
                dvcEntries = DescriptorTransformer.parseAndValidateDescriptorValueConfigurationEntries(trfConfig.getAdvancedProcessConfigurations());
            }
            catch (ShapeChangeParseException e) {
                this.result.addError(this, 102, e.getMessage());
                return;
            }
            if (!dvcEntries.isEmpty()) {
                ArrayList<Info> infoTypesFromSelectedSchemas = new ArrayList<Info>();
                infoTypesFromSelectedSchemas.addAll(this.genModel.allPackagesFromSelectedSchemas());
                infoTypesFromSelectedSchemas.addAll(this.genModel.selectedSchemaClasses());
                infoTypesFromSelectedSchemas.addAll(this.genModel.selectedSchemaProperties());
                infoTypesFromSelectedSchemas.addAll(this.genModel.selectedSchemaAssociations());
                for (Info i : infoTypesFromSelectedSchemas) {
                    for (DescriptorValueConfigurationEntry dvce : dvcEntries) {
                        if (!dvce.getModelElementSelectionInfo().matches(i)) continue;
                        if (dvce.hasValues()) {
                            i.descriptors().put(dvce.getDescriptor(), dvce.getCopyOfValues());
                            continue;
                        }
                        i.descriptors().remove(dvce.getDescriptor());
                    }
                }
            }
        }
    }

    static List<DescriptorValueConfigurationEntry> parseAndValidateDescriptorValueConfigurationEntries(Element advancedProcessConfigurations) throws ShapeChangeParseException {
        ArrayList<DescriptorValueConfigurationEntry> dvcEntries = new ArrayList<DescriptorValueConfigurationEntry>();
        if (advancedProcessConfigurations == null) {
            return dvcEntries;
        }
        ArrayList<Element> dvEs = new ArrayList<Element>();
        NodeList dvNl = advancedProcessConfigurations.getElementsByTagName("DescriptorValue");
        if (dvNl != null && dvNl.getLength() != 0) {
            for (int k = 0; k < dvNl.getLength(); ++k) {
                Node n = dvNl.item(k);
                if (n.getNodeType() != 1) continue;
                dvEs.add((Element)n);
            }
        }
        ArrayList<CallSite> compilationErrors = new ArrayList<CallSite>();
        for (int i = 0; i < dvEs.size(); ++i) {
            String indexForMsg = "" + (i + 1);
            Element dvE = (Element)dvEs.get(i);
            String name = dvE.getAttribute("descriptorName");
            Descriptor descriptor = null;
            try {
                descriptor = Descriptor.valueOf(name.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new ShapeChangeParseException("Descriptor '" + name + "' of " + indexForMsg + " DescriptorValue element from the transformer configuration is unknown");
            }
            ArrayList<LangString> descriptorValues = new ArrayList<LangString>();
            Element valuesE = XMLUtil.getFirstElement(dvE, "values");
            if (valuesE != null) {
                List<Element> langStringEs = XMLUtil.getChildElements(valuesE, "LangString");
                for (Element lsE : langStringEs) {
                    String value;
                    String lang = null;
                    if (lsE.hasAttribute("lang")) {
                        lang = lsE.getAttribute("lang");
                    }
                    if (StringUtils.isBlank((CharSequence)(value = lsE.getTextContent()))) {
                        value = null;
                    }
                    if (lang == null && value == null) continue;
                    LangString ls = new LangString(value, lang);
                    descriptorValues.add(ls);
                }
            }
            ModelElementSelectionInfo meselect = ModelElementSelectionInfo.parse(dvE);
            try {
                meselect.validate();
            }
            catch (ModelElementSelectionParseException e) {
                compilationErrors.add((CallSite)((Object)(indexForMsg + " DescriptorValue element: " + e.getMessage())));
            }
            dvcEntries.add(new DescriptorValueConfigurationEntry(descriptor, descriptorValues, meselect));
        }
        if (!compilationErrors.isEmpty()) {
            throw new ShapeChangeParseException(StringUtils.join(compilationErrors, (String)", "));
        }
        return dvcEntries;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 4: {
                return "Context: supertype '$1$'";
            }
            case 5: {
                return "Context: subtype '$1$'";
            }
            case 10: {
                return "Syntax exception for regular expression '$1$' of parameter '$2$'. Message is: $3$. $4$ will not have any effect.";
            }
            case 100: {
                return "No 'advancedProcessConfigurations' element present in the configuration. Descriptors will not be updated.";
            }
            case 101: {
                return "";
            }
            case 102: {
                return "Invalid DescriptorValue element(s) encountered. rule-trf-all-updateDescriptors will be ignored. Details: $1$";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

