/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Constraints;

import de.interactive_instruments.ShapeChange.FOL.FolExpression;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.FolConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericOclConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericTextConstraint;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.SBVR.Sbvr2FolParser;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class ConstraintParserAndValidator
implements Transformer {
    @Override
    public void process(GenericModel m, Options o, TransformerConfiguration trfConfig, ShapeChangeResult r) throws ShapeChangeAbortException {
        Sbvr2FolParser sbvrParser = new Sbvr2FolParser(m);
        for (PackageInfo pkg : m.selectedSchemas()) {
            for (ClassInfo tmp : m.classes(pkg)) {
                GenericClassInfo genCi = (GenericClassInfo)tmp;
                if (genCi.category() == 16) continue;
                List<Constraint> ciCons = genCi.directConstraints();
                if (ciCons != null) {
                    Collections.sort(ciCons, ConstraintComparators.NAME);
                    Vector<Constraint> newConstraints = new Vector<Constraint>();
                    for (Constraint con : ciCons) {
                        if (con instanceof OclConstraint) {
                            OclConstraint oclCon = (OclConstraint)con;
                            newConstraints.add(ConstraintParserAndValidator.parse(oclCon, genCi));
                            continue;
                        }
                        if (con instanceof FolConstraint) {
                            FolConstraint folCon = (FolConstraint)con;
                            newConstraints.add(ConstraintParserAndValidator.parse(folCon, sbvrParser, genCi, r));
                            continue;
                        }
                        newConstraints.add(con);
                    }
                    genCi.setDirectConstraints(newConstraints);
                }
                if (genCi.properties() == null) continue;
                for (PropertyInfo pi : genCi.properties().values()) {
                    GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                    List<Constraint> piCons = genPi.constraints();
                    if (piCons == null) continue;
                    Collections.sort(piCons, ConstraintComparators.NAME);
                    Vector<Constraint> newConstraints = new Vector<Constraint>();
                    for (Constraint con : piCons) {
                        if (con instanceof OclConstraint) {
                            OclConstraint oclCon = (OclConstraint)con;
                            newConstraints.add(ConstraintParserAndValidator.parse(oclCon, genPi));
                            continue;
                        }
                        newConstraints.add(con);
                    }
                }
            }
        }
    }

    public static Constraint parse(FolConstraint con, Sbvr2FolParser parser, GenericClassInfo genCi, ShapeChangeResult r) {
        if (con.sourceType().equals("SBVR")) {
            con.mergeComments(new String[]{con.text()});
            FolExpression folExpr = parser.parse(con);
            if (folExpr != null) {
                con.setFolExpression(folExpr);
                return con;
            }
            return new GenericTextConstraint(genCi, (Constraint)con);
        }
        ShapeChangeResult.MessageContext ctx = r.addError(null, 38, con.sourceType());
        ctx.addDetail(null, 39, con.name(), con.contextModelElmt().fullNameInSchema());
        return new GenericTextConstraint(genCi, (Constraint)con);
    }

    public static Constraint parse(OclConstraint con, GenericClassInfo genCi) {
        GenericOclConstraint validated = new GenericOclConstraint(genCi, con);
        if (validated.syntaxTree() != null) {
            return validated;
        }
        GenericTextConstraint fallback = new GenericTextConstraint(genCi, (Constraint)con);
        return fallback;
    }

    public static Constraint parse(OclConstraint con, GenericPropertyInfo genPi) {
        GenericOclConstraint validated = new GenericOclConstraint(genPi, con);
        if (validated.syntaxTree() != null) {
            return validated;
        }
        GenericTextConstraint fallback = new GenericTextConstraint(genPi, (Constraint)con);
        return fallback;
    }

    public static class ConstraintComparators {
        public static Comparator<Constraint> NAME = new Comparator<Constraint>(){

            @Override
            public int compare(Constraint o1, Constraint o2) {
                return o1.name().compareTo(o2.name());
            }
        };
    }
}

