/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Constraints;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConstraintConverterConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("geometryRepresentationConstraintRegex", "geometryRepresentationTypes", "geometryRepresentationValueTypeRegex", "valueTypeRepresentationConstraintRegex", "valueTypeRepresentationTypes").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTransformerParameters());
        isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        Map<String, ProcessRuleSet> ruleSets = config.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        String geomRestrToGeomTVRule = null;
        if (rules.contains("rule-trf-cls-constraints-geometryRestrictionToGeometryTV-inclusion")) {
            geomRestrToGeomTVRule = "rule-trf-cls-constraints-geometryRestrictionToGeometryTV-inclusion";
        } else if (rules.contains("rule-trf-cls-constraints-geometryRestrictionToGeometryTV-exclusion")) {
            geomRestrToGeomTVRule = "rule-trf-cls-constraints-geometryRestrictionToGeometryTV-exclusion";
        }
        if (geomRestrToGeomTVRule != null) {
            String geomRepConstrRegex = config.parameterAsString("geometryRepresentationConstraintRegex", null, false, false);
            if (geomRepConstrRegex == null) {
                isValid = false;
                result.addError(this, 100, "geometryRepresentationConstraintRegex", geomRestrToGeomTVRule);
            } else {
                try {
                    Pattern.compile(geomRepConstrRegex);
                }
                catch (PatternSyntaxException e) {
                    isValid = false;
                    result.addError(this, 4, "geometryRepresentationConstraintRegex", geomRepConstrRegex, e.getMessage());
                }
            }
            List<String> geomRepTypesIn = config.parameterAsStringList("geometryRepresentationTypes", null, true, true, ";");
            if (geomRepTypesIn == null || geomRepTypesIn.isEmpty()) {
                isValid = false;
                result.addError(this, 100, "geometryRepresentationTypes", geomRestrToGeomTVRule);
            } else {
                for (String s : geomRepTypesIn) {
                    String[] map = s.split("=");
                    if (map.length == 2 && !map[0].trim().isEmpty() && !map[1].trim().isEmpty()) continue;
                    isValid = false;
                    result.addError(this, 101, s);
                    break;
                }
            }
        }
        if (rules.contains("rule-trf-cls-constraints-geometryRestrictionToGeometryTV-typesWithoutRestriction-byValueTypeMatch")) {
            String geomRepValueTypeRegex = config.parameterAsString("geometryRepresentationValueTypeRegex", null, false, false);
            if (geomRepValueTypeRegex == null) {
                isValid = false;
                result.addError(this, 100, "geometryRepresentationValueTypeRegex", "rule-trf-cls-constraints-geometryRestrictionToGeometryTV-typesWithoutRestriction-byValueTypeMatch");
            } else {
                try {
                    Pattern.compile(geomRepValueTypeRegex);
                }
                catch (PatternSyntaxException e) {
                    isValid = false;
                    result.addError(this, 4, "geometryRepresentationValueTypeRegex", geomRepValueTypeRegex, e.getMessage());
                }
            }
        }
        if (rules.contains("rule-trf-cls-constraints-valueTypeRestrictionToTV-exclusion")) {
            String valueTypeRepresentationConstraintRegex = config.parameterAsString("valueTypeRepresentationConstraintRegex", null, false, false);
            if (valueTypeRepresentationConstraintRegex == null) {
                isValid = false;
                result.addError(this, 100, "valueTypeRepresentationConstraintRegex", "rule-trf-cls-constraints-valueTypeRestrictionToTV-exclusion");
            } else {
                try {
                    Pattern.compile(valueTypeRepresentationConstraintRegex);
                }
                catch (PatternSyntaxException e) {
                    isValid = false;
                    result.addError(this, 4, "valueTypeRepresentationConstraintRegex", valueTypeRepresentationConstraintRegex, e.getMessage());
                }
            }
            String valueTypeRepresentationTypes = config.parameterAsString("valueTypeRepresentationTypes", null, false, false);
            if (valueTypeRepresentationTypes == null) {
                isValid = false;
                result.addError(this, 100, "valueTypeRepresentationTypes", "rule-trf-cls-constraints-valueTypeRestrictionToTV-exclusion");
            } else {
                Pattern valuePattern = Pattern.compile("^\\s*(\\w+)\\s*\\{\\s*(\\w+)\\s*(=\\s*\\w+\\s*)?(,\\s*(\\w+)\\s*(=\\s*\\w+\\s*)?)*\\}\\s*(;\\s*(\\w+)\\s*\\{\\s*(\\w+)\\s*(=\\s*\\w+\\s*)?(,\\s*(\\w+)\\s*(=\\s*\\w+\\s*)?)*\\}\\s*)*$");
                Matcher matcher = valuePattern.matcher(valueTypeRepresentationTypes);
                if (!matcher.matches()) {
                    isValid = false;
                    result.addError(this, 102, "valueTypeRepresentationTypes");
                }
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 4: {
                return "Syntax exception for regular expression value of configuration parameter '$1$'. Regular expression value was: $2$. Exception message: $3$.";
            }
            case 100: {
                return "Parameter '$1$' is required for rule '$2$' but no actual value was found in the configuration.";
            }
            case 101: {
                return "Parameter 'geometryRepresentationTypes' is malformed. Multiple values must be separated by semicolon, and each value must contain two non-empty strings, separated by '='. Found: '$1$' (check the other values as well).";
            }
            case 102: {
                return "Parameter '$1$' is invalid. Check the structure of the parameter value.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

