/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Constraints;

import com.google.common.base.Joiner;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Util.ValueTypeOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class ConstraintConverter
implements Transformer,
MessageSource {
    private static final Joiner commaJoiner = Joiner.on((String)",").skipNulls();
    public static final String PARAM_GEOM_REP_CONSTRAINT_REGEX = "geometryRepresentationConstraintRegex";
    public static final String PARAM_VALUETYPE_REP_CONSTRAINT_REGEX = "valueTypeRepresentationConstraintRegex";
    public static final String PARAM_GEOM_REP_TYPES = "geometryRepresentationTypes";
    public static final String PARAM_VALUETYPE_REP_TYPES = "valueTypeRepresentationTypes";
    public static final String PARAM_GEOM_REP_VALUE_TYPE_REGEX = "geometryRepresentationValueTypeRegex";
    public static final String VALUE_TYPE_OPTIONS_TV_NAME = "valueTypeOptions";
    public static final String RULE_TRF_CLS_CONSTRAINTS_GEOMRESTRICTIONTOGEOMTV_INCL = "rule-trf-cls-constraints-geometryRestrictionToGeometryTV-inclusion";
    public static final String RULE_TRF_CLS_CONSTRAINTS_GEOMRESTRICTIONTOGEOMTV_EXCL = "rule-trf-cls-constraints-geometryRestrictionToGeometryTV-exclusion";
    public static final String RULE_TRF_CLS_CONSTRAINTS_VALUETYPERESTRICTIONTOTV_EXCL = "rule-trf-cls-constraints-valueTypeRestrictionToTV-exclusion";
    public static final String RULE_TRF_CLS_CONSTRAINTS_GEOMRESTRICTIONTOGEOMTV_NORESTRICTION_BYVALUETYPE = "rule-trf-cls-constraints-geometryRestrictionToGeometryTV-typesWithoutRestriction-byValueTypeMatch";
    public static final String RULE_TRF_CLS_CONSTRAINTS_CODELIST_RESTRICTION_TO_TV = "rule-trf-cls-constraints-codeListRestrictionToTV";
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public void process(GenericModel genModel, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.options = options;
        this.result = result;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (rules.isEmpty()) {
            return;
        }
        if (rules.contains(RULE_TRF_CLS_CONSTRAINTS_GEOMRESTRICTIONTOGEOMTV_INCL)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_CONSTRAINTS_GEOMRESTRICTIONTOGEOMTV_INCL);
            this.applyRuleGeometryRestrictionToGeometryTaggedValue(genModel, trfConfig, rules, true);
        } else if (rules.contains(RULE_TRF_CLS_CONSTRAINTS_GEOMRESTRICTIONTOGEOMTV_EXCL)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_CONSTRAINTS_GEOMRESTRICTIONTOGEOMTV_EXCL);
            this.applyRuleGeometryRestrictionToGeometryTaggedValue(genModel, trfConfig, rules, false);
        } else if (rules.contains(RULE_TRF_CLS_CONSTRAINTS_CODELIST_RESTRICTION_TO_TV)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_CONSTRAINTS_CODELIST_RESTRICTION_TO_TV);
            this.applyRuleCodeListRestrictionToTaggedValue(genModel, trfConfig, rules);
        } else if (rules.contains(RULE_TRF_CLS_CONSTRAINTS_VALUETYPERESTRICTIONTOTV_EXCL)) {
            result.addProcessFlowInfo(null, 20103, RULE_TRF_CLS_CONSTRAINTS_VALUETYPERESTRICTIONTOTV_EXCL);
            this.applyRuleValueTypeRestrictionToPropertyTaggedValue(genModel, trfConfig, rules);
        }
    }

    private void applyRuleValueTypeRestrictionToPropertyTaggedValue(GenericModel genModel, TransformerConfiguration config, Set<String> rules) {
        String valueTypeRepConstrRegex = config.parameterAsString(PARAM_VALUETYPE_REP_CONSTRAINT_REGEX, null, false, false);
        Pattern valueTypeRepConstrPattern = null;
        if (valueTypeRepConstrRegex != null) {
            try {
                valueTypeRepConstrPattern = Pattern.compile(valueTypeRepConstrRegex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        List<String> valueTypesRepTypesIn = config.parameterAsStringList(PARAM_VALUETYPE_REP_TYPES, null, true, true, ";");
        TreeMap valueTypeRepTypes = new TreeMap();
        boolean foundInvalidValueTypeRepTypeValue = false;
        if (valueTypesRepTypesIn != null && !valueTypesRepTypesIn.isEmpty()) {
            Pattern valueTypeRepTypesDetectionPattern = Pattern.compile("^\\s*(\\w+)\\s*\\{(.*)\\}\\s*$");
            for (String s : valueTypesRepTypesIn) {
                Matcher m = valueTypeRepTypesDetectionPattern.matcher(s);
                if (!m.matches()) continue;
                String supertypeName = m.group(1);
                String suptertypeDefinitions = m.group(2);
                String[] mappings = StringUtils.split((String)suptertypeDefinitions, (String)",");
                TreeMap<String, Optional<String>> typeMap = new TreeMap<String, Optional<String>>();
                for (String mapping : mappings) {
                    String[] map = StringUtils.split((String)mapping, (String)"=");
                    if (map.length > 2 || map[0].trim().isEmpty()) {
                        foundInvalidValueTypeRepTypeValue = true;
                        break;
                    }
                    String typeMapKey = map[0].trim();
                    String typeMapValue = map.length == 2 ? map[1].trim() : null;
                    typeMap.put(typeMapKey, Optional.ofNullable(typeMapValue));
                }
                valueTypeRepTypes.put(supertypeName, typeMap);
            }
        }
        if (foundInvalidValueTypeRepTypeValue || valueTypeRepConstrPattern == null || valueTypeRepTypes.size() == 0) {
            this.result.addError(this, 300);
        } else {
            Pattern propertyNameDetectionPattern = Pattern.compile("^.*inv: (self\\.)?(\\w+).*$");
            Pattern disallowedKindDetectionPattern = Pattern.compile("oclIsKindOf\\((\\w+)");
            Pattern disallowedTypeDetectionPattern = Pattern.compile("oclIsTypeOf\\((\\w+)");
            for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
                ShapeChangeResult.MessageContext mc;
                if (genCi.category() == 3 || genCi.category() == 2) continue;
                ValueTypeOptions vto = new ValueTypeOptions();
                for (Constraint con : genCi.constraints()) {
                    Matcher matcherOnPropertyName;
                    Matcher matcherOnConstraintName = valueTypeRepConstrPattern.matcher(con.name());
                    if (!matcherOnConstraintName.matches() || !(matcherOnPropertyName = propertyNameDetectionPattern.matcher(con.text())).matches()) continue;
                    String propertyName = matcherOnPropertyName.group(2);
                    PropertyInfo genPi = genCi.property(propertyName);
                    String propertyValueTypeName = genPi.typeInfo().name;
                    if (!valueTypeRepTypes.containsKey(propertyValueTypeName)) continue;
                    HashSet<String> disallowedTypes = new HashSet<String>();
                    Matcher matcherOnOclIsKindOf = disallowedKindDetectionPattern.matcher(con.text());
                    while (matcherOnOclIsKindOf.find()) {
                        String type = matcherOnOclIsKindOf.group(1);
                        disallowedTypes.add(type);
                        ClassInfo typeCi = genModel.classByName(type);
                        if (typeCi == null) continue;
                        SortedSet<ClassInfo> allSubtypes = typeCi.subtypesInCompleteHierarchy();
                        for (ClassInfo classInfo : allSubtypes) {
                            disallowedTypes.add(classInfo.name());
                        }
                    }
                    Matcher matcherOnOclIsTypeOf = disallowedTypeDetectionPattern.matcher(con.text());
                    while (matcherOnOclIsTypeOf.find()) {
                        String type = matcherOnOclIsTypeOf.group(1);
                        disallowedTypes.add(type);
                    }
                    SortedMap typeMap = (SortedMap)valueTypeRepTypes.get(propertyValueTypeName);
                    TreeMap<String, Optional> generallyAllowedTypeMap = new TreeMap<String, Optional>();
                    for (Map.Entry entry : typeMap.entrySet()) {
                        String generallyAllowedTypeName = (String)entry.getKey();
                        Optional vtTargetName = (Optional)entry.getValue();
                        generallyAllowedTypeMap.put(generallyAllowedTypeName, vtTargetName);
                        ClassInfo typeCi = genModel.classByName(generallyAllowedTypeName);
                        if (typeCi == null) continue;
                        SortedSet<ClassInfo> allSubtypes = typeCi.subtypesInCompleteHierarchy();
                        for (ClassInfo subtype : allSubtypes) {
                            generallyAllowedTypeMap.put(subtype.name(), (Optional)typeMap.get(subtype.name()));
                        }
                    }
                    TreeSet<String> allowedTypeNames = new TreeSet<String>();
                    for (Map.Entry valueType : generallyAllowedTypeMap.entrySet()) {
                        String vtName = (String)valueType.getKey();
                        Optional vtTargetName = (Optional)valueType.getValue();
                        if (disallowedTypes.contains(vtName)) continue;
                        if (vtTargetName == null || vtTargetName.isEmpty()) {
                            allowedTypeNames.add(vtName);
                            continue;
                        }
                        allowedTypeNames.add((String)vtTargetName.get());
                    }
                    if (allowedTypeNames.size() <= 0) continue;
                    vto.add(propertyName, !genPi.isAttribute() && genPi.association().assocClass() != null, allowedTypeNames);
                }
                if (vto.isEmpty()) continue;
                String oldValue = genCi.taggedValue(VALUE_TYPE_OPTIONS_TV_NAME);
                if (StringUtils.isNotBlank((CharSequence)oldValue) && (mc = this.result.addWarning(this, 301, genCi.name(), oldValue, vto.toString())) != null) {
                    mc.addDetail(this, 1, genCi.fullName());
                }
                genCi.setTaggedValue(VALUE_TYPE_OPTIONS_TV_NAME, vto.toString(), false);
            }
        }
    }

    private void applyRuleCodeListRestrictionToTaggedValue(GenericModel genModel, TransformerConfiguration trfConfig, Set<String> rules) {
        Pattern regex1 = Pattern.compile("(?s).*inv:\\s*(?:(?:self\\.)?(?:\\w+)->notEmpty\\(\\) implies)?\\s*(?:self\\.)?(\\w+)\\.oclIsTypeOf\\((\\w+)\\)\\s*");
        Pattern regex2 = Pattern.compile("(?s).*inv:\\s*(?:(?:self\\.)?\\w+->notEmpty\\(\\) implies )?(?:self\\.)?(\\w+)->forAll\\(\\w+\\|\\w+\\.oclIsTypeOf\\((\\w+)\\)\\)\\s*");
        for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
            if (genCi.category() == 3 || genCi.category() == 2 || genCi.category() == 7) continue;
            for (Constraint con : genCi.constraints()) {
                Matcher matcher = null;
                Matcher matcher1 = regex1.matcher(con.text());
                Matcher matcher2 = regex2.matcher(con.text());
                if (matcher1.matches()) {
                    matcher = matcher1;
                } else if (matcher2.matches()) {
                    matcher = matcher2;
                }
                if (matcher == null) continue;
                String propName = matcher.group(1);
                String typeName = matcher.group(2);
                PropertyInfo pi = genCi.property(propName);
                if (pi == null) {
                    this.result.addError(this, 200, con.name(), genCi.name(), propName);
                    continue;
                }
                ClassInfo ci = genModel.classByName(typeName);
                if (ci == null) {
                    this.result.addError(this, 201, con.name(), genCi.name(), typeName);
                    continue;
                }
                if (!pi.typeInfo().name.equalsIgnoreCase("CharacterString") || ci.category() != 2) continue;
                this.result.addInfo(this, 202, con.name(), genCi.name(), propName, typeName);
                ((GenericPropertyInfo)pi).setTaggedValue("codeListRestriction", typeName, false);
            }
        }
    }

    private void applyRuleGeometryRestrictionToGeometryTaggedValue(GenericModel genModel, TransformerConfiguration config, Set<String> rules, boolean isInclusion) {
        String geomRepConstrRegex = config.parameterAsString(PARAM_GEOM_REP_CONSTRAINT_REGEX, null, false, false);
        Pattern geomRepConstrPattern = null;
        if (geomRepConstrRegex != null) {
            try {
                geomRepConstrPattern = Pattern.compile(geomRepConstrRegex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        String geomRepValueTypeRegex = config.parameterAsString(PARAM_GEOM_REP_VALUE_TYPE_REGEX, null, false, false);
        Pattern geomRepValueTypePattern = null;
        if (geomRepValueTypeRegex != null && rules.contains(RULE_TRF_CLS_CONSTRAINTS_GEOMRESTRICTIONTOGEOMTV_NORESTRICTION_BYVALUETYPE)) {
            try {
                geomRepValueTypePattern = Pattern.compile(geomRepValueTypeRegex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        List<String> geomRepTypesIn = config.parameterAsStringList(PARAM_GEOM_REP_TYPES, null, true, true, ";");
        HashMap<String, String> geomRepTypes = new HashMap<String, String>();
        boolean foundInvalidGeomRepTypeValue = false;
        if (geomRepTypesIn != null && !geomRepTypesIn.isEmpty()) {
            for (String s : geomRepTypesIn) {
                String[] map = s.split("=");
                if (map.length != 2 || map[0].trim().isEmpty() || map[1].trim().isEmpty()) {
                    foundInvalidGeomRepTypeValue = true;
                    break;
                }
                geomRepTypes.put(map[0].trim(), map[1].trim());
            }
        }
        if (foundInvalidGeomRepTypeValue || geomRepConstrPattern == null || geomRepTypes.size() == 0) {
            this.result.addError(this, 100);
        } else {
            for (GenericClassInfo genCi : genModel.selectedSchemaClasses()) {
                ShapeChangeResult.MessageContext mc;
                if (genCi.category() == 3 || genCi.category() == 2) continue;
                TreeSet<String> geometryTVValues = new TreeSet<String>();
                int countGeomRepConstrFound = 0;
                for (Constraint con : genCi.constraints()) {
                    Matcher matcherOnConstraintName = geomRepConstrPattern.matcher(con.name());
                    if (!matcherOnConstraintName.matches() || ++countGeomRepConstrFound != 1) continue;
                    for (Map.Entry geomRepType : geomRepTypes.entrySet()) {
                        String geomTypeName = (String)geomRepType.getKey();
                        String geomTypeAbbrev = (String)geomRepType.getValue();
                        if ((!isInclusion || !con.text().contains(geomTypeName)) && (isInclusion || con.text().contains(geomTypeName))) continue;
                        geometryTVValues.add(geomTypeAbbrev);
                    }
                }
                if (countGeomRepConstrFound > 1) {
                    ShapeChangeResult.MessageContext mc2 = this.result.addError(this, 101, "" + countGeomRepConstrFound, genCi.name());
                    if (mc2 != null) {
                        mc2.addDetail(this, 1, genCi.fullName());
                    }
                } else if (countGeomRepConstrFound == 0 && geomRepValueTypePattern != null) {
                    for (PropertyInfo pi : genCi.propertiesAll()) {
                        Matcher matcherOnPiTypeName = geomRepValueTypePattern.matcher(pi.typeInfo().name);
                        if (!matcherOnPiTypeName.matches()) continue;
                        for (String geomTypeAbbrev : geomRepTypes.values()) {
                            geometryTVValues.add(geomTypeAbbrev);
                        }
                    }
                }
                if (geometryTVValues.size() <= 0) continue;
                String join = commaJoiner.join(geometryTVValues);
                String geometryTV = genCi.taggedValue("geometry");
                if (StringUtils.isNotBlank((CharSequence)geometryTV) && (mc = this.result.addWarning(this, 102, genCi.name(), geometryTV, join)) != null) {
                    mc.addDetail(this, 1, genCi.fullName());
                }
                genCi.setTaggedValue("geometry", join, false);
            }
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 100: {
                return "Invalid value(s) for configuration parameters 'geometryRepresentationConstraintRegex' and/or 'geometryRepresentationTypes'. For further details, check the configuration validator log messages.";
            }
            case 101: {
                return "Found multiple ($1$) constraints to restrict geometry representation on type '$2$'. An arbitrary constraint is chosen.";
            }
            case 102: {
                return "Overwriting tagged value 'geometry' in type '$1$'. Old value: '$2$'. New value: '$3$'.";
            }
            case 200: {
                return "Presence of code list restriction could not be determined for type restriction constraint '$1$' of class '$2$'. Property '$3$' identified by the type restriction was not found for the class. The constraint will be ignored.";
            }
            case 201: {
                return "Presence of code list restriction could not be determined for type restriction constraint '$1$' of class '$2$'. Type '$3$' identified by the type restriction was not found in the model. The constraint will be ignored.";
            }
            case 202: {
                return "Code list restriction identified for type restriction constraint '$1$' of class '$2$'. Property '$3$' is restricted to code list '$4$'.";
            }
            case 300: {
                return "Invalid value(s) for configuration parameters 'valueTypeRepresentationConstraintRegex' and/or 'valueTypeRepresentationTypes'. For further details, check the configuration validator log messages.";
            }
            case 301: {
                return "Overwriting tagged value 'valueTypeOptions' in type '$1$'. Old value: '$2$'. New value: '$3$'.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

