/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.CityGML;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CityGMLTransformer
implements MessageSource,
Transformer {
    public static final String RULE_CITYGML_CREATE_ADE = "rule-trf-CityGML-createADE";
    public static final String TV_CITYGML_TARGET = "cityGmlTargetType";
    private GenericModel genModel = null;
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public void process(GenericModel genModel, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.genModel = genModel;
        this.options = options;
        this.result = result;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (rules.isEmpty()) {
            return;
        }
        if (rules.contains(RULE_CITYGML_CREATE_ADE)) {
            this.applyRuleCreateADE(genModel, trfConfig);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyRuleCreateADE(GenericModel genModel, TransformerConfiguration trfConfig) {
        ShapeChangeResult.MessageContext mc;
        String qname;
        GenericClassInfo cityObject = null;
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            if (genCi.category() != 1 || !genCi.name().equals("_CityObject") || genCi.stereotype("adeelement")) continue;
            cityObject = genCi;
            break;
        }
        if (cityObject == null) {
            this.result.addError(this, 102);
            return;
        }
        HashMap<String, GenericClassInfo> classByQname = new HashMap<String, GenericClassInfo>();
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            if (genCi.pkg() == null || genCi.pkg().xmlns() == null) continue;
            qname = genCi.qname();
            if (classByQname.containsKey(qname)) {
                GenericClassInfo existingCls = (GenericClassInfo)classByQname.get(qname);
                mc = this.result.addWarning(this, 100, qname);
                if (mc == null) continue;
                mc.addDetail(this, 1, existingCls.fullNameInSchema());
                mc.addDetail(this, 1, genCi.fullNameInSchema());
                continue;
            }
            classByQname.put(qname, genCi);
        }
        Iterator<GenericClassInfo> iterator = genModel.selectedSchemaClasses().iterator();
        while (true) {
            GenericClassInfo targetType;
            GenericClassInfo genCi;
            block13: {
                if (!iterator.hasNext()) {
                    return;
                }
                genCi = iterator.next();
                if (genCi.category() != 1) continue;
                qname = null;
                if (StringUtils.isNotBlank((CharSequence)genCi.taggedValue(TV_CITYGML_TARGET))) {
                    qname = genCi.taggedValue(TV_CITYGML_TARGET).trim();
                } else if (trfConfig.hasMappingForType(RULE_CITYGML_CREATE_ADE, genCi.name())) {
                    qname = trfConfig.getMappingForType(RULE_CITYGML_CREATE_ADE, genCi.name()).getTargetType().trim();
                }
                targetType = null;
                if (StringUtils.isNotBlank((CharSequence)qname)) {
                    if (classByQname.containsKey(qname)) {
                        targetType = (GenericClassInfo)classByQname.get(qname);
                        break block13;
                    } else {
                        mc = this.result.addError(this, 101, genCi.name(), qname);
                        if (mc == null) continue;
                        mc.addDetail(this, 1, genCi.fullNameInSchema());
                        continue;
                    }
                }
                targetType = cityObject;
            }
            for (String supertypeId : genCi.supertypes()) {
                GenericClassInfo supertype = genModel.getGenClasses().get(supertypeId);
                supertype.setCategory(4);
            }
            targetType.addSubtype(genCi.id());
            genCi.addSupertype(targetType.id());
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 4: {
                return "Context: supertype '$1$'";
            }
            case 5: {
                return "Context: subtype '$1$'";
            }
            case 10: {
                return "Syntax exception for regular expression '$1$' of parameter '$2$'. Message is: $3$. $4$ will not have any effect.";
            }
            case 100: {
                return "QName '$1$' not unique within the model. No QName mapping will be established for the second class listed in the details of this message.";
            }
            case 101: {
                return "QName of class '$1$' is '$2$'. No mapping is available for this QName.";
            }
            case 102: {
                return "Type '_CityObject' was not found in the model. This type is required for processing of 'rule-trf-CityGML-createADE'. The rule will not be applied.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

