/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Adding;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.Profile.Profiles;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;

public class CodeListLoader
implements Transformer,
MessageSource {
    public static final String RULE_LOAD_CODES = "rule-trf-cls-loadCodes";
    public static final String TV_CL_SOURCE = "codeListSource";
    public static final String TV_CL_SOURCE_CHARSET = "codeListSourceCharset";
    public static final String TV_CL_SOURCE_REPRESENTATION = "codeListSourceRepresentation";
    private Options options = null;
    private ShapeChangeResult result = null;
    private Set<String> rules = null;
    private TransformerConfiguration config = null;
    private GenericModel model = null;

    @Override
    public void process(GenericModel model, Options options, TransformerConfiguration config, ShapeChangeResult result) throws ShapeChangeAbortException {
        this.model = model;
        this.options = options;
        this.result = result;
        this.config = config;
        Map<String, ProcessRuleSet> ruleSets = config.getRuleSets();
        this.rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                this.rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        if (this.rules.contains(RULE_LOAD_CODES)) {
            result.addProcessFlowInfo(null, 20103, RULE_LOAD_CODES);
            this.applyRuleLoadCodes();
        }
    }

    private void applyRuleLoadCodes() {
        for (GenericClassInfo genCi : this.model.selectedSchemaClasses()) {
            File tmpFile;
            Charset clSourceCharset;
            block31: {
                String clSourceRepresentationName;
                ShapeChangeResult.MessageContext mc;
                String clSource;
                block30: {
                    if (genCi.category() != 2 || !StringUtils.isNotBlank((CharSequence)genCi.taggedValue(TV_CL_SOURCE))) continue;
                    clSource = genCi.taggedValue(TV_CL_SOURCE).trim();
                    String clSourceCharsetName = genCi.taggedValue(TV_CL_SOURCE_CHARSET);
                    clSourceCharset = StandardCharsets.UTF_8;
                    if (StringUtils.isNotBlank((CharSequence)clSourceCharsetName)) {
                        try {
                            clSourceCharset = Charset.forName(clSourceCharsetName.trim());
                        }
                        catch (Exception e) {
                            mc = this.result.addError(this, 100, clSourceCharsetName.trim(), genCi.name(), e.getMessage());
                            if (mc == null) break block30;
                            mc.addDetail(this, 2, genCi.fullNameInSchema());
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)(clSourceRepresentationName = genCi.taggedValue(TV_CL_SOURCE_REPRESENTATION)))) {
                    mc = this.result.addError(this, 101, genCi.name());
                    if (mc == null) continue;
                    mc.addDetail(this, 2, genCi.fullNameInSchema());
                    continue;
                }
                CodeListSourceRepresentation clSourceRepresentation = null;
                try {
                    clSourceRepresentation = CodeListSourceRepresentation.fromString(clSourceRepresentationName);
                }
                catch (IllegalArgumentException e) {
                    ShapeChangeResult.MessageContext mc2 = this.result.addError(this, 102, genCi.name(), e.getMessage());
                    if (mc2 == null) continue;
                    mc2.addDetail(this, 2, genCi.fullNameInSchema());
                    continue;
                }
                if (clSourceRepresentation != CodeListSourceRepresentation.ISO_639_2) continue;
                tmpFile = null;
                try {
                    tmpFile = File.createTempFile("ShapeChange_CodeListLoader", genCi.name());
                    tmpFile.deleteOnExit();
                    if (clSource.toLowerCase().startsWith("http")) {
                        URL clSourceUrl = new URL(clSource);
                        URLConnection urlConn = clSourceUrl.openConnection();
                        urlConn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0");
                        FileUtils.copyInputStreamToFile((InputStream)urlConn.getInputStream(), (File)tmpFile);
                        break block31;
                    }
                    File clSourceFile = new File(clSource);
                    if (clSourceFile.exists()) {
                        FileUtils.copyFile((File)clSourceFile, (File)tmpFile);
                        break block31;
                    }
                    this.result.addError(this, 105, genCi.name(), clSourceFile.getAbsolutePath());
                }
                catch (Exception e) {
                    this.result.addError(this, 106, genCi.name(), clSource, tmpFile.getAbsolutePath(), e.getMessage());
                }
                continue;
            }
            TreeMap<String, String> nameEn_by_alpha3bib = new TreeMap<String, String>();
            try (FileInputStream fis = new FileInputStream(tmpFile);
                 BOMInputStream bomis = new BOMInputStream((InputStream)fis, false);
                 InputStreamReader reader = new InputStreamReader((InputStream)bomis, clSourceCharset);){
                CSVParser records = CSVFormat.newFormat((char)'|').withHeader(new String[]{"alpha3bibliographic", "alpha3terminologic", "alpha2", "name_en", "name_fr"}).parse((Reader)reader);
                for (CSVRecord record : records) {
                    String alpha3bib = StringUtils.strip((String)record.get("alpha3bibliographic"));
                    String name_en = StringUtils.strip((String)record.get("name_en"));
                    nameEn_by_alpha3bib.put(alpha3bib, name_en);
                }
                int index = 0;
                for (Map.Entry code : nameEn_by_alpha3bib.entrySet()) {
                    ++index;
                    String alpha3bib = (String)code.getKey();
                    String name_en = (String)code.getValue();
                    GenericPropertyInfo genPi = new GenericPropertyInfo(this.model, alpha3bib + "_codeFor_" + genCi.id(), alpha3bib);
                    genPi.setTaggedValues(this.options.taggedValueFactory(), false);
                    genPi.setStereotypes(this.options.stereotypesFactory());
                    Descriptors desc = new Descriptors();
                    desc.put(Descriptor.DEFINITION, name_en);
                    desc.put(Descriptor.DOCUMENTATION, name_en);
                    genPi.setDescriptors(desc);
                    genPi.setProfiles(new Profiles());
                    genPi.setDerived(false);
                    genPi.setReadOnly(false);
                    genPi.setAttribute(true);
                    genPi.setTypeInfo(null);
                    genPi.setNavigable(true);
                    genPi.setOrdered(false);
                    genPi.setUnique(false);
                    genPi.setOwned(false);
                    genPi.setComposition(true);
                    genPi.setAggregation(false);
                    genPi.setCardinality(new Multiplicity());
                    genPi.setInitialValue(null);
                    genPi.setInlineOrByReference("inlineOrByReference");
                    genPi.setInClass(genCi);
                    StructuredNumber strucNum = new StructuredNumber(index);
                    genPi.setSequenceNumber(strucNum, true);
                    genPi.setConstraints(null);
                    genPi.setAssociation(null);
                    genPi.setRestriction(false);
                    genPi.setNilReasonAllowed(false);
                    this.model.add(genPi, genCi);
                }
            }
            catch (IOException e) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 104, genCi.name(), e.getMessage());
                if (mc == null) continue;
                mc.addDetail(this, 2, genCi.fullNameInSchema());
            }
        }
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: property '$1$'";
            }
            case 2: {
                return "Context: class '$1$'";
            }
            case 100: {
                return "Could not load charset '$1$' defined for source of code list '$2$'. Message is: $3$. UTF-8 will be used as fallback.";
            }
            case 101: {
                return "No representation defined for source of code list '$1$'. The code list will be ignored.";
            }
            case 102: {
                return "Representation for source of code list '$1$' could not be identified. Message is: $2$. The code list will be ignored.";
            }
            case 103: {
                return "";
            }
            case 104: {
                return "Exception occurred while reading source file for code list '$1$'. Message is: '$2$'. The code list will be ignored.";
            }
            case 105: {
                return "Source file for code list '$1$' not found at location '$2$'. The code list will be ignored.";
            }
            case 106: {
                return "Could not copy source file for code list '$1$' from '$2$' to '$3$'. Message is: $4$. The code list will be ignored.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }

    public static enum CodeListSourceRepresentation {
        ISO_639_2("application/x.iso639_2");

        private String repName;

        private CodeListSourceRepresentation(String repName) {
            this.repName = repName;
        }

        public String getName() {
            return this.repName;
        }

        public static CodeListSourceRepresentation fromString(String repName) throws IllegalArgumentException {
            for (CodeListSourceRepresentation clsr : CodeListSourceRepresentation.values()) {
                if (!repName.equalsIgnoreCase(clsr.getName())) continue;
                return clsr;
            }
            throw new IllegalArgumentException("Code list representation '" + repName + "' is unknown.");
        }
    }
}

