/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Adding;

import de.interactive_instruments.ShapeChange.ClassSelector;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Stereotypes;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.PackageSelector;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.Util.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeCreator
implements Transformer,
MessageSource {
    private ShapeChangeResult result = null;
    private Options options = null;
    private GenericModel model = null;

    @Override
    public void process(GenericModel m, Options o, TransformerConfiguration trfConfig, ShapeChangeResult r) throws ShapeChangeAbortException {
        this.result = r;
        this.options = o;
        this.model = m;
        if (trfConfig.getAdvancedProcessConfigurations() == null) {
            this.result.addWarning(this, 1);
        } else {
            List<AttributeDefinition> attDefs = this.parseAttributeDefinitions(trfConfig.getAdvancedProcessConfigurations());
            for (AttributeDefinition attDef : attDefs) {
                Set<PackageInfo> packageSelection;
                PackageSelector ps = attDef.getPackageSelector();
                ClassSelector cs = attDef.getClassSelector();
                SortedSet<ClassInfo> classSelection = cs.selectClasses(this.model, packageSelection = ps.selectPackages(this.model));
                if (classSelection.isEmpty()) {
                    this.result.addInfo(this, 5, attDef.getName());
                    continue;
                }
                for (ClassInfo ci : classSelection) {
                    GenericClassInfo genCi = (GenericClassInfo)ci;
                    SortedMap<StructuredNumber, PropertyInfo> propsInCi = ci.properties();
                    PropertyInfo samePiInClass = null;
                    for (PropertyInfo existingProp : propsInCi.values()) {
                        if (!existingProp.name().equals(attDef.getName())) continue;
                        samePiInClass = existingProp;
                    }
                    if (samePiInClass != null) {
                        this.result.addWarning(this, 6, attDef.getName(), ci.name());
                        continue;
                    }
                    String id = attDef.getName() + "_addedToClass_" + genCi.id();
                    GenericPropertyInfo genPi = new GenericPropertyInfo(this.model, id.toString(), attDef.getName());
                    if (attDef.getDescriptors() != null) {
                        genPi.setDescriptors(attDef.getDescriptors().createCopy());
                    }
                    if (attDef.getAliasName() != null) {
                        genPi.descriptors().put(Descriptor.ALIAS, attDef.getAliasName());
                    }
                    genPi.setInitialValue(attDef.getInitialValue());
                    genPi.setDerived(attDef.isDerived());
                    genPi.setOrdered(attDef.isOrdered());
                    genPi.setUnique(attDef.isUnique());
                    genPi.setOwned(attDef.isOwned());
                    genPi.setReadOnly(attDef.isReadOnly());
                    genPi.setCardinality(attDef.getMultiplicity());
                    genPi.setTypeInfo(attDef.getType());
                    TaggedValues tvsForPi = this.options.taggedValueFactory(attDef.getTaggedValues());
                    if (!tvsForPi.containsKey("sequenceNumber")) {
                        if (genCi.properties() != null && genCi.properties().size() > 0) {
                            int maxMajorComponentExistingProps = Integer.MIN_VALUE;
                            for (StructuredNumber snExistingProp : genCi.properties().keySet()) {
                                if (snExistingProp.components[0] <= maxMajorComponentExistingProps) continue;
                                maxMajorComponentExistingProps = snExistingProp.components[0];
                            }
                            tvsForPi.add("sequenceNumber", "" + (maxMajorComponentExistingProps + 1));
                        } else {
                            tvsForPi.add("sequenceNumber", "" + genPi.getNextNumberForAttributeWithoutExplicitSequenceNumber());
                        }
                    } else {
                        String seqN = tvsForPi.getFirstValue("sequenceNumber");
                        StructuredNumber sn = new StructuredNumber(seqN);
                        for (StructuredNumber snExistingProp : genCi.properties().keySet()) {
                            if (snExistingProp.compareTo(sn) != 0) continue;
                            int[] components = sn.components;
                            int newComponent = 1;
                            block5: for (StructuredNumber tmp : genCi.properties().keySet()) {
                                if (tmp.components.length <= components.length) continue;
                                for (int i = 0; i < components.length; ++i) {
                                    if (tmp.components[i] != components[i]) continue block5;
                                }
                                int compTmp = tmp.components[components.length];
                                if (newComponent > compTmp) continue;
                                newComponent = compTmp + 1;
                            }
                            sn = sn.createCopyWithSuffix(newComponent);
                            tvsForPi.put("sequenceNumber", sn.getString());
                        }
                    }
                    genPi.setTaggedValues(tvsForPi, true);
                    genPi.setStereotypes(attDef.getStereotypes());
                    PropertyInfo samePiInSupertypes = ci.property(genPi.name());
                    if (samePiInSupertypes != null) {
                        genPi.setRestriction(true);
                    }
                    genPi.setInClass(genCi);
                    genPi.setAggregation(false);
                    genPi.setAttribute(true);
                    genPi.setComposition(true);
                    genPi.setNavigable(true);
                    this.model.add(genPi, genCi, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
                }
            }
        }
    }

    private List<AttributeDefinition> parseAttributeDefinitions(Element apcs) {
        ArrayList<AttributeDefinition> attDefs = new ArrayList<AttributeDefinition>();
        ArrayList<Element> attDefEs = new ArrayList<Element>();
        NodeList adNl = apcs.getElementsByTagName("AttributeDefinition");
        if (adNl != null && adNl.getLength() != 0) {
            for (int k = 0; k < adNl.getLength(); ++k) {
                Node n = adNl.item(k);
                if (n.getNodeType() != 1) continue;
                attDefEs.add((Element)n);
            }
        }
        for (int i = 0; i < attDefEs.size(); ++i) {
            NodeList tvNl;
            NodeList stNl;
            String mult;
            String isReadOnlyS;
            String isOwnedS;
            String isUniqueS;
            String isOrderedS;
            String isDerivedS;
            String iv;
            Element ivE;
            Element descriptorsE;
            String alias;
            String indexForMsg = "" + (i + 1);
            Element attDefE = (Element)attDefEs.get(i);
            AttributeDefinition ad = new AttributeDefinition();
            Element nE = XMLUtil.getFirstElement(attDefE, "name");
            String name = nE.getTextContent().trim();
            if (name.length() == 0) {
                this.result.addError(this, 3, "name", indexForMsg);
                continue;
            }
            ad.setName(name);
            Element selections = XMLUtil.getFirstElement(attDefE, "classSelection");
            PackageSelector ps = new PackageSelector();
            Element psE = XMLUtil.getFirstElement(selections, "PackageSelector");
            if (psE.hasAttribute("schemaNameRegex")) {
                String snr = psE.getAttribute("schemaNameRegex");
                try {
                    Pattern snP = Pattern.compile(snr);
                    ps.setSchemaNamePattern(snP);
                }
                catch (PatternSyntaxException e) {
                    this.result.addError(this, 2, "schemaNameRegex", "PackageSelector", indexForMsg, name);
                    continue;
                }
            }
            if (psE.hasAttribute("nameRegex")) {
                String nr = psE.getAttribute("nameRegex");
                try {
                    Pattern nP = Pattern.compile(nr);
                    ps.setNamePattern(nP);
                }
                catch (PatternSyntaxException e) {
                    this.result.addError(this, 2, "nameRegex", "PackageSelector", indexForMsg, name);
                    continue;
                }
            }
            if (psE.hasAttribute("stereotypeRegex")) {
                String sr = psE.getAttribute("stereotypeRegex");
                try {
                    Pattern sP = Pattern.compile(sr);
                    ps.setStereotypePattern(sP);
                }
                catch (PatternSyntaxException e) {
                    this.result.addError(this, 2, "stereotypeRegex", "PackageSelector", indexForMsg, name);
                    continue;
                }
            }
            ad.setPackageSelector(ps);
            ClassSelector cs = new ClassSelector();
            Element csE = XMLUtil.getFirstElement(selections, "ClassSelector");
            if (csE.hasAttribute("nameRegex")) {
                String nr = csE.getAttribute("nameRegex");
                try {
                    Pattern nP = Pattern.compile(nr);
                    cs.setNamePattern(nP);
                }
                catch (PatternSyntaxException e) {
                    this.result.addError(this, 2, "nameRegex", "ClassSelector", indexForMsg, name);
                    continue;
                }
            }
            if (csE.hasAttribute("stereotypeRegex")) {
                String sr = csE.getAttribute("stereotypeRegex");
                try {
                    Pattern sP = Pattern.compile(sr);
                    cs.setStereotypePattern(sP);
                }
                catch (PatternSyntaxException e) {
                    this.result.addError(this, 2, "stereotypeRegex", "PackageSelector", indexForMsg, name);
                    continue;
                }
            }
            ad.setClassSelector(cs);
            Element aliasE = XMLUtil.getFirstElement(attDefE, "aliasName");
            if (aliasE != null && (alias = aliasE.getTextContent().trim()).length() != 0) {
                ad.setAliasName(alias);
            }
            if ((descriptorsE = XMLUtil.getFirstElement(attDefE, "descriptors")) != null) {
                Descriptors descriptors = new Descriptors();
                NodeList descriptorsNl = descriptorsE.getElementsByTagName("Descriptor");
                if (descriptorsNl != null && descriptorsNl.getLength() != 0) {
                    for (int j = 0; j < descriptorsNl.getLength(); ++j) {
                        Node n = descriptorsNl.item(j);
                        if (n.getNodeType() != 1) continue;
                        Element descriptorE = (Element)n;
                        ArrayList<LangString> descriptorValues = new ArrayList<LangString>();
                        Element descriptorValuesE = XMLUtil.getFirstElement(descriptorE, "descriptorValues");
                        NodeList descriptorValuesNl = descriptorValuesE.getElementsByTagName("DescriptorValue");
                        if (descriptorValuesNl != null && descriptorValuesNl.getLength() != 0) {
                            for (int k = 0; k < descriptorValuesNl.getLength(); ++k) {
                                Node dv = descriptorValuesNl.item(k);
                                if (dv.getNodeType() != 1) continue;
                                Element descriptorValueE = (Element)dv;
                                String value = descriptorValueE.getTextContent().trim();
                                String lang = null;
                                if (descriptorValueE.hasAttribute("lang")) {
                                    lang = descriptorValueE.getAttribute("lang");
                                }
                                if (value == null || value.length() <= 0) continue;
                                descriptorValues.add(new LangString(value, lang));
                            }
                        }
                        if (descriptorValues.size() <= 0) continue;
                        String descriptorName = descriptorE.getAttribute("name").trim();
                        try {
                            Descriptor descriptor = Descriptor.valueOf(descriptorName.toUpperCase(Locale.ENGLISH));
                            descriptors.put(descriptor, descriptorValues);
                            ad.setDescriptors(descriptors);
                            continue;
                        }
                        catch (IllegalArgumentException | NullPointerException e) {
                            this.result.addError(this, 7, descriptorName);
                        }
                    }
                }
            }
            if ((ivE = XMLUtil.getFirstElement(attDefE, "initialValue")) != null && (iv = ivE.getTextContent()).length() != 0) {
                ad.setInitialValue(iv);
            }
            boolean isDerived = false;
            Element isDerivedE = XMLUtil.getFirstElement(attDefE, "isDerived");
            if (isDerivedE != null && ((isDerivedS = isDerivedE.getTextContent().trim()).equalsIgnoreCase("true") || isDerivedS.equals("1"))) {
                isDerived = true;
            }
            ad.setDerived(isDerived);
            boolean isOrdered = false;
            Element isOrderedE = XMLUtil.getFirstElement(attDefE, "isOrdered");
            if (isOrderedE != null && ((isOrderedS = isOrderedE.getTextContent().trim()).equalsIgnoreCase("true") || isOrderedS.equals("1"))) {
                isOrdered = true;
            }
            ad.setOrdered(isOrdered);
            boolean isUnique = true;
            Element isUniqueE = XMLUtil.getFirstElement(attDefE, "isUnique");
            if (isUniqueE != null && ((isUniqueS = isUniqueE.getTextContent().trim()).equalsIgnoreCase("false") || isUniqueS.equals("0"))) {
                isUnique = false;
            }
            ad.setUnique(isUnique);
            boolean isOwned = false;
            Element isOwnedE = XMLUtil.getFirstElement(attDefE, "isOwned");
            if (isOwnedE != null && ((isOwnedS = isOwnedE.getTextContent().trim()).equalsIgnoreCase("true") || isOwnedS.equals("1"))) {
                isOwned = true;
            }
            ad.setOwned(isOwned);
            boolean isReadOnly = false;
            Element isReadOnlyE = XMLUtil.getFirstElement(attDefE, "isReadOnly");
            if (isReadOnlyE != null && ((isReadOnlyS = isReadOnlyE.getTextContent().trim()).equalsIgnoreCase("true") || isReadOnlyS.equals("1"))) {
                isReadOnly = true;
            }
            ad.setReadOnly(isReadOnly);
            Multiplicity m = new Multiplicity();
            Element multE = XMLUtil.getFirstElement(attDefE, "multiplicity");
            if (multE != null && (mult = multE.getTextContent().trim()).length() != 0) {
                m = new Multiplicity(mult);
            }
            ad.setMultiplicity(m);
            Stereotypes sts = this.options.stereotypesFactory();
            Element stsE = XMLUtil.getFirstElement(attDefE, "stereotypes");
            if (stsE != null && (stNl = stsE.getElementsByTagName("Stereotype")) != null && stNl.getLength() != 0) {
                for (int k = 0; k < stNl.getLength(); ++k) {
                    Node n = stNl.item(k);
                    if (n.getNodeType() != 1) continue;
                    Element stE = (Element)n;
                    String st = stE.getTextContent().trim();
                    st = this.options.normalizeStereotype(st);
                    for (String s : Options.propertyStereotypes) {
                        if (!st.toLowerCase().equals(s)) continue;
                        sts.add(s);
                    }
                }
            }
            ad.setStereotypes(sts);
            TaggedValues tvs = this.options.taggedValueFactory();
            Element tvsE = XMLUtil.getFirstElement(attDefE, "taggedValues");
            if (tvsE != null && (tvNl = tvsE.getElementsByTagName("TaggedValue")) != null && tvNl.getLength() != 0) {
                for (int k = 0; k < tvNl.getLength(); ++k) {
                    Node n = tvNl.item(k);
                    if (n.getNodeType() != 1) continue;
                    Element tvE = (Element)n;
                    tvs.add(tvE.getAttribute("name"), tvE.getAttribute("value"));
                }
            }
            ad.setTaggedValues(tvs);
            Element typeE = XMLUtil.getFirstElement(attDefE, "type");
            String type = typeE.getTextContent().trim();
            if (type.length() == 0) {
                this.result.addError(this, 3, "type", indexForMsg);
                continue;
            }
            ClassInfo typeCi = this.model.classByName(type);
            Type tInfo = new Type();
            tInfo.name = type;
            if (typeCi == null) {
                this.result.addWarning(this, 4, indexForMsg, type, name);
                tInfo.id = "unknown";
            } else {
                tInfo.id = typeCi.id();
            }
            ad.setType(tInfo);
            attDefs.add(ad);
        }
        return attDefs;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class AttributeCreator";
            }
            case 1: {
                return "No 'advancedProcessConfigurations' element present in the configuration. No attributes will be added to the model.";
            }
            case 2: {
                return "Syntax exception for regular expression value of attribute '$1$' in '$2$' of $3$ AttributeDefinition element. AttributeDefinition will be ignored.";
            }
            case 3: {
                return "'$1$' element of $2$ AttributeDefinition element is empty which is not allowed. AttributeDefinition will be ignored.";
            }
            case 4: {
                return "$1$ AttributeDefinition element states that '$2$' shall be the type of the new attribute with name '$3$', but the model does not contain a class with that name. Using 'unknown' as type id and category of value.";
            }
            case 5: {
                return "No classes were selected for definition of attribute '$1$'. AttributeDefinition will be ignored.";
            }
            case 6: {
                return "Property with name '$1$' already exists in class '$2$'. Because overwriting an existing property is not allowed the AttributeDefinition will be ignored.";
            }
            case 7: {
                return "Unknown descriptor '$1$' encountered while loading the attribute definition. The according descriptor element will be ignored.";
            }
        }
        return "(" + AttributeDefinition.class.getName() + ") Unknown message with number: " + mnr;
    }

    class AttributeDefinition {
        private PackageSelector ps;
        private ClassSelector cs;
        private String aliasName;
        private String initialValue;
        private boolean isDerived;
        private boolean isOrdered;
        private boolean isUnique;
        private boolean isReadOnly;
        private boolean isOwned;
        private String name;
        private Multiplicity multiplicity;
        private TaggedValues tvs;
        private Type type;
        private Stereotypes stereotypes;
        private Descriptors descriptors;

        AttributeDefinition() {
        }

        public PackageSelector getPackageSelector() {
            return this.ps;
        }

        public ClassSelector getClassSelector() {
            return this.cs;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public String getInitialValue() {
            return this.initialValue;
        }

        public boolean isDerived() {
            return this.isDerived;
        }

        public boolean isOrdered() {
            return this.isOrdered;
        }

        public boolean isUnique() {
            return this.isUnique;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public String getName() {
            return this.name;
        }

        public Multiplicity getMultiplicity() {
            return this.multiplicity;
        }

        public TaggedValues getTaggedValues() {
            return this.tvs;
        }

        public Type getType() {
            return this.type;
        }

        public void setPackageSelector(PackageSelector ps) {
            this.ps = ps;
        }

        public void setClassSelector(ClassSelector cs) {
            this.cs = cs;
        }

        public void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public void setInitialValue(String initialValue) {
            this.initialValue = initialValue;
        }

        public void setDerived(boolean isDerived) {
            this.isDerived = isDerived;
        }

        public void setOrdered(boolean isOrdered) {
            this.isOrdered = isOrdered;
        }

        public void setOwned(boolean isOwned) {
            this.isOwned = isOwned;
        }

        public void setUnique(boolean isUnique) {
            this.isUnique = isUnique;
        }

        public void setReadOnly(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMultiplicity(Multiplicity multiplicity) {
            this.multiplicity = multiplicity;
        }

        public void setTaggedValues(TaggedValues tvs) {
            this.tvs = tvs;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Stereotypes getStereotypes() {
            return this.stereotypes;
        }

        public void setStereotypes(Stereotypes stereotypes) {
            this.stereotypes = stereotypes;
        }

        public Descriptors getDescriptors() {
            return this.descriptors;
        }

        public void setDescriptors(Descriptors descriptors) {
            this.descriptors = descriptors;
        }

        public boolean isOwned() {
            return this.isOwned;
        }
    }
}

