/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.AIXM;

import de.interactive_instruments.ShapeChange.AIXMSchemaInfos;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericAssociationInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPackageInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class AIXMSchemaMerger
implements Transformer,
MessageSource {
    public static final String AIXM_5_1_TNS = "http://www.aixm.aero/schema/5.1";
    public static final String PARAM_INPUT_MERGE_AIXM_CORE_TNS = "coreSchemaTargetNamespace";
    private String coreAIXMSchemaTargetNamespace = "http://www.aixm.aero/schema/5.1";
    private GenericModel model;
    private Options options;
    private ShapeChangeResult result;
    private GenericPackageInfo coreSchema = null;
    private Map<String, AIXMSchemaInfos.AIXMSchemaInfo> schemaInfos;

    @Override
    public void process(GenericModel m, Options o, TransformerConfiguration trfConfig, ShapeChangeResult r) throws ShapeChangeAbortException {
        this.model = m;
        this.options = o;
        this.result = r;
        if (trfConfig.hasParameter(PARAM_INPUT_MERGE_AIXM_CORE_TNS)) {
            this.coreAIXMSchemaTargetNamespace = trfConfig.getParameterValue(PARAM_INPUT_MERGE_AIXM_CORE_TNS);
        }
        for (PackageInfo selectedSchema : this.model.selectedSchemas()) {
            if (!selectedSchema.targetNamespace().equals(this.coreAIXMSchemaTargetNamespace)) continue;
            this.coreSchema = (GenericPackageInfo)selectedSchema;
            break;
        }
        if (this.coreSchema == null) {
            ShapeChangeResult.MessageContext mc = this.result.addFatalError(this, 1);
            mc.addDetail(this, 0);
            throw new ShapeChangeAbortException(this.message(1));
        }
        HashSet<GenericClassInfo> extCis = new HashSet<GenericClassInfo>();
        HashMap<String, GenericClassInfo> nonExtCisById = new HashMap<String, GenericClassInfo>();
        for (PackageInfo packageInfo : this.model.selectedSchemas()) {
            SortedSet<ClassInfo> cisOfSelectedSchema = this.model.classes(packageInfo);
            Iterator iterator = cisOfSelectedSchema.iterator();
            while (iterator.hasNext()) {
                Object ci = (ClassInfo)iterator.next();
                if (ci.category() == 16) {
                    extCis.add((GenericClassInfo)ci);
                    continue;
                }
                nonExtCisById.put(ci.id(), (GenericClassInfo)ci);
            }
        }
        this.schemaInfos = new TreeMap<String, AIXMSchemaInfos.AIXMSchemaInfo>();
        for (ClassInfo classInfo : extCis) {
            this.determineSchemaInfos(classInfo, this.schemaInfos);
        }
        for (ClassInfo classInfo : nonExtCisById.values()) {
            this.determineSchemaInfos(classInfo, this.schemaInfos);
        }
        this.options.setAIXMSchemaInfos(this.schemaInfos);
        this.coreSchema.setContainedPackages(new TreeSet<GenericPackageInfo>());
        this.coreSchema.setClasses(new TreeSet<GenericClassInfo>());
        HashMap<String, GenericPackageInfo> pkgInfosById = new HashMap<String, GenericPackageInfo>();
        pkgInfosById.put(this.coreSchema.id(), this.coreSchema);
        this.model.setGenPackageInfosById(pkgInfosById);
        this.model.setGenClassInfosById(new HashMap<String, GenericClassInfo>());
        this.model.setGenClassInfosByName(new HashMap<String, GenericClassInfo>());
        HashMap<String, GenericAssociationInfo> hashMap = new HashMap<String, GenericAssociationInfo>();
        for (GenericAssociationInfo genericAssociationInfo : this.model.selectedSchemaAssociations()) {
            if (genericAssociationInfo.end1().inClass().category() == 16 || genericAssociationInfo.end2().inClass().category() == 16) continue;
            hashMap.put(genericAssociationInfo.id(), genericAssociationInfo);
        }
        this.model.setGenAssociationInfosById(hashMap);
        HashMap<String, GenericPropertyInfo> genPropsToKeepById = new HashMap<String, GenericPropertyInfo>();
        for (GenericClassInfo nonExtCi : nonExtCisById.values()) {
            for (PropertyInfo pi : nonExtCi.properties().values()) {
                GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                genPropsToKeepById.put(genPi.id(), genPi);
            }
        }
        for (GenericAssociationInfo ai : hashMap.values()) {
            GenericPropertyInfo end1 = (GenericPropertyInfo)ai.end1();
            genPropsToKeepById.put(end1.id(), end1);
            GenericPropertyInfo end2 = (GenericPropertyInfo)ai.end2();
            genPropsToKeepById.put(end2.id(), end2);
        }
        this.model.setGenPropertiesById(genPropsToKeepById);
        for (Object ci : nonExtCisById.values()) {
            this.coreSchema.addClass((GenericClassInfo)ci);
            ((GenericClassInfo)ci).setPkg(this.coreSchema);
            this.model.register((GenericClassInfo)ci);
        }
        HashMap<String, GenericClassInfo> hashMap2 = new HashMap<String, GenericClassInfo>();
        for (GenericClassInfo ci : nonExtCisById.values()) {
            if (ci.category() != 1) continue;
            hashMap2.put(ci.id(), ci);
        }
        for (GenericClassInfo ci : extCis) {
            SortedSet supertypeIds = ci.supertypes();
            if (!supertypeIds.isEmpty()) {
                Object mc;
                if (supertypeIds.size() > 1) {
                    ShapeChangeResult.MessageContext mc2 = this.result.addError(this, 2, ci.name());
                    mc2.addDetail(this, 0);
                    continue;
                }
                GenericClassInfo st = (GenericClassInfo)nonExtCisById.get(supertypeIds.iterator().next());
                if (st == null) {
                    mc = this.result.addWarning(this, 4, ci.name());
                    ((ShapeChangeResult.MessageContext)mc).addDetail(this, 0);
                    continue;
                }
                if (st.category() != 1 && st.category() != 6) {
                    mc = this.result.addError(this, 3, ci.name(), st.name());
                    ((ShapeChangeResult.MessageContext)mc).addDetail(this, 0);
                    continue;
                }
                for (PropertyInfo propertyInfo : ci.properties().values()) {
                    this.copyExtensionOrSupertypeProperty(propertyInfo, st);
                }
                ci.removeSupertype(st.id());
                st.removeSubtype(ci.id());
                continue;
            }
            for (GenericClassInfo aixmFeature : hashMap2.values()) {
                for (Object pi2 : ci.properties().values()) {
                    this.copyExtensionOrSupertypeProperty((PropertyInfo)pi2, aixmFeature);
                }
            }
        }
        HashMap<String, GenericClassInfo> timeSliceTypesByTheirFeatureTypeId = new HashMap<String, GenericClassInfo>();
        for (GenericClassInfo ft : hashMap2.values()) {
            GenericClassInfo tsType = new GenericClassInfo(ft.model(), ft.id() + "TimeSlice", ft.name() + "TimeSlice", 6);
            timeSliceTypesByTheirFeatureTypeId.put(ft.id(), tsType);
            GenericPackageInfo genPkg = this.model.getGenPackageInfosById().get(ft.pkg().id());
            tsType.setPkg(genPkg);
            genPkg.addClass(tsType);
            this.model.register(tsType);
            SortedMap<StructuredNumber, PropertyInfo> sortedMap = ft.properties();
            for (PropertyInfo pi : sortedMap.values()) {
                GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                genPi.setInClass(tsType);
            }
            tsType.setProperties(sortedMap);
            TreeMap<StructuredNumber, PropertyInfo> newFtProps = new TreeMap<StructuredNumber, PropertyInfo>();
            ft.setProperties(newFtProps);
            GenericPropertyInfo tsPi = new GenericPropertyInfo(this.model, "timeSlice_for_" + ft.id(), "timeSlice");
            Multiplicity mult = new Multiplicity();
            mult.minOccurs = 1;
            mult.maxOccurs = Integer.MAX_VALUE;
            tsPi.setCardinality(mult);
            tsPi.setComposition(true);
            tsPi.setConstraints(null);
            tsPi.setInClass(ft);
            tsPi.setInlineOrByReference("inline");
            tsPi.setTaggedValues(this.options.taggedValueFactory(), false);
            tsPi.setSequenceNumber(new StructuredNumber("1"), true);
            Type t = new Type();
            t.id = tsType.id();
            t.name = tsType.name();
            tsPi.setTypeInfo(t);
            this.model.add(tsPi, ft);
            GenericPropertyInfo interpretationPi = this.createInterpretationProperty(tsType);
            this.model.add(interpretationPi, tsType, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_TOP, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
            AIXMSchemaInfos.AIXMSchemaInfo si = this.schemaInfos.get(ft.id());
            this.schemaInfos.put(tsPi.id(), si);
            this.schemaInfos.put(interpretationPi.id(), si);
            this.schemaInfos.put(tsType.id(), si);
        }
        this.result.addDebug("Merging complete.");
    }

    private GenericPropertyInfo createInterpretationProperty(GenericClassInfo inClass) {
        GenericPropertyInfo pi = new GenericPropertyInfo(this.model, "interpretation_for_" + inClass.id(), "interpretation");
        Multiplicity mult = new Multiplicity();
        mult.minOccurs = 1;
        mult.maxOccurs = 1;
        pi.setCardinality(mult);
        pi.setComposition(true);
        pi.setConstraints(null);
        pi.setInClass(inClass);
        pi.setInlineOrByReference("inline");
        pi.setTaggedValues(this.options.taggedValueFactory(), false);
        pi.setSequenceNumber(new StructuredNumber("1"), true);
        pi.setTypeInfo(Type.from("CharacterString", this.model));
        return pi;
    }

    private void determineSchemaInfos(ClassInfo ci, Map<String, AIXMSchemaInfos.AIXMSchemaInfo> schemaInfos) {
        boolean isExtension = ci.category() == 16;
        String xmlns = ci.pkg().xmlns();
        String targetNamespace = ci.pkg().targetNamespace();
        AIXMSchemaInfos.AIXMSchemaInfo si = new AIXMSchemaInfos.AIXMSchemaInfo(xmlns, targetNamespace, isExtension);
        if (schemaInfos.containsKey(ci.id())) {
            this.result.addWarning(this, 6, ci.fullNameInSchema());
            return;
        }
        schemaInfos.put(ci.id(), si);
        for (PropertyInfo pi : ci.properties().values()) {
            if (schemaInfos.containsKey(pi.id())) {
                this.result.addWarning(this, 6, pi.fullNameInSchema());
                return;
            }
            schemaInfos.put(pi.id(), si);
        }
    }

    private void copyExtensionOrSupertypeProperty(PropertyInfo pi, GenericClassInfo genCi) {
        if (pi.isAttribute()) {
            GenericPropertyInfo copy = this.model.createCopy(pi, pi.id() + "_extensionPropCopyFor_" + genCi.id());
            copy.setInClass(genCi);
            if (pi.typeInfo().id.equals(pi.inClass().id())) {
                copy.typeInfo().id = genCi.id();
                copy.typeInfo().name = genCi.name();
            }
            ArrayList<GenericPropertyInfo> l = new ArrayList<GenericPropertyInfo>();
            l.add(copy);
            this.model.add(copy, genCi, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_BOTTOM, GenericModel.PropertyCopyDuplicatBehaviorIndicator.OVERWRITE);
            this.addSchemaInfoForCopy(pi, copy);
        } else {
            GenericPropertyInfo copyPi = this.model.createCopy(pi, pi.id() + "_extensionPropCopyFor_" + genCi.id());
            this.addSchemaInfoForCopy(pi, copyPi);
            copyPi.setInClass(genCi);
            if (pi.typeInfo().id.equals(pi.inClass().id())) {
                copyPi.typeInfo().id = genCi.id();
                copyPi.typeInfo().name = genCi.name();
            }
            GenericPropertyInfo copyOtherEnd = this.model.createCopy(pi.reverseProperty(), pi.reverseProperty() + "_extensionPropCopyFor_" + genCi.id());
            this.addSchemaInfoForCopy(pi.reverseProperty(), copyOtherEnd);
            copyOtherEnd.typeInfo().id = genCi.id();
            copyOtherEnd.typeInfo().name = genCi.name();
            AssociationInfo ai = pi.association();
            GenericAssociationInfo genAi = this.model.createCopy(ai, ai.id() + "_extensionPropCopyFor_" + genCi.id());
            if (ai.end1() == pi) {
                genAi.setEnd1(copyPi);
                genAi.setEnd2(copyOtherEnd);
            } else {
                genAi.setEnd1(copyOtherEnd);
                genAi.setEnd2(copyPi);
            }
            this.model.addAssociation(genAi);
            if (ai.assocClass() != null) {
                ClassInfo assocCi = ai.assocClass();
                GenericClassInfo genAssocCi = (GenericClassInfo)assocCi;
                GenericClassInfo assocCopy = new GenericClassInfo(this.model, assocCi.id() + "_extensionCopyFor_" + genCi.id(), assocCi.name(), assocCi.category());
                this.addSchemaInfoForCopy(assocCi, assocCopy);
                genAi.setAssocClass(assocCopy);
                assocCopy.setTaggedValues(assocCi.taggedValuesAll(), false);
                assocCopy.setDescriptors(assocCi.descriptors().createCopy());
                assocCopy.setProfiles(assocCi.profiles().createCopy());
                assocCopy.setStereotypes(assocCi.stereotypes());
                assocCopy.setIsAbstract(assocCi.isAbstract());
                assocCopy.setIsLeaf(assocCi.isLeaf());
                assocCopy.setSupertypes(this.model.copy(assocCi.supertypes()));
                assocCopy.setSubtypes(this.model.copy(assocCi.subtypes()));
                assocCopy.setDirectConstraints(this.model.copy(assocCi.directConstraints()));
                assocCopy.setAssocInfo(genAi);
                assocCopy.setProperties(null);
                this.model.copyClassContent(genAssocCi, assocCopy, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_INSEQUENCE, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
                assocCopy.setPkg(this.coreSchema);
                this.model.register(assocCopy);
            }
            this.model.add(copyPi, genCi, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_BOTTOM, GenericModel.PropertyCopyDuplicatBehaviorIndicator.OVERWRITE);
            if (pi.reverseProperty().isNavigable()) {
                ShapeChangeResult.MessageContext mc = this.result.addWarning(this, 5, pi.inClass().name(), pi.reverseProperty().inClass().name(), pi.name(), pi.reverseProperty().name());
                mc.addDetail(this, 0);
            }
        }
    }

    private void addSchemaInfoForCopy(Info orig, Info copy) {
        AIXMSchemaInfos.AIXMSchemaInfo si = this.schemaInfos.get(orig.id());
        this.schemaInfos.put(copy.id(), si);
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: class AIXMSchemaMerger";
            }
            case 1: {
                return "Could not find the core AIXM schema. None amongst the selected schemas has a target namespace equal to '" + this.coreAIXMSchemaTargetNamespace + "'.";
            }
            case 2: {
                return "Class '$1$' is an <<extension>> type. It has more than one supertype which is not allowed.";
            }
            case 3: {
                return "Class '$1$' is an <<extension>> type. Its supertype '$2$' is not a <<feature>> or <<object>> - this is not allowed.";
            }
            case 4: {
                return "Class '$1$' is an <<extension>> type. It has a supertype that is not part of the schemas selected for processing. '$1$' will be ignored. Ensure that all AIXM schemas - the core schema and the extension schemas - are properly selected via the input configuration.";
            }
            case 5: {
                return "The association between classes '$1$' and '$2$' (with one role being '$3$' and the other one being '$4$') is navigable in both directions. This is not allowed in AIXM.";
            }
            case 6: {
                return "The id() of Info object with full name '$1$' is already contained in AIXM schema infos. Info object '$1$' will not be added to the schema infos.";
            }
        }
        return "(" + AIXMSchemaMerger.class.getName() + ") Unknown message with number: " + mnr;
    }
}

