/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import de.interactive_instruments.ShapeChange.XmlNamespace;
import de.interactive_instruments.ShapeChange.XsdMapEntry;
import de.interactive_instruments.ShapeChange.XsdPropertyMapEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class TargetXmlSchemaConfiguration
extends TargetConfiguration {
    private List<XsdMapEntry> xsdMapEntries = new ArrayList<XsdMapEntry>();
    private Map<String, XsdPropertyMapEntry> xsdPropertyMapEntries = new HashMap<String, XsdPropertyMapEntry>();
    private List<XmlNamespace> xmlNamespaces = new ArrayList<XmlNamespace>();

    public TargetXmlSchemaConfiguration(String className, ProcessMode processMode, Map<String, String> parameters, Map<String, ProcessRuleSet> ruleSets, List<ProcessMapEntry> mapEntries, List<XsdMapEntry> xsdMapEntries, Map<String, List<XsdPropertyMapEntry>> xsdPropertyMapEntries, List<XmlNamespace> xmlNamespaces, SortedSet<String> inputIds, Element advancedProcessConfigurations) {
        super(className, processMode, parameters, ruleSets, null, inputIds, null, advancedProcessConfigurations);
        if (CollectionUtils.isNotEmpty(xsdMapEntries)) {
            this.xsdMapEntries = xsdMapEntries;
        }
        for (String property : xsdPropertyMapEntries.keySet()) {
            for (XsdPropertyMapEntry xpme : xsdPropertyMapEntries.get(property)) {
                this.xsdPropertyMapEntries.put(property + "#" + (xpme.hasSchema() ? xpme.getSchema() : ""), xpme);
            }
        }
        if (CollectionUtils.isNotEmpty(xmlNamespaces)) {
            this.xmlNamespaces = xmlNamespaces;
        }
    }

    public List<XsdMapEntry> getXsdMapEntries() {
        return this.xsdMapEntries;
    }

    public Map<String, XsdPropertyMapEntry> getXsdPropertyMapEntries() {
        return this.xsdPropertyMapEntries;
    }

    public List<XmlNamespace> getXmlNamespaces() {
        return this.xmlNamespaces;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TargetXmlSchemaConfiguration:\r\n");
        sb.append("--- with target configuration:\r\n");
        sb.append(super.toString());
        sb.append("\txml namespaces: \r\n");
        if (this.xmlNamespaces == null || this.xmlNamespaces.isEmpty()) {
            sb.append("none\r\n");
        } else {
            for (XmlNamespace xmlNamespace : this.xmlNamespaces) {
                sb.append("\t\txml namespace (" + xmlNamespace.getNsabr() + "|" + xmlNamespace.getNs() + "|" + xmlNamespace.getLocation() + "|");
                if (xmlNamespace.getPackageName() != null) {
                    sb.append(xmlNamespace.getPackageName());
                } else {
                    sb.append("no package name");
                }
                sb.append(")\r\n");
            }
        }
        sb.append("\txsd map entries: ");
        if (this.xsdMapEntries == null || this.xsdMapEntries.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (XsdMapEntry xsdMapEntry : this.xsdMapEntries) {
                sb.append("\t\txsd map entry: (");
                sb.append(xsdMapEntry.getType() + "|");
                if (xsdMapEntry.getEncodingRules() == null || xsdMapEntry.getEncodingRules().isEmpty()) {
                    sb.append("<no encoding rules>|");
                } else {
                    for (String encRule : xsdMapEntry.getEncodingRules()) {
                        sb.append(encRule + " ");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append("|");
                }
                if (xsdMapEntry.getXmlType() == null) {
                    sb.append("<no type>|");
                } else {
                    sb.append(xsdMapEntry.getXmlType() + "|");
                }
                if (xsdMapEntry.getXmlTypeContent() == null) {
                    sb.append("<no type content>|");
                } else {
                    sb.append(xsdMapEntry.getXmlTypeContent() + "|");
                }
                if (xsdMapEntry.getXmlTypeType() == null) {
                    sb.append("<no type type>|");
                } else {
                    sb.append(xsdMapEntry.getXmlTypeType() + "|");
                }
                if (xsdMapEntry.getXmlTypeNilReason() == null) {
                    sb.append("<no nil reason>|");
                } else {
                    sb.append(xsdMapEntry.getXmlTypeNilReason() + "|");
                }
                if (xsdMapEntry.getXmlElement() == null) {
                    sb.append("<no element>|");
                } else {
                    sb.append(xsdMapEntry.getXmlElement() + "|");
                }
                if (xsdMapEntry.getXmlPropertyType() == null) {
                    sb.append("<no property type>|");
                } else {
                    sb.append(xsdMapEntry.getXmlPropertyType() + "|");
                }
                if (xsdMapEntry.getXmlAttribute() == null) {
                    sb.append("<no attribute>|");
                } else {
                    sb.append(xsdMapEntry.getXmlAttribute() + "|");
                }
                if (xsdMapEntry.getXmlAttributeGroup() == null) {
                    sb.append("<no attribute group>|");
                } else {
                    sb.append(xsdMapEntry.getXmlAttributeGroup() + "|");
                }
                if (xsdMapEntry.getNsabr() == null) {
                    sb.append("<no nsabr>");
                } else {
                    sb.append(xsdMapEntry.getNsabr());
                }
                sb.append(")\r\n");
            }
        }
        sb.append("\txsd property map entries: ");
        if (this.xsdPropertyMapEntries == null || this.xsdPropertyMapEntries.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (XsdPropertyMapEntry xsdPropertyMapEntry : this.xsdPropertyMapEntries.values()) {
                sb.append("\t\txsd property map entry: ");
                sb.append(xsdPropertyMapEntry.toString());
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }

    public String determineQName(PropertyInfo pi) {
        XsdPropertyMapEntry xpme = this.getPropertyMapEntry(pi);
        if (xpme != null && xpme.hasTargetElement()) {
            return xpme.getTargetElement();
        }
        return pi.qname();
    }

    public XsdPropertyMapEntry getPropertyMapEntry(PropertyInfo pi) {
        PackageInfo schemaOfInClass = pi.model().schemaPackage(pi.inClass());
        if (schemaOfInClass == null) {
            return null;
        }
        return this.getPropertyMapEntry(pi.inClass().name() + "::" + pi.name(), schemaOfInClass.name());
    }

    public XsdPropertyMapEntry getPropertyMapEntry(String propertyNameScopedToClass, String schemaName) {
        if (StringUtils.isBlank((CharSequence)propertyNameScopedToClass) || StringUtils.isBlank((CharSequence)schemaName)) {
            return null;
        }
        if (this.xsdPropertyMapEntries.containsKey(propertyNameScopedToClass + "#" + schemaName)) {
            return this.xsdPropertyMapEntries.get(propertyNameScopedToClass + "#" + schemaName);
        }
        String piName = null;
        String[] components = propertyNameScopedToClass.split("::");
        piName = components[1];
        if (this.xsdPropertyMapEntries.containsKey(piName + "#" + schemaName)) {
            return this.xsdPropertyMapEntries.get(piName + "#" + schemaName);
        }
        if (this.xsdPropertyMapEntries.containsKey(propertyNameScopedToClass + "#")) {
            return this.xsdPropertyMapEntries.get(propertyNameScopedToClass + "#");
        }
        return this.xsdPropertyMapEntries.get(piName + "#");
    }
}

