/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Util.ShapeChangeClassFinder;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class TargetRegistry {
    protected List<Class<?>> targetClasses;
    protected Map<String, String> targetClassNameByIdentifier = new HashMap<String, String>();
    protected Map<String, String> targetDefaultEncodingRuleByIdentifier = new HashMap<String, String>();
    protected SortedSet<String> targetIdentifiers = new TreeSet<String>();

    public TargetRegistry() throws ShapeChangeAbortException {
        this.targetClasses = ShapeChangeClassFinder.findClassesImplementing("de.interactive_instruments.ShapeChange.Target.Target");
        for (Class<?> tc : this.targetClasses) {
            try {
                Target target = (Target)tc.getConstructor(new Class[0]).newInstance(new Object[0]);
                String targetIdentifier = target.getTargetIdentifier();
                if (this.targetClassNameByIdentifier.containsKey(targetIdentifier)) {
                    throw new ShapeChangeAbortException("Duplicate target identifier '" + targetIdentifier + "'. Found for targets " + this.targetClassNameByIdentifier.get(targetIdentifier) + " and target " + tc.getName() + ". The latter would overwrite the former in the target registry, which can lead to unexpected results. Execution will stop. Contact the target implementers to ensure that the identifiers of the targets are unique.");
                }
                this.targetIdentifiers.add(targetIdentifier);
                this.targetClassNameByIdentifier.put(targetIdentifier, tc.getName());
                String targetDefaultEncodingRule = target.getDefaultEncodingRule();
                if (targetDefaultEncodingRule == null) {
                    targetDefaultEncodingRule = "*";
                }
                this.targetDefaultEncodingRuleByIdentifier.put(targetIdentifier, targetDefaultEncodingRule);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.err.println("Exception occurred while loading target class " + tc.getName() + " and attempting to gather target identifiers.");
                e.printStackTrace();
            }
        }
    }

    public List<Class<?>> getTargetClasses() {
        return this.targetClasses;
    }

    public String targetClassName(String targetIdentifier) {
        return this.targetClassNameByIdentifier.get(targetIdentifier);
    }

    public String targetDefaultEncodingRule(String targetIdentifier) {
        return this.targetDefaultEncodingRuleByIdentifier.get(targetIdentifier);
    }

    public SortedSet<String> getTargetIdentifiers() {
        return this.targetIdentifiers;
    }
}

