/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ConstraintMapping;
import de.interactive_instruments.ShapeChange.DescriptorTarget;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Namespace;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.PropertyConversionParameter;
import de.interactive_instruments.ShapeChange.RdfPropertyMapEntry;
import de.interactive_instruments.ShapeChange.RdfTypeMapEntry;
import de.interactive_instruments.ShapeChange.StereotypeConversionParameter;
import de.interactive_instruments.ShapeChange.Target.Ontology.RdfGeneralProperty;
import de.interactive_instruments.ShapeChange.TargetConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.TypeConversionParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class TargetOwlConfiguration
extends TargetConfiguration {
    private SortedMap<String, RdfTypeMapEntry> rdfTypeMapEntries = new TreeMap<String, RdfTypeMapEntry>();
    private SortedMap<String, RdfPropertyMapEntry> rdfPropertyMapEntries = new TreeMap<String, RdfPropertyMapEntry>();
    private SortedMap<String, List<StereotypeConversionParameter>> stereotypeConversionParameters;
    private SortedMap<String, TypeConversionParameter> typeConversionParameters = new TreeMap<String, TypeConversionParameter>();
    private SortedMap<String, PropertyConversionParameter> propertyConversionParameters = new TreeMap<String, PropertyConversionParameter>();
    private List<DescriptorTarget> descriptorTargets;
    private SortedMap<ConstraintMapping.ConstraintType, ConstraintMapping> constraintMappings;
    private List<RdfGeneralProperty> generalProperties;

    public TargetOwlConfiguration(String className, ProcessMode processMode, Map<String, String> parameters, Map<String, ProcessRuleSet> ruleSets, SortedSet<String> inputIds, List<Namespace> namespaces, Element advancedProcessConfigurations, Map<String, List<RdfTypeMapEntry>> rdfTypeMapEntries, Map<String, List<RdfPropertyMapEntry>> rdfPropertyMapEntries, SortedMap<String, List<StereotypeConversionParameter>> stereotypeConversionParameters, Map<String, List<TypeConversionParameter>> typeConversionParameters, Map<String, List<PropertyConversionParameter>> propertyConversionParameters, List<DescriptorTarget> descriptorTargets, SortedMap<ConstraintMapping.ConstraintType, ConstraintMapping> constraintMappings, List<RdfGeneralProperty> generalProperties) {
        super(className, processMode, parameters, ruleSets, null, inputIds, namespaces, advancedProcessConfigurations);
        for (String type : rdfTypeMapEntries.keySet()) {
            for (RdfTypeMapEntry rtme : rdfTypeMapEntries.get(type)) {
                this.rdfTypeMapEntries.put(type + "#" + (rtme.hasSchema() ? rtme.getSchema() : ""), rtme);
            }
        }
        for (String property : rdfPropertyMapEntries.keySet()) {
            for (RdfPropertyMapEntry rpme : rdfPropertyMapEntries.get(property)) {
                this.rdfPropertyMapEntries.put(property + "#" + (rpme.hasSchema() ? rpme.getSchema() : ""), rpme);
            }
        }
        this.stereotypeConversionParameters = stereotypeConversionParameters;
        for (String type : typeConversionParameters.keySet()) {
            for (TypeConversionParameter tcp : typeConversionParameters.get(type)) {
                this.typeConversionParameters.put(type + "#" + (tcp.hasSchema() ? tcp.getSchema() : ""), tcp);
            }
        }
        for (String property : propertyConversionParameters.keySet()) {
            for (PropertyConversionParameter pcp : propertyConversionParameters.get(property)) {
                this.propertyConversionParameters.put(property + "#" + (pcp.hasSchema() ? pcp.getSchema() : ""), pcp);
            }
        }
        this.descriptorTargets = descriptorTargets;
        this.constraintMappings = constraintMappings;
        this.generalProperties = generalProperties != null ? generalProperties : new ArrayList();
    }

    public RdfTypeMapEntry getTypeMapEntry(ClassInfo ci) {
        if (ci == null) {
            return null;
        }
        PackageInfo pkg = ci.model().schemaPackage(ci);
        if (pkg == null) {
            return this.getTypeMapEntry(ci.name());
        }
        return this.getTypeMapEntry(ci.name(), pkg.name());
    }

    public RdfTypeMapEntry getTypeMapEntry(String typeName) {
        return this.getTypeMapEntry(typeName, null);
    }

    public RdfTypeMapEntry getTypeMapEntryByTypeInfo(PropertyInfo pi) {
        Model model = pi.model();
        Type t = pi.typeInfo();
        RdfTypeMapEntry rtme = t.id != null && model.classById(t.id) != null ? this.getTypeMapEntry(model.classById(t.id)) : this.getTypeMapEntry(t.name);
        return rtme;
    }

    public RdfTypeMapEntry getTypeMapEntry(String typeName, String schemaName) {
        if (typeName == null) {
            return null;
        }
        if (schemaName != null && this.rdfTypeMapEntries.containsKey(typeName + "#" + schemaName)) {
            return (RdfTypeMapEntry)this.rdfTypeMapEntries.get(typeName + "#" + schemaName);
        }
        return (RdfTypeMapEntry)this.rdfTypeMapEntries.get(typeName + "#");
    }

    public RdfPropertyMapEntry getPropertyMapEntry(PropertyInfo pi) {
        return this.getPropertyMapEntry(pi.inClass().name() + "::" + pi.name(), pi.model().schemaPackage(pi.inClass()).name());
    }

    public RdfPropertyMapEntry getPropertyMapEntry(String propertyNameScopedToClass, String schemaName) {
        if (propertyNameScopedToClass == null || propertyNameScopedToClass.trim().isEmpty() || schemaName == null || schemaName.trim().isEmpty()) {
            return null;
        }
        if (this.rdfPropertyMapEntries.containsKey(propertyNameScopedToClass + "#" + schemaName)) {
            return (RdfPropertyMapEntry)this.rdfPropertyMapEntries.get(propertyNameScopedToClass + "#" + schemaName);
        }
        String piName = null;
        String[] components = propertyNameScopedToClass.split("::");
        piName = components[1];
        if (this.rdfPropertyMapEntries.containsKey(piName + "#" + schemaName)) {
            return (RdfPropertyMapEntry)this.rdfPropertyMapEntries.get(piName + "#" + schemaName);
        }
        if (this.rdfPropertyMapEntries.containsKey(propertyNameScopedToClass + "#")) {
            return (RdfPropertyMapEntry)this.rdfPropertyMapEntries.get(propertyNameScopedToClass + "#");
        }
        return (RdfPropertyMapEntry)this.rdfPropertyMapEntries.get(piName + "#");
    }

    public TypeConversionParameter getTypeConversionParameter(ClassInfo ci) {
        if (ci == null) {
            return null;
        }
        return this.getTypeConversionParameter(ci.name(), ci.model().schemaPackage(ci).name());
    }

    public TypeConversionParameter getTypeConversionParameter(String typeName, String schemaName) {
        if (typeName == null) {
            return null;
        }
        if (schemaName != null && this.typeConversionParameters.containsKey(typeName + "#" + schemaName)) {
            return (TypeConversionParameter)this.typeConversionParameters.get(typeName + "#" + schemaName);
        }
        return (TypeConversionParameter)this.typeConversionParameters.get(typeName + "#");
    }

    public PropertyConversionParameter getPropertyConversionParameter(PropertyInfo pi) {
        return this.getPropertyConversionParameter(pi.inClass().name() + "::" + pi.name(), pi.model().schemaPackage(pi.inClass()).name());
    }

    public PropertyConversionParameter getPropertyConversionParameter(String propertyNameScopedToClass, String schemaName) {
        if (propertyNameScopedToClass == null || propertyNameScopedToClass.trim().isEmpty() || schemaName == null || schemaName.trim().isEmpty()) {
            return null;
        }
        if (this.propertyConversionParameters.containsKey(propertyNameScopedToClass + "#" + schemaName)) {
            return (PropertyConversionParameter)this.propertyConversionParameters.get(propertyNameScopedToClass + "#" + schemaName);
        }
        String piName = null;
        String[] components = propertyNameScopedToClass.split("::");
        piName = components[1];
        if (this.propertyConversionParameters.containsKey(piName + "#" + schemaName)) {
            return (PropertyConversionParameter)this.propertyConversionParameters.get(piName + "#" + schemaName);
        }
        if (this.propertyConversionParameters.containsKey(propertyNameScopedToClass + "#")) {
            return (PropertyConversionParameter)this.propertyConversionParameters.get(propertyNameScopedToClass + "#");
        }
        return (PropertyConversionParameter)this.propertyConversionParameters.get(piName + "#");
    }

    public SortedMap<String, List<StereotypeConversionParameter>> getStereotypeConversionParameters() {
        return this.stereotypeConversionParameters;
    }

    public List<DescriptorTarget> getDescriptorTargets() {
        return this.descriptorTargets;
    }

    public ConstraintMapping getConstraintMapping(ConstraintMapping.ConstraintType type) {
        return (ConstraintMapping)this.constraintMappings.get((Object)type);
    }

    public boolean hasConstraintMapping(ConstraintMapping.ConstraintType type) {
        return this.constraintMappings.containsKey((Object)type);
    }

    public List<RdfGeneralProperty> getGeneralProperties() {
        return this.generalProperties;
    }

    public SortedMap<String, RdfTypeMapEntry> getRdfTypeMapEntries() {
        return this.rdfTypeMapEntries;
    }

    public SortedMap<String, RdfPropertyMapEntry> getRdfPropertyMapEntries() {
        return this.rdfPropertyMapEntries;
    }

    public SortedMap<String, TypeConversionParameter> getTypeConversionParameters() {
        return this.typeConversionParameters;
    }

    public SortedMap<String, PropertyConversionParameter> getPropertyConversionParameters() {
        return this.propertyConversionParameters;
    }

    public SortedMap<ConstraintMapping.ConstraintType, ConstraintMapping> getConstraintMappings() {
        return this.constraintMappings;
    }
}

