/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.TargetHelper;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Ocl.OclNode;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema;
import de.interactive_instruments.ShapeChange.TargetHelper.XpathHelper;
import de.interactive_instruments.ShapeChange.Type;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class XpathConstraintNode {
    protected ArrayList<XpathConstraintNode> children = new ArrayList();
    protected boolean negated = false;
    protected XpathConstraintNode parent = null;
    protected XpathHelper xpathHelper = null;

    public void addChild(XpathConstraintNode child) {
        this.children.add(child);
        child.parent = this;
    }

    public boolean isAndOrLogic(boolean isAnd) {
        return false;
    }

    public boolean isDependentOn(OclNode.Declaration vardecl) {
        for (XpathConstraintNode scn : this.children) {
            if (!scn.isDependentOn(vardecl)) continue;
            return true;
        }
        return false;
    }

    public boolean bindsVariable(OclNode.Declaration vardecl) {
        return false;
    }

    public boolean isVarOrAttribBased(OclNode.Declaration vardecl) {
        return false;
    }

    public Attribute generatingAttribute() {
        return null;
    }

    public boolean isMultiple() {
        return false;
    }

    public boolean hasSimpleType() {
        return true;
    }

    public boolean hasIdentity() {
        return false;
    }

    public boolean containsError() {
        if (this instanceof Error) {
            return true;
        }
        for (XpathConstraintNode node : this.children) {
            if (!node.containsError()) continue;
            return true;
        }
        return false;
    }

    public abstract XpathFragment translate(BindingContext var1);

    public static class MessageComment
    extends XpathConstraintNode {
        protected String name = null;

        public MessageComment(XpathHelper xpathHelper, String name) {
            this.xpathHelper = xpathHelper;
            this.name = name;
        }

        public String getErrorNumber() {
            return this.name.substring(6);
        }

        public String[] compileAsMessageArgumentList() {
            String[] arglist = new String[this.children.size()];
            int i = 0;
            for (XpathConstraintNode arg : this.children) {
                XpathFragment sql = arg.translate(null);
                arglist[i++] = sql.fragment == null ? "*ERROR*" : sql.fragment;
            }
            return arglist;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            return null;
        }
    }

    public static class Error
    extends XpathConstraintNode {
        public Error(XpathHelper xpathHelper) {
            this.xpathHelper = xpathHelper;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            return null;
        }
    }

    public static class IfThenElse
    extends XpathConstraintNode {
        public IfThenElse(XpathHelper xpathHelper) {
            this.xpathHelper = xpathHelper;
        }

        @Override
        public boolean hasSimpleType() {
            return ((XpathConstraintNode)this.children.get(1)).hasSimpleType() && ((XpathConstraintNode)this.children.get(2)).hasSimpleType();
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathConstraintNode con = (XpathConstraintNode)this.children.get(0);
            XpathConstraintNode thn = (XpathConstraintNode)this.children.get(1);
            XpathConstraintNode els = (XpathConstraintNode)this.children.get(2);
            XpathFragment xptthn = thn.translate(ctx);
            XpathFragment xptels = els.translate(ctx);
            XpathType thntype = xptthn.type;
            XpathType elstype = xptels.type;
            String elsepart = xptthn.merge(xptels);
            if (thntype == XpathType.NODESET && elstype == XpathType.NODESET) {
                XpathFragment xptcon = con.translate(xptthn.atEnd);
                String conpart = xptthn.merge(xptcon);
                String convar = xptthn.findOrAdd(conpart);
                xptthn.fragment = xptthn.fragment + "[$" + convar + "] | " + elsepart + "[not($" + convar + ")]";
                xptthn.priority = 8;
            } else {
                XpathFragment xptcon = con.translate(ctx);
                String conpart = xptthn.merge(xptcon);
                String convar = xptthn.findOrAdd(conpart);
                String thnvar = xptthn.findOrAdd(xptthn.fragment);
                String elsvar = xptthn.findOrAdd(elsepart);
                xptthn.fragment = "concat( substring($" + thnvar + ",number(not($" + convar + "))*string-length($" + thnvar + ")+1), substring($" + elsvar + ",number($" + convar + ")*string-length($" + elsvar + ")+1) )";
                xptthn.priority = 11;
                xptthn.atEnd.setState(BindingContext.CtxState.NONE);
                if (thntype == XpathType.NUMBER || elstype == XpathType.NUMBER) {
                    xptthn.fragment = "number( " + xptthn.fragment + " )";
                    xptthn.type = XpathType.NUMBER;
                } else if (thntype == XpathType.BOOLEAN || elstype == XpathType.BOOLEAN) {
                    xptthn.fragment = "boolean( " + xptthn.fragment + " )";
                    xptthn.type = XpathType.BOOLEAN;
                } else {
                    xptthn.type = XpathType.STRING;
                }
            }
            return xptthn;
        }
    }

    public static class Literal
    extends XpathConstraintNode {
        OclNode.LiteralExp literal;

        public Literal(XpathHelper xpathHelper, OclNode.LiteralExp lit, boolean neg) {
            this.xpathHelper = xpathHelper;
            this.literal = lit;
            this.negated = neg;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            Object value = this.literal.asString();
            XpathType type = XpathType.STRING;
            if (this.literal instanceof OclNode.StringLiteralExp) {
                value = "'" + (String)value + "'";
            } else if (this.literal instanceof OclNode.EnumerationLiteralExp) {
                OclNode.EnumerationLiteralExp litex = (OclNode.EnumerationLiteralExp)this.literal;
                ClassInfo ci = litex.dataType.umlClass;
                if (ci != null && ci.name().equals("Boolean")) {
                    boolean val = ((String)value).equalsIgnoreCase("TRUE");
                    if (this.negated) {
                        val = !val;
                    }
                    value = val ? "true()" : "false()";
                    type = XpathType.BOOLEAN;
                } else {
                    String resuri;
                    if (litex.umlProperty != null && StringUtils.isNotBlank((CharSequence)(resuri = litex.umlProperty.taggedValue("resourceURI")))) {
                        value = resuri;
                    }
                    value = "'" + (String)value + "'";
                }
            } else if (this.literal instanceof OclNode.BooleanLiteralExp) {
                OclNode.BooleanLiteralExp lit = (OclNode.BooleanLiteralExp)this.literal;
                boolean val = lit.value;
                if (this.negated) {
                    val = !val;
                }
                value = val ? "true()" : "false()";
                type = XpathType.BOOLEAN;
            } else if (this.literal instanceof OclNode.IntegerLiteralExp || this.literal instanceof OclNode.RealLiteralExp) {
                type = XpathType.NUMBER;
            } else if (this.literal instanceof OclNode.DateTimeLiteralExp) {
                OclNode.DateTimeLiteralExp lt = (OclNode.DateTimeLiteralExp)this.literal;
                if (lt.current) {
                    value = "***ERROR[125]***";
                } else {
                    GregorianCalendar dt = lt.dateTime;
                    int y = dt.get(1);
                    int m = dt.get(2) + 1;
                    int d = dt.get(5);
                    value = String.format("'%04d-%02d-%02d'", y, m, d);
                }
                type = XpathType.BOOLEAN;
            } else if (this.literal instanceof OclNode.OclVoidLiteralExp) {
                value = "/*[false()]";
                type = XpathType.NODESET;
            }
            XpathFragment xpt = new XpathFragment(11, (String)value, type);
            return xpt;
        }
    }

    public static class Attribute
    extends XpathConstraintNode {
        protected AttrComp[] attributes;

        public Attribute(XpathHelper xpathHelper, OclNode.AttributeCallExp attr, boolean negated) {
            this.xpathHelper = xpathHelper;
            this.attributes = new AttrComp[]{new AttrComp(attr)};
            this.negated = negated;
        }

        public Attribute(XpathHelper xpathHelper, AttrComp atc, boolean negated) {
            this.xpathHelper = xpathHelper;
            this.attributes = new AttrComp[]{new AttrComp(atc)};
            this.negated = negated;
        }

        public void appendAttribute(OclNode.AttributeCallExp aex) {
            AttrComp[] attribs = new AttrComp[this.attributes.length + 1];
            for (int i = 0; i < this.attributes.length; ++i) {
                attribs[i] = this.attributes[i];
            }
            attribs[this.attributes.length] = new AttrComp(aex);
            this.attributes = attribs;
        }

        public void appendAttribute(AttrComp atc) {
            AttrComp[] attribs = new AttrComp[this.attributes.length + 1];
            for (int i = 0; i < this.attributes.length; ++i) {
                attribs[i] = this.attributes[i];
            }
            attribs[this.attributes.length] = new AttrComp(atc);
            this.attributes = attribs;
        }

        public void appendAbsorbedAttribute(int absorptionType, OclNode.AttributeCallExp attr) {
            int last = this.attributes.length - 1;
            this.attributes[last].absAttr = attr;
            this.attributes[last].absType = absorptionType;
        }

        public Attribute splitBefore(int at) {
            if (at < 0 || at >= this.attributes.length) {
                return null;
            }
            Attribute atrite = new Attribute(this.xpathHelper, this.attributes[at], this.negated);
            for (int i = at + 1; i < this.attributes.length; ++i) {
                this.appendAttribute(this.attributes[i]);
            }
            if (at == 0) {
                atrite.addChild((XpathConstraintNode)this.children.get(0));
            } else {
                Attribute atleft = new Attribute(this.xpathHelper, this.attributes[0], this.negated);
                for (int i = 1; i < at; ++i) {
                    this.appendAttribute(this.attributes[i]);
                }
                atleft.addChild((XpathConstraintNode)this.children.get(0));
                atrite.addChild(atleft);
            }
            return atrite;
        }

        public boolean isPropertyAbsorbing() {
            AttrComp ac = this.attributes[this.attributes.length - 1];
            OclNode.AttributeCallExp acex = ac.absType == 0 ? ac.main : ac.absAttr;
            PropertyInfo pi = (PropertyInfo)acex.selector.modelProperty;
            Type t = pi.typeInfo();
            ClassInfo ci = pi.model().classById(t.id);
            return ci != null && ci.isUnionDirect();
        }

        @Override
        public boolean isVarOrAttribBased(OclNode.Declaration vardecl) {
            return ((XpathConstraintNode)this.children.get(0)).isVarOrAttribBased(vardecl);
        }

        @Override
        public Attribute generatingAttribute() {
            return this;
        }

        @Override
        public boolean isMultiple() {
            for (AttrComp at : this.attributes) {
                if (at.main.multMapping != OclNode.MultiplicityMapping.ONE2MANY && (at.absType != 1 || at.absAttr.multMapping != OclNode.MultiplicityMapping.ONE2MANY)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasSimpleType() {
            int last = this.attributes.length - 1;
            return this.hasSimpleType(last);
        }

        public boolean hasSimpleType(int idx) {
            boolean result = true;
            switch (this.attributes[idx].absType) {
                case 0: {
                    ClassInfo ci = this.attributes[idx].main.dataType.umlClass;
                    if (ci == null) break;
                    Boolean indicatorSimpleType = XmlSchema.indicatorForObjectElementWithSimpleContent(ci);
                    result = !XmlSchema.classHasObjectElement(ci) || indicatorSimpleType != null && indicatorSimpleType != false;
                    break;
                }
                case 1: {
                    ClassInfo ci = this.attributes[idx].absAttr.dataType.umlClass;
                    if (ci == null) break;
                    Boolean indicatorSimpleType = XmlSchema.indicatorForObjectElementWithSimpleContent(ci);
                    result = !XmlSchema.classHasObjectElement(ci) || indicatorSimpleType != null && indicatorSimpleType != false;
                    break;
                }
            }
            return result;
        }

        @Override
        public boolean hasIdentity() {
            int last = this.attributes.length - 1;
            return this.hasIdentity(last);
        }

        public boolean hasIdentity(int idx) {
            boolean result = false;
            switch (this.attributes[idx].absType) {
                case 0: {
                    ClassInfo ci = this.attributes[idx].main.dataType.umlClass;
                    if (ci == null) break;
                    result = XmlSchema.classCanBeReferenced(ci);
                    break;
                }
                case 1: {
                    ClassInfo ci = this.attributes[idx].absAttr.dataType.umlClass;
                    if (ci == null) break;
                    result = XmlSchema.classCanBeReferenced(ci);
                    break;
                }
            }
            return result;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            PropertyInfo[] props = new PropertyInfo[this.attributes.length];
            for (int i = 0; i < props.length; ++i) {
                props[i] = (PropertyInfo)this.attributes[i].main.selector.modelProperty;
            }
            XpathFragment obj = ((XpathConstraintNode)this.children.get(0)).translate(ctx);
            String alpha = this.xpathHelper.alpha;
            String beta = this.xpathHelper.beta;
            boolean alphaEx = alpha != null && alpha.length() > 0;
            boolean betaEx = beta != null && beta.length() > 0;
            for (int idx = 0; idx < props.length; ++idx) {
                boolean is19139;
                PropertyInfo pi = props[idx];
                int conCode = 0;
                String cid = pi.typeInfo().id;
                ClassInfo ci = null;
                if (cid != null) {
                    ci = pi.model().classById(cid);
                }
                if (!this.hasSimpleType(idx)) {
                    conCode = 1;
                    if (ci != null && XmlSchema.classCanBeReferenced(ci)) {
                        String ref = pi.inlineOrByReference();
                        if (ref == null) {
                            ref = "";
                        }
                        if (ref.equals("byreference")) {
                            conCode = 2;
                        } else if (!ref.equals("inline")) {
                            conCode = 3;
                        }
                    }
                }
                String proper = this.xpathHelper.getAndRegisterXmlName(pi);
                boolean bl = is19139 = pi.matches("rule-xsd-all-naming-19139") || ci != null && ci.matches("rule-xsd-cls-standard-19139-property-types");
                if (conCode == 0) {
                    if (obj.fragment.length() > 0) {
                        obj.fragment = obj.fragment + "/";
                        obj.priority = 9;
                    }
                    obj.fragment = obj.fragment + proper;
                    if (this.attributes[idx].absType == 2) {
                        obj.fragment = obj.fragment + "[@xsi:nil='true']/@nilReason";
                        obj.priority = 9;
                    }
                    if (obj.atEnd == null) continue;
                    obj.atEnd.addStep();
                    continue;
                }
                Object frag_inl = null;
                Object frag_ref = null;
                boolean isVar = false;
                if (conCode == 3 && obj.atEnd.state == BindingContext.CtxState.OTHER && obj.fragment.length() > 0 && !obj.fragment.startsWith(".")) {
                    String var = obj.findOrAdd(obj.fragment);
                    obj.fragment = "$" + var;
                    isVar = true;
                }
                if (conCode == 1 || conCode == 3) {
                    frag_inl = obj.fragment;
                    if (((String)frag_inl).length() > 0) {
                        frag_inl = (String)frag_inl + "/";
                    }
                    frag_inl = (String)frag_inl + proper;
                    if (obj.atEnd != null) {
                        obj.atEnd.addStep();
                    }
                    frag_inl = (String)frag_inl + "/*";
                    if (obj.atEnd != null) {
                        obj.atEnd.addStep();
                    }
                }
                if (conCode == 2 || conCode == 3) {
                    String idAttributeFrag;
                    if (!isVar) {
                        String frag;
                        BindingContext ctx1 = ctx.clone();
                        ctx1.setState(BindingContext.CtxState.OTHER);
                        XpathFragment obj1 = ((XpathConstraintNode)this.children.get(0)).translate(ctx1);
                        obj.fragment = frag = obj.merge(obj1);
                    }
                    if (is19139) {
                        idAttributeFrag = "@id";
                    } else {
                        idAttributeFrag = "@gml:id";
                        this.xpathHelper.registerNamespace("gml");
                    }
                    Object attxlink = obj.fragment;
                    if (((String)attxlink).length() > 0) {
                        attxlink = (String)attxlink + "/";
                    }
                    attxlink = (String)attxlink + proper;
                    attxlink = (String)attxlink + "/@xlink:href";
                    frag_ref = "//*[";
                    if (alphaEx || betaEx) {
                        frag_ref = (String)frag_ref + "concat(";
                        if (alphaEx) {
                            frag_ref = (String)frag_ref + "'" + alpha + "',";
                        }
                        frag_ref = (String)frag_ref + idAttributeFrag;
                        if (betaEx) {
                            frag_ref = (String)frag_ref + ",'" + beta + "'";
                        }
                        frag_ref = (String)frag_ref + ")";
                    } else {
                        frag_ref = (String)frag_ref + idAttributeFrag;
                    }
                    frag_ref = (String)frag_ref + "=" + (String)attxlink + "]";
                    this.xpathHelper.registerNamespace("xlink");
                    if (obj.atEnd != null) {
                        obj.atEnd.setState(BindingContext.CtxState.OTHER);
                    }
                }
                if (conCode == 3) {
                    obj.fragment = (String)frag_inl + " | " + frag_ref;
                    obj.priority = 8;
                    continue;
                }
                if (conCode == 1) {
                    obj.fragment = frag_inl;
                    obj.priority = 9;
                    continue;
                }
                obj.fragment = frag_ref;
                obj.priority = 10;
            }
            if (this.negated) {
                obj.fragment = "not(" + obj.fragment + ")";
                obj.priority = 11;
                obj.atEnd.setState(BindingContext.CtxState.NONE);
            }
            return obj;
        }

        protected static class AttrComp {
            protected OclNode.AttributeCallExp main = null;
            protected OclNode.AttributeCallExp absAttr = null;
            protected int absType = 0;

            protected AttrComp(OclNode.AttributeCallExp at) {
                this.main = at;
            }

            protected AttrComp(AttrComp atc) {
                this.main = atc.main;
                this.absAttr = atc.absAttr;
                this.absType = atc.absType;
            }
        }
    }

    public static class Variable
    extends XpathConstraintNode {
        protected OclNode.Declaration vardecl;

        public Variable(XpathHelper xpathHelper, OclNode.Declaration vardecl, boolean neg) {
            this.xpathHelper = xpathHelper;
            this.vardecl = vardecl;
            this.negated = neg;
        }

        public String getName() {
            return this.vardecl.name;
        }

        @Override
        public boolean isDependentOn(OclNode.Declaration vardecl) {
            return this.vardecl == vardecl;
        }

        @Override
        public boolean isVarOrAttribBased(OclNode.Declaration vardecl) {
            return this.isDependentOn(vardecl);
        }

        @Override
        public Attribute generatingAttribute() {
            XpathConstraintNode binds = null;
            XpathConstraintNode scn = this.parent;
            while (scn != null) {
                if (scn.bindsVariable(this.vardecl)) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds == null) {
                return null;
            }
            return binds.children.get(0).generatingAttribute();
        }

        @Override
        public boolean hasSimpleType() {
            XpathConstraintNode binds = null;
            XpathConstraintNode scn = this.parent;
            while (scn != null) {
                if (scn.bindsVariable(this.vardecl)) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds == null) {
                return false;
            }
            return binds.children.get(0).hasSimpleType();
        }

        @Override
        public boolean hasIdentity() {
            XpathConstraintNode binds = null;
            XpathConstraintNode scn = this.parent;
            while (scn != null) {
                if (scn.bindsVariable(this.vardecl)) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds == null) {
                return true;
            }
            return binds.children.get(0).hasIdentity();
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xpt = new XpathFragment(11, "");
            if (this.getName().equals("self")) {
                xpt.atEnd = new BindingContext(BindingContext.CtxState.ATCURRENT);
                if (ctx.state != BindingContext.CtxState.ATCURRENT) {
                    xpt.fragment = "current()";
                }
            } else if (ctx.state != BindingContext.CtxState.OTHER) {
                xpt.fragment = "***ERROR[124," + this.getName() + "]***";
            } else {
                int i;
                int steps = 0;
                boolean found = false;
                if (ctx.vars != null) {
                    for (i = ctx.vars.size() - 1; i >= 0; --i) {
                        BindingContext.CtxElmt ce = ctx.vars.get(i);
                        steps += ce.noOfSteps;
                        if (ce.vardecl != this.vardecl) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    xpt.fragment = "***ERROR[124," + this.getName() + "]***";
                } else {
                    if (steps > 0) {
                        xpt.fragment = "..";
                        for (i = 2; i <= steps; ++i) {
                            xpt.fragment = xpt.fragment + "/..";
                        }
                    }
                    if (steps > 1) {
                        xpt.priority = 9;
                    }
                }
                xpt.atEnd = new BindingContext(BindingContext.CtxState.OTHER);
            }
            return xpt;
        }
    }

    public static class Arithmetic
    extends XpathConstraintNode {
        String operation;

        public Arithmetic(XpathHelper xpathHelper, String oper) {
            this.xpathHelper = xpathHelper;
            this.operation = oper;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xpt1 = ((XpathConstraintNode)this.children.get(0)).translate(ctx);
            if (this.children.size() == 1) {
                if (xpt1.priority <= 7) {
                    xpt1.bracket();
                }
                xpt1.priority = 7;
            } else {
                XpathFragment xpt2 = ((XpathConstraintNode)this.children.get(1)).translate(ctx);
                int prio = 5;
                if (this.operation.equals("*") || this.operation.equals("/")) {
                    prio = 6;
                }
                if (xpt1.priority < prio) {
                    xpt1.bracket();
                }
                if (this.operation.equals("/") || this.operation.equals("-")) {
                    if (xpt2.priority <= prio) {
                        xpt2.bracket();
                    }
                } else if (xpt2.priority < prio) {
                    xpt2.bracket();
                }
                xpt2.atEnd = null;
                String op2 = xpt1.merge(xpt2);
                xpt1.fragment = xpt1.fragment + " " + (this.operation.equals("/") ? "div" : this.operation) + " " + op2;
                xpt1.priority = prio;
            }
            xpt1.type = XpathType.NUMBER;
            xpt1.atEnd = new BindingContext(BindingContext.CtxState.NONE);
            return xpt1;
        }
    }

    public static class Matches
    extends XpathConstraintNode {
        public Matches(XpathHelper xpathHelper) {
            this.xpathHelper = xpathHelper;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xptobj = ((XpathConstraintNode)this.children.get(0)).translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = ".";
            }
            XpathFragment xptpat = ((XpathConstraintNode)this.children.get(1)).translate(ctx);
            if (xptpat.fragment.length() == 0) {
                xptpat.fragment = ".";
            }
            String patstring = xptobj.merge(xptpat);
            XpathHelper.ExtensionFunctionTemplate eft = this.xpathHelper.extensionFunctions.get("matches");
            if (eft == null) {
                return new XpathFragment(11, "***ERROR[123]***");
            }
            String fcall = eft.function.replace("$object$", xptobj.fragment).replace("$pattern$", patstring);
            xptobj.fragment = eft.nsPrefix + ":" + fcall;
            xptobj.type = XpathType.STRING;
            xptobj.priority = 11;
            xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            this.xpathHelper.registerNamespace(eft.nsPrefix, eft.namespace);
            return xptobj;
        }
    }

    public static class ChangeCase
    extends XpathConstraintNode {
        protected String operation = null;

        public ChangeCase(XpathHelper xpathHelper, String oper) {
            this.xpathHelper = xpathHelper;
            this.operation = oper;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment result = new XpathFragment(11, "***ERROR[123]***");
            return result;
        }
    }

    public static class Substring
    extends XpathConstraintNode {
        public Substring(XpathHelper xpathHelper) {
            this.xpathHelper = xpathHelper;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xptobj = ((XpathConstraintNode)this.children.get(0)).translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = ".";
            }
            XpathFragment xptfr = ((XpathConstraintNode)this.children.get(1)).translate(ctx);
            if (xptfr.fragment.length() == 0) {
                xptfr.fragment = ".";
            }
            XpathFragment xptto = ((XpathConstraintNode)this.children.get(2)).translate(ctx);
            if (xptto.fragment.length() == 0) {
                xptto.fragment = ".";
            }
            String fr = xptobj.merge(xptfr);
            xptobj.fragment = "substring(" + xptobj.fragment + ", ";
            xptobj.fragment = xptobj.fragment + fr + ", ";
            if (xptto.priority < 5) {
                xptto.bracket();
            }
            if (xptfr.priority <= 5) {
                xptfr.bracket();
            }
            xptobj.fragment = xptobj.fragment + xptto.fragment + " - " + xptfr.fragment + " + 1)";
            xptobj.type = XpathType.STRING;
            xptobj.priority = 11;
            xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            return xptobj;
        }
    }

    public static class Concatenate
    extends XpathConstraintNode {
        public Concatenate(XpathHelper xpathHelper) {
            this.xpathHelper = xpathHelper;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathFragment result = null;
            for (XpathConstraintNode arg : this.children) {
                XpathFragment xptarg = arg.translate(ctx);
                if (result == null) {
                    result = xptarg;
                    continue;
                }
                String a1 = result.merge(xptarg);
                result.fragment = result.fragment + ", " + a1;
            }
            result.fragment = "concat(" + result.fragment + ")";
            result.type = XpathType.STRING;
            result.priority = 11;
            result.atEnd.setState(BindingContext.CtxState.NONE);
            return result;
        }
    }

    public static class Size
    extends XpathConstraintNode {
        boolean setoper = false;

        public Size(XpathHelper xpathHelper, boolean set) {
            this.xpathHelper = xpathHelper;
            this.setoper = set;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathConstraintNode obj = (XpathConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            xpt.fragment = !this.setoper ? "string-length(" + xpt.fragment + ")" : "count(" + xpt.fragment + ")";
            xpt.type = XpathType.NUMBER;
            xpt.priority = 11;
            xpt.atEnd = new BindingContext(BindingContext.CtxState.NONE);
            return xpt;
        }
    }

    public static class Cast
    extends XpathConstraintNode {
        protected ClassInfo argumentClass = null;
        protected String targetClassName;

        public Cast(XpathHelper xpathHelper) {
            this.xpathHelper = xpathHelper;
        }

        public void setClass(ClassInfo ci) {
            this.argumentClass = ci;
        }

        @Override
        public boolean hasSimpleType() {
            return ((XpathConstraintNode)this.children.get(0)).hasSimpleType();
        }

        @Override
        public boolean hasIdentity() {
            return ((XpathConstraintNode)this.children.get(0)).hasIdentity();
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathConstraintNode objnode = (XpathConstraintNode)this.children.get(0);
            XpathFragment xptobj = objnode.translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = "self::*";
                xptobj.priority = 10;
            }
            SortedSet<String> subtypes = this.argumentClass.subtypes();
            HashSet<String> classnames = new HashSet<String>();
            for (String stid : subtypes) {
                ClassInfo ci = this.argumentClass.model().classById(stid);
                if (ci.isAbstract()) continue;
                classnames.add(this.xpathHelper.getAndRegisterXmlName(ci));
            }
            if (!this.argumentClass.isAbstract()) {
                classnames.add(this.xpathHelper.getAndRegisterXmlName(this.argumentClass));
            }
            boolean first = true;
            if (xptobj.priority < 9) {
                xptobj.bracket();
            }
            xptobj.fragment = xptobj.fragment + "[";
            for (String name : classnames) {
                if (!first) {
                    xptobj.fragment = xptobj.fragment + " or ";
                }
                first = false;
                xptobj.fragment = xptobj.fragment + "name()='" + name + "'";
            }
            if (first) {
                xptobj.fragment = xptobj.fragment + "false()";
            }
            xptobj.fragment = xptobj.fragment + "]";
            xptobj.priority = 10;
            return xptobj;
        }
    }

    public static class KindOf
    extends XpathConstraintNode {
        protected ClassInfo argumentClass = null;
        protected boolean exact = false;

        public KindOf(XpathHelper xpathHelper, boolean exact, boolean neg) {
            this.xpathHelper = xpathHelper;
            this.exact = exact;
            this.negated = neg;
        }

        public void setClass(ClassInfo ci) {
            this.argumentClass = ci;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SortedSet<String> subtypes;
            XpathConstraintNode objnode = (XpathConstraintNode)this.children.get(0);
            XpathFragment xptobj = objnode.translate(ctx);
            boolean emptyobject = xptobj.fragment.length() == 0;
            HashSet<String> classnames = new HashSet<String>();
            if (!this.exact && (subtypes = this.argumentClass.subtypes()) != null) {
                for (String stid : subtypes) {
                    ClassInfo ci = this.argumentClass.model().classById(stid);
                    if (ci.isAbstract()) continue;
                    classnames.add(this.xpathHelper.getAndRegisterXmlName(ci));
                }
            }
            if (!this.argumentClass.isAbstract()) {
                classnames.add(this.xpathHelper.getAndRegisterXmlName(this.argumentClass));
            }
            if (classnames.size() == 0) {
                xptobj.fragment = this.negated ? "true()" : "false()";
                xptobj.priority = 11;
                xptobj.type = XpathType.BOOLEAN;
                xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            } else {
                boolean first = true;
                if (xptobj.priority < 9) {
                    xptobj.bracket();
                    xptobj.priority = 11;
                }
                if (!emptyobject) {
                    xptobj.fragment = xptobj.fragment + "[";
                }
                for (String name : classnames) {
                    if (!first) {
                        xptobj.fragment = xptobj.fragment + (this.negated ? "and" : " or ");
                    }
                    first = false;
                    xptobj.fragment = xptobj.fragment + "name()" + (this.negated ? "!=" : "=") + "'" + name + "'";
                }
                xptobj.priority = 3;
                if (classnames.size() > 1) {
                    int n = xptobj.priority = this.negated ? 2 : 1;
                }
                if (!emptyobject) {
                    xptobj.fragment = xptobj.fragment + "]";
                    xptobj.priority = 10;
                }
            }
            return xptobj;
        }
    }

    public static class AllInstances
    extends XpathConstraintNode {
        protected ClassInfo objectClass;

        public AllInstances(XpathHelper xpathHelper, ClassInfo ci, boolean negated) {
            this.xpathHelper = xpathHelper;
            this.objectClass = ci;
            this.negated = negated;
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public boolean hasSimpleType() {
            return false;
        }

        @Override
        public boolean hasIdentity() {
            return XmlSchema.classCanBeReferenced(this.objectClass);
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            SortedSet<String> subtypes = this.objectClass.subtypes();
            HashSet<String> classnames = new HashSet<String>();
            if (subtypes != null) {
                for (String string : subtypes) {
                    ClassInfo ci = this.objectClass.model().classById(string);
                    if (ci.isAbstract()) continue;
                    classnames.add(this.xpathHelper.getAndRegisterXmlName(ci));
                }
            }
            if (!this.objectClass.isAbstract()) {
                classnames.add(this.xpathHelper.getAndRegisterXmlName(this.objectClass));
            }
            Object fragment = "";
            if (classnames.size() == 0) {
                fragment = "/*[false()]";
            } else {
                for (String name : classnames) {
                    if (((String)fragment).length() != 0) {
                        fragment = (String)fragment + " | ";
                    }
                    fragment = (String)fragment + "//" + name;
                }
            }
            XpathFragment xpathFragment = new XpathFragment(classnames.size() > 1 ? 8 : 9, (String)fragment);
            xpathFragment.atEnd = new BindingContext(BindingContext.CtxState.OTHER);
            return xpathFragment;
        }
    }

    public static class Select
    extends XpathConstraintNode {
        protected OclNode.Declaration vardecl;
        protected XpathConstraintNode generatorBody = null;

        public Select(XpathHelper xpathHelper, OclNode.Declaration vardecl) {
            this.xpathHelper = xpathHelper;
            this.vardecl = vardecl;
        }

        @Override
        public boolean bindsVariable(OclNode.Declaration vardecl) {
            return this.vardecl == vardecl;
        }

        @Override
        public Attribute generatingAttribute() {
            return ((XpathConstraintNode)this.children.get(0)).generatingAttribute();
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public boolean hasSimpleType() {
            return ((XpathConstraintNode)this.children.get(0)).hasSimpleType();
        }

        @Override
        public boolean hasIdentity() {
            return ((XpathConstraintNode)this.children.get(0)).hasIdentity();
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathConstraintNode obj = (XpathConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            BindingContext bodyctx = xpt.atEnd.clone();
            bodyctx.pushDeclaration(this.vardecl);
            XpathConstraintNode pred = (XpathConstraintNode)this.children.get(1);
            XpathFragment prd = pred.translate(bodyctx);
            prd.atEnd = null;
            String filter = xpt.merge(prd);
            if (xpt.priority < 10) {
                xpt.bracket();
            }
            xpt.fragment = xpt.fragment + "[" + filter + "]";
            xpt.priority = 10;
            return xpt;
        }
    }

    public static class Unique
    extends XpathConstraintNode {
        OclNode.Declaration vardecl;

        public Unique(XpathHelper xpathHelper, OclNode.Declaration vardecl, boolean neg) {
            this.xpathHelper = xpathHelper;
            this.negated = neg;
            this.vardecl = vardecl;
        }

        @Override
        public boolean bindsVariable(OclNode.Declaration vardecl) {
            return this.vardecl == vardecl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public XpathFragment translate(BindingContext ctx) {
            boolean neg = this.negated;
            XpathConstraintNode obj = (XpathConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            XpathConstraintNode expr = (XpathConstraintNode)this.children.get(1);
            if (!expr.isDependentOn(this.vardecl)) {
                xpt.fragment = "count(" + xpt.fragment + ") " + (neg ? ">" : "<=") + " 1";
                neg = false;
                xpt.priority = 4;
                xpt.type = XpathType.BOOLEAN;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            } else if (expr.isVarOrAttribBased(this.vardecl) && expr instanceof Variable) {
                boolean simple = false;
                if (obj instanceof Attribute) {
                    Attribute obat = (Attribute)obj;
                    ClassInfo ci = obat.attributes[obat.attributes.length - 1].main.dataType.umlClass;
                    if (ci != null) {
                        Boolean indicatorSimpleType = XmlSchema.indicatorForObjectElementWithSimpleContent(ci);
                        boolean bl = simple = !XmlSchema.classHasObjectElement(ci) || indicatorSimpleType != null && indicatorSimpleType != false;
                    }
                }
                if (simple) {
                    String var = xpt.findOrAdd(xpt.fragment);
                    xpt.fragment = "$" + var + "[. = (preceding::*|ancestor::*)[count(.|$" + var + ")=count($" + var + ")]]";
                    xpt.priority = 10;
                    neg = !neg;
                } else {
                    xpt.fragment = neg ? "false()" : "true()";
                    neg = false;
                    xpt.priority = 11;
                    xpt.type = XpathType.BOOLEAN;
                    xpt.atEnd.setState(BindingContext.CtxState.NONE);
                }
            } else {
                if (!expr.isVarOrAttribBased(this.vardecl)) return new XpathFragment(11, "***ERROR[122]***");
                if (expr.isMultiple()) return new XpathFragment(11, "***ERROR[121]***");
                Attribute exat = (Attribute)expr;
                Attribute exat1 = exat.splitBefore(1);
                if (exat1 == null) {
                    if (!exat.hasSimpleType()) {
                        XpathConstraintNode sv = (XpathConstraintNode)exat.children.get(0);
                        exat.children.set(0, (XpathConstraintNode)this.children.get(0));
                        XpathFragment xpta = exat.translate(ctx);
                        xpt.merge(xpta);
                        xpt.fragment = "count(" + xpt.fragment + ") " + (neg ? "!=" : "=") + " count(" + xpta.fragment + ")";
                        neg = false;
                        xpt.priority = 4;
                        xpt.type = XpathType.BOOLEAN;
                        xpt.atEnd.setState(BindingContext.CtxState.NONE);
                        exat.children.set(0, sv);
                    } else {
                        String var = xpt.findOrAdd(xpt.fragment);
                        PropertyInfo pi = (PropertyInfo)exat.attributes[0].main.selector.modelProperty;
                        String prop = this.xpathHelper.getAndRegisterXmlName(pi);
                        String nil = "";
                        if (exat.attributes[0].absType == 2) {
                            nil = "[@xsi:nil='true']/@nilReason";
                        }
                        xpt.fragment = "$" + var + "[" + prop + nil + " = (preceding::*|ancestor::*)[count(.|$" + var + ")=count($" + var + ")]/" + prop + nil + "]";
                        xpt.priority = 10;
                        neg = !neg;
                    }
                } else {
                    boolean savednegated = this.negated;
                    this.negated = false;
                    this.children.set(1, (XpathConstraintNode)exat1.children.get(0));
                    XpathFragment xpt1 = this.translate(ctx);
                    Attribute exat0 = (Attribute)exat1.children.get(0);
                    Variable v0 = (Variable)exat0.children.get(0);
                    exat0.children.set(0, (XpathConstraintNode)this.children.get(0));
                    exat1.children.set(0, v0);
                    this.children.set(0, exat0);
                    this.children.set(1, exat1);
                    XpathFragment xpt2 = this.translate(ctx);
                    Object frag2 = xpt1.merge(xpt2);
                    if (xpt1.priority < 2) {
                        xpt1.bracket();
                    }
                    if (xpt2.priority < 2) {
                        frag2 = "(" + (String)frag2 + ")";
                    }
                    xpt1.fragment = xpt1.fragment + " and " + (String)frag2;
                    xpt1.priority = 2;
                    xpt1.type = XpathType.BOOLEAN;
                    xpt1.atEnd.setState(BindingContext.CtxState.NONE);
                    xpt = xpt1;
                    this.children.set(0, obj);
                    this.children.set(1, expr);
                    this.negated = savednegated;
                }
            }
            if (!neg) return xpt;
            xpt.fragment = "not(" + xpt.fragment + ")";
            xpt.type = XpathType.BOOLEAN;
            xpt.priority = 11;
            xpt.atEnd.setState(BindingContext.CtxState.NONE);
            return xpt;
        }
    }

    public static class Exists
    extends XpathConstraintNode {
        OclNode.Declaration vardecl;

        public Exists(XpathHelper xpathHelper, OclNode.Declaration vardecl, boolean neg) {
            this.xpathHelper = xpathHelper;
            this.negated = neg;
            this.vardecl = vardecl;
        }

        @Override
        public boolean bindsVariable(OclNode.Declaration vardecl) {
            return this.vardecl == vardecl;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathConstraintNode obj = (XpathConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            BindingContext bodyctx = xpt.atEnd.clone();
            bodyctx.pushDeclaration(this.vardecl);
            XpathConstraintNode pred = (XpathConstraintNode)this.children.get(1);
            XpathFragment prd = pred.translate(bodyctx);
            prd.atEnd = null;
            String filter = xpt.merge(prd);
            if (xpt.priority < 10) {
                xpt.bracket();
            }
            xpt.fragment = xpt.fragment + "[" + filter + "]";
            xpt.priority = 10;
            if (this.negated) {
                xpt.fragment = "not(" + xpt.fragment + ")";
                xpt.type = XpathType.BOOLEAN;
                xpt.priority = 11;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            }
            return xpt;
        }
    }

    public static class Empty
    extends XpathConstraintNode {
        public Empty(XpathHelper xpathHelper, boolean neg) {
            this.xpathHelper = xpathHelper;
            this.negated = neg;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            XpathConstraintNode obj = (XpathConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            if (xpt.fragment.length() == 0) {
                xpt.fragment = ".";
            }
            if (!this.negated) {
                xpt.fragment = "not(" + xpt.fragment + ")";
                xpt.type = XpathType.BOOLEAN;
                xpt.priority = 11;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            }
            return xpt;
        }
    }

    public static class Comparison
    extends XpathConstraintNode {
        String opname;

        public Comparison(XpathHelper xpathHelper, String name) {
            this.xpathHelper = xpathHelper;
            this.opname = name.equals("<>") ? "!=" : name;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            int refprio = 4;
            if (this.opname.equals("=") || this.opname.equals("!=")) {
                refprio = 3;
            }
            XpathFragment[] child_xpt = new XpathFragment[2];
            for (int i = 0; i < 2; ++i) {
                XpathConstraintNode child = (XpathConstraintNode)this.children.get(i);
                if (!child.hasSimpleType() && !child.hasIdentity()) {
                    return new XpathFragment(11, "***ERROR[126]***");
                }
                child_xpt[i] = child.translate(ctx);
                if (child.hasIdentity()) {
                    child_xpt[i].fragment = "generate-id(" + child_xpt[i].fragment + ")";
                    child_xpt[i].priority = 11;
                }
                if (child_xpt[i].fragment.length() == 0) {
                    child_xpt[i].fragment = ".";
                }
                if (child_xpt[i].priority <= refprio) {
                    child_xpt[i].bracket();
                }
                child_xpt[i].atEnd.setState(BindingContext.CtxState.NONE);
            }
            String op2 = child_xpt[0].merge(child_xpt[1]);
            child_xpt[0].fragment = child_xpt[0].fragment + " " + this.opname + " " + op2;
            child_xpt[0].type = XpathType.BOOLEAN;
            child_xpt[0].priority = refprio;
            return child_xpt[0];
        }
    }

    public static class Logic
    extends XpathConstraintNode {
        protected LogicType logic;

        public Logic(XpathHelper xpathHelper, LogicType logic) {
            this.xpathHelper = xpathHelper;
            this.logic = logic;
        }

        @Override
        public boolean isAndOrLogic(boolean isAnd) {
            if (this.logic == LogicType.XOR || this.logic == LogicType.EQV) {
                return false;
            }
            return this.logic == LogicType.AND == isAnd;
        }

        @Override
        public XpathFragment translate(BindingContext ctx) {
            if (this.children.size() == 1) {
                return ((XpathConstraintNode)this.children.get(0)).translate(ctx);
            }
            String particle = null;
            int refprio = -1;
            if (this.logic == LogicType.AND) {
                particle = "and";
                refprio = 2;
            } else if (this.logic == LogicType.OR) {
                particle = "or";
                refprio = 1;
            } else if (this.logic == LogicType.XOR) {
                particle = "!=";
                refprio = 3;
            } else {
                particle = "=";
                refprio = 3;
            }
            XpathFragment result = null;
            for (XpathConstraintNode ocn : this.children) {
                XpathFragment child_xpt = ocn.translate(ctx);
                if ((this.logic == LogicType.XOR || this.logic == LogicType.EQV) && child_xpt.type != XpathType.BOOLEAN) {
                    child_xpt.fragment = "boolean(" + child_xpt.fragment + ")";
                    child_xpt.type = XpathType.BOOLEAN;
                    child_xpt.priority = 11;
                } else if (child_xpt.priority < refprio) {
                    child_xpt.bracket();
                }
                child_xpt.atEnd.setState(BindingContext.CtxState.NONE);
                if (result == null) {
                    result = child_xpt;
                    continue;
                }
                String mrge = result.merge(child_xpt);
                result.fragment = result.fragment + " " + particle + " ";
                result.fragment = result.fragment + mrge;
            }
            result.priority = refprio;
            result.type = XpathType.BOOLEAN;
            return result;
        }

        protected static enum LogicType {
            AND,
            OR,
            XOR,
            EQV;

        }
    }

    public static class XpathFragment {
        public int priority;
        public String fragment;
        public XpathType type;
        public TreeMap<String, String> lets = null;
        public BindingContext atEnd = new BindingContext(BindingContext.CtxState.NONE);

        public XpathFragment(int p, String f, XpathType t) {
            this.priority = p;
            this.fragment = f;
            this.type = t;
        }

        public XpathFragment(int p, String f) {
            this.priority = p;
            this.fragment = f;
            this.type = XpathType.NODESET;
        }

        public void bracket() {
            this.fragment = "(" + this.fragment + ")";
            this.priority = 11;
        }

        public String merge(XpathFragment xf) {
            xf.replace("\\$(\\w*)", "%$1");
            if (xf.lets != null) {
                for (Map.Entry<String, String> ve : xf.lets.entrySet()) {
                    String vn = ve.getKey();
                    String ex = ve.getValue();
                    String vnew = this.findOrAdd(ex);
                    xf.replace("%" + vn, "\\$" + vnew);
                }
            }
            if (this.atEnd != null) {
                this.atEnd.merge(xf.atEnd);
            }
            return xf.fragment;
        }

        public String findOrAdd(String ex) {
            if (this.lets == null) {
                this.lets = new TreeMap();
            }
            for (Map.Entry<String, String> ve : this.lets.entrySet()) {
                if (!ve.getValue().equals(ex)) continue;
                return ve.getKey();
            }
            Object newkey = "A";
            if (!this.lets.isEmpty()) {
                String last = this.lets.lastKey();
                String lc = last.substring(last.length() - 1);
                if (lc.equals("Z")) {
                    newkey = last + "A";
                } else {
                    try {
                        byte[] bytes = lc.getBytes("US-ASCII");
                        bytes[0] = (byte)(bytes[0] + 1);
                        newkey = last.substring(0, last.length() - 1) + new String(bytes, "US-ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.lets.put((String)newkey, ex);
            return newkey;
        }

        private void replace(String from, String to) {
            Pattern pat = Pattern.compile(from);
            if (this.lets != null) {
                for (Map.Entry<String, String> ve : this.lets.entrySet()) {
                    String ex = ve.getValue();
                    Matcher matcher = pat.matcher(ex);
                    ve.setValue(matcher.replaceAll(to));
                }
            }
            Matcher matcher = pat.matcher(this.fragment);
            this.fragment = matcher.replaceAll(to);
        }
    }

    public static class BindingContext {
        public CtxState state;
        ArrayList<CtxElmt> vars = null;

        BindingContext(CtxState state) {
            this.state = state;
        }

        public BindingContext clone() {
            BindingContext copy = new BindingContext(this.state);
            if (this.vars != null) {
                for (CtxElmt ce : this.vars) {
                    copy.pushDeclaration(ce.vardecl);
                    copy.vars.get((int)(copy.vars.size() - 1)).noOfSteps = ce.noOfSteps;
                }
            }
            return copy;
        }

        public void setState(CtxState state) {
            this.state = state;
            this.vars = null;
        }

        public void pushDeclaration(OclNode.Declaration vd) {
            if (this.vars == null) {
                this.vars = new ArrayList();
            }
            this.vars.add(new CtxElmt(vd));
            this.state = CtxState.OTHER;
        }

        public void addStep() {
            if (this.vars == null || this.vars.size() == 0) {
                return;
            }
            ++this.vars.get((int)(this.vars.size() - 1)).noOfSteps;
        }

        public void popDeclaration() {
            if (this.vars == null || this.vars.size() == 0) {
                return;
            }
            this.vars.remove(this.vars.size() - 1);
        }

        public void merge(BindingContext ctx) {
            if (ctx == null) {
                return;
            }
            if (this.state == CtxState.NONE) {
                return;
            }
            if (ctx.state == CtxState.NONE) {
                this.setState(CtxState.NONE);
                return;
            }
            if (ctx.state == CtxState.ATCURRENT && this.state == CtxState.ATCURRENT) {
                return;
            }
            if (ctx.state == CtxState.OTHER && this.state == CtxState.OTHER) {
                int thissize = this.vars == null ? 0 : this.vars.size();
                int ctxsize = ctx.vars == null ? 0 : ctx.vars.size();
                int i = thissize - 1;
                for (int j = ctxsize - 1; i >= 0 && j >= 0; --i, --j) {
                    CtxElmt cei = this.vars.get(i);
                    CtxElmt cej = ctx.vars.get(j);
                    if (cei.vardecl != cej.vardecl || cei.noOfSteps != cej.noOfSteps) break;
                }
                while (i >= 0) {
                    this.vars.remove(i--);
                }
                if (this.vars != null && this.vars.size() == 0) {
                    this.vars = null;
                }
            } else {
                this.state = CtxState.OTHER;
                this.vars = null;
            }
        }

        public class CtxElmt {
            public OclNode.Declaration vardecl;
            public int noOfSteps = 0;

            CtxElmt(OclNode.Declaration vd) {
                this.vardecl = vd;
            }
        }

        public static enum CtxState {
            NONE,
            ATCURRENT,
            OTHER;

        }
    }

    protected static enum XpathType {
        BOOLEAN,
        NUMBER,
        STRING,
        NODESET;

    }
}

