/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Namespace;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.w3c.dom.Element;

public class TargetConfiguration
extends ProcessConfiguration {
    private SortedSet<String> inputIds;
    private List<Namespace> namespaces;
    private Map<String, Namespace> namespaceByNamespace = new HashMap<String, Namespace>();
    private Map<String, Namespace> namespaceByAbbreviation = new HashMap<String, Namespace>();

    public TargetConfiguration(String className, ProcessMode processMode, Map<String, String> parameters, Map<String, ProcessRuleSet> ruleSets, List<ProcessMapEntry> mapEntries, SortedSet<String> inputIds, List<Namespace> namespaces, Element advancedProcessConfigurations) {
        super(className, processMode, parameters, ruleSets, mapEntries, advancedProcessConfigurations);
        this.inputIds = inputIds;
        this.namespaces = namespaces;
        if (namespaces != null) {
            for (Namespace ns : namespaces) {
                this.namespaceByNamespace.put(ns.getNs(), ns);
                this.namespaceByAbbreviation.put(ns.getNsabr(), ns);
            }
        }
    }

    public SortedSet<String> getInputIds() {
        return this.inputIds;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TargetConfiguration:\r\n");
        sb.append("--- with process configuration:\r\n");
        sb.append(super.toString());
        sb.append("\tinputs: \r\n");
        for (String s : this.inputIds) {
            sb.append("\t\t" + s + "\r\n");
        }
        if (this.namespaces != null) {
            sb.append("\tnamespaces: \r\n");
            for (Namespace ns : this.namespaces) {
                sb.append("\t\t(" + ns.getNsabr() + "|" + ns.getNs() + "|" + (ns.getLocation() != null ? ns.getLocation() : "NA") + ")\r\n");
            }
        }
        return sb.toString();
    }

    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    public String nsabrForNamespace(String namespace) {
        if (this.namespaceByNamespace.containsKey(namespace)) {
            return this.namespaceByNamespace.get(namespace).getNsabr();
        }
        return null;
    }

    public String fullNamespace(String abbreviation) {
        if (this.namespaceByAbbreviation.containsKey(abbreviation)) {
            return this.namespaceByAbbreviation.get(abbreviation).getNs();
        }
        return null;
    }

    public boolean hasNamespaceWithAbbreviation(String abbrev) {
        return this.fullNamespace(abbrev) != null;
    }

    public String locationOfNamespace(String namespace) {
        if (this.namespaceByNamespace.containsKey(namespace)) {
            return this.namespaceByNamespace.get(namespace).getLocation();
        }
        return null;
    }
}

