/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Model.Descriptors;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.LangString;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Qualifier;
import de.interactive_instruments.ShapeChange.Model.TaggedValues;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XpathFragment;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XpathType;
import de.interactive_instruments.ShapeChange.TargetXmlSchemaConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import de.interactive_instruments.ShapeChange.XsdPropertyMapEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XsdDocument
implements MessageSource {
    public static final String DGIWGSP_NSABR = "gmldgiwgsp";
    public static final String DGIWGSP_NS = "http://www.dgiwg.org/gml/3.2/profiles/spatial/1.0/";
    public static final String GMLSF_NSABR = "gmlsf";
    public static final String GMLSF_NS = "http://www.opengis.net/gmlsf/2.0";
    protected Document document = null;
    protected Element root = null;
    protected Element rootAnnotation = null;
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected TargetXmlSchemaConfiguration config = null;
    protected Model model = null;
    protected String name = null;
    protected Vector<String> includes = new Vector();
    protected Vector<String> imports = new Vector();
    protected boolean printed = false;
    protected String targetNamespace = null;
    protected String outputDirectory;
    protected String documentationTemplate = null;
    protected String documentationNoValue = null;
    protected String okstraKeyValuePropertyType;
    protected String okstraKeyValueBaseType;
    protected String okstraObjectRefType;
    protected String okstraPrefix;
    protected String okstra;
    protected String codeListRepresentationTVFallback;
    protected EnumSet<Descriptor> descriptorsToRepresent = EnumSet.noneOf(Descriptor.class);
    protected SchematronSchema schDoc;

    public XsdDocument(PackageInfo pi, Model m, Options o, ShapeChangeResult r, TargetXmlSchemaConfiguration c, String n, SchematronSchema schDoc) throws ShapeChangeAbortException, ParserConfigurationException {
        this.options = o;
        this.result = r;
        this.model = m;
        this.config = c;
        this.name = n;
        this.schDoc = schDoc;
        this.outputDirectory = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        this.documentationTemplate = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "documentationTemplate");
        this.documentationNoValue = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "documentationNoValue");
        this.codeListRepresentationTVFallback = this.options.parameterAsString(XmlSchema.class.getName(), "defaultCodeListRepresentation", null, false, true);
        List<String> namesOfDescriptorsToRepresent = this.options.parameterAsStringList("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "representDescriptors", null, true, true);
        for (String descriptorName : namesOfDescriptorsToRepresent) {
            Descriptor desc = Descriptor.valueOf(descriptorName.toUpperCase(Locale.ENGLISH));
            this.descriptorsToRepresent.add(desc);
        }
        String s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "okstraKeyValuePropertyType");
        this.okstraKeyValuePropertyType = s != null ? s : "okstra-basis:KeyValuePropertyType";
        s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "okstraKeyValueBaseType");
        this.okstraKeyValueBaseType = s != null ? s : "gml:AbstractFeatureType";
        s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "okstraObjectRefType");
        this.okstraObjectRefType = s != null ? s : "okstra-basis:ObjectRefType";
        this.okstraPrefix = this.okstraKeyValuePropertyType.split(":")[0];
        s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "okstra");
        this.okstra = s != null ? s : "false";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.document = db.newDocument();
        this.root = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        this.document.appendChild(this.root);
        this.addAttribute(this.root, "xmlns", "http://www.w3.org/2001/XMLSchema");
        this.addAttribute(this.root, "elementFormDefault", "qualified");
        this.addAttribute(this.root, "version", pi.version());
        this.targetNamespace = pi.targetNamespace();
        this.addAttribute(this.root, "targetNamespace", this.targetNamespace);
        this.addAttribute(this.root, "xmlns:" + pi.xmlns(), this.targetNamespace);
        this.rootAnnotation = this.addStandardAnnotation(this.root, pi);
        if (this.options.getCurrentProcessConfig().parameterAsString("processOutput_addComment", null, false, true) == null) {
            this.addCreationComment(this.root);
        }
    }

    public SchematronSchema getSchematronDocument() {
        return this.schDoc;
    }

    protected void addAttribute(Element e, String name, String value) {
        Attr att = this.document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Comment addCreationComment(Element e) {
        Comment e1 = this.document.createComment("XML Schema document created by ShapeChange - http://shapechange.net/");
        e.appendChild(e1);
        return e1;
    }

    protected Element addStandardAnnotation(Element e, Info info) {
        Descriptors descriptors;
        TaggedValues taggedValues;
        Element e1 = null;
        if (!info.matches("rule-xsd-all-no-documentation")) {
            Object txt;
            if (this.documentationTemplate != null) {
                txt = info.derivedDocumentation(this.documentationTemplate, this.documentationNoValue);
            } else {
                txt = info.definition();
                if (txt != null) {
                    txt = ((String)txt).trim();
                    txt = ((String)txt).replaceAll("\r\n", "\n");
                    if (!((String)(txt = ((String)txt).replaceAll("\r", "\n"))).isEmpty()) {
                        String s = info.description();
                        if (s != null && !s.isEmpty()) {
                            s = s.trim();
                            s = s.replaceAll("\r\n", "\n");
                            s = s.replaceAll("\r", "\n");
                            txt = (String)txt + "\nNOTE " + s;
                        }
                        if ((s = info.aliasName()) != null && !s.trim().isEmpty()) {
                            s = s.trim();
                            s = s.replaceAll("\r\n", "\n");
                            s = s.replaceAll("\r", "\n");
                            txt = s + ": " + (String)txt;
                        }
                    }
                }
            }
            if (txt != null && !((String)txt).trim().isEmpty()) {
                e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "documentation");
                txt = this.options.internalize((String)txt);
                e1.appendChild(this.document.createTextNode((String)txt));
            }
        }
        Element e2 = null;
        if (info instanceof PackageInfo) {
            String gmlsfComplianceLevel;
            Element e0;
            String profile;
            PackageInfo pi = (PackageInfo)info;
            if (info.matches("rule-xsd-pkg-gmlProfileSchema") && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (profile = pi.gmlProfileSchema()) != null && !profile.trim().isEmpty()) {
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                e0 = this.document.createElementNS(this.options.GML_NS, "gmlProfileSchema");
                e2.appendChild(e0);
                e0.appendChild(this.document.createTextNode(profile));
            }
            if (info.matches("rule-xsd-pkg-dgiwgsp")) {
                String dgiwgComplianceLevel = pi.taggedValue("dgiwgComplianceLevel");
                String dgiwgGMLProfileSchema = pi.taggedValue("dgiwgGMLProfileSchema");
                if (StringUtils.isNotBlank((CharSequence)dgiwgComplianceLevel) && StringUtils.isNotBlank((CharSequence)dgiwgGMLProfileSchema)) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    this.addAttribute(e2, "source", this.options.schemaLocationOfNamespace(DGIWGSP_NS));
                    Element e02 = this.document.createElementNS(DGIWGSP_NS, "ComplianceLevel");
                    e2.appendChild(e02);
                    e02.appendChild(this.document.createTextNode(dgiwgComplianceLevel));
                    e02 = this.document.createElementNS(DGIWGSP_NS, "GMLProfileSchema");
                    e2.appendChild(e02);
                    e02.appendChild(this.document.createTextNode(dgiwgGMLProfileSchema));
                    this.addImport(DGIWGSP_NSABR, DGIWGSP_NS);
                }
            }
            if (info.matches("rule-xsd-pkg-gmlsf") && StringUtils.isNotBlank((CharSequence)(gmlsfComplianceLevel = pi.taggedValue("gmlsfComplianceLevel")))) {
                e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                this.addAttribute(e2, "source", this.options.schemaLocationOfNamespace(GMLSF_NS));
                e0 = this.document.createElementNS(GMLSF_NS, "ComplianceLevel");
                e2.appendChild(e0);
                e0.appendChild(this.document.createTextNode(gmlsfComplianceLevel));
                this.addImport(GMLSF_NSABR, GMLSF_NS);
            }
        }
        if ((info instanceof PropertyInfo || info instanceof ClassInfo) && StringUtils.isNotBlank((CharSequence)info.globalIdentifier()) && info.matches("rule-xsd-all-globalIdentifierAnnotation")) {
            if (e2 == null) {
                e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
            }
            Element e3 = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/AppInfo", "sc:globalIdentifier");
            e2.appendChild(e3);
            e3.appendChild(this.document.createTextNode(info.globalIdentifier()));
            this.addImport("sc", "http://www.interactive-instruments.de/ShapeChange/AppInfo");
        }
        if (info instanceof PropertyInfo) {
            Object e3;
            PropertyInfo propi = (PropertyInfo)info;
            ClassInfo ci = this.model.classById(propi.typeInfo().id);
            if (ci != null) {
                Element e32;
                if (info.matches("rule-xsd-prop-targetElement") && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (propi.inlineOrByReference().equals("byreference") || ci.category() == 12 && ci.matches("rule-xsd-cls-okstra-fid")) && ci.category() != 2 && this.classHasObjectElement(ci)) {
                    String s;
                    if (e2 == null) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    }
                    if ((s = this.mapElement(ci)) == null) {
                        s = ci.qname();
                    }
                    e32 = this.document.createElementNS(this.options.GML_NS, "targetElement");
                    e2.appendChild(e32);
                    e32.appendChild(this.document.createTextNode(s));
                }
                if (propi.inClass().matches("rule-xsd-cls-codelist-asDictionaryGml33") && (ci.asDictionary() || ci.asDictionaryGml33())) {
                    if (e2 == null) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    }
                    e3 = this.document.createElementNS(Options.GMLEXR_NS, "targetCodeList");
                    e2.appendChild((Node)e3);
                    e3.appendChild(this.document.createTextNode(ci.name()));
                    this.addImport("gmlexr", Options.GMLEXR_NS);
                }
                if (ci.category() == 2 && propi.matches("rule-xsd-prop-targetCodeListURI")) {
                    String codeListURI = StringUtils.stripToNull((String)ci.taggedValue("codeList"));
                    if (codeListURI == null) {
                        codeListURI = StringUtils.stripToNull((String)ci.taggedValue("vocabulary"));
                    }
                    if (codeListURI != null) {
                        if (e2 == null) {
                            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                        }
                        e32 = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/AppInfo", "sc:targetCodeListURI");
                        e2.appendChild(e32);
                        e32.appendChild(this.document.createTextNode(codeListURI));
                        this.addImport("sc", "http://www.interactive-instruments.de/ShapeChange/AppInfo");
                    }
                }
            }
            if (info.matches("rule-xsd-prop-reverseProperty") && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && propi.reverseProperty() != null && propi.reverseProperty().isNavigable()) {
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                e3 = this.document.createElementNS(this.options.GML_NS, "reversePropertyName");
                e2.appendChild((Node)e3);
                e3.appendChild(this.document.createTextNode(this.config.determineQName(propi.reverseProperty())));
            }
            if (info.matches("rule-xsd-prop-defaultCodeSpace") && !propi.defaultCodeSpace().isEmpty() && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                e3 = this.document.createElementNS(this.options.GML_NS, "defaultCodeSpace");
                e2.appendChild((Node)e3);
                e3.appendChild(this.document.createTextNode(propi.defaultCodeSpace()));
            }
        }
        if (info.matches("rule-xsd-all-tagged-values") && !(taggedValues = info.taggedValuesForTagList(this.options.parameter("representTaggedValues"))).isEmpty()) {
            TreeSet<String> tags = new TreeSet<String>(taggedValues.keySet());
            for (String tag : tags) {
                String[] values = taggedValues.get(tag);
                List<String> valueList = Arrays.asList(values);
                Collections.sort(valueList);
                for (String v : values) {
                    if (v.trim().length() <= 0) continue;
                    if (e2 == null) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    }
                    Element e3 = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/AppInfo", "sc:taggedValue");
                    this.addAttribute(e3, "tag", tag);
                    e3.appendChild(this.document.createTextNode(v));
                    e2.appendChild(e3);
                    this.addImport("sc", "http://www.interactive-instruments.de/ShapeChange/AppInfo");
                }
            }
        }
        if (info.matches("rule-xsd-all-descriptorAnnotation") && !this.descriptorsToRepresent.isEmpty() && !(descriptors = info.descriptors()).isEmpty()) {
            for (Descriptor descToRep : this.descriptorsToRepresent) {
                if (!descriptors.has(descToRep)) continue;
                List<LangString> descVals = descriptors.values(descToRep);
                Collections.sort(descVals);
                for (LangString ls : descVals) {
                    if (!ls.hasValue()) continue;
                    if (e2 == null) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    }
                    Element e3 = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/AppInfo", "sc:descriptor");
                    this.addAttribute(e3, "name", descToRep.getName());
                    if (ls.hasLang()) {
                        this.addAttribute(e3, "lang", ls.getLang());
                    }
                    e3.appendChild(this.document.createTextNode(ls.getValue()));
                    e2.appendChild(e3);
                    this.addImport("sc", "http://www.interactive-instruments.de/ShapeChange/AppInfo");
                }
            }
        }
        if (e1 != null || e2 != null) {
            Element e0 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
            if (e1 != null) {
                e0.appendChild(e1);
            }
            if (e2 != null) {
                e0.appendChild(e2);
            }
            e.appendChild(e0);
            return e0;
        }
        return null;
    }

    private boolean classHasObjectType(ClassInfo ci) {
        int cat = ci.category();
        return cat == 5 || cat == 8 && !ci.asGroup() || cat == 1 || cat == 6 || cat == 12 && ci.matches("rule-xsd-cls-okstra-fid");
    }

    private boolean classHasObjectElement(ClassInfo ci) {
        int cat = ci.category();
        if (ci.matches("rule-xsd-cls-enum-object-element") && (cat == 3 || cat == 2)) {
            return true;
        }
        return this.classHasObjectType(ci);
    }

    private boolean classHasIdentity(ClassInfo ci) {
        int cat = ci.category();
        return cat == 4 || cat == 1 || cat == 6 || cat == 12 && ci.matches("rule-xsd-cls-okstra-fid") || (cat == 5 || cat == 8) && ci.matches("rule-xsd-cls-standard-swe-property-types");
    }

    private String addImport(String qname) {
        this.result.addDebug(this, 10022, qname);
        String s = qname.trim();
        if (s.isEmpty()) {
            return null;
        }
        int idx = s.indexOf(":");
        if (idx > 0) {
            String nsabr = s.substring(0, idx);
            this.addImport(nsabr, this.options.fullNamespace(nsabr));
        }
        return s;
    }

    protected String mapBaseType(ClassInfo ci) {
        String s = null;
        MapEntry me = this.options.baseMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me == null) {
            if (this.classHasObjectType(ci)) {
                s = this.typeName(ci, true);
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 117, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        } else {
            s = this.addImport(me.p1);
        }
        return s;
    }

    protected String mapElement(ClassInfo ci) {
        if (ci == null) {
            return null;
        }
        String s = null;
        MapEntry me = this.options.elementMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me == null) {
            if (this.classHasObjectElement(ci)) {
                s = this.elementName(ci, true);
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 119, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        } else {
            s = this.addImport(me.p1);
        }
        return s;
    }

    private String elementName(ClassInfo ci, boolean qualified) {
        if (ci != null) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                if (ci.matches("rule-xsd-all-naming-19139")) {
                    if (ci.isAbstract()) {
                        return (String)(qualified ? ci.pkg().xmlns() + ":" : "") + "Abstract" + ci.name();
                    }
                    return qualified ? ci.qname() : ci.name();
                }
                if (ci.matches("rule-xsd-all-naming-gml") || ci.matches("rule-xsd-all-naming-swe")) {
                    return qualified ? ci.qname() : ci.name();
                }
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 154, "object element", ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        }
        return null;
    }

    private String typeName(ClassInfo ci, boolean qualified) {
        if (ci != null) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                if (ci.matches("rule-xsd-all-naming-19139")) {
                    if (ci.category() == 2) {
                        return qualified ? "gco:CodeListValue_Type" : "CodeListValue_Type";
                    }
                    if (ci.isAbstract()) {
                        return this.options.internalize((String)(qualified ? ci.pkg().xmlns() + ":" : "") + "Abstract" + ci.name() + "_Type");
                    }
                    return this.options.internalize((qualified ? ci.qname() : ci.name()) + "_Type");
                }
                if (ci.matches("rule-xsd-all-naming-gml") || ci.matches("rule-xsd-all-naming-swe")) {
                    return this.options.internalize((qualified ? ci.qname() : ci.name()) + (ci.name().endsWith("Property") ? "_" : "") + "Type");
                }
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 154, "type", ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        }
        return null;
    }

    private String propertyTypeName(ClassInfo ci, boolean qualified) {
        if (ci != null) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                if (ci.matches("rule-xsd-all-naming-19139")) {
                    if (ci.isAbstract()) {
                        return (String)(qualified ? ci.pkg().xmlns() + ":" : "") + "Abstract" + ci.name() + "_PropertyType";
                    }
                    return (qualified ? ci.qname() : ci.name()) + "_PropertyType";
                }
                if (ci.matches("rule-xsd-all-naming-gml") || ci.matches("rule-xsd-all-naming-swe")) {
                    Object propertyTypeName = (qualified ? ci.qname() : ci.name()) + (ci.name().endsWith("Property") ? "_" : "") + "PropertyType";
                    propertyTypeName = this.options.internalize((String)propertyTypeName);
                    return propertyTypeName;
                }
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 154, "property type", ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        }
        return null;
    }

    private String defaultSubstitutionGroup(ClassInfo ci) {
        int cat = ci.category();
        if (ci.matches("rule-xsd-cls-no-gml-types")) {
            return null;
        }
        if (ci.matches("rule-xsd-all-naming-gml")) {
            this.addImport("gml", this.options.fullNamespace("gml"));
            if (cat == 6) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    if (ci.matches("rule-xsd-all-gml21")) {
                        return "gml:_Feature";
                    }
                    return "gml:_GML";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractGML";
                }
            } else if (cat == 5 || cat == 8) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractObject";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    if (ci.matches("rule-xsd-all-gml21")) {
                        return null;
                    }
                    return "gml:_Object";
                }
            } else if (cat == 1) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    return "gml:_Feature";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractFeature";
                }
            }
        } else if (ci.matches("rule-xsd-all-naming-swe")) {
            this.addImport("swe", this.options.fullNamespace("swe"));
            if (cat == 6) {
                return "swe:AbstractSWE";
            }
        } else if (ci.matches("rule-xsd-all-naming-19139") && cat != 8) {
            this.addImport("gco", this.options.fullNamespace("gco"));
            if (cat == 2 || cat == 3) {
                return "gco:CharacterString";
            }
            return "gco:AbstractObject";
        }
        return null;
    }

    private String defaultBaseType(ClassInfo ci) {
        int cat = ci.category();
        if (ci.matches("rule-xsd-cls-no-gml-types")) {
            return null;
        }
        if (ci.matches("rule-xsd-all-naming-gml")) {
            this.addImport("gml", this.options.fullNamespace("gml"));
            if (cat == 6) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    if (ci.matches("rule-xsd-all-gml21")) {
                        return "gml:AbstractFeatureType";
                    }
                    return "gml:AbstractGMLType";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractGMLType";
                }
            } else if (cat == 1) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    return "gml:AbstractFeatureType";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractFeatureType";
                }
            }
        } else if (ci.matches("rule-xsd-all-naming-swe")) {
            this.addImport("swe", this.options.fullNamespace("swe"));
            if (cat == 6) {
                return "swe:AbstractSWEType";
            }
        } else if (ci.matches("rule-xsd-all-naming-19139") && cat != 8) {
            this.addImport("gco", this.options.fullNamespace("gco"));
            return "gco:AbstractObject_Type";
        }
        return null;
    }

    public void pObjectElement(ClassInfo ci, ClassInfo cibase) {
        String s;
        if (ci.pkg() == null || ci.pkg().xmlns() == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
            return;
        }
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.document.getDocumentElement().appendChild(e4);
        this.addAttribute(e4, "name", this.elementName(ci, false));
        this.addAttribute(e4, "type", this.typeName(ci, true));
        if (ci.isAbstract()) {
            this.addAttribute(e4, "abstract", "true");
        }
        if (cibase == null) {
            String s2 = this.defaultSubstitutionGroup(ci);
            if (s2 != null) {
                this.addAttribute(e4, "substitutionGroup", s2);
            }
        } else if (this.classHasObjectElement(cibase) && (s = this.mapElement(cibase)) != null) {
            this.addAttribute(e4, "substitutionGroup", s);
            this.addImport(cibase.pkg().xmlns(), cibase.pkg().targetNamespace());
        }
        this.addStandardAnnotation(e4, ci);
    }

    public Element pComplexType(ClassInfo ci, ClassInfo cibase, SchematronSchema schDoc) {
        int idx;
        String xmlElement;
        String s;
        ClassInfo baseType;
        MapEntry me;
        ShapeChangeResult.MessageContext mc;
        Element e3;
        int cat = ci.category();
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.typeName(ci, false));
        if (ci.isAbstract()) {
            this.addAttribute(e1, "abstract", "true");
        }
        if (cibase == null && (cat == 5 || cat == 8) && ci.matches("rule-xsd-all-naming-gml")) {
            e3 = e1;
        } else {
            String s2 = null;
            if (cibase == null) {
                s2 = this.defaultBaseType(ci);
            } else {
                s2 = this.mapBaseType(cibase);
                if (s2 == null) {
                    this.result.addError(this, 158);
                    s2 = "fixme:fixme";
                }
                this.addImport(cibase.pkg().xmlns(), cibase.pkg().targetNamespace());
            }
            if (s2 != null) {
                Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                e1.appendChild(e2);
                e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                e2.appendChild(e3);
                this.addAttribute(e3, "base", s2);
            } else if (cibase != null) {
                mc = this.result.addError(null, 121, cibase == null ? "<unknown>" : cibase.name(), this.typeName(ci, false));
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci == null ? "<unknown>" : ci.fullName());
                }
                e3 = e1;
            } else {
                e3 = e1;
            }
        }
        Element ret = null;
        if (cat == 8 && ci.matches("rule-xsd-cls-union-as-choice")) {
            if (cibase == null && ci.properties().size() > 0) {
                ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
            } else if (ci.properties().size() > 0 && cibase.properties().size() > 0 && (mc = this.result.addError(this, 2000, ci.name(), cibase.name())) != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        } else if (ci.matches("rule-xsd-cls-sequence")) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            if (ci.matches("rule-xsd-cls-mixin-classes")) {
                if (ci.matches("rule-xsd-cls-mixin-classes-as-group")) {
                    this.addGroupReferences(ci, ret, false);
                } else {
                    this.addMixinProperties(ci, ret, schDoc);
                }
            }
        } else {
            mc = this.result.addError(this, 155, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        }
        if (ret != null) {
            e3.appendChild(ret);
        }
        if (ci.baseClass() != null && ci.matches("rule-xsd-cls-standard-19139-isoType") && (me = this.options.elementMapEntry((baseType = ci.baseClass()).name(), baseType.encodingRule("xsd"))) != null && !(s = (xmlElement = me.p1).trim()).isEmpty() && (idx = s.indexOf(":")) > 0) {
            String metadataBaseTypeElementName;
            PackageInfo pkg;
            String nsabr = s.substring(0, idx);
            String ns = this.options.fullNamespace(nsabr);
            if (ns == null && (pkg = ci.model().schemaPackage(baseType)) != null && pkg.xmlns().equalsIgnoreCase(nsabr)) {
                ns = pkg.targetNamespace();
            }
            if (ns != null && (ns.equals("http://www.isotc211.org/2005/gco") || ns.equals("http://www.isotc211.org/2005/gmd") || ns.equals("http://www.isotc211.org/2005/gmx") || ns.equals("http://www.isotc211.org/2005/gsr") || ns.equals("http://www.isotc211.org/2005/gss") || ns.equals("http://www.isotc211.org/2005/gts")) && (metadataBaseTypeElementName = s.substring(idx + 1)) != null) {
                this.addImport("gco", this.options.fullNamespace("gco"));
                Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                e3.appendChild(e4);
                this.addAttribute(e4, "ref", "gco:isoType");
                this.addAttribute(e4, "use", "required");
                this.addAttribute(e4, "fixed", metadataBaseTypeElementName);
            }
        }
        return ret;
    }

    public void pValueTypeGroup(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", ci.name());
        this.addStandardAnnotation(e1, ci);
        Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        e1.appendChild(e2);
        for (PropertyInfo propi : ci.properties().values()) {
            ShapeChangeResult.MessageContext mc;
            ClassInfo vci = this.model.classById(propi.typeInfo().id);
            if (vci != null) {
                if (this.classHasObjectElement(vci)) {
                    String s = this.mapElement(vci);
                    if (s != null) {
                        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
                        e2.appendChild(e3);
                        this.addAttribute(e3, "ref", s);
                        this.addImport(vci.pkg().xmlns(), vci.pkg().targetNamespace());
                        continue;
                    }
                    ShapeChangeResult.MessageContext mc2 = this.result.addError(this, 166, vci.name(), ci.name());
                    if (mc2 == null) continue;
                    mc2.addDetail(null, 400, "Property", propi.fullName());
                    continue;
                }
                mc = this.result.addError(this, 166, vci.name(), ci.name());
                if (mc == null) continue;
                mc.addDetail(null, 400, "Property", propi.fullName());
                continue;
            }
            mc = this.result.addError(null, 131, propi.name(), propi.typeInfo().name);
            if (mc == null) continue;
            mc.addDetail(null, 400, "Property", propi.fullName());
        }
    }

    public Element pGroup(ClassInfo ci, ClassInfo cibase) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", ci.name() + "Group");
        this.addStandardAnnotation(e1, ci);
        Element ret = null;
        if (ci.category() == 8 && ci.matches("rule-xsd-cls-union-as-choice")) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        } else if (ci.category() == 8 && ci.matches("rule-xsd-cls-union-as-group-property-type")) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        } else if (ci.matches("rule-xsd-cls-sequence")) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            if (ci.matches("rule-xsd-cls-mixin-classes") && ci.matches("rule-xsd-cls-mixin-classes-as-group")) {
                this.addGroupReferences(ci, ret, true);
            }
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 155, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        }
        e1.appendChild(ret);
        return ret;
    }

    private void addGroupReferences(ClassInfo ci, Element e, boolean recursive) {
        SortedSet<String> st = ci.supertypes();
        if (st != null && ci.matches("rule-xsd-cls-mixin-classes") && ci.matches("rule-xsd-cls-mixin-classes-as-group")) {
            for (String sid : st) {
                ClassInfo cix = this.model.classById(sid);
                if (cix != null && (cix.category() == 4 || cix.matches("rule-xsd-cls-no-abstract-classes") && cix.isAbstract())) {
                    Element eg = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
                    e.appendChild(eg);
                    this.addAttribute(eg, "ref", cix.qname() + "Group");
                    if (!recursive) continue;
                    this.addGroupReferences(cix, e, true);
                    continue;
                }
                if (cix == null || cix.category() == 4 || !ci.matches("rule-xsd-cls-mixin-classes-non-mixin-supertypes") || !recursive) continue;
                this.processLocalProperties(cix, e, null);
                if (!recursive) continue;
                this.addGroupReferences(cix, e, true);
            }
        }
    }

    private void addMixinProperties(ClassInfo ci, Element e, SchematronSchema schDoc) {
        SortedSet<String> st = ci.supertypes();
        if (st != null && ci.matches("rule-xsd-cls-mixin-classes") && !ci.matches("rule-xsd-cls-mixin-classes-as-group")) {
            for (String sid : st) {
                ClassInfo cix = this.model.classById(sid);
                if (cix == null || cix.category() != 4 && (!cix.matches("rule-xsd-cls-no-abstract-classes") || !cix.isAbstract())) continue;
                this.processLocalProperties(cix, e, schDoc);
                this.addMixinProperties(cix, e, schDoc);
            }
        }
    }

    private void addElements(Element e, HashSet<ClassInfo> v) {
        ClassInfo[] clArr = new ClassInfo[v.size()];
        v.toArray(clArr);
        Arrays.sort(clArr, new Comparator<ClassInfo>(){

            @Override
            public int compare(ClassInfo ci1, ClassInfo ci2) {
                return ci1.name().compareTo(ci2.name());
            }
        });
        for (int cidx = 0; cidx < clArr.length; ++cidx) {
            ClassInfo ci = clArr[cidx];
            String s = this.mapElement(ci);
            if (s == null) continue;
            Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            e.appendChild(e3);
            this.addAttribute(e3, "ref", s);
            this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
        }
    }

    private HashSet<ClassInfo> subtypes(ClassInfo ci) {
        HashSet<ClassInfo> res = new HashSet<ClassInfo>();
        if (ci.subtypes() != null) {
            for (String subtypeId : ci.subtypes()) {
                ClassInfo cix = this.model.classById(subtypeId);
                if (cix != null && (cix.category() == 4 || cix.matches("rule-xsd-cls-no-abstract-classes") && cix.isAbstract())) {
                    res.addAll(this.subtypes(cix));
                    continue;
                }
                res.add(cix);
            }
        }
        return res;
    }

    private HashSet<ClassInfo> subtypesOfMixins(ClassInfo ci, boolean inMixin) {
        HashSet<ClassInfo> res = new HashSet<ClassInfo>();
        if (ci.subtypes() != null) {
            for (String subtypeId : ci.subtypes()) {
                ClassInfo cix = this.model.classById(subtypeId);
                if (cix != null && (cix.category() == 4 || cix.matches("rule-xsd-cls-no-abstract-classes") && cix.isAbstract())) {
                    res.addAll(this.subtypesOfMixins(cix, true));
                    continue;
                }
                if (inMixin) {
                    res.add(cix);
                    continue;
                }
                res.addAll(this.subtypesOfMixins(cix, false));
            }
        }
        return res;
    }

    public void pPropertyTypeWithSubtypes(ClassInfo ci) {
        if (ci.matches("rule-xsd-cls-noPropertyType") && !ci.includePropertyType()) {
            return;
        }
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.propertyTypeName(ci, false));
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        e1.appendChild(e4);
        this.addAttribute(e4, "minOccurs", "0");
        this.addElements(e4, this.subtypes(ci));
        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
        e1.appendChild(e4);
        if (ci.matches("rule-xsd-cls-no-gml-types")) {
            this.addAttribute(e4, "ref", "xlink:simpleAttrs");
            this.addImport("xlink", this.options.fullNamespace("xlink"));
        } else {
            this.addAttribute(e4, "ref", "gml:AssociationAttributeGroup");
            this.addImport("gml", this.options.fullNamespace("gml"));
            if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e4);
                this.addAttribute(e4, "ref", "gml:OwnershipAttributeGroup");
            }
        }
    }

    public void pPropertyTypes(ClassInfo ci) {
        if (ci.matches("rule-xsd-cls-noPropertyType") && !ci.includePropertyType()) {
            return;
        }
        boolean rnobase = ci.matches("rule-xsd-cls-no-gml-types");
        boolean rgml = ci.matches("rule-xsd-cls-standard-gml-property-types");
        boolean r19139 = ci.matches("rule-xsd-cls-standard-19139-property-types");
        boolean rswe = ci.matches("rule-xsd-cls-standard-swe-property-types");
        HashSet<ClassInfo> instatiableMixinSubclasses = null;
        if (ci.matches("rule-xsd-cls-mixin-classes-non-mixin-supertypes")) {
            instatiableMixinSubclasses = this.subtypesOfMixins(ci, false);
        }
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.propertyTypeName(ci, false));
        Element e4 = instatiableMixinSubclasses != null && !instatiableMixinSubclasses.isEmpty() ? this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice") : this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        e1.appendChild(e4);
        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        e4.appendChild(e3);
        String s = this.elementName(ci, true);
        if (s != null) {
            this.addAttribute(e3, "ref", s);
        }
        if (instatiableMixinSubclasses != null && !instatiableMixinSubclasses.isEmpty()) {
            this.addElements(e4, instatiableMixinSubclasses);
        }
        if (rgml && !rnobase) {
            if (this.classHasIdentity(ci)) {
                this.addAttribute(e4, "minOccurs", "0");
                e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e3);
                this.addAttribute(e3, "ref", "gml:AssociationAttributeGroup");
                this.addImport("gml", this.options.fullNamespace("gml"));
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                    e1.appendChild(e3);
                    this.addAttribute(e3, "ref", "gml:OwnershipAttributeGroup");
                }
            }
        } else if (rswe) {
            if (this.classHasIdentity(ci)) {
                this.addAttribute(e4, "minOccurs", "0");
                e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e3);
                this.addAttribute(e3, "ref", "swe:AssociationAttributeGroup");
                this.addImport("swe", this.options.fullNamespace("swe"));
            }
        } else if (r19139) {
            this.addAttribute(e4, "minOccurs", "0");
            int cat = ci.category();
            if (cat != 2 && cat != 3 && cat != 8) {
                e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                this.addAttribute(e3, "ref", "gco:ObjectReference");
                e1.appendChild(e3);
            }
            this.addImport("gco", this.options.fullNamespace("gco"));
            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            e1.appendChild(e3);
            this.addAttribute(e3, "ref", "gco:nilReason");
        } else {
            this.addAttribute(e4, "minOccurs", "0");
            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
            e1.appendChild(e3);
            this.addAttribute(e3, "ref", "xlink:simpleAttrs");
            this.addImport("xlink", this.options.fullNamespace("xlink"));
        }
        if (ci.matches("rule-xsd-cls-byValuePropertyType") && this.classHasIdentity(ci) && ci.includeByValuePropertyType()) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", ci.name() + "PropertyByValueType");
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            e1.appendChild(e4);
            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            e4.appendChild(e3);
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                this.addAttribute(e3, "ref", ci.qname());
            }
        }
    }

    public void pPropertyTypeWithGroup(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.propertyTypeName(ci, false));
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        e1.appendChild(e4);
        this.addAttribute(e4, "minOccurs", "0");
        this.addElements(e4, this.subtypes(ci));
        Element e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
        e4.appendChild(e5);
        this.addAttribute(e5, "ref", ci.qname());
        this.addAttribute(e4, "minOccurs", "0");
        e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
        e1.appendChild(e5);
        this.addAttribute(e5, "ref", "swe:AssociationAttributeGroup");
        this.addImport("swe", this.options.fullNamespace("swe"));
    }

    public void pOKSTRAKEYPropertyType(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", ci.name() + (ci.name().endsWith("Property") ? "_" : "") + "PropertyType");
        Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
        e1.appendChild(e2);
        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
        this.addAttribute(e3, "base", this.okstraKeyValuePropertyType);
        this.addImport(this.okstraPrefix, this.options.fullNamespace(this.okstraPrefix));
        e2.appendChild(e3);
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        e3.appendChild(e4);
        Element e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.addAttribute(e5, "ref", ci.qname());
        this.addAttribute(e5, "minOccurs", "0");
        e4.appendChild(e5);
        e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.addAttribute(e5, "name", ci.name());
        this.document.getDocumentElement().appendChild(e5);
        Element e6 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        e5.appendChild(e6);
        Element e7 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
        e6.appendChild(e7);
        Element e8 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
        this.addAttribute(e8, "base", this.okstraKeyValueBaseType);
        e7.appendChild(e8);
        Element e9 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        e8.appendChild(e9);
        Element e10 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        e9.appendChild(e10);
        this.addAttribute(e10, "name", "Kennung");
        this.addAttribute(e10, "type", "string");
        e10 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        e9.appendChild(e10);
        this.addAttribute(e10, "name", "Langtext");
        this.addAttribute(e10, "type", "string");
    }

    private Element pAnonymousBasicType(ClassInfo ci) {
        Element e1 = null;
        String id = ci.id();
        if (id != null) {
            if (ci.matches("rule-xsd-cls-basictype-list") && ci.properties().size() == 1 && ci.properties().values().iterator().next().cardinality().maxOccurs > 1) {
                MapEntry me;
                e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                this.addStandardAnnotation(e1, ci);
                PropertyInfo pi = ci.properties().values().iterator().next();
                ClassInfo typeCi = this.model.classByIdOrName(pi.typeInfo());
                Object itemType = null;
                if (typeCi != null) {
                    me = this.options.baseMapEntry(typeCi.name(), ci.encodingRule("xsd"));
                    if (me != null) {
                        itemType = me.p1;
                        this.addImport(me.p1);
                    }
                    if (itemType == null) {
                        itemType = typeCi.qname() + "Type";
                        this.addImport(typeCi.pkg().xmlns(), typeCi.pkg().targetNamespace());
                    }
                } else {
                    me = this.options.baseMapEntry(pi.typeInfo().name, ci.encodingRule("xsd"));
                    if (me != null) {
                        itemType = me.p1;
                        this.addImport(me.p1);
                    } else {
                        itemType = "FIXME";
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 2001, pi.typeInfo().name, pi.name(), ci.name());
                        if (mc != null) {
                            mc.addDetail(null, 400, "Class", ci.fullName());
                        }
                    }
                }
                Element eList = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "list");
                this.addAttribute(eList, "itemType", (String)itemType);
                if (pi.cardinality().minOccurs == 0 && pi.cardinality().maxOccurs == Integer.MAX_VALUE) {
                    e1.appendChild(eList);
                } else {
                    Element eRestrict = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                    e1.appendChild(eRestrict);
                    Element eSimpleTypeChild = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                    eSimpleTypeChild.appendChild(eList);
                    eRestrict.appendChild(eSimpleTypeChild);
                    if (pi.cardinality().minOccurs == pi.cardinality().maxOccurs) {
                        int length = pi.cardinality().minOccurs;
                        Element eLength = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "length");
                        this.addAttribute(eLength, "value", "" + length);
                        eRestrict.appendChild(eLength);
                    } else {
                        if (pi.cardinality().minOccurs > 0) {
                            Element eMinLength = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "minLength");
                            this.addAttribute(eMinLength, "value", "" + pi.cardinality().minOccurs);
                            eRestrict.appendChild(eMinLength);
                        }
                        if (pi.cardinality().maxOccurs != Integer.MAX_VALUE) {
                            Element eMaxLength = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
                            this.addAttribute(eMaxLength, "value", "" + pi.cardinality().maxOccurs);
                            eRestrict.appendChild(eMaxLength);
                        }
                    }
                }
            } else {
                Object base = ci.taggedValue("base");
                String length = ci.taggedValue("length");
                if (StringUtils.isBlank((CharSequence)length)) {
                    length = ci.taggedValue("maxLength");
                }
                String pattern = ci.taggedValue("pattern");
                String min = ci.taggedValue("rangeMinimum");
                String max = ci.taggedValue("rangeMaximum");
                String typecontent = "simple/simple";
                String baseType = null;
                if (StringUtils.isBlank((CharSequence)base)) {
                    MapEntry me;
                    if (ci.supertypes() != null) {
                        for (String supertypeId : ci.supertypes()) {
                            ClassInfo cix = this.model.classById(supertypeId);
                            if (cix == null) continue;
                            MapEntry me2 = this.options.baseMapEntry(cix.name(), ci.encodingRule("xsd"));
                            if (me2 != null) {
                                base = me2.p1;
                                typecontent = me2.p2;
                            }
                            if (base != null) continue;
                            base = cix.qname() + "Type";
                        }
                    }
                    if ((me = this.findBaseMapEntryInSupertypes(ci, ci.encodingRule("xsd"), "simple", "simple")) != null) {
                        baseType = me.p1;
                    }
                }
                if (baseType == null) {
                    baseType = base;
                }
                if (StringUtils.isNotBlank((CharSequence)base)) {
                    Element e5;
                    Element e3;
                    Element e4;
                    if (typecontent.equals("complex/simple")) {
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        this.addStandardAnnotation(e1, ci);
                        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                        e1.appendChild(e4);
                        e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                        e4.appendChild(e3);
                    } else if (typecontent.equals("simple/simple")) {
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                        this.addStandardAnnotation(e1, ci);
                        e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                        e1.appendChild(e3);
                    } else {
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        this.addStandardAnnotation(e1, ci);
                        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                        e1.appendChild(e4);
                        e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e4.appendChild(e3);
                    }
                    this.addAttribute(e3, "base", (String)base);
                    if (this.facetSupported("totalDigits", baseType) && StringUtils.isNotBlank((CharSequence)length)) {
                        e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "totalDigits");
                        e3.appendChild(e5);
                        this.addAttribute(e5, "value", length);
                    }
                    if (this.facetSupported("maxLength", baseType) && StringUtils.isNotBlank((CharSequence)length)) {
                        e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
                        e3.appendChild(e5);
                        this.addAttribute(e5, "value", length);
                    }
                    if (this.facetSupported("pattern", baseType) && StringUtils.isNotBlank((CharSequence)pattern)) {
                        e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "pattern");
                        e3.appendChild(e5);
                        this.addAttribute(e5, "value", pattern);
                    }
                    if (this.facetSupported("minInclusive", baseType) && StringUtils.isNotBlank((CharSequence)min)) {
                        e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "minInclusive");
                        e3.appendChild(e5);
                        this.addAttribute(e5, "value", min);
                    }
                    if (this.facetSupported("maxInclusive", baseType) && StringUtils.isNotBlank((CharSequence)max)) {
                        e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxInclusive");
                        e3.appendChild(e5);
                        this.addAttribute(e5, "value", max);
                    }
                } else {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 122, ci.name());
                    if (mc != null) {
                        mc.addDetail(null, 400, "Class", ci.fullName());
                    }
                }
            }
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 123, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
        return e1;
    }

    private MapEntry findBaseMapEntryInSupertypes(ClassInfo ci, String encodingRule, String xmlTypeType, String xmlTypeContent) {
        MapEntry me = null;
        if (ci.supertypes() != null) {
            for (String supertypeId : ci.supertypes()) {
                ClassInfo cix = this.model.classById(supertypeId);
                if (cix == null) continue;
                MapEntry mex = this.options.baseMapEntry(cix.name(), encodingRule, xmlTypeType, xmlTypeContent);
                if (mex == null) {
                    mex = this.findBaseMapEntryInSupertypes(cix, encodingRule, xmlTypeType, xmlTypeContent);
                }
                if (mex == null) continue;
                me = mex;
            }
        }
        return me;
    }

    private boolean facetSupported(String facet, String base) {
        if (facet.equals("minInclusive") || facet.equals("maxInclusive") || facet.equals("minExclusive") || facet.equals("maxExclusive")) {
            if (base.equals("integer")) {
                return true;
            }
            if (base.equals("positiveInteger")) {
                return true;
            }
            if (base.equals("negativeInteger")) {
                return true;
            }
            if (base.equals("nonNegativeInteger")) {
                return true;
            }
            if (base.equals("nonPositiveInteger")) {
                return true;
            }
            if (base.equals("long")) {
                return true;
            }
            if (base.equals("unsignedLong")) {
                return true;
            }
            if (base.equals("int")) {
                return true;
            }
            if (base.equals("unsignedInt")) {
                return true;
            }
            if (base.equals("short")) {
                return true;
            }
            if (base.equals("unsignedShort")) {
                return true;
            }
            if (base.equals("byte")) {
                return true;
            }
            if (base.equals("unsignedByte")) {
                return true;
            }
            if (base.equals("decimal")) {
                return true;
            }
            if (base.equals("float")) {
                return true;
            }
            if (base.equals("double")) {
                return true;
            }
            if (base.equals("duration")) {
                return true;
            }
            if (base.equals("dateTime")) {
                return true;
            }
            if (base.equals("date")) {
                return true;
            }
            if (base.equals("time")) {
                return true;
            }
            if (base.equals("gYear")) {
                return true;
            }
            if (base.equals("gYearMonth")) {
                return true;
            }
            if (base.equals("gMonth")) {
                return true;
            }
            if (base.equals("gMonthDay")) {
                return true;
            }
            if (base.equals("gDay")) {
                return true;
            }
        }
        if (facet.equals("totalDigits")) {
            if (base.equals("integer")) {
                return true;
            }
            if (base.equals("positiveInteger")) {
                return true;
            }
            if (base.equals("negativeInteger")) {
                return true;
            }
            if (base.equals("nonNegativeInteger")) {
                return true;
            }
            if (base.equals("nonPositiveInteger")) {
                return true;
            }
            if (base.equals("long")) {
                return true;
            }
            if (base.equals("unsignedLong")) {
                return true;
            }
            if (base.equals("int")) {
                return true;
            }
            if (base.equals("unsignedInt")) {
                return true;
            }
            if (base.equals("short")) {
                return true;
            }
            if (base.equals("unsignedShort")) {
                return true;
            }
            if (base.equals("byte")) {
                return true;
            }
            if (base.equals("unsignedByte")) {
                return true;
            }
            if (base.equals("decimal")) {
                return true;
            }
        }
        if (facet.equals("maxLength")) {
            if (base.equals("string")) {
                return true;
            }
            if (base.equals("normalizedString")) {
                return true;
            }
            if (base.equals("token")) {
                return true;
            }
            if (base.equals("base64Binary")) {
                return true;
            }
            if (base.equals("hexBinary")) {
                return true;
            }
            if (base.equals("Name")) {
                return true;
            }
            if (base.equals("QName")) {
                return true;
            }
            if (base.equals("NCName")) {
                return true;
            }
            if (base.equals("anyURI")) {
                return true;
            }
            if (base.equals("language")) {
                return true;
            }
            if (base.equals("ID")) {
                return true;
            }
            if (base.equals("IDREF")) {
                return true;
            }
            if (base.equals("IDREFS")) {
                return true;
            }
            if (base.equals("ENTITY")) {
                return true;
            }
            if (base.equals("ENTITIES")) {
                return true;
            }
            if (base.equals("NOTATION")) {
                return true;
            }
            if (base.equals("NMTOKEN")) {
                return true;
            }
            if (base.equals("NMTOKENS")) {
                return true;
            }
        }
        if (facet.equals("pattern")) {
            return true;
        }
        return base.contains(":");
    }

    public void pGlobalBasicType(ClassInfo ci) {
        Element e1 = this.pAnonymousBasicType(ci);
        if (e1 != null) {
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", this.typeName(ci, false));
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 124, this.typeName(ci, false));
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
    }

    private Element pAnonymousEnumeration(ClassInfo ci) {
        int cat;
        ClassInfo nci;
        SortedSet<String> sids;
        ClassInfo cci;
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        this.addStandardAnnotation(e1, ci);
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
        e1.appendChild(e4);
        this.addAttribute(e4, "base", "string");
        LinkedList<ClassInfo> classes = new LinkedList<ClassInfo>();
        classes.add(ci);
        LinkedList<ClassInfo> tasks = new LinkedList<ClassInfo>();
        if (ci.matches("rule-xsd-cls-enum-supertypes")) {
            tasks.add(ci);
            while (tasks.size() > 0) {
                cci = (ClassInfo)tasks.removeFirst();
                sids = cci.supertypes();
                if (sids == null) continue;
                for (String id : sids) {
                    nci = this.model.classById(id);
                    if (nci == null || (cat = nci.category()) != 3 && cat != 2) continue;
                    tasks.addLast(nci);
                    classes.addFirst(nci);
                }
            }
        }
        if (ci.matches("rule-xsd-cls-enum-subtypes")) {
            tasks.add(ci);
            while (tasks.size() > 0) {
                cci = (ClassInfo)tasks.removeFirst();
                sids = cci.subtypes();
                if (sids == null) continue;
                for (String id : sids) {
                    nci = this.model.classById(id);
                    if (nci == null || (cat = nci.category()) != 3 && cat != 2) continue;
                    tasks.addLast(nci);
                    classes.addLast(nci);
                }
            }
        }
        for (ClassInfo cci2 : classes) {
            for (PropertyInfo atti : cci2.properties().values()) {
                Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "enumeration");
                e4.appendChild(e3);
                String val = atti.name();
                if (atti.initialValue() != null) {
                    val = atti.initialValue();
                }
                this.addAttribute(e3, "value", val);
                this.addStandardAnnotation(e3, atti);
            }
        }
        return e1;
    }

    public void pGlobalEnumeration(ClassInfo ci) {
        Element e1 = this.pAnonymousEnumeration(ci);
        if (e1 != null) {
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", this.typeName(ci, false));
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 126, this.typeName(ci, false));
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
    }

    public void pGlobalCodeList(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.typeName(ci, false));
        this.addStandardAnnotation(e1, ci);
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "union");
        e1.appendChild(e4);
        this.addAttribute(e4, "memberTypes", ci.qname() + "EnumerationType " + ci.qname() + "OtherType");
        e1 = this.pAnonymousEnumeration(ci);
        if (e1 != null) {
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", ci.name() + "EnumerationType");
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 156, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", ci.name() + "OtherType");
        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
        e1.appendChild(e4);
        this.addAttribute(e4, "base", "string");
        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "pattern");
        e4.appendChild(e3);
        this.addAttribute(e3, "value", "other: \\w{2,}");
    }

    private boolean includeProperty(PropertyInfo pi) {
        XsdPropertyMapEntry pme = this.config.getPropertyMapEntry(pi);
        return !(!pi.isNavigable() || pi.isRestriction() || pi.matches("rule-xsd-prop-exclude-derived") && pi.isDerived() || pi.matches("rule-xsd-all-notEncoded") && pi.encodingRule("xsd").equalsIgnoreCase("notencoded") || pme != null && !pme.hasTargetElement());
    }

    public boolean processLocalProperty(ClassInfo ci, PropertyInfo pi, Element sequenceOrChoice, Multiplicity m, SchematronSchema schDoc) {
        if (this.includeProperty(pi)) {
            Element property = this.addProperty(ci, pi, m, schDoc);
            if (property.getLocalName().equals("attribute") || property.getLocalName().equals("attributeGroup")) {
                sequenceOrChoice.getParentNode().appendChild(property);
            } else {
                sequenceOrChoice.appendChild(property);
            }
            return pi.isAggregation() || pi.isComposition();
        }
        return false;
    }

    public boolean processLocalProperties(ClassInfo ci, Element sequenceOrChoice, SchematronSchema schDoc) {
        int res = 0;
        this.result.addDebug(null, 10023, ci.name());
        for (PropertyInfo pi : ci.properties().values()) {
            if (!this.processLocalProperty(ci, pi, sequenceOrChoice, null, schDoc)) continue;
            ++res;
        }
        AssociationInfo ai = ci.isAssocClass();
        if (ai != null && ai.matches("rule-xsd-rel-association-classes")) {
            Multiplicity m = new Multiplicity();
            if (this.processLocalProperty(ci, ai.end1(), sequenceOrChoice, m, schDoc)) {
                ++res;
            }
            if (this.processLocalProperty(ci, ai.end2(), sequenceOrChoice, m, schDoc)) {
                ++res;
            }
        }
        if (ci.matches("rule-xsd-cls-adehook")) {
            String elementName = "AbstractGenericApplicationPropertyOf" + ci.name();
            Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addAttribute(e1, "ref", elementName);
            this.addMinMaxOccurs(e1, new Multiplicity("0..*"));
            sequenceOrChoice.appendChild(e1);
            Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.document.getDocumentElement().appendChild(e4);
            this.addAttribute(e4, "name", elementName);
            this.addAttribute(e4, "type", "anyType");
            this.addAttribute(e4, "abstract", "true");
        }
        return res == 1;
    }

    private void addMinMaxOccurs(Element e, Multiplicity m) {
        if (m.minOccurs != 1) {
            String minOccursTxt = Integer.valueOf(m.minOccurs).toString();
            minOccursTxt = this.options.internalize(minOccursTxt);
            this.addAttribute(e, "minOccurs", minOccursTxt);
        }
        if (m.maxOccurs == Integer.MAX_VALUE) {
            this.addAttribute(e, "maxOccurs", "unbounded");
        } else if (m.maxOccurs != 1) {
            String maxOccursTxt = Integer.valueOf(m.maxOccurs).toString();
            maxOccursTxt = this.options.internalize(maxOccursTxt);
            this.addAttribute(e, "maxOccurs", maxOccursTxt);
        }
    }

    protected Element addProperty(ClassInfo cibase, PropertyInfo pi, Multiplicity m, SchematronSchema schDoc) {
        Element e1;
        XsdPropertyMapEntry pme = this.config.getPropertyMapEntry(pi);
        if (pme != null) {
            Element e12 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addStandardAnnotation(e12, pi);
            this.addAttribute(e12, "ref", this.addImport(pme.getTargetElement()));
            this.addMinMaxOccurs(e12, pi.cardinality());
            return e12;
        }
        boolean inAssocClass = true;
        if (m == null) {
            m = pi.cardinality();
            inAssocClass = false;
        }
        ClassInfo ci = this.model.classById(pi.typeInfo().id);
        String asAtt = pi.taggedValue("xsdAsAttribute");
        if (StringUtils.isBlank((CharSequence)asAtt)) {
            asAtt = pi.taggedValue("asXMLAttribute");
        }
        String asAttRef = "";
        String asAttGroupRef = "";
        if (ci != null) {
            MapEntry me = this.options.attributeMapEntry(ci.name(), cibase.encodingRule("xsd"));
            if (me != null) {
                asAttRef = me.rule;
            }
            if ((me = this.options.attributeGroupMapEntry(ci.name(), cibase.encodingRule("xsd"))) != null) {
                asAttGroupRef = me.rule;
            }
        }
        if (ci != null && ci.category() == 8 && ci.asGroup() && ci.matches("rule-xsd-cls-union-asGroup")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
            this.addStandardAnnotation(e1, pi);
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                this.addAttribute(e1, "ref", ci.qname() + "Group");
                this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
            }
            this.addMinMaxOccurs(e1, m);
        } else if (!asAttRef.equals("")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            this.addAttribute(e1, "ref", asAttRef);
            int idx = asAttRef.indexOf(":");
            if (idx > 0) {
                String nsabr = asAttRef.substring(0, idx);
                this.addImport(nsabr, this.options.fullNamespace(nsabr));
            }
            if (m.minOccurs == 1) {
                this.addAttribute(e1, "use", "required");
            }
        } else if (!asAttGroupRef.equals("")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
            this.addAttribute(e1, "ref", asAttGroupRef);
            int idx = asAttGroupRef.indexOf(":");
            if (idx > 0) {
                String nsabr = asAttGroupRef.substring(0, idx);
                this.addImport(nsabr, this.options.fullNamespace(nsabr));
            }
        } else if (pi.matches("rule-xsd-prop-xsdAsAttribute") && "true".equalsIgnoreCase(asAtt) && (m.maxOccurs == 1 || this.asList(pi)) && !inAssocClass) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            this.addStandardAnnotation(e1, pi);
            this.addAttribute(e1, "name", pi.name());
            if (m.minOccurs == 1) {
                this.addAttribute(e1, "use", "required");
            }
            this.mapPropertyType(cibase, pi, e1, false, schDoc);
            if (pi.initialValue() != null && !pi.initialValue().isEmpty() && pi.matches("rule-xsd-prop-initialValue")) {
                if (pi.isReadOnly()) {
                    this.addAttribute(e1, "fixed", this.stripQuotes(pi.initialValue()));
                } else {
                    this.addAttribute(e1, "default", this.stripQuotes(pi.initialValue()));
                    if (e1.hasAttribute("use")) {
                        e1.removeAttribute("use");
                    }
                }
            }
        } else if (cibase.matches("rule-xsd-cls-suppress") && cibase.stereotype("adeelement")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addStandardAnnotation(e1, pi);
            this.addAttribute(e1, "name", pi.name());
            if (ci != null && ci.asCharacterString()) {
                this.addAttribute(e1, "type", "string");
            } else {
                this.mapPropertyType(cibase, pi, e1, inAssocClass, schDoc);
            }
            ClassInfo cis = cibase.unsuppressedSupertype(true);
            if (cis != null) {
                String s = this.mapElement(cis);
                if (s != null) {
                    this.addAttribute(e1, "substitutionGroup", s.replace(":_", ":").replace(":", ":_GenericApplicationPropertyOf"));
                    this.addImport(cis.pkg().xmlns(), cis.pkg().targetNamespace());
                }
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 145, cibase.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", cibase.fullName());
                }
            }
        } else if (ci != null && ci.category() == 2 && ci.matches("rule-xsd-cls-codelist-gmlsf")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addStandardAnnotation(e1, pi);
            this.addAttribute(e1, "name", pi.name());
            Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
            e1.appendChild(e2);
            Element simpleContent = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
            e2.appendChild(simpleContent);
            Element restriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
            this.addAttribute(restriction, "base", "gml:CodeType");
            simpleContent.appendChild(restriction);
            String codeListUri = ci.taggedValue("codeList");
            if (StringUtils.isBlank((CharSequence)codeListUri)) {
                codeListUri = ci.taggedValue("vocabulary");
            }
            if (StringUtils.isNotBlank((CharSequence)codeListUri)) {
                Element attribute = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                this.addAttribute(attribute, "name", "codeSpace");
                this.addAttribute(attribute, "type", "anyURI");
                this.addAttribute(attribute, "fixed", codeListUri.trim());
                restriction.appendChild(attribute);
            }
            this.addMinMaxOccurs(e1, m);
            this.addImport("gml", this.options.fullNamespace("gml"));
        } else if (pi.categoryOfValue() == 1 && pi.matches("rule-xsd-prop-featureType-gmlsf-byReference")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addStandardAnnotation(e1, pi);
            this.addAttribute(e1, "name", pi.name());
            this.addAttribute(e1, "type", "gml:ReferenceType");
            this.addMinMaxOccurs(e1, m);
            this.addImport("gml", this.options.fullNamespace("gml"));
        } else {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addStandardAnnotation(e1, pi);
            this.addAttribute(e1, "name", pi.name());
            if (pi.nilReasonAllowed() && pi.matches("rule-xsd-prop-nilReasonAllowed") || pi.voidable() && pi.matches("rule-xsd-prop-nillable")) {
                this.addAttribute(e1, "nillable", "true");
            }
            if (pi.initialValue() != null && !pi.initialValue().isEmpty() && pi.matches("rule-xsd-prop-initialValue")) {
                if (pi.isReadOnly()) {
                    this.addAttribute(e1, "fixed", this.stripQuotes(pi.initialValue()));
                } else {
                    this.addAttribute(e1, "default", this.stripQuotes(pi.initialValue()));
                }
            }
            boolean multiplicityAlreadySet = false;
            if (ci != null && ci.asCharacterString() && ci.matches("rule-xsd-cls-union-asCharacterString")) {
                this.addAttribute(e1, "type", "string");
            } else {
                multiplicityAlreadySet = this.mapPropertyType(cibase, pi, e1, inAssocClass, schDoc);
            }
            if (!multiplicityAlreadySet) {
                if (ci != null && ci.isKindOf("historisches_Objekt") && ci.matches("rule-xsd-cls-okstra-lifecycle")) {
                    m.maxOccurs = Integer.MAX_VALUE;
                }
                this.addMinMaxOccurs(e1, m);
            }
            if (pi.matches("rule-xsd-prop-length-size-pattern") && (StringUtils.isNotBlank((CharSequence)pi.taggedValue("length")) || StringUtils.isNotBlank((CharSequence)pi.taggedValue("size")) && StringUtils.isNotBlank((CharSequence)pi.taggedValue("pattern")))) {
                Element simpleType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                e1.appendChild(simpleType);
                Element restriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                this.addAttribute(restriction, "base", "string");
                e1.removeAttribute("type");
                simpleType.appendChild(restriction);
                Element concreteRestriction = null;
                if (StringUtils.isNotBlank((CharSequence)pi.taggedValue("length"))) {
                    concreteRestriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
                    this.addAttribute(concreteRestriction, "value", pi.taggedValue("length"));
                } else if (StringUtils.isNotBlank((CharSequence)pi.taggedValue("size")) && StringUtils.isNotBlank((CharSequence)pi.taggedValue("pattern"))) {
                    concreteRestriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "pattern");
                    this.addAttribute(concreteRestriction, "value", pi.taggedValue("pattern") + "{" + pi.taggedValue("size") + "}");
                }
                if (concreteRestriction != null) {
                    restriction.appendChild(concreteRestriction);
                }
            }
            if (pi.matches("rule-xsd-prop-constrainingFacets") && pi.categoryOfValue() != 2 && pi.categoryOfValue() != 3) {
                String length = pi.taggedValue("length");
                if (StringUtils.isBlank((CharSequence)length)) {
                    length = pi.taggedValue("maxLength");
                }
                if (StringUtils.isBlank((CharSequence)length)) {
                    length = pi.taggedValue("size");
                }
                String pattern = pi.taggedValue("pattern");
                String min = pi.taggedValue("rangeMinimum");
                String max = pi.taggedValue("rangeMaximum");
                String typecontent = "simple/simple";
                if (StringUtils.isNotBlank((CharSequence)length) || StringUtils.isNotBlank((CharSequence)pattern) || StringUtils.isNotBlank((CharSequence)min) || StringUtils.isNotBlank((CharSequence)max)) {
                    String baseType = null;
                    Object base = null;
                    MapEntry me = this.options.baseMapEntry(pi.typeInfo().name, pi.encodingRule("xsd"));
                    if (me != null) {
                        base = me.p1;
                        baseType = me.p1;
                        typecontent = me.p2;
                    }
                    if (base == null && ci != null) {
                        base = ci.qname() + "Type";
                    }
                    if (ci != null) {
                        MapEntry me2 = this.findBaseMapEntryInSupertypes(ci, pi.encodingRule("xsd"), "simple", "simple");
                        if (me2 == null) {
                            me2 = this.findBaseMapEntryInSupertypes(ci, pi.encodingRule("xsd"), "complex", "simple");
                        }
                        if (me2 != null) {
                            baseType = me2.p1;
                        }
                    }
                    if (base != null && baseType != null) {
                        Element e5;
                        Element e3;
                        Element e2;
                        e1.removeAttribute("type");
                        if (typecontent.equals("complex/simple")) {
                            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                            e1.appendChild(e2);
                            Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                            e2.appendChild(e4);
                            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                            e4.appendChild(e3);
                        } else if (typecontent.equals("simple/simple")) {
                            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                            e1.appendChild(e2);
                            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                            e2.appendChild(e3);
                        } else {
                            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                            e1.appendChild(e2);
                            Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                            e2.appendChild(e4);
                            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                            e4.appendChild(e3);
                        }
                        this.addAttribute(e3, "base", (String)base);
                        if (this.facetSupported("totalDigits", baseType) && StringUtils.isNotBlank((CharSequence)length)) {
                            e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "totalDigits");
                            e3.appendChild(e5);
                            this.addAttribute(e5, "value", length);
                        }
                        if (this.facetSupported("maxLength", baseType) && StringUtils.isNotBlank((CharSequence)length)) {
                            e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
                            e3.appendChild(e5);
                            this.addAttribute(e5, "value", length);
                        }
                        if (this.facetSupported("pattern", baseType) && StringUtils.isNotBlank((CharSequence)pattern)) {
                            e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "pattern");
                            e3.appendChild(e5);
                            this.addAttribute(e5, "value", pattern);
                        }
                        if (this.facetSupported("minInclusive", baseType) && StringUtils.isNotBlank((CharSequence)min)) {
                            e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "minInclusive");
                            e3.appendChild(e5);
                            this.addAttribute(e5, "value", min);
                        }
                        if (this.facetSupported("maxInclusive", baseType) && StringUtils.isNotBlank((CharSequence)max)) {
                            e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxInclusive");
                            e3.appendChild(e5);
                            this.addAttribute(e5, "value", max);
                        }
                    } else {
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 180, ci.name(), pi.name());
                        if (mc != null) {
                            mc.addDetail(null, 400, "Property", pi.fullName());
                        }
                    }
                }
            }
        }
        return e1;
    }

    private boolean asArray(PropertyInfo propi) {
        boolean asArray = false;
        if (propi.matches("rule-xsd-prop-gmlArrayProperty")) {
            String s = propi.taggedValue("gmlArrayProperty");
            asArray = "true".equalsIgnoreCase(s);
        }
        if (!(!asArray || propi.matches("rule-xsd-prop-inlineOrByReference") && propi.inlineOrByReference().equals("inline"))) {
            asArray = false;
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 170, propi.inClass().name() + "." + propi.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
        }
        return asArray;
    }

    private boolean asList(PropertyInfo propi) {
        boolean asList = false;
        if (propi.matches("rule-xsd-prop-gmlListProperty")) {
            String s = propi.taggedValue("gmlListProperty");
            asList = "true".equalsIgnoreCase(s);
        }
        return asList;
    }

    private List<Qualifier> qualifiers(PropertyInfo propi) {
        List<Qualifier> qv;
        PropertyInfo revpi;
        if (propi.matches("rule-xsd-prop-qualified-associations") && !propi.isAttribute() && propi.isNavigable() && (revpi = propi.reverseProperty()) != null && (qv = revpi.qualifiers()) != null && qv.size() > 0) {
            return qv;
        }
        return null;
    }

    private boolean processQualifiers(Element e, PropertyInfo propi) {
        List<Qualifier> qv = this.qualifiers(propi);
        if (qv != null) {
            for (Qualifier q : qv) {
                this.processQualifier(e, propi, q);
            }
            return true;
        }
        return false;
    }

    private void processQualifier(Element e, PropertyInfo propi, Qualifier q) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
        e.appendChild(e1);
        this.addAttribute(e1, "name", q.name);
        if (q.type == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 176);
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
            this.addAttribute(e1, "type", "string");
        } else {
            MapEntry me = this.options.typeMapEntry(q.type, propi.encodingRule("xsd"));
            if (me != null) {
                if (me.p2.equalsIgnoreCase("simple/simple")) {
                    String propertyTypeName = this.addImport(me.p1);
                    if (propertyTypeName == null) {
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 174, me.p1);
                        if (mc != null) {
                            mc.addDetail(null, 400, "Property", propi.fullName());
                        }
                        propertyTypeName = "fixme:fixme";
                    }
                    this.addAttribute(e1, "type", propertyTypeName);
                } else if (me.p2.equalsIgnoreCase("complex/complex")) {
                    this.addAttribute(e1, "type", "anyURI");
                } else {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 175, me.p1);
                    if (mc != null) {
                        mc.addDetail(null, 400, "Property", propi.fullName());
                    }
                    this.addAttribute(e1, "type", "string");
                }
            } else {
                ClassInfo ci = this.model.classByName(q.type);
                if (ci != null) {
                    if (ci.category() == 3) {
                        this.addAttribute(e1, "type", ci.qname() + "Type");
                        this.addImport(ci.qname());
                    } else if (ci.category() == 2 || ci.category() == 1 || ci.category() == 6 || ci.category() == 4) {
                        this.addAttribute(e1, "type", "anyURI");
                    } else if (ci.category() == 5 || ci.category() == 8) {
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 178, ci.qname());
                        if (mc != null) {
                            mc.addDetail(null, 400, "Property", propi.fullName());
                        }
                        this.addAttribute(e1, "type", "string");
                    } else {
                        ShapeChangeResult.MessageContext mc = this.result.addError(this, 179, ci.qname());
                        if (mc != null) {
                            mc.addDetail(null, 400, "Property", propi.fullName());
                        }
                        this.addAttribute(e1, "type", "string");
                    }
                } else {
                    ShapeChangeResult.MessageContext mc = this.result.addError(this, 177, q.type);
                    if (mc != null) {
                        mc.addDetail(null, 400, "Property", propi.fullName());
                    }
                    this.addAttribute(e1, "type", "string");
                }
            }
        }
    }

    protected boolean mapPropertyType(ClassInfo cibase, PropertyInfo propi, Element e, boolean inAssocClass, SchematronSchema schDoc) {
        Element e1x;
        ShapeChangeResult.MessageContext mc;
        boolean asArray;
        Object mc2;
        ShapeChangeResult.MessageContext mc3;
        String pName = cibase.name() + "." + propi.name();
        boolean isAttribute = e.getLocalName().equals("attribute");
        Element e1 = null;
        Type ti = propi.typeInfo();
        MapEntry me = this.options.typeMapEntry(ti.name, cibase.encodingRule("xsd"));
        boolean multiplicityAlreadySet = false;
        boolean addMetadata = false;
        if (propi.propertyMetadata() && propi.matches("rule-xsd-prop-metadata")) {
            addMetadata = true;
        }
        if (StringUtils.isNotBlank((CharSequence)propi.taggedValue("codeListRestriction"))) {
            String typeName = propi.taggedValue("codeListRestriction");
            ClassInfo codeList = propi.model().classByName(typeName);
            this.addAssertionForCodelistUri(cibase, propi, codeList, schDoc);
        }
        if (me != null) {
            if (me.rule.equals("direct")) {
                boolean withQualifiers;
                ShapeChangeResult.MessageContext mc4;
                String propertyTypeName;
                boolean addNilReason = me.p3 != null && me.p3.equals("false") && (propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable"));
                boolean softtyped = false;
                if (propi.matches("rule-xsd-prop-soft-typed")) {
                    String s = propi.taggedValue("soft-typed");
                    softtyped = "true".equalsIgnoreCase(s);
                }
                boolean asList = this.asList(propi);
                if (propi.matches("rule-xsd-prop-att-map-entry") && !isAttribute) {
                    String asAttGroupRef;
                    MapEntry mea = this.options.attributeMapEntry(ti.name, cibase.encodingRule("xsd"));
                    String asAttRef = mea != null ? mea.rule : "";
                    MapEntry meag = this.options.attributeGroupMapEntry(ti.name, cibase.encodingRule("xsd"));
                    String string = asAttGroupRef = meag != null ? meag.rule : "";
                    if (!asAttRef.equals("") || !asAttGroupRef.equals("")) {
                        String nsabr;
                        int ix;
                        Element e2;
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        e.appendChild(e1);
                        if (addNilReason) {
                            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                            e1.appendChild(e2);
                            this.addNilReason(e2);
                        }
                        if (addMetadata) {
                            this.addMetadata(e1);
                        }
                        if (softtyped) {
                            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                            e1.appendChild(e2);
                            this.addName(e2);
                        }
                        if (!asAttRef.equals("")) {
                            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                            this.addAttribute(e2, "ref", asAttRef);
                            ix = asAttRef.indexOf(":");
                            if (ix > 0) {
                                nsabr = asAttRef.substring(0, ix);
                                this.addImport(nsabr, this.options.fullNamespace(nsabr));
                            }
                            e1.appendChild(e2);
                        }
                        if (!asAttGroupRef.equals("")) {
                            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                            this.addAttribute(e2, "ref", asAttGroupRef);
                            ix = asAttGroupRef.indexOf(":");
                            if (ix > 0) {
                                nsabr = asAttGroupRef.substring(0, ix);
                                this.addImport(nsabr, this.options.fullNamespace(nsabr));
                            }
                            e1.appendChild(e2);
                        }
                        return false;
                    }
                }
                if ((propertyTypeName = this.addImport(me.p1)) == null) {
                    this.result.addError(this, 174, me.p1);
                    propertyTypeName = "fixme:fixme";
                }
                if (isAttribute) {
                    boolean simpleType;
                    boolean bl = simpleType = me.p2 != null && me.p2.equals("simple/simple");
                    if (!simpleType || addNilReason || addMetadata || softtyped) {
                        mc4 = this.result.addError(this, 128, pName);
                        if (mc4 != null) {
                            mc4.addDetail(null, 400, "Property", propi.fullName());
                        }
                        if (!simpleType) {
                            return false;
                        }
                        addNilReason = false;
                        addMetadata = false;
                        softtyped = false;
                    }
                }
                if (asList) {
                    boolean simpleType;
                    boolean bl = simpleType = me.p2 != null && me.p2.equals("simple/simple");
                    if (!simpleType) {
                        mc4 = this.result.addError(this, 169, pName, me.p1);
                        if (mc4 != null) {
                            mc4.addDetail(null, 400, "Property", propi.fullName());
                        }
                        return false;
                    }
                }
                boolean asArray2 = this.asArray(propi);
                String asArrayTargetElement = null;
                if (asArray2) {
                    MapEntry me2 = this.options.elementMapEntry(ti.name, cibase.encodingRule("xsd"));
                    if (me2 == null) {
                        asArray2 = false;
                        ShapeChangeResult.MessageContext mc5 = this.result.addError(this, 172, pName, ti.name);
                        if (mc5 != null) {
                            mc5.addDetail(null, 400, "Property", propi.fullName());
                        }
                    } else {
                        asArrayTargetElement = me2.p1;
                    }
                }
                boolean bl = withQualifiers = this.qualifiers(propi) != null && !isAttribute;
                if (!(addNilReason || addMetadata || softtyped || asArray2 || asList || withQualifiers)) {
                    this.addAttribute(e, "type", propertyTypeName);
                    return false;
                }
                if (asList) {
                    e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                    e.appendChild(e1);
                    Multiplicity m = propi.cardinality();
                    if (m.minOccurs == 0 && m.maxOccurs == Integer.MAX_VALUE) {
                        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "list");
                        e1.appendChild(e4);
                        this.addAttribute(e4, "itemType", me.p1);
                    } else {
                        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                        e1.appendChild(e4);
                        Element e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                        e4.appendChild(e5);
                        Element e6 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "list");
                        e5.appendChild(e6);
                        this.addAttribute(e6, "itemType", me.p1);
                        if (m.minOccurs > 0) {
                            e6 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "minLength");
                            e4.appendChild(e6);
                            Object minOccTxt = "" + m.minOccurs;
                            minOccTxt = this.options.internalize((String)minOccTxt);
                            this.addAttribute(e6, "value", (String)minOccTxt);
                        }
                        if (m.maxOccurs != Integer.MAX_VALUE) {
                            e6 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
                            e4.appendChild(e6);
                            Object maxOccTxt = "" + m.maxOccurs;
                            maxOccTxt = this.options.internalize((String)maxOccTxt);
                            this.addAttribute(e6, "value", (String)maxOccTxt);
                        }
                    }
                    multiplicityAlreadySet = true;
                    if (isAttribute) {
                        if (propi.cardinality().minOccurs > 0) {
                            this.addAttribute(e, "required", "true");
                        }
                    } else if (propi.cardinality().minOccurs == 0) {
                        this.addAttribute(e, "minOccurs", "0");
                    }
                } else if (asArray2) {
                    multiplicityAlreadySet = this.addAnonymousPropertyType(e, propi, null, asArrayTargetElement, null, false);
                    multiplicityAlreadySet = true;
                    if (propi.cardinality().minOccurs == 0) {
                        this.addAttribute(e, "minOccurs", "0");
                    }
                } else {
                    Element e2;
                    e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    e.appendChild(e1);
                    Element e4 = me.p2 == null || me.p2.equals("complex/complex") ? this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent") : this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                    e1.appendChild(e4);
                    Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                    e4.appendChild(e3);
                    this.addAttribute(e3, "base", propertyTypeName);
                    if (addNilReason) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                        e3.appendChild(e2);
                        this.addNilReason(e2);
                    }
                    if (addMetadata) {
                        this.addMetadata(e3);
                    }
                    if (softtyped) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                        e3.appendChild(e2);
                        this.addName(e2);
                    }
                    if (withQualifiers && this.processQualifiers(e3, propi)) {
                        this.addAttribute(e, "minOccurs", "0");
                        this.addAttribute(e, "maxOccurs", "unbounded");
                        multiplicityAlreadySet = true;
                    }
                }
            } else if (me.rule.equals("propertyType")) {
                multiplicityAlreadySet = this.addAnonymousPropertyType(e, propi, null, me.p1, null, false);
            } else if (me.rule.equals("metadataPropertyType")) {
                multiplicityAlreadySet = this.addAnonymousPropertyType(e, propi, null, me.p1, null, true);
            }
            return multiplicityAlreadySet;
        }
        ClassInfo ci = this.model.classById(ti.id);
        if (ci == null && (ci = this.model.classByName(ti.name)) != null && (mc3 = this.result.addError(null, 135, pName)) != null) {
            mc3.addDetail(null, 400, "Property", propi.fullName());
        }
        ClassInfo associationClass = null;
        if (!propi.isAttribute() && !inAssocClass) {
            AssociationInfo ai = propi.association();
            if (ai != null && ai.matches("rule-xsd-rel-association-classes")) {
                associationClass = ai.assocClass();
            }
            if (associationClass != null) {
                ci = associationClass;
            }
        }
        if (ci == null) {
            mc2 = this.result.addError(null, 131, pName, ti.name);
            if (mc2 != null) {
                ((ShapeChangeResult.MessageContext)mc2).addDetail(null, 400, "Property", propi.fullName());
            }
            return false;
        }
        if (ci.isUnionDirect() && ci.matches("rule-xsd-cls-union-direct")) {
            for (PropertyInfo pi2 : ci.properties().values()) {
                if (!pi2.isNavigable() || pi2.isRestriction() || pi2.implementedByNilReason()) continue;
                if (ci.hasNilReason()) {
                    pi2.nilReasonAllowed(true);
                }
                this.addAttribute(e, "nillable", "true");
                this.mapPropertyType(cibase, pi2, e, false, schDoc);
                int pi2MinOccurs = pi2.cardinality().minOccurs;
                int propiMinOccurs = propi.cardinality().minOccurs;
                int minOccurs = propiMinOccurs < pi2MinOccurs ? propiMinOccurs : pi2MinOccurs;
                int pi2MaxOccurs = pi2.cardinality().maxOccurs;
                int propiMaxOccurs = propi.cardinality().maxOccurs;
                int maxOccurs = 0;
                maxOccurs = pi2MaxOccurs == Integer.MAX_VALUE || propiMaxOccurs == Integer.MAX_VALUE ? Integer.MAX_VALUE : pi2MaxOccurs * propiMaxOccurs;
                Multiplicity m = new Multiplicity(minOccurs, maxOccurs);
                this.addMinMaxOccurs(e, m);
                return true;
            }
            mc2 = this.result.addError(this, 129, ci.name(), pName);
            if (mc2 != null) {
                ((ShapeChangeResult.MessageContext)mc2).addDetail(null, 400, "Class", ci.fullName());
            }
        }
        if ((asArray = this.asArray(propi)) && !this.classHasObjectElement(ci)) {
            asArray = false;
            mc = this.result.addError(this, 173, pName, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
        }
        if (ci.category() == 8 && ci.matches("rule-xsd-cls-union-omitUnionsRepresentingFeatureTypeSets") && "true".equalsIgnoreCase(ci.taggedValue("representsFeatureTypeSet"))) {
            if (addMetadata) {
                e1x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                e.appendChild(e1x);
                Element e4x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                e1x.appendChild(e4x);
                Element e3x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                e4x.appendChild(e3x);
                this.addAttribute(e3x, "base", "gml:ReferenceType");
                this.addMetadata(e3x);
            } else {
                this.addAttribute(e, "type", "gml:ReferenceType");
            }
            this.addImport("gml", this.options.fullNamespace("gml"));
            if (propi.matches("rule-xsd-prop-targetElement") && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                Element annotationElement;
                NodeList annotationElements = e.getElementsByTagName("annotation");
                if (annotationElements != null && annotationElements.getLength() != 0) {
                    annotationElement = (Element)annotationElements.item(0);
                } else {
                    annotationElement = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
                    e.appendChild(annotationElement);
                }
                Element appinfoElement = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                annotationElement.appendChild(appinfoElement);
                ArrayList<ClassInfo> representedFeatures = new ArrayList<ClassInfo>(this.findAllRepresentedFeatures(ci));
                Collections.sort(representedFeatures, new Comparator<ClassInfo>(){

                    @Override
                    public int compare(ClassInfo o1, ClassInfo o2) {
                        return o1.name().compareTo(o2.name());
                    }
                });
                for (ClassInfo representedFeatureType : representedFeatures) {
                    String s = this.mapElement(representedFeatureType);
                    if (s == null) {
                        s = representedFeatureType.qname();
                    }
                    Element targetElement = this.document.createElementNS(this.options.GML_NS, "gml:targetElement");
                    appinfoElement.appendChild(targetElement);
                    targetElement.appendChild(this.document.createTextNode(s));
                }
            }
        } else if (ci.category() == 11 && ci.matches("rule-xsd-cls-okstra-schluesseltabelle")) {
            this.addAttribute(e, "type", this.propertyTypeName(ci, true));
            this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
        } else if (ci.category() == 12 && ci.matches("rule-xsd-cls-okstra-fid")) {
            this.addAttribute(e, "type", this.okstraObjectRefType);
            this.addImport(this.okstraPrefix, this.options.fullNamespace(this.okstraPrefix));
        } else if (this.classHasObjectElement(ci)) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                mc = this.result.addError(this, 141, ci.name(), propi.inClass().name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else if (ci.matches("rule-xsd-cls-standard-19139-property-types")) {
                String type = this.propertyTypeName(ci, true);
                if (addMetadata) {
                    Element e1x2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    e.appendChild(e1x2);
                    Element e4x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                    e1x2.appendChild(e4x);
                    Element e3x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                    e4x.appendChild(e3x);
                    this.addAttribute(e3x, "base", type);
                    this.addMetadata(e3x);
                } else {
                    this.addAttribute(e, "type", type);
                }
                this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
                if (ci.category() == 2) {
                    this.addAssertionForCodelistUri(cibase, propi, ci, schDoc);
                }
            } else if (ci.matches("rule-xsd-cls-standard-gml-property-types") || ci.matches("rule-xsd-cls-standard-swe-property-types")) {
                boolean embedPropertyType = false;
                boolean addImport = true;
                if (propi.matches("rule-xsd-prop-inlineOrByReference") && propi.inlineOrByReference().equals("byreference")) {
                    embedPropertyType = true;
                    if (!propi.matches("rule-xsd-prop-targetElement")) {
                        addImport = false;
                    }
                } else if (propi.matches("rule-xsd-prop-inlineOrByReference") && propi.inlineOrByReference().equals("inline")) {
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        boolean bl = embedPropertyType = embedPropertyType || this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (propi.isAggregation() || propi.isComposition() || propi.isMetadata()) && (propi.categoryOfValue() == 6 || propi.categoryOfValue() == 1);
                    }
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        boolean bl = embedPropertyType = embedPropertyType || propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable");
                    }
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        embedPropertyType = embedPropertyType || asArray;
                    }
                    embedPropertyType = embedPropertyType || this.classHasIdentity(ci) && !ci.includeByValuePropertyType() || !this.classHasIdentity(ci) && !ci.includePropertyType();
                    embedPropertyType = embedPropertyType || this.qualifiers(propi) != null;
                    boolean bl = embedPropertyType = embedPropertyType || addMetadata;
                    if (!embedPropertyType) {
                        if (this.classHasIdentity(ci)) {
                            this.addAttribute(e, "type", ci.qname() + "PropertyByValueType");
                        } else {
                            this.addAttribute(e, "type", this.propertyTypeName(ci, true));
                        }
                    }
                } else {
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        boolean bl = embedPropertyType = embedPropertyType || this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (propi.isAggregation() || propi.isComposition() || propi.isMetadata()) && (propi.categoryOfValue() == 6 || propi.categoryOfValue() == 1);
                    }
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        boolean bl = embedPropertyType = embedPropertyType || this.options.GML_NS.equals("http://www.opengis.net/gml") && (propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable"));
                    }
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        embedPropertyType = embedPropertyType || this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) && !this.classHasIdentity(ci);
                    }
                    boolean bl = embedPropertyType = embedPropertyType || !ci.includePropertyType();
                    if (ci.matches("rule-xsd-cls-standard-swe-property-types")) {
                        embedPropertyType = embedPropertyType || propi.matches("rule-xsd-prop-soft-typed") && "true".equalsIgnoreCase(propi.taggedValue("soft-typed"));
                    }
                    embedPropertyType = embedPropertyType || this.qualifiers(propi) != null;
                    boolean bl2 = embedPropertyType = embedPropertyType || addMetadata;
                    if (!embedPropertyType) {
                        this.addAttribute(e, "type", this.propertyTypeName(ci, true));
                    }
                }
                if (embedPropertyType) {
                    multiplicityAlreadySet = this.addAnonymousPropertyType(e, propi, associationClass, ci.qname(), null, false);
                }
                if (asArray) {
                    multiplicityAlreadySet = true;
                    if (propi.cardinality().minOccurs == 0) {
                        this.addAttribute(e, "minOccurs", "0");
                    }
                }
                if (addImport) {
                    this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
                }
            }
        } else if (ci.matches("rule-xsd-cls-mixin-classes") && ci.category() == 4 || ci.matches("rule-xsd-cls-no-abstract-classes") && ci.isAbstract()) {
            multiplicityAlreadySet = this.addAnonymousPropertyType(e, propi, null, null, this.subtypes(ci), false);
        } else if (ci.matches("rule-xsd-cls-standard-gml-property-types") || ci.matches("rule-xsd-cls-standard-swe-property-types")) {
            Element e4;
            if (ci.category() == 2 && ci.matches("rule-xsd-cls-codelist-anonymous-xlink")) {
                e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                e.appendChild(e1);
                e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
                e1.appendChild(e4);
                e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e4);
                this.addAttribute(e4, "ref", "xlink:simpleAttrs");
                this.addImport("xlink", this.options.fullNamespace("xlink"));
            } else if (ci.category() == 2 && (ci.matches("rule-xsd-cls-codelist-asDictionary") && ci.asDictionary() || ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") && ci.asDictionaryGml33())) {
                if (propi.inClass().matches("rule-xsd-cls-codelist-asDictionaryGml33")) {
                    if (addMetadata) {
                        e1x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        e.appendChild(e1x);
                        Element e4x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                        e1x.appendChild(e4x);
                        Element e3x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e4x.appendChild(e3x);
                        this.addAttribute(e3x, "base", "gml:ReferenceType");
                        this.addMetadata(e3x);
                    } else {
                        this.addAttribute(e, "type", "gml:ReferenceType");
                    }
                    this.addAssertionForCodelistUri(cibase, propi, ci, schDoc);
                } else if (propi.inClass().matches("rule-xsd-cls-standard-swe-property-types")) {
                    if (addMetadata) {
                        e1x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        e.appendChild(e1x);
                        Element e4x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                        e1x.appendChild(e4x);
                        Element e3x = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e4x.appendChild(e3x);
                        this.addAttribute(e3x, "base", "swe:ReferenceType");
                        this.addMetadata(e3x);
                    } else {
                        this.addAttribute(e, "type", "swe:ReferenceType");
                    }
                    this.addAssertionForCodelistUri(cibase, propi, ci, schDoc);
                } else {
                    if (!(propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable") || addMetadata)) {
                        this.addAttribute(e, "type", "gml:CodeType");
                    } else {
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        e.appendChild(e1);
                        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                        e1.appendChild(e4);
                        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e4.appendChild(e3);
                        this.addAttribute(e3, "base", "gml:CodeType");
                        if (propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) {
                            Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                            e3.appendChild(e2);
                            this.addNilReason(e2);
                        }
                        if (addMetadata) {
                            this.addMetadata(e3);
                        }
                    }
                    this.addAssertionForCodelistUri(cibase, propi, ci, schDoc);
                }
                if (propi.isMetadata() && (mc = this.result.addWarning(this, 1009, pName)) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
                if (ci.matches("rule-xsd-cls-standard-swe-property-types")) {
                    this.addImport("swe", this.options.fullNamespace("swe"));
                } else {
                    this.addImport("gml", this.options.fullNamespace("gml"));
                }
            } else if (ci.category() == 2 || ci.category() == 3 && !ci.matches("rule-xsd-cls-local-enumeration") || ci.matches("rule-xsd-cls-basictype") && ci.category() == 7 && !ci.matches("rule-xsd-cls-local-basictype")) {
                if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                    mc = this.result.addError(this, 141, ci.name(), propi.inClass().name());
                    if (mc != null) {
                        mc.addDetail(null, 400, "Class", ci.fullName());
                    }
                } else {
                    if (!(propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable") || addMetadata)) {
                        this.addAttribute(e, "type", this.options.internalize(ci.qname() + "Type"));
                    } else {
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        e.appendChild(e1);
                        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                        e1.appendChild(e4);
                        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e4.appendChild(e3);
                        this.addAttribute(e3, "base", this.options.internalize(ci.qname() + "Type"));
                        if (propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) {
                            Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                            e3.appendChild(e2);
                            this.addNilReason(e2);
                        }
                        if (addMetadata) {
                            this.addMetadata(e3);
                        }
                    }
                    this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
                }
                if (propi.isMetadata() && (mc = this.result.addWarning(this, 1009, pName)) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
            } else if (ci.category() == 3 && ci.matches("rule-xsd-cls-local-enumeration")) {
                e1 = this.pAnonymousEnumeration(ci);
                e.appendChild(e1);
                if ((propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) && (mc = this.result.addWarning(this, 1010, pName, "enumeration")) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
                if (propi.isMetadata() && (mc = this.result.addWarning(this, 1009, pName)) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
            } else if (ci.matches("rule-xsd-cls-basictype") && ci.category() == 7 && ci.matches("rule-xsd-cls-local-basictype")) {
                e1 = this.pAnonymousBasicType(ci);
                e.appendChild(e1);
                if ((propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) && (mc = this.result.addWarning(this, 1010, pName, "basic type")) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
                if (propi.isMetadata() && (mc = this.result.addWarning(this, 1009, pName)) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
            } else {
                mc = this.result.addError(this, 130, pName);
                if (mc != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
            }
        } else {
            mc = this.result.addError(this, 130, pName);
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
        }
        return multiplicityAlreadySet;
    }

    private SortedSet<ClassInfo> findAllRepresentedFeatures(ClassInfo ci) {
        TreeSet<ClassInfo> result = new TreeSet<ClassInfo>();
        if (ci != null && ci.category() == 8 && "true".equalsIgnoreCase(ci.taggedValue("representsFeatureTypeSet"))) {
            for (PropertyInfo option : ci.propertiesAll()) {
                ClassInfo type = this.model.classById(option.typeInfo().id);
                if (type == null) {
                    type = this.model.classByName(option.typeInfo().name);
                }
                if (type == null) continue;
                if (type.category() == 8 && "true".equalsIgnoreCase(ci.taggedValue("representsFeatureTypeSet"))) {
                    result.addAll(this.findAllRepresentedFeatures(type));
                    continue;
                }
                if (type.category() != 1) continue;
                result.add(type);
            }
        }
        return result;
    }

    private void addAssertionForCodelistUri(ClassInfo cibase, PropertyInfo propi, ClassInfo typeCi, SchematronSchema schDoc) {
        if (schDoc != null && cibase.matches("rule-xsd-cls-codelist-constraints")) {
            String s = typeCi.taggedValue("codeList");
            if (StringUtils.isBlank((CharSequence)s)) {
                s = typeCi.taggedValue("vocabulary");
            }
            if (typeCi.matches("rule-xsd-cls-standard-19139-property-types")) {
                XpathFragment xpath;
                if (StringUtils.isNotBlank((CharSequence)s)) {
                    xpath = new XpathFragment(0, propi.qname() + "/*/@codeList='" + s + "'");
                    schDoc.addAssertion(cibase, xpath, "Code list is '" + s + "'");
                }
                Object s2 = schDoc.determineCodeListValuePattern(typeCi, "{codeList}/{value}");
                s2 = "concat('" + ((String)s2).replace("{codeList}", s).replace("{value}", "',*/@codeListValue)");
                xpath = new XpathFragment(0, "(not contains('" + (String)s2 + "', '#') and document('" + (String)s2 + "')) or (contains('" + (String)s2 + "', '#') and document(substring-before('" + (String)s2 + "','#'))/id(substring-after('" + (String)s2 + "','#')))");
                schDoc.addAssertion(cibase, xpath, "Code list value exists");
                s = typeCi.taggedValue("codeListRepresentation");
                if (StringUtils.isBlank((CharSequence)s) || s.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    xpath = new XpathFragment(0, "(not contains('" + (String)s2 + "', '#') and document('" + (String)s2 + "')/gml:Definition) or (contains('" + (String)s2 + "', '#') and document(substring-before('" + (String)s2 + "','#'))/id(substring-after('" + (String)s2 + "','#'))[local-name()='Definiton' and namespace-uri()='http://www.opengis.net/gml/3.2'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using GML 3.2");
                } else if (s.equalsIgnoreCase("application/rdf+xml")) {
                    xpath = new XpathFragment(0, "(not contains('" + (String)s2 + "', '#') and document('" + (String)s2 + "')/skos:Concept) or (contains('" + (String)s2 + "', '#') and document(substring-before('" + (String)s2 + "','#'))/id(substring-after('" + (String)s2 + "','#'))[local-name()='Concept' and namespace-uri()='http://www.w3.org/2004/02/skos/core#'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using SKOS");
                }
            } else if (propi.inClass().matches("rule-xsd-cls-codelist-asDictionaryGml33") && (typeCi.asDictionary() || typeCi.asDictionaryGml33())) {
                XpathFragment xpath;
                if (s != null && !s.isEmpty()) {
                    xpath = new XpathFragment(0, "starts-with(" + propi.qname() + "/@xlink:href,'" + s + "')");
                    schDoc.addAssertion(cibase, xpath, "Code list value URI starts with '" + s + "'");
                }
                xpath = new XpathFragment(0, "(not contains(" + propi.qname() + "/@xlink:href, '#') and document(" + propi.qname() + "/@xlink:href)) or (contains(" + propi.qname() + "/@xlink:href, '#') and document(substring-before(" + propi.qname() + "/@xlink:href,'#'))/id(substring-after(" + propi.qname() + "/@xlink:href,'#')))");
                schDoc.addAssertion(cibase, xpath, "Code list value exists");
                s = typeCi.taggedValue("codeListRepresentation");
                if (StringUtils.isBlank((CharSequence)s) || s.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    xpath = new XpathFragment(0, "(not contains(" + propi.qname() + "/@xlink:href, '#') and document(" + propi.qname() + "/@xlink:href)/gml:Definition) or (contains(" + propi.qname() + "/@xlink:href, '#') and document(substring-before(" + propi.qname() + "/@xlink:href,'#'))/id(substring-after(" + propi.qname() + "/@xlink:href,'#'))[local-name()='Definiton' and namespace-uri()='http://www.opengis.net/gml/3.2'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using GML 3.2");
                } else if (s.equalsIgnoreCase("application/rdf+xml")) {
                    xpath = new XpathFragment(0, "(not contains(" + propi.qname() + "/@xlink:href, '#') and document(" + propi.qname() + "/@xlink:href)/skos:Concept) or (contains(" + propi.qname() + "/@xlink:href, '#') and document(substring-before(" + propi.qname() + "/@xlink:href,'#'))/id(substring-after(" + propi.qname() + "/@xlink:href,'#'))[local-name()='Concept' and namespace-uri()='http://www.w3.org/2004/02/skos/core#'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using SKOS");
                }
            } else if (propi.inClass().matches("rule-xsd-cls-codelist-asDictionary") && (typeCi.asDictionary() || typeCi.asDictionaryGml33()) && s != null && !s.isEmpty()) {
                XpathFragment xpath = new XpathFragment(0, propi.qname() + "/@codeSpace='" + s + "'");
                schDoc.addAssertion(cibase, xpath, "Code space is '" + s + "'");
                Object s2 = schDoc.determineCodeListValuePattern(typeCi, "{codeList}/{value}");
                s2 = "concat('" + ((String)s2).replace("{codeList}", s).replace("{value}", "',.)");
                xpath = new XpathFragment(0, "(not contains('" + (String)s2 + "', '#') and document('" + (String)s2 + "')) or (contains('" + (String)s2 + "', '#') and document(substring-before('" + (String)s2 + "','#'))/id(substring-after('" + (String)s2 + "','#')))");
                schDoc.addAssertion(cibase, xpath, "Code list value exists");
                s = typeCi.taggedValue("codeListRepresentation");
                if (StringUtils.isBlank((CharSequence)s) || s.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    xpath = new XpathFragment(0, "(not contains('" + (String)s2 + "', '#') and document('" + (String)s2 + "')/gml:Definition) or (contains('" + (String)s2 + "', '#') and document(substring-before('" + (String)s2 + "','#'))/id(substring-after('" + (String)s2 + "','#'))[local-name()='Definiton' and namespace-uri()='http://www.opengis.net/gml/3.2'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using GML 3.2");
                } else if (s.equalsIgnoreCase("application/rdf+xml")) {
                    xpath = new XpathFragment(0, "(not contains('" + (String)s2 + "', '#') and document('" + (String)s2 + "')/skos:Concept) or (contains('" + (String)s2 + "', '#') and document(substring-before('" + (String)s2 + "','#'))/id(substring-after('" + (String)s2 + "','#'))[local-name()='Concept' and namespace-uri()='http://www.w3.org/2004/02/skos/core#'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using SKOS");
                }
            }
        } else if (schDoc != null && cibase.matches("rule-xsd-cls-codelist-constraints2")) {
            String clRepTV;
            if (propi.matches("rule-xsd-all-propertyAssertion-ignoreProhibited") && "true".equalsIgnoreCase(propi.taggedValue("prohibitedInProfile"))) {
                return;
            }
            schDoc.setQueryBinding("xslt2");
            String clTV = typeCi.taggedValue("codeList");
            if (StringUtils.isBlank((CharSequence)clTV)) {
                clTV = typeCi.taggedValue("vocabulary");
            }
            if (StringUtils.isBlank((CharSequence)clTV)) {
                this.result.addWarning(this, 1001, typeCi.name());
            }
            if (StringUtils.isBlank((CharSequence)(clRepTV = typeCi.taggedValue("codeListRepresentation"))) && this.codeListRepresentationTVFallback != null) {
                clRepTV = this.codeListRepresentationTVFallback;
            }
            if (StringUtils.isNotBlank((CharSequence)clRepTV) && !clRepTV.equalsIgnoreCase("application/gml+xml;version=3.2") && !clRepTV.equalsIgnoreCase("application/x.iso19139+xml")) {
                this.result.addWarning(this, 1000, clRepTV, typeCi.name());
            }
            if (typeCi.matches("rule-xsd-cls-standard-19139-property-types")) {
                XpathFragment xpathCodeListCorrectRepresentation;
                String codeListExpr = "*/@codeList";
                String codeListValueExpr = "*/@codeListValue";
                if (StringUtils.isNotBlank((CharSequence)clTV)) {
                    XpathFragment xpathCodeListUse = new XpathFragment(0, "every $codeListUrl in " + codeListExpr + " satisfies " + codeListExpr + "='" + clTV + "'", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListUse, "Code list shall be '" + clTV + "'");
                }
                if (StringUtils.isBlank((CharSequence)clRepTV) || clRepTV.equalsIgnoreCase("application/gml+xml;version=3.2") || clRepTV.equalsIgnoreCase("application/x.iso19139+xml")) {
                    schDoc.registerNamespace("gml");
                    XpathFragment xpathCodeListExists = new XpathFragment(0, "every $codeListUrl in " + codeListExpr + " satisfies (not(contains($codeListUrl, '#')) and doc-available($codeListUrl)) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and boolean(for $codelistDoc in doc(substring-before($codeListUrl,'#')) return exists($codelistDoc//*[@gml:id = substring-after($codeListUrl,'#')])))", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListExists, "Code list shall exist");
                }
                if (StringUtils.isBlank((CharSequence)clRepTV) || clRepTV.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    schDoc.registerNamespace("gml");
                    xpathCodeListCorrectRepresentation = new XpathFragment(0, "every $codeListUrl in " + codeListExpr + " satisfies (not(contains($codeListUrl, '#')) and doc-available($codeListUrl) and doc($codeListUrl)/gml:Dictionary) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and boolean(for $codelistDoc in doc(substring-before($codeListUrl,'#')) return exists($codelistDoc//gml:Dictionary[@gml:id = substring-after($codeListUrl,'#')])))", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListCorrectRepresentation, "Code list dictionary shall be represented using a GML 3.2 Dictionary");
                } else if (clRepTV.equalsIgnoreCase("application/x.iso19139+xml")) {
                    schDoc.registerNamespace("gml");
                    schDoc.registerNamespace("gmx");
                    xpathCodeListCorrectRepresentation = new XpathFragment(0, "every $codeListUrl in " + codeListExpr + " satisfies (not(contains($codeListUrl, '#')) and doc-available($codeListUrl) and doc($codeListUrl)/*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeListDictionary' or local-name() = 'CodeListDictionary')]) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and boolean(for $codelistDoc in doc(substring-before($codeListUrl,'#')) return exists($codelistDoc//*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeListDictionary' or local-name() = 'CodeListDictionary') and @gml:id = substring-after($codeListUrl,'#')])))", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListCorrectRepresentation, "Code list dictionary shall be represented using an ISO 19139 CodeListDictionary");
                }
                XpathFragment xpathCodeListValueExists = null;
                if (StringUtils.isBlank((CharSequence)clRepTV) || clRepTV.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    schDoc.registerNamespace("gml");
                    xpathCodeListValueExists = new XpathFragment(0, "every $codeListUrl in " + codeListExpr + ", $codeListValue in " + codeListValueExpr + " satisfies (not(contains($codeListUrl, '#')) and doc-available($codeListUrl) and doc($codeListUrl)/*/gml:dictionaryEntry/gml:Definition[gml:identifier = $codeListValue]) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and doc(substring-before($codeListUrl,'#'))//*[@gml:id = substring-after($codeListUrl,'#')]/gml:dictionaryEntry/gml:Definition[gml:identifier = $codeListValue])", XpathType.BOOLEAN);
                } else if (clRepTV.equalsIgnoreCase("application/x.iso19139+xml")) {
                    schDoc.registerNamespace("gml");
                    schDoc.registerNamespace("gmx");
                    xpathCodeListValueExists = new XpathFragment(0, "every $codeListUrl in " + codeListExpr + ", $codeListValue in " + codeListValueExpr + " satisfies (not(contains($codeListUrl, '#')) and doc-available($codeListUrl) and doc($codeListUrl)/*/gmx:codeEntry/*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeDefinition' or local-name() = 'CodeDefinition') and gml:identifier = $codeListValue]) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and doc(substring-before($codeListUrl,'#'))//*[@gml:id = substring-after($codeListUrl,'#')]/gmx:codeEntry/*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeDefinition' or local-name() = 'CodeDefinition') and gml:identifier = $codeListValue])", XpathType.BOOLEAN);
                }
                if (xpathCodeListValueExists != null) {
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListValueExists, "Code list value shall exist");
                }
            } else if (propi.inClass().matches("rule-xsd-cls-codelist-asDictionaryGml33") && (typeCi.asDictionary() || typeCi.asDictionaryGml33())) {
                XpathFragment xpathCLValueCorrectRepresentation;
                String clRefExp = "@xlink:href";
                if (StringUtils.isNotBlank((CharSequence)clTV)) {
                    schDoc.registerNamespace("xlink");
                    XpathFragment xpathCLValUriStartsWith = new XpathFragment(0, "every $clValueUri in " + clRefExp + " satisfies starts-with(" + clRefExp + ",'" + clTV + "')", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCLValUriStartsWith, "Code list value URI shall start with '" + clTV + "'");
                }
                if (StringUtils.isBlank((CharSequence)clRepTV) || clRepTV.equalsIgnoreCase("application/gml+xml;version=3.2") || clRepTV.equalsIgnoreCase("application/x.iso19139+xml")) {
                    schDoc.registerNamespace("gml");
                    schDoc.registerNamespace("xlink");
                    XpathFragment xpathCLValueExists = new XpathFragment(0, "every $clValueUri in " + clRefExp + " satisfies (not(contains($clValueUri, '#')) and doc-available($clValueUri)) or (contains($clValueUri, '#') and doc-available(substring-before($clValueUri,'#')) and boolean(for $codelistDoc in doc(substring-before($clValueUri,'#')) return exists($codelistDoc//*[@gml:id = substring-after($clValueUri,'#')])))", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCLValueExists, "Code list value shall exist");
                }
                if (StringUtils.isBlank((CharSequence)clRepTV) || clRepTV.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    schDoc.registerNamespace("gml");
                    schDoc.registerNamespace("xlink");
                    xpathCLValueCorrectRepresentation = new XpathFragment(0, "every $clValueUri in " + clRefExp + " satisfies (not(contains($clValueUri, '#')) and doc-available($clValueUri) and doc($clValueUri)/gml:Definition) or (contains($clValueUri, '#') and doc-available(substring-before($clValueUri,'#')) and boolean(for $codelistDoc in doc(substring-before($clValueUri,'#')) return exists($codelistDoc//gml:Definition[@gml:id = substring-after($clValueUri,'#')])))", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCLValueCorrectRepresentation, "Code list value shall be represented using GML 3.2 (gml:Definition)");
                } else if (clRepTV.equalsIgnoreCase("application/x.iso19139+xml")) {
                    schDoc.registerNamespace("gml");
                    schDoc.registerNamespace("gmx");
                    schDoc.registerNamespace("xlink");
                    xpathCLValueCorrectRepresentation = new XpathFragment(0, "every $clValueUri in " + clRefExp + " satisfies (not(contains($clValueUri, '#')) and doc-available($clValueUri) and doc($clValueUri)/*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeDefinition' or local-name() = 'CodeDefinition')]) or (contains($clValueUri, '#') and doc-available(substring-before($clValueUri,'#')) and boolean(for $codelistDoc in doc(substring-before($clValueUri,'#')) return exists($codelistDoc//*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeDefinition' or local-name() = 'CodeDefinition') and @gml:id = substring-after($clValueUri,'#')])))", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCLValueCorrectRepresentation, "Code list dictionary item shall be represented using an ISO 19139 CodeDefinition");
                }
            } else if (propi.inClass().matches("rule-xsd-cls-codelist-asDictionary") && (typeCi.asDictionary() || typeCi.asDictionaryGml33()) && StringUtils.isNotBlank((CharSequence)clTV)) {
                XpathFragment xpathCodeListCorrectRepresentation;
                String clRefExp = "if (@codeSpace) then @codeSpace else '" + clTV + "'";
                XpathFragment xpathCodeListUse = new XpathFragment(0, "if (not(@codeSpace)) then true() else @codeSpace='" + clTV + "'");
                schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListUse, "Code space, if set, shall be '" + clTV + "'");
                if (StringUtils.isBlank((CharSequence)clRepTV) || clRepTV.equalsIgnoreCase("application/gml+xml;version=3.2") || clRepTV.equalsIgnoreCase("application/x.iso19139+xml")) {
                    schDoc.registerNamespace("gml");
                    XpathFragment xpathCodeListExists = new XpathFragment(0, "every $codeListUrl in " + clRefExp + " satisfies (not(contains($codeListUrl, '#')) and doc-available($codeListUrl)) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and boolean(for $codelistDoc in doc(substring-before($codeListUrl,'#')) return exists($codelistDoc//*[@gml:id = substring-after($codeListUrl,'#')])))", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListExists, "Code list shall exist");
                }
                if (StringUtils.isBlank((CharSequence)clRepTV) || clRepTV.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    schDoc.registerNamespace("gml");
                    xpathCodeListCorrectRepresentation = new XpathFragment(0, "every $codeListUrl in " + clRefExp + " satisfies (not(contains($codeListUrl, '#')) and doc-available($codeListUrl) and doc($codeListUrl)/gml:Dictionary) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and boolean(for $codelistDoc in doc(substring-before($codeListUrl,'#')) return exists($codelistDoc//gml:Dictionary[@gml:id = substring-after($codeListUrl,'#')])))", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListCorrectRepresentation, "Code list dictionary shall be represented using a GML 3.2 Dictionary");
                } else if (clRepTV.equalsIgnoreCase("application/x.iso19139+xml")) {
                    schDoc.registerNamespace("gml");
                    schDoc.registerNamespace("gmx");
                    xpathCodeListCorrectRepresentation = new XpathFragment(0, "every $codeListUrl in " + clRefExp + " satisfies (not(contains($codeListUrl, '#')) and doc-available($codeListUrl) and doc($codeListUrl)/*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeListDictionary' or local-name() = 'CodeListDictionary')]) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and boolean(for $codelistDoc in doc(substring-before($codeListUrl,'#')) return exists($codelistDoc//*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeListDictionary' or local-name() = 'CodeListDictionary') and @gml:id = substring-after($codeListUrl,'#')])))", XpathType.BOOLEAN);
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListCorrectRepresentation, "Code list dictionary shall be represented using an ISO 19139 CodeListDictionary");
                }
                XpathFragment xpathCodeListValueExists = null;
                if (StringUtils.isBlank((CharSequence)clRepTV) || clRepTV.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    schDoc.registerNamespace("gml");
                    xpathCodeListValueExists = new XpathFragment(0, "every $codeListUrl in " + clRefExp + ", $codeListValue in ./text() satisfies(not(contains($codeListUrl, '#')) and doc-available($codeListUrl) and doc($codeListUrl)/*/gml:dictionaryEntry/gml:Definition[gml:identifier = $codeListValue]) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and doc(substring-before($codeListUrl,'#'))//*[@gml:id = substring-after($codeListUrl,'#')]/gml:dictionaryEntry/gml:Definition[gml:identifier = $codeListValue])", XpathType.BOOLEAN);
                } else if (clRepTV.equalsIgnoreCase("application/x.iso19139+xml")) {
                    schDoc.registerNamespace("gml");
                    schDoc.registerNamespace("gmx");
                    xpathCodeListValueExists = new XpathFragment(0, "every $codeListUrl in " + clRefExp + ", $codeListValue in ./text() satisfies(not(contains($codeListUrl, '#')) and doc-available($codeListUrl) and doc($codeListUrl)/*/gmx:codeEntry/*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeDefinition' or local-name() = 'CodeDefinition') and gml:identifier = $codeListValue]) or (contains($codeListUrl, '#') and doc-available(substring-before($codeListUrl,'#')) and doc(substring-before($codeListUrl,'#'))//*[@gml:id = substring-after($codeListUrl,'#')]/gmx:codeEntry/*[namespace-uri() = 'http://www.isotc211.org/2005/gmx' and (local-name() = 'ML_CodeDefinition' or local-name() = 'CodeDefinition') and gml:identifier = $codeListValue])", XpathType.BOOLEAN);
                }
                if (xpathCodeListValueExists != null) {
                    schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathCodeListValueExists, "Code list value shall exist");
                }
            }
        }
    }

    private void addNilReason(Element e) {
        this.addAttribute(e, "name", "nilReason");
        if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
            this.addAttribute(e, "type", "gml:NilReasonType");
        } else if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
            this.addAttribute(e, "type", "gml:NullType");
        }
        this.addImport("gml", this.options.fullNamespace("gml"));
    }

    private void addName(Element e) {
        this.addAttribute(e, "name", "name");
        this.addAttribute(e, "type", "NCName");
        this.addAttribute(e, "use", "required");
    }

    private boolean addAnonymousPropertyType(Element e, PropertyInfo propi, ClassInfo targetAssociationClass, String targetElement, HashSet<ClassInfo> types, boolean valueIsMetadata) {
        String s;
        Element e4;
        Element e5;
        Element sequenceOrChoice;
        ClassInfo instantiableMixinSubclassesTypeCi;
        Element typeOrExtension;
        Element e2;
        ClassInfo cibase = propi.inClass();
        if (cibase == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 157, propi.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
            return false;
        }
        boolean addMetadata = false;
        if (propi.propertyMetadata() && propi.matches("rule-xsd-prop-metadata")) {
            addMetadata = true;
        }
        if ((propi.isMetadata() || valueIsMetadata) && propi.matches("rule-xsd-prop-metadata-gmlsf-byReference")) {
            this.addAttribute(e, "type", "gml:ReferenceType");
            this.addImport("gml", this.options.fullNamespace("gml"));
            return false;
        }
        if (propi.matches("rule-xsd-prop-inlineOrByReference") && propi.inlineOrByReference().equals("byreference")) {
            if (cibase.matches("rule-xsd-cls-no-gml-types")) {
                Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                e.appendChild(e1);
                Element e42 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
                e1.appendChild(e42);
                e42 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e42);
                this.addAttribute(e42, "ref", "xlink:simpleAttrs");
                this.addImport("xlink", this.options.fullNamespace("xlink"));
                return false;
            }
            if (cibase.matches("rule-xsd-cls-standard-swe-property-types")) {
                this.addAttribute(e, "type", "swe:ReferenceType");
                this.addImport("swe", this.options.fullNamespace("swe"));
                return false;
            }
            boolean multiplicityAlreadySet = false;
            if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                boolean addNilReason = false;
                if (propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) {
                    addNilReason = true;
                }
                if (cibase.matches("rule-xsd-all-gml21")) {
                    Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    e.appendChild(e1);
                    Element e43 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
                    e1.appendChild(e43);
                    e43 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                    e1.appendChild(e43);
                    this.addAttribute(e43, "ref", "gml:AssociationAttributeGroup");
                    if (addNilReason) {
                        Element e52 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                        this.addAttribute(e52, "name", "nilReason");
                        this.addAttribute(e52, "type", "gml:NullType");
                        e1.appendChild(e52);
                    }
                    if (addMetadata) {
                        this.addMetadata(e1);
                    }
                } else if (this.qualifiers(propi) != null || addNilReason || addMetadata) {
                    Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    e.appendChild(e1);
                    Element e44 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                    e1.appendChild(e44);
                    Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                    e44.appendChild(e3);
                    this.addAttribute(e3, "base", "gml:ReferenceType");
                    if (this.processQualifiers(e3, propi)) {
                        this.addAttribute(e, "minOccurs", "0");
                        this.addAttribute(e, "maxOccurs", "unbounded");
                        multiplicityAlreadySet = true;
                    }
                    if (addNilReason) {
                        Element e53 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                        this.addAttribute(e53, "name", "nilReason");
                        this.addAttribute(e53, "type", "gml:NullType");
                        e3.appendChild(e53);
                    }
                    if (addMetadata) {
                        this.addMetadata(e3);
                    }
                } else {
                    this.addAttribute(e, "type", "gml:ReferenceType");
                }
                this.addImport("gml", this.options.fullNamespace("gml"));
                return multiplicityAlreadySet;
            }
            if (!(!this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") || propi.isMetadata() || valueIsMetadata || propi.isAggregation() || propi.isComposition())) {
                if (this.qualifiers(propi) != null || addMetadata) {
                    Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    e.appendChild(e1);
                    Element e45 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                    e1.appendChild(e45);
                    Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                    e45.appendChild(e3);
                    this.addAttribute(e3, "base", "gml:ReferenceType");
                    if (this.processQualifiers(e3, propi)) {
                        this.addAttribute(e, "minOccurs", "0");
                        this.addAttribute(e, "maxOccurs", "unbounded");
                        multiplicityAlreadySet = true;
                    }
                    if (addMetadata) {
                        this.addMetadata(e3);
                    }
                    return multiplicityAlreadySet;
                }
                this.addAttribute(e, "type", "gml:ReferenceType");
                this.addImport("gml", this.options.fullNamespace("gml"));
                return multiplicityAlreadySet;
            }
        }
        Element type = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        e.appendChild(type);
        if ((propi.isMetadata() || valueIsMetadata) && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && cibase.matches("rule-xsd-cls-standard-gml-property-types")) {
            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
            type.appendChild(e2);
            typeOrExtension = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
            e2.appendChild(typeOrExtension);
            this.addAttribute(typeOrExtension, "base", "gml:AbstractMetadataPropertyType");
        } else if ((propi.isAggregation() || propi.isComposition()) && (propi.categoryOfValue() == 6 || propi.categoryOfValue() == 1) && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && cibase.matches("rule-xsd-cls-standard-gml-property-types") && !cibase.matches("rule-xsd-cls-no-gml-types")) {
            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
            type.appendChild(e2);
            typeOrExtension = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
            e2.appendChild(typeOrExtension);
            if (propi.categoryOfValue() == 1) {
                this.addAttribute(typeOrExtension, "base", "gml:AbstractFeatureMemberType");
            } else {
                this.addAttribute(typeOrExtension, "base", "gml:AbstractMemberType");
            }
        } else {
            typeOrExtension = type;
        }
        HashSet<ClassInfo> instatiableMixinSubclasses = null;
        ClassInfo classInfo = instantiableMixinSubclassesTypeCi = targetAssociationClass != null ? targetAssociationClass : this.model.classByIdOrName(propi.typeInfo());
        if (instantiableMixinSubclassesTypeCi != null && instantiableMixinSubclassesTypeCi.matches("rule-xsd-cls-mixin-classes-non-mixin-supertypes")) {
            instatiableMixinSubclasses = this.subtypesOfMixins(instantiableMixinSubclassesTypeCi, false);
        }
        if (propi.matches("rule-xsd-prop-inlineOrByReference") && propi.inlineOrByReference().equals("byreference")) {
            sequenceOrChoice = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            typeOrExtension.appendChild(sequenceOrChoice);
        } else if (instatiableMixinSubclasses != null && !instatiableMixinSubclasses.isEmpty()) {
            sequenceOrChoice = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
            typeOrExtension.appendChild(sequenceOrChoice);
            e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            sequenceOrChoice.appendChild(e5);
            String s2 = this.elementName(instantiableMixinSubclassesTypeCi, true);
            if (s2 != null) {
                this.addAttribute(e5, "ref", s2);
            }
            this.addElements(sequenceOrChoice, instatiableMixinSubclasses);
        } else if (types != null) {
            sequenceOrChoice = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
            typeOrExtension.appendChild(sequenceOrChoice);
            this.addElements(sequenceOrChoice, types);
        } else if (targetElement != null) {
            sequenceOrChoice = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            typeOrExtension.appendChild(sequenceOrChoice);
            e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            sequenceOrChoice.appendChild(e5);
            this.addAttribute(e5, "ref", targetElement);
            int idx = targetElement.indexOf(":");
            if (idx > 0) {
                String nsabr = targetElement.substring(0, idx);
                this.addImport(nsabr, this.options.fullNamespace(nsabr));
            }
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(this, 116, propi.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
            return false;
        }
        boolean nilReasonAdded = false;
        ClassInfo cit = this.model.classById(propi.typeInfo().id);
        boolean multiplicityAlreadySet = false;
        if (this.asArray(propi)) {
            this.addMinMaxOccurs(sequenceOrChoice, propi.cardinality());
        } else if ((cit == null || this.classHasIdentity(cit)) && propi.matches("rule-xsd-prop-inlineOrByReference") && !propi.inlineOrByReference().equals("inline") || !propi.matches("rule-xsd-prop-inlineOrByReference") && cit != null && this.classHasIdentity(cit)) {
            if (!propi.inlineOrByReference().equals("byreference")) {
                this.addAttribute(sequenceOrChoice, "minOccurs", "0");
            }
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
            typeOrExtension.appendChild(e4);
            if (cibase.matches("rule-xsd-cls-no-gml-types")) {
                this.addAttribute(e4, "ref", "xlink:simpleAttrs");
            } else if (cibase.matches("rule-xsd-cls-standard-swe-property-types")) {
                this.addAttribute(e4, "ref", "swe:AssociationAttributeGroup");
            } else {
                this.addAttribute(e4, "ref", "gml:AssociationAttributeGroup");
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    nilReasonAdded = true;
                }
            }
        }
        if (!propi.isMetadata() && !valueIsMetadata && !propi.isAggregation() && !propi.isComposition() && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && cit != null && this.classHasIdentity(cit) && cibase.matches("rule-xsd-cls-standard-gml-property-types")) {
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
            typeOrExtension.appendChild(e4);
            this.addAttribute(e4, "ref", "gml:OwnershipAttributeGroup");
        }
        if ((propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) && !nilReasonAdded) {
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            typeOrExtension.appendChild(e4);
            this.addAttribute(e4, "name", "nilReason");
            if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                this.addAttribute(e4, "type", "gml:NilReasonType");
            } else if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                this.addAttribute(e4, "type", "gml:NullType");
            }
        }
        if (propi.matches("rule-xsd-prop-soft-typed") && "true".equalsIgnoreCase(s = propi.taggedValue("soft-typed"))) {
            Element e46 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            typeOrExtension.appendChild(e46);
            this.addName(e46);
        }
        if (this.processQualifiers(typeOrExtension, propi)) {
            this.addAttribute(e, "minOccurs", "0");
            this.addAttribute(e, "maxOccurs", "unbounded");
            multiplicityAlreadySet = true;
        }
        if (addMetadata) {
            this.addMetadata(typeOrExtension);
        }
        if (cibase.matches("rule-xsd-cls-no-gml-types")) {
            this.addImport("xlink", this.options.fullNamespace("xlink"));
        } else if (cibase.matches("rule-xsd-cls-standard-swe-property-types")) {
            this.addImport("swe", this.options.fullNamespace("swe"));
        } else {
            this.addImport("gml", this.options.fullNamespace("gml"));
        }
        return multiplicityAlreadySet;
    }

    private void addMetadata(Element e) {
        Element m = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
        e.appendChild(m);
        this.addAttribute(m, "name", "metadata");
        this.addAttribute(m, "type", "anyURI");
    }

    private String stripQuotes(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block3: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    continue block3;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public void addInclude(XsdDocument xsd) {
        if (xsd == this) {
            return;
        }
        boolean found = false;
        for (String f : this.includes) {
            if (!f.equals(xsd.name)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.includes.add(xsd.name);
        }
    }

    public void addImport(String nsabr, String ns) {
        if (ns == null || ns.equals(this.targetNamespace)) {
            return;
        }
        boolean found = false;
        for (String nsx : this.imports) {
            if (!nsx.equals(ns)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.imports.add(ns);
            this.result.addDebug(this, 10021, ns);
            if (nsabr != null) {
                this.addAttribute(this.root, "xmlns:" + nsabr, ns);
            }
        }
    }

    public void printFile(Properties outputFormat) throws Exception {
        Element e;
        if (this.printed) {
            return;
        }
        Element anchor = this.rootAnnotation;
        Collections.sort(this.includes);
        for (String string : this.includes) {
            e = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "include");
            this.addAttribute(e, "schemaLocation", string);
            if (anchor == null) {
                this.root.insertBefore(e, this.root.getFirstChild());
            } else {
                this.root.insertBefore(e, anchor.getNextSibling());
            }
            anchor = e;
        }
        Collections.sort(this.imports);
        for (String s : this.imports) {
            e = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
            this.addAttribute(e, "namespace", s);
            String loc = this.options.schemaLocationOfNamespace(s);
            if (loc != null) {
                this.addAttribute(e, "schemaLocation", loc);
            }
            if (anchor == null) {
                this.root.insertBefore(e, this.root.getFirstChild());
            } else {
                this.root.insertBefore(e, anchor.getNextSibling());
            }
            anchor = e;
        }
        File file = new File(this.outputDirectory);
        boolean exi = file.exists();
        if (!exi) {
            file.mkdirs();
            exi = file.exists();
        }
        boolean dir = file.isDirectory();
        boolean wrt = file.canWrite();
        boolean rea = file.canRead();
        if (!(exi && dir && wrt && rea)) {
            this.result.addFatalError(this, 12, this.outputDirectory);
            throw new ShapeChangeAbortException();
        }
        try {
            String fname = this.outputDirectory + "/" + this.name;
            new File(fname).getCanonicalPath();
            FileOutputStream fout = new FileOutputStream(fname);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)bout, outputFormat.getProperty("encoding"));
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
        }
        catch (IOException ioe) {
            this.result.addError(null, 171, this.name);
        }
        this.printed = true;
    }

    public boolean printed() {
        return this.printed;
    }

    @Override
    public String message(int mnr) {
        String mess = this.messageText(mnr);
        if (mess == null) {
            return null;
        }
        String prefix = "";
        if (mess.startsWith("??")) {
            prefix = "??";
            mess = mess.substring(2);
        }
        return prefix + "XML Schema Target: " + mess;
    }

    protected String messageText(int mnr) {
        switch (mnr) {
            case 1: {
                return "Context: class '$1$'";
            }
            case 2: {
                return "Context: property '$1$'";
            }
            case 12: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
            case 116: {
                return "Target object element(s) missing in property type for property '$1$'.";
            }
            case 119: {
                return "No element for type '$1$' is defined. Only object and data types are represented by elements.";
            }
            case 122: {
                return "The type with the name '$1$' has no tagged value 'base' or valid supertype and cannot be mapped to a basic type.";
            }
            case 123: {
                return "The type with the name '$1$' has no ID and cannot be mapped to a basic type.";
            }
            case 124: {
                return "Failed to create basic type '$1$'.";
            }
            case 128: {
                return "The property '$1$' cannot be assigned a type as it is mapped to an XML attribute, but the type is not a simple type.";
            }
            case 129: {
                return "Union '$1$' as the value type of '$2$' could not be mapped as it does not contain the expected number of exactly one property to be encoded in the application schema.";
            }
            case 130: {
                return "No type can be provided for the property '$1$'.";
            }
            case 141: {
                return "The class '$1$' referenced from class '$2$' is not part of any package nor is it mapped to a well-known XML Schema type. The class is ignored.";
            }
            case 145: {
                return "ADE class '$1$' cannot be suppressed, as it has no supertype.";
            }
            case 154: {
                return "??No rule to name the '$1$' of class '$2$' is configured. Please check the current configuration.";
            }
            case 155: {
                return "??No rule for a choice/sequence/all container for class '$1$' is configured, sequence is used. Please check the current configuration.";
            }
            case 156: {
                return "??Failed to create enumeration type '$1$EnumerationType'.";
            }
            case 157: {
                return "??Class of property '$1$' cannot be determined. The property is ignored.";
            }
            case 158: {
                return "??MapEntry contains empty mapping target. Verify the configuration and look for 'fixme:fixme' in the created schemas.";
            }
            case 166: {
                return "Class '$1$' cannot be mapped to an object element and is not included in the mapping of class '$2$'.";
            }
            case 169: {
                return "The property '$1$' cannot be assigned a type as it is mapped to an XML Schema list attribute, but the type '$2$' is not a simple type.";
            }
            case 170: {
                return "??The property '$1$' cannot be made an array propery as it is not restricted to inline content. Set 'inlineOrByReference' to 'inline' on the property.";
            }
            case 172: {
                return "??The property '$1$' cannot be made an array propery as the type map does not specify an XML element for type '$2$'.";
            }
            case 173: {
                return "??The property '$1$' cannot be made an array propery as the type '$2$' is not represented by an object element in XML.";
            }
            case 174: {
                return "??MapEntry contains mapping target '$1$' from unknown schema. Verify the configuration and look for 'fixme:fixme' in the created schemas.";
            }
            case 175: {
                return "??'$1$' is a complex type with simple content which cannot be used in a qualifier. 'string' is used instead.";
            }
            case 177: {
                return "??A qualifier has type '$1$' which could not be identified unambiguously in model. 'string' is used instead.";
            }
            case 178: {
                return "??'$1$' is a data type and cannot be used in a qualifier. 'string' is used instead.";
            }
            case 179: {
                return "??'$1$' is a type of an unsupported category for a qualifier. 'string' is used instead.";
            }
            case 180: {
                return "Could not find a map entry for the value type '$1$' of property '$2$' or the value type itself (in the model). Thus, constraining facets could not be created.";
            }
            case 1009: {
                return "The property '$1$' is tagged as a metadata property. This is only possible for properties with complex content.";
            }
            case 1010: {
                return "Support for nilReason attributes was requested in property '$1$'. This is not possible for properties which have a local $2$ as their value.";
            }
            case 1000: {
                return "??Representation '$1$' of code list '$2$' is not recognized. No representation specific schematron assertions will be created for this code list.";
            }
            case 1001: {
                return "??Code list URI of code list '$1$' is undefined. Schematron assertions that require the presence of this URI will not be created for the code list.";
            }
            case 2000: {
                return "Union '$1$' is subtype of union '$2$'. Both have attributes. This would lead to an XML Schema that requires choices of both unions to be encoded via two XML elements. This is contrary to the modeling intent of a union (where a single element would be encoded). The attributes of the subtype will be ignored. It is recommended that you review and revise your model. One situation where it is ok to have a subtype union is where the subtype does not have any attribute and only defines OCL constraints to restrict the options from the supertype union.";
            }
            case 2001: {
                return "Could not find QName for value type '$1$' of property '$2$' in basic type '$3$'. Using 'FIXME' instead.";
            }
            case 10021: {
                return "Import to namespace '$1$' added.";
            }
            case 10022: {
                return "Found: '$1$'";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

