/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.Target.XmlSchema.BindingContext;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XpathType;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XpathFragment {
    public int priority;
    public String fragment;
    public XpathType type;
    public TreeMap<String, String> lets = null;
    public BindingContext atEnd = new BindingContext(BindingContext.CtxState.NONE);

    public XpathFragment(int p, String f, XpathType t) {
        this.priority = p;
        this.fragment = f;
        this.type = t;
    }

    public XpathFragment(int p, String f) {
        this.priority = p;
        this.fragment = f;
        this.type = XpathType.NODESET;
    }

    public void bracket() {
        this.fragment = "(" + this.fragment + ")";
        this.priority = 20;
    }

    public String merge(XpathFragment xf) {
        if (xf.lets != null) {
            String vn;
            for (Map.Entry<String, String> ve : xf.lets.entrySet()) {
                vn = ve.getKey();
                xf.replace("\\$" + vn + "(?!\\w)", "%" + vn);
            }
            for (Map.Entry<String, String> ve : xf.lets.entrySet()) {
                vn = ve.getKey();
                String ex = ve.getValue();
                String vnew = this.findOrAdd(ex);
                xf.replace("%" + vn + "(?!\\w)", "\\$" + vnew);
            }
        }
        if (this.atEnd != null) {
            this.atEnd.merge(xf.atEnd);
        }
        return xf.fragment;
    }

    public String findOrAdd(String ex) {
        if (this.lets == null) {
            this.lets = new TreeMap();
        }
        if (ex.startsWith("$") && this.lets.containsKey(ex.substring(1))) {
            return ex.substring(1);
        }
        for (Map.Entry<String, String> ve : this.lets.entrySet()) {
            if (!ve.getValue().equals(ex)) continue;
            return ve.getKey();
        }
        Object newkey = "A";
        if (!this.lets.isEmpty()) {
            String last = this.lets.lastKey();
            String lc = last.substring(last.length() - 1);
            if (lc.equals("Z")) {
                newkey = last + "A";
            } else {
                try {
                    byte[] bytes = lc.getBytes("US-ASCII");
                    bytes[0] = (byte)(bytes[0] + 1);
                    newkey = last.substring(0, last.length() - 1) + new String(bytes, "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        this.lets.put((String)newkey, ex);
        return newkey;
    }

    private void replace(String from, String to) {
        Pattern pat = Pattern.compile(from);
        if (this.lets != null) {
            for (Map.Entry<String, String> ve : this.lets.entrySet()) {
                String ex = ve.getValue();
                Matcher matcher = pat.matcher(ex);
                ve.setValue(matcher.replaceAll(to));
            }
        }
        Matcher matcher = pat.matcher(this.fragment);
        this.fragment = matcher.replaceAll(to);
    }
}

