/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.AbstractConfigurationValidator;
import de.interactive_instruments.ShapeChange.Model.Descriptor;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessConfiguration;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class XmlSchemaConfigurationValidator
extends AbstractConfigurationValidator {
    protected SortedSet<String> allowedParametersWithStaticNames = new TreeSet<String>(Stream.of("defaultCodeListRepresentation", "defaultCodeListValuePattern", "defaultVoidReasonType", "okstra", "okstraKeyValueBaseType", "okstraKeyValuePropertyType", "okstraObjectRefType", "representDescriptors", "schematronFileNameTemplate", "schematronQueryBinding", "schematronXlinkHrefPostfix", "schematronXlinkHrefPrefix", "segmentSchematron", "skipXmlSchemaOutput", "suppressedTypeInterpretation", "includeDocumentation", "realisationLikeGeneralisation", "enumStyle", "basicTypeStyle", "schematron", "includeDerivedProperties").collect(Collectors.toSet()));
    protected List<Pattern> regexForAllowedParametersWithDynamicNames = Stream.of(Pattern.compile("^schematronExtension\\.(\\w+?)\\.function|schematronExtension\\.(\\w+?)\\.namespace$")).collect(Collectors.toList());
    private ProcessConfiguration config = null;
    private Options options = null;
    private ShapeChangeResult result = null;

    @Override
    public boolean isValid(ProcessConfiguration config, Options options, ShapeChangeResult result) {
        String representDescriptorsParamValue;
        String explicitSchematronQueryBinding;
        this.config = config;
        this.options = options;
        this.result = result;
        boolean isValid = true;
        this.allowedParametersWithStaticNames.addAll(this.getCommonTargetParameters());
        boolean bl = isValid = this.validateParameters(this.allowedParametersWithStaticNames, this.regexForAllowedParametersWithDynamicNames, config.getParameters().keySet(), result) && isValid;
        if (config.getParameters().keySet() != null) {
            String schExtFunctRegex = "^schematronExtension\\.(\\w+?)\\.function";
            Pattern schExtFunctPattern = Pattern.compile(schExtFunctRegex);
            HashSet<String> schExtFunctionNames = new HashSet<String>();
            for (String parameter : config.getParameters().keySet()) {
                Matcher mat = schExtFunctPattern.matcher(parameter);
                if (!mat.matches()) continue;
                schExtFunctionNames.add(mat.group(1));
            }
            String schExtNsRegex = "^schematronExtension\\.(\\w+?)\\.namespace";
            Pattern schExtNsPattern = Pattern.compile(schExtNsRegex);
            for (String parameter : config.getParameters().keySet()) {
                String functName;
                Matcher mat = schExtNsPattern.matcher(parameter);
                if (!mat.matches() || schExtFunctionNames.contains(functName = mat.group(1))) continue;
                isValid = false;
                result.addError(this, 200, parameter, functName);
            }
        }
        if ((explicitSchematronQueryBinding = options.parameterAsString(this.getClass().getName(), "schematronQueryBinding", null, false, true)) != null && !explicitSchematronQueryBinding.equalsIgnoreCase("xslt2")) {
            result.addError(this, 101, explicitSchematronQueryBinding);
            isValid = false;
        }
        if ((representDescriptorsParamValue = options.parameterAsString("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "representDescriptors", null, false, true)) != null) {
            List<String> namesOfDescriptorsToRepresent = options.parameterAsStringList("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "representDescriptors", null, true, true);
            TreeSet<String> unknownDescriptors = new TreeSet<String>();
            for (String descriptorName : namesOfDescriptorsToRepresent) {
                try {
                    Descriptor.valueOf(descriptorName.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    unknownDescriptors.add(descriptorName);
                }
            }
            if (!unknownDescriptors.isEmpty()) {
                String unknownDescriptorsAsString = StringUtils.join(unknownDescriptors, (String)", ");
                result.addError(this, 100, representDescriptorsParamValue, unknownDescriptorsAsString);
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: XmlSchema target configuration element with 'inputs'='$1$'.";
            }
            case 100: {
                return "Configuration parameter 'representDescriptors' contains unknown descriptors. Parameter value is: '$1$'. Unknown descriptors are: '$2$'.";
            }
            case 101: {
                return "Configuration parameter 'schematronQueryBinding', if set, must have a value equal to (ignoring case) 'xslt2'. Found parameter value: '$1$'.";
            }
            case 200: {
                return "Parameter '$1$' defines a namespace for the schematron extension function '$2$'. However, the corresponding parameter that actually defines that function ('schematronExtension.$2$.function') was not found. The parameter will therefore be ignored.";
            }
        }
        return "(" + XmlSchemaConfigurationValidator.class.getName() + ") Unknown message with number: " + mnr;
    }
}

