/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.RuleRegistry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronSchemaOld;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronSchemaXslt2;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XpathFragment;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XpathType;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XsdDocument;
import de.interactive_instruments.ShapeChange.TargetXmlSchemaConfiguration;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlSchema
implements Target,
MessageSource {
    private ShapeChangeResult result = null;
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private boolean printed = false;
    private final HashMap<String, XsdDocument> xsdMap = new HashMap();
    protected SchematronSchema commonSchDoc = null;
    private boolean diagnosticsOnly = false;
    private String outputDirectory;
    protected ClassInfo defaultVoidReasonType = null;
    private TargetXmlSchemaConfiguration config;
    protected String explicitSchematronQueryBinding;
    protected boolean schematronSegmentation = false;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        File trgdir;
        String voidReasonType;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.diagnosticsOnly = diagOnly;
        if (this.pi.matches("rule-xsd-all-notEncoded") && this.pi.encodingRule("xsd").equalsIgnoreCase("notencoded")) {
            return;
        }
        this.result.addDebug(this, 10012, this.pi.name());
        this.config = (TargetXmlSchemaConfiguration)o.getCurrentProcessConfig();
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if (StringUtils.isBlank((CharSequence)(voidReasonType = this.options.parameterAsString(this.getClass().getName(), "defaultVoidReasonType", null, false, true)))) {
            this.defaultVoidReasonType = null;
        } else {
            this.defaultVoidReasonType = this.findClassByFullNameInSchemaInModelOrByNameInSchema(voidReasonType);
            if (this.defaultVoidReasonType == null) {
                this.result.addInfo(this, 2012, voidReasonType);
            }
        }
        this.explicitSchematronQueryBinding = this.options.parameterAsString(this.getClass().getName(), "schematronQueryBinding", null, false, true);
        this.schematronSegmentation = this.options.parameterAsBoolean(this.getClass().getName(), "segmentSchematron", false);
        if (this.pi.matches("rule-xsd-pkg-schematron") && !this.schematronSegmentation) {
            String schemaXsdDocument = this.pi.xsdDocument();
            String schemaXsdBaseName = FilenameUtils.getBaseName((String)schemaXsdDocument);
            this.commonSchDoc = "xslt2".equalsIgnoreCase(this.explicitSchematronQueryBinding) ? new SchematronSchemaXslt2(this.model, this.options, this.result, this.pi, schemaXsdBaseName, this.schematronSegmentation) : new SchematronSchemaOld(this.model, this.options, this.result, this.pi, schemaXsdBaseName, this.schematronSegmentation);
        }
        this.createXSDs(this.pi, null);
        if (this.pi.matches("rule-xsd-pkg-dependencies")) {
            this.processDependecies(this.pi);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pi.taggedValue("xsdForcedImports"))) {
            String[] nsabrForcedImports = this.pi.taggedValue("xsdForcedImports").split("\\s*,\\s*");
            XsdDocument xsd = this.xsdMap.get(this.pi.id());
            for (String nsabr : nsabrForcedImports) {
                String ns = this.options.fullNamespace(nsabr);
                if (StringUtils.isBlank((CharSequence)ns)) {
                    this.result.addError(this, 1001, nsabr, this.pi.name());
                    continue;
                }
                xsd.addImport(nsabr, ns);
            }
        }
        if (!this.diagnosticsOnly && !(trgdir = new File(this.outputDirectory)).exists()) {
            trgdir.mkdirs();
        }
    }

    @Override
    public void process(ClassInfo ci) {
        Element propertyHook;
        SchematronSchema schDoc;
        if (ci == null || ci.pkg() == null) {
            return;
        }
        int cat = ci.category();
        this.result.addDebug(this, 10016, ci.name(), ci.encodingRule("xsd"));
        if (ci.matches("rule-xsd-all-notEncoded") && ci.encodingRule("xsd").equalsIgnoreCase("notencoded")) {
            return;
        }
        PackageInfo pi = ci.pkg();
        XsdDocument xsd = this.xsdMap.get(pi.id());
        while (xsd == null) {
            if ((pi = pi.owner()) == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(this, 10, ci.name(), ci.pkg().name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
                return;
            }
            xsd = this.xsdMap.get(pi.id());
        }
        ClassInfo cibase = ci.baseClass();
        if (ci.matches("rule-xsd-cls-no-base-class")) {
            cibase = null;
        }
        if ((schDoc = xsd.getSchematronDocument()) != null) {
            List<Constraint> cs = ci.constraints();
            Collections.sort(cs, new Comparator<Constraint>(){

                @Override
                public int compare(Constraint ci1, Constraint ci2) {
                    return ci1.name().compareTo(ci2.name());
                }
            });
            for (Constraint c : cs) {
                if (c == null || !(c instanceof OclConstraint) || schDoc == null || ((OclConstraint)c).syntaxTree() == null) continue;
                schDoc.addAssertion(ci, (OclConstraint)c);
            }
            for (PropertyInfo propi : ci.properties().values()) {
                if (ci.category() != 2 && ci.category() != 3 && (propi.nilReasonAllowed() && propi.matches("rule-xsd-prop-nilReasonAllowed") || propi.voidable() && propi.matches("rule-xsd-prop-nillable"))) {
                    if (propi.matches("rule-xsd-prop-valueOrNilReason-constraints")) {
                        this.addAssertionForValueOrNilReason(ci, propi, this.model.classByIdOrName(propi.typeInfo()), schDoc);
                    }
                    if (propi.matches("rule-xsd-prop-nilReason-constraints")) {
                        ShapeChangeResult.MessageContext mc;
                        ClassInfo directVoidReasonType;
                        String voidReasonType = propi.taggedValue("voidReasonType");
                        if (StringUtils.isBlank((CharSequence)voidReasonType)) {
                            directVoidReasonType = null;
                        } else {
                            ShapeChangeResult.MessageContext mc2;
                            directVoidReasonType = this.findClassByFullNameInSchemaInModelOrByNameInSchema(voidReasonType);
                            if (directVoidReasonType == null && (mc2 = this.result.addInfo(this, 2013, propi.name(), propi.inClass().name(), voidReasonType)) != null) {
                                mc2.addDetail(this, 0, propi.fullName());
                            }
                        }
                        ClassInfo vrt = directVoidReasonType;
                        if (vrt == null) {
                            vrt = this.defaultVoidReasonType;
                        }
                        if (vrt != null) {
                            if (vrt.category() == 3 && vrt.properties().size() > 0) {
                                this.addAssertionForNilReasonCheck(ci, propi, vrt, schDoc);
                            } else {
                                mc = this.result.addWarning(this, 2009, propi.name(), vrt.name());
                                if (mc != null) {
                                    mc.addDetail(this, 0, propi.fullNameInSchema());
                                }
                            }
                        } else {
                            mc = this.result.addWarning(this, 2010, propi.name());
                            if (mc != null) {
                                mc.addDetail(this, 0, propi.fullNameInSchema());
                            }
                        }
                    }
                }
                List<Constraint> propiCs = propi.constraints();
                Collections.sort(propiCs, new Comparator<Constraint>(){

                    @Override
                    public int compare(Constraint ci1, Constraint ci2) {
                        return ci1.name().compareTo(ci2.name());
                    }
                });
                for (Constraint c : propiCs) {
                    if (c == null || !(c instanceof OclConstraint) || schDoc == null || ((OclConstraint)c).syntaxTree() == null) continue;
                    schDoc.addAssertionForPropertyConstraint((OclConstraint)c, null, true);
                }
            }
        }
        switch (cat) {
            case 2: 
            case 3: {
                if (!ci.matches("rule-xsd-cls-enum-object-element")) break;
                xsd.pObjectElement(ci, cibase);
                break;
            }
            case 8: {
                if (ci.matches("rule-xsd-cls-union-asGroup") && ci.asGroup() || ci.matches("rule-xsd-cls-union-asCharacterString") && ci.asCharacterString() || ci.matches("rule-xsd-cls-union-as-group-property-type") || ci.isUnionDirect() || ci.matches("rule-xsd-cls-union-omitUnionsRepresentingFeatureTypeSets") && "true".equalsIgnoreCase(ci.taggedValue("representsFeatureTypeSet"))) break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 12: {
                if (ci.matches("rule-xsd-cls-no-abstract-classes") && ci.isAbstract() || ci.matches("rule-xsd-cls-suppress") && ci.suppressed() || !ci.matches("rule-xsd-cls-object-element")) break;
                xsd.pObjectElement(ci, cibase);
                break;
            }
            case 4: {
                if (!ci.matches("rule-xsd-cls-mixin-classes")) break;
            }
        }
        switch (cat) {
            case 3: {
                if (!ci.matches("rule-xsd-cls-global-enumeration")) break;
                xsd.pGlobalEnumeration(ci);
                break;
            }
            case 2: {
                if ((!ci.matches("rule-xsd-cls-codelist-asDictionary") || ci.asDictionary()) && (!ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") || ci.asDictionaryGml33())) break;
                xsd.pGlobalCodeList(ci);
                break;
            }
            case 8: {
                if (ci.matches("rule-xsd-cls-union-omitUnionsRepresentingFeatureTypeSets") && "true".equalsIgnoreCase(ci.taggedValue("representsFeatureTypeSet")) || ci.matches("rule-xsd-cls-union-asGroup") && ci.asGroup() || ci.matches("rule-xsd-cls-union-asCharacterString") && ci.asCharacterString()) break;
                if (ci.matches("rule-xsd-cls-union-as-group-property-type")) {
                    xsd.pValueTypeGroup(ci);
                    break;
                }
                if (ci.isUnionDirect()) break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 12: {
                if (ci.matches("rule-xsd-cls-adeelement") && ci.stereotype("adeelement")) {
                    xsd.processLocalProperties(ci, xsd.root, schDoc);
                    break;
                }
                if (ci.matches("rule-xsd-cls-suppress") && ci.suppressed() || ci.matches("rule-xsd-cls-no-abstract-classes") && ci.isAbstract() || !ci.matches("rule-xsd-cls-type")) break;
                propertyHook = xsd.pComplexType(ci, cibase, schDoc);
                if (!ci.matches("rule-xsd-cls-local-properties")) break;
                xsd.processLocalProperties(ci, propertyHook, schDoc);
                break;
            }
            case 4: {
                if (!ci.matches("rule-xsd-cls-mixin-classes")) break;
            }
        }
        switch (cat) {
            case 2: 
            case 3: {
                if (!ci.matches("rule-xsd-cls-enum-property-type")) break;
                xsd.pPropertyTypes(ci);
                break;
            }
            case 8: {
                if (ci.matches("rule-xsd-cls-union-asGroup") && ci.asGroup() || ci.matches("rule-xsd-cls-union-asCharacterString") && ci.asCharacterString()) break;
                if (ci.matches("rule-xsd-cls-union-as-group-property-type")) {
                    xsd.pPropertyTypeWithGroup(ci);
                    break;
                }
                if (ci.isUnionDirect() || ci.matches("rule-xsd-cls-union-omitUnionsRepresentingFeatureTypeSets") && "true".equalsIgnoreCase(ci.taggedValue("representsFeatureTypeSet"))) break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (ci.matches("rule-xsd-cls-suppress") && ci.suppressed()) break;
                if (ci.matches("rule-xsd-cls-no-abstract-classes") && ci.isAbstract()) {
                    xsd.pPropertyTypeWithSubtypes(ci);
                    break;
                }
                if (!ci.matches("rule-xsd-cls-type")) break;
                xsd.pPropertyTypes(ci);
                break;
            }
            case 4: {
                if (!ci.matches("rule-xsd-cls-mixin-classes")) break;
                xsd.pPropertyTypeWithSubtypes(ci);
                break;
            }
            case 11: {
                if (!ci.matches("rule-xsd-cls-okstra-schluesseltabelle")) break;
                xsd.pOKSTRAKEYPropertyType(ci);
            }
        }
        switch (cat) {
            case 8: {
                if (ci.matches("rule-xsd-cls-union-omitUnionsRepresentingFeatureTypeSets") && "true".equalsIgnoreCase(ci.taggedValue("representsFeatureTypeSet")) || !ci.matches("rule-xsd-cls-union-asGroup") || !ci.asGroup()) break;
                propertyHook = xsd.pGroup(ci, cibase);
                xsd.processLocalProperties(ci, propertyHook, schDoc);
                break;
            }
            case 4: {
                if (!ci.matches("rule-xsd-cls-mixin-classes") || !ci.matches("rule-xsd-cls-mixin-classes-as-group")) break;
                propertyHook = xsd.pGroup(ci, cibase);
                xsd.processLocalProperties(ci, propertyHook, schDoc);
                break;
            }
            case 7: {
                if (!ci.matches("rule-xsd-cls-basictype") || ci.matches("rule-xsd-cls-local-basictype")) break;
                xsd.pGlobalBasicType(ci);
            }
        }
    }

    ClassInfo findClassByFullNameInSchemaInModelOrByNameInSchema(String className) {
        if (className.contains("::")) {
            return this.model.classByFullNameInSchema(className);
        }
        return this.model.classes(this.pi).stream().filter(schemaCi -> schemaCi.name().equalsIgnoreCase(className)).findFirst().orElse(null);
    }

    private void addAssertionForNilReasonCheck(ClassInfo cibase, PropertyInfo propi, ClassInfo voidReasonType, SchematronSchema schDoc) {
        if (this.pi.matches("rule-xsd-prop-xsdAsAttribute")) {
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 2006, propi.name(), propi.inClass().name());
            if (mc != null) {
                mc.addDetail(this, 0, propi.fullName());
            }
            return;
        }
        if (cibase.category() == 8 && (cibase.matches("rule-xsd-cls-union-asCharacterString") && "true".equalsIgnoreCase(cibase.taggedValue("gmlAsCharacterString")) || cibase.matches("rule-xsd-cls-union-asGroup") && "true".equalsIgnoreCase(cibase.taggedValue("gmlAsGroup")))) {
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 2007, propi.name(), propi.inClass().name());
            if (mc != null) {
                mc.addDetail(this, 0, propi.fullName());
            }
            return;
        }
        if (cibase.category() == 4 && cibase.matches("rule-xsd-cls-mixin-classes-as-group")) {
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 2008, propi.name(), propi.inClass().name());
            if (mc != null) {
                mc.addDetail(this, 0, propi.fullName());
            }
            return;
        }
        schDoc.setQueryBinding("xslt2");
        String enumSequence = voidReasonType.properties().values().stream().map(enumPi -> "'" + enumPi.name() + "'").sorted().collect(Collectors.joining(", "));
        String xpath = "not(@*:nilReason) or @*:nilReason = (" + enumSequence + ")";
        XpathFragment xpathNilReasonCheck = new XpathFragment(0, xpath, XpathType.BOOLEAN);
        String assertionText = "If a nil reason is given for property " + propi.name() + ", then it needs to be one of: " + enumSequence;
        schDoc.addAssertionForExplicitProperty(cibase, propi, true, xpathNilReasonCheck, assertionText);
    }

    private void addAssertionForValueOrNilReason(ClassInfo cibase, PropertyInfo propi, ClassInfo typeCi, SchematronSchema schDoc) {
        boolean unionAsGroup;
        if (propi.matches("rule-xsd-prop-xsdAsAttribute")) {
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 2002, propi.name(), propi.inClass().name());
            if (mc != null) {
                mc.addDetail(this, 0, propi.fullName());
            }
            return;
        }
        MapEntry mea = this.options.attributeMapEntry(propi.typeInfo().name, cibase.encodingRule("xsd"));
        MapEntry meag = this.options.attributeGroupMapEntry(propi.typeInfo().name, cibase.encodingRule("xsd"));
        boolean bl = unionAsGroup = typeCi != null && typeCi.matches("rule-xsd-cls-union-asGroup");
        if (mea != null || meag != null || unionAsGroup) {
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 2003, propi.name(), propi.inClass().name());
            if (mc != null) {
                mc.addDetail(this, 0, propi.fullName());
            }
            return;
        }
        if (cibase.category() == 8 && (cibase.matches("rule-xsd-cls-union-asCharacterString") && "true".equalsIgnoreCase(cibase.taggedValue("gmlAsCharacterString")) || cibase.matches("rule-xsd-cls-union-asGroup") && "true".equalsIgnoreCase(cibase.taggedValue("gmlAsGroup")))) {
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 2004, propi.name(), propi.inClass().name());
            if (mc != null) {
                mc.addDetail(this, 0, propi.fullName());
            }
            return;
        }
        if (cibase.category() == 4 && cibase.matches("rule-xsd-cls-mixin-classes-as-group")) {
            ShapeChangeResult.MessageContext mc = this.result.addDebug(this, 2005, propi.name(), propi.inClass().name());
            if (mc != null) {
                mc.addDetail(this, 0, propi.fullName());
            }
            return;
        }
        boolean valueIsSimpleType = this.isSimpleType(typeCi, propi.typeInfo().name, propi.encodingRule("xsd"));
        schDoc.setQueryBinding("xslt2");
        String piElementXPath = propi.qname();
        String piValueXPath = null;
        if (propi.matches("rule-xsd-prop-metadata-gmlsf-byReference") && "true".equalsIgnoreCase(propi.taggedValue("isMetadata"))) {
            piValueXPath = piElementXPath + "/@xlink:href";
            schDoc.registerNamespace("xlink");
        } else if (typeCi != null) {
            if (typeCi.category() == 2) {
                if (typeCi.matches("rule-xsd-all-naming-19139")) {
                    piValueXPath = piElementXPath + "/*";
                } else if (propi.inClass().matches("rule-xsd-cls-codelist-asDictionaryGml33") && typeCi.asDictionaryGml33()) {
                    piValueXPath = piElementXPath + "/@xlink:href";
                    schDoc.registerNamespace("xlink");
                } else {
                    piValueXPath = piElementXPath + "/text()";
                }
            } else if (typeCi.category() == 3) {
                piValueXPath = typeCi.matches("rule-xsd-all-naming-19139") ? piElementXPath + "/*" : piElementXPath + "/text()";
            } else if (typeCi.category() == 8) {
                if (typeCi.matches("rule-xsd-cls-union-omitUnionsRepresentingFeatureTypeSets") && "true".equalsIgnoreCase(typeCi.taggedValue("representsFeatureTypeSet"))) {
                    piValueXPath = piElementXPath + "/@xlink:href";
                    schDoc.registerNamespace("xlink");
                } else {
                    piValueXPath = piElementXPath + "/*";
                }
            } else if (typeCi.category() == 7) {
                piValueXPath = piElementXPath + "/text()";
            } else if (typeCi.category() == 5) {
                piValueXPath = piElementXPath + "/*";
            } else if (typeCi.category() == 1) {
                if (typeCi.matches("rule-xsd-prop-featureType-gmlsf-byReference")) {
                    piValueXPath = piElementXPath + "/@xlink:href";
                    schDoc.registerNamespace("xlink");
                } else if (typeCi.matches("rule-xsd-all-naming-19139")) {
                    piValueXPath = piElementXPath + "/(* | @xlink:href)";
                    schDoc.registerNamespace("xlink");
                } else if ("inline".equalsIgnoreCase(propi.inlineOrByReference())) {
                    piValueXPath = piElementXPath + "/*";
                } else if ("byreference".equalsIgnoreCase(propi.inlineOrByReference())) {
                    piValueXPath = piElementXPath + "/@xlink:href";
                    schDoc.registerNamespace("xlink");
                } else {
                    piValueXPath = piElementXPath + "/(* | @xlink:href)";
                    schDoc.registerNamespace("xlink");
                }
            } else if (typeCi.matches("rule-xsd-all-naming-19139")) {
                if (!XmlSchema.classCanBeReferenced(typeCi)) {
                    piValueXPath = piElementXPath + "/*";
                } else {
                    piValueXPath = piElementXPath + "/(* | @xlink:href)";
                    schDoc.registerNamespace("xlink");
                }
            } else if (valueIsSimpleType) {
                piValueXPath = piElementXPath + "/text()";
            } else if ("inline".equalsIgnoreCase(propi.inlineOrByReference())) {
                piValueXPath = piElementXPath + "/*";
            } else if ("byreference".equalsIgnoreCase(propi.inlineOrByReference())) {
                piValueXPath = piElementXPath + "/@xlink:href";
                schDoc.registerNamespace("xlink");
            } else {
                piValueXPath = piElementXPath + "/(* | @xlink:href)";
                schDoc.registerNamespace("xlink");
            }
        } else if (valueIsSimpleType) {
            piValueXPath = piElementXPath + "/text()";
        } else if ("inline".equalsIgnoreCase(propi.inlineOrByReference()) || !this.options.xmlReferenceable(propi.typeInfo().name, propi.encodingRule("xsd")).booleanValue()) {
            piValueXPath = piElementXPath + "/*";
        } else if ("byreference".equalsIgnoreCase(propi.inlineOrByReference())) {
            piValueXPath = piElementXPath + "/@xlink:href";
            schDoc.registerNamespace("xlink");
        } else {
            piValueXPath = piElementXPath + "/(* | @xlink:href)";
            schDoc.registerNamespace("xlink");
        }
        schDoc.registerNamespace("xsi");
        String xpath = "not(" + piElementXPath + ") or (count(" + piElementXPath + "[@xsi:nil='true' and @*:nilReason]) eq 1 and not(" + piValueXPath + ")) or (count(" + piElementXPath + "[@xsi:nil='true' or @*:nilReason]) eq 0 and count(" + piValueXPath + ") eq count(" + piElementXPath + "))";
        XpathFragment xpathValueOrNilReason = new XpathFragment(0, xpath, XpathType.BOOLEAN);
        String assertionText = "If there are elements for property " + propi.name() + ", then either there is only a single such element that is nil, has a nilReason, and no value - or all of these elements are not nil, do not have nilReason attributes, and have values";
        schDoc.addAssertion(cibase, true, xpathValueOrNilReason, assertionText);
    }

    public boolean isSimpleType(ClassInfo ci, String ciName, String propiEncodingRule) {
        boolean isSimple = false;
        if (ci != null) {
            Boolean indicatorSimpleType = XmlSchema.indicatorForObjectElementWithSimpleContent(ci);
            isSimple = !XmlSchema.classHasObjectElement(ci) || indicatorSimpleType != null && indicatorSimpleType != false;
        } else {
            String tname = ciName;
            MapEntry me = this.options.typeMapEntry(tname, propiEncodingRule);
            if (me != null) {
                isSimple = me.p2.equalsIgnoreCase("simple/simple") || me.p2.equalsIgnoreCase("complex/simple");
            }
        }
        return isSimple;
    }

    @Override
    public void write() {
        if (this.printed) {
            return;
        }
        if (this.diagnosticsOnly) {
            return;
        }
        boolean skipXmlSchemaOutput = this.options.parameterAsBoolean(this.getClass().getName(), "skipXmlSchemaOutput", false);
        if (skipXmlSchemaOutput) {
            this.result.addInfo(this, 1000);
        } else {
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", "UTF-8");
            for (XsdDocument xsd : this.xsdMap.values()) {
                if (xsd.printed()) continue;
                try {
                    xsd.printFile(outputFormat);
                    this.result.addResult(this.getTargetName(), this.outputDirectory, xsd.name, this.pi.targetNamespace());
                }
                catch (Exception e) {
                    String m = e.getMessage();
                    if (m != null) {
                        this.result.addError(m);
                    }
                    e.printStackTrace(System.err);
                }
            }
        }
        HashSet<SchematronSchema> schDocs = new HashSet<SchematronSchema>();
        for (XsdDocument xsd : this.xsdMap.values()) {
            if (xsd.getSchematronDocument() == null) continue;
            schDocs.add(xsd.getSchematronDocument());
        }
        for (SchematronSchema schDoc : schDocs) {
            if (schDoc.hasRules()) {
                schDoc.write(this.outputDirectory);
                continue;
            }
            this.result.addDebug(this, 2011, schDoc.getFileName());
        }
        this.printed = true;
    }

    protected boolean createXSDs(PackageInfo pi, XsdDocument xsdcurr) throws ShapeChangeAbortException {
        XsdDocument xsd;
        boolean res = false;
        Object xsdDocument = pi.xsdDocument();
        if (xsdDocument != null && ((String)xsdDocument).length() > 0) {
            try {
                this.result.addDebug(this, 10017, (String)xsdDocument, pi.name());
                xsd = new XsdDocument(pi, this.model, this.options, this.result, this.config, (String)xsdDocument, this.determineSchematronSchemaForXsdDocument((String)xsdDocument));
                res = true;
            }
            catch (ParserConfigurationException e) {
                this.result.addFatalError(null, 2);
                throw new ShapeChangeAbortException();
            }
        }
        xsd = xsdcurr;
        if (xsd == null) {
            xsdDocument = pi.name() + ".xsd";
            this.result.addWarning(this, 15, pi.name(), (String)xsdDocument);
            try {
                this.result.addDebug(this, 10017, (String)xsdDocument, pi.name());
                xsd = new XsdDocument(pi, this.model, this.options, this.result, this.config, (String)xsdDocument, this.determineSchematronSchemaForXsdDocument((String)xsdDocument));
                res = true;
            }
            catch (ParserConfigurationException e) {
                this.result.addFatalError(null, 2);
                throw new ShapeChangeAbortException();
            }
        }
        this.xsdMap.put(pi.id(), xsd);
        if (pi.matches("rule-xsd-pkg-contained-packages")) {
            try {
                for (PackageInfo pix : pi.containedPackages()) {
                    if (pix.isSchema()) {
                        xsd.addImport(pix.xmlns(), pix.targetNamespace());
                        continue;
                    }
                    boolean created = this.createXSDs(pix, xsd);
                    if (!created) continue;
                    xsd.addInclude(this.xsdMap.get(pix.id()));
                    this.xsdMap.get(pix.id()).addInclude(xsd);
                }
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                Exception se = e;
                if (e instanceof SAXException) {
                    se = ((SAXException)e).getException();
                }
                if (se != null) {
                    se.printStackTrace(System.err);
                } else {
                    e.printStackTrace(System.err);
                }
                throw new ShapeChangeAbortException();
            }
        }
        return res;
    }

    private SchematronSchema determineSchematronSchemaForXsdDocument(String xsdDocumentFilename) {
        SchematronSchema schDoc = this.commonSchDoc;
        if (this.pi.matches("rule-xsd-pkg-schematron") && this.schematronSegmentation) {
            String schemaXsdBaseName = FilenameUtils.getBaseName((String)xsdDocumentFilename);
            schDoc = "xslt2".equalsIgnoreCase(this.explicitSchematronQueryBinding) ? new SchematronSchemaXslt2(this.model, this.options, this.result, this.pi, schemaXsdBaseName, this.schematronSegmentation) : new SchematronSchemaOld(this.model, this.options, this.result, this.pi, schemaXsdBaseName, this.schematronSegmentation);
        }
        return schDoc;
    }

    protected void processDependecies(PackageInfo pi) throws ShapeChangeAbortException {
        XsdDocument xsd1 = this.xsdMap.get(pi.id());
        for (String pid : pi.supplierIds()) {
            XsdDocument xsd2 = this.xsdMap.get(pid);
            if (xsd2 != null) {
                xsd1.addInclude(xsd2);
                continue;
            }
            PackageInfo pi2 = this.model.packageById(pid);
            if (pi2 == null || pi2.xmlns() == null || pi2.xmlns().length() <= 0 || pi2.targetNamespace() == null || pi2.targetNamespace().length() <= 0) continue;
            xsd1.addImport(pi2.xmlns(), pi2.targetNamespace());
        }
        try {
            for (PackageInfo pix : pi.containedPackages()) {
                if (pix.isSchema()) continue;
                this.processDependecies(pix);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
            throw new ShapeChangeAbortException();
        }
    }

    @Override
    public String getTargetName() {
        return "XML Schema";
    }

    @Override
    public String getTargetIdentifier() {
        return "xsd";
    }

    public static Boolean indicatorForObjectElementWithSimpleContent(ClassInfo ci) {
        if (ci.category() == 2 && ci.matches("rule-xsd-cls-standard-19139-property-types")) {
            return true;
        }
        return ci.options().xmlElementHasSimpleContent(ci.name(), ci.encodingRule("xsd"));
    }

    public static boolean classHasObjectElement(ClassInfo ci) {
        MapEntry me = ci.options().elementMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me != null) {
            return me.p1 != null && me.p1.length() > 0;
        }
        me = ci.options().typeMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me != null && me.rule != null && me.rule.equalsIgnoreCase("direct") && me.p2 != null && (me.p2.equalsIgnoreCase("complex/simple") || me.p2.equalsIgnoreCase("simple/simple"))) {
            return false;
        }
        me = ci.options().attributeMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me != null) {
            return false;
        }
        me = ci.options().attributeGroupMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me != null) {
            return false;
        }
        int cat = ci.category();
        if (ci.matches("rule-xsd-all-naming-19139")) {
            return cat == 5 || cat == 8 || cat == 1 || cat == 6 || cat == 3 || cat == 2 || cat == -1;
        }
        return cat == 5 && !ci.matches("rule-all-cls-aixmDatatype") || cat == 8 && (!ci.matches("rule-xsd-cls-union-asGroup") || !ci.asGroup()) || cat == 1 || cat == 6 || cat == -1 || cat == 12 && ci.matches("rule-xsd-cls-okstra-fid");
    }

    public static boolean implementedAsXmlAttribute(PropertyInfo pi) {
        boolean result = false;
        if (pi.name().equals("uom") && pi.matches("rule-all-prop-uomAsAttribute")) {
            result = true;
        } else if (pi.matches("rule-xsd-prop-xsdAsAttribute")) {
            result = true;
        }
        return result;
    }

    public static boolean classCanBeReferenced(ClassInfo ci) {
        Boolean xmlElementCanBeReferenced = ci.options().xmlReferenceable(ci.name(), ci.encodingRule("xsd"));
        if (XmlSchema.classHasObjectElement(ci) && (xmlElementCanBeReferenced == null || xmlElementCanBeReferenced.booleanValue())) {
            int cat = ci.category();
            if (cat == 1) {
                return true;
            }
            if (cat == 12) {
                return true;
            }
            if (cat == 6) {
                return true;
            }
            if (ci.matches("rule-xsd-all-naming-19139")) {
                if (cat == 5) {
                    return true;
                }
                if (cat == 8) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void registerRulesAndRequirements(RuleRegistry r) {
        r.addRule("req-xsd-pkg-xsdDocument-unique");
        r.addRule("req-xsd-cls-name-unique");
        r.addRule("req-xsd-cls-ncname");
        r.addRule("req-xsd-prop-data-type");
        r.addRule("req-xsd-prop-value-type-exists");
        r.addRule("req-xsd-prop-ncname");
        r.addRule("rule-xsd-pkg-contained-packages");
        r.addRule("rule-xsd-pkg-dependencies");
        r.addRule("rule-xsd-cls-union-as-choice");
        r.addRule("rule-xsd-cls-unknown-as-object");
        r.addRule("rule-xsd-cls-sequence");
        r.addRule("rule-xsd-cls-object-element");
        r.addRule("rule-xsd-cls-type");
        r.addRule("rule-xsd-cls-property-type");
        r.addRule("rule-xsd-cls-local-properties");
        ProcessRuleSet starPrs = new ProcessRuleSet("*", new TreeSet<String>(Stream.of("req-xsd-pkg-xsdDocument-unique", "req-xsd-cls-name-unique", "req-xsd-cls-ncname", "req-xsd-prop-data-type", "req-xsd-prop-value-type-exists", "req-xsd-prop-ncname", "rule-xsd-pkg-contained-packages", "rule-xsd-pkg-dependencies", "rule-xsd-cls-unknown-as-object", "rule-xsd-cls-object-element", "rule-xsd-cls-type", "rule-xsd-cls-property-type", "rule-xsd-cls-local-properties", "rule-xsd-cls-union-as-choice", "rule-xsd-cls-sequence").collect(Collectors.toSet())));
        r.addRuleSet(starPrs);
        r.addRule("req-xsd-cls-generalization-consistent");
        r.addRule("rule-xsd-all-naming-gml");
        r.addRule("rule-xsd-cls-global-enumeration");
        r.addRule("rule-xsd-cls-codelist-asDictionary");
        r.addRule("rule-xsd-cls-noPropertyType");
        r.addRule("rule-xsd-cls-byValuePropertyType");
        r.addRule("rule-xsd-cls-standard-gml-property-types");
        r.addRule("rule-xsd-pkg-gmlProfileSchema");
        r.addRule("rule-xsd-prop-defaultCodeSpace");
        r.addRule("rule-xsd-prop-inlineOrByReference");
        r.addRule("rule-xsd-prop-reverseProperty");
        r.addRule("rule-xsd-prop-targetElement");
        ProcessRuleSet iso19136_2007Prs = new ProcessRuleSet("iso19136_2007", "*", new TreeSet<String>(Stream.of("req-xsd-cls-generalization-consistent", "rule-xsd-all-naming-gml", "rule-xsd-cls-global-enumeration", "rule-xsd-cls-codelist-asDictionary", "rule-xsd-cls-standard-gml-property-types", "rule-xsd-cls-noPropertyType", "rule-xsd-cls-byValuePropertyType", "rule-xsd-pkg-gmlProfileSchema", "rule-xsd-prop-targetElement", "rule-xsd-prop-reverseProperty", "rule-xsd-prop-defaultCodeSpace", "rule-xsd-prop-inlineOrByReference").collect(Collectors.toSet())));
        r.addRuleSet(iso19136_2007Prs);
        r.addRule("rule-xsd-cls-codelist-asDictionaryGml33");
        r.addRule("rule-xsd-rel-association-classes");
        ProcessRuleSet gml33Prs = new ProcessRuleSet("gml33", "*", new TreeSet<String>(Stream.of("req-xsd-cls-generalization-consistent", "rule-xsd-all-naming-gml", "rule-xsd-cls-global-enumeration", "rule-xsd-cls-codelist-asDictionaryGml33", "rule-xsd-cls-standard-gml-property-types", "rule-xsd-cls-noPropertyType", "rule-xsd-cls-byValuePropertyType", "rule-xsd-pkg-gmlProfileSchema", "rule-xsd-prop-targetElement", "rule-xsd-prop-reverseProperty", "rule-xsd-prop-defaultCodeSpace", "rule-xsd-prop-inlineOrByReference", "rule-xsd-rel-association-classes").collect(Collectors.toSet())));
        r.addRuleSet(gml33Prs);
        r.addRule("rule-xsd-all-naming-19139");
        r.addRule("rule-xsd-cls-standard-19139-isoType");
        r.addRule("rule-xsd-cls-standard-19139-property-types");
        r.addRule("rule-xsd-cls-enum-object-element");
        r.addRule("rule-xsd-cls-enum-property-type");
        ProcessRuleSet iso19139_2007Prs = new ProcessRuleSet("iso19139_2007", "*", new TreeSet<String>(Stream.of("rule-xsd-cls-enum-object-element", "rule-xsd-cls-enum-property-type", "rule-xsd-cls-global-enumeration", "rule-xsd-cls-standard-19139-property-types", "rule-xsd-all-naming-19139").collect(Collectors.toSet())));
        r.addRuleSet(iso19139_2007Prs);
        r.addRule("rule-xsd-all-naming-swe");
        r.addRule("rule-xsd-prop-xsdAsAttribute");
        r.addRule("rule-xsd-prop-soft-typed");
        r.addRule("rule-xsd-cls-union-as-group-property-type");
        r.addRule("rule-xsd-cls-standard-swe-property-types");
        r.addRule("rule-xsd-prop-initialValue");
        ProcessRuleSet ogcSweCommon2Prs = new ProcessRuleSet("ogcSweCommon2", "*", new TreeSet<String>(Stream.of("req-xsd-cls-generalization-consistent", "rule-xsd-all-naming-swe", "rule-xsd-cls-global-enumeration", "rule-xsd-cls-codelist-asDictionary", "rule-xsd-cls-standard-swe-property-types", "rule-xsd-cls-noPropertyType", "rule-xsd-cls-byValuePropertyType", "rule-xsd-pkg-gmlProfileSchema", "rule-xsd-prop-targetElement", "rule-xsd-prop-reverseProperty", "rule-xsd-prop-defaultCodeSpace", "rule-xsd-prop-inlineOrByReference", "rule-xsd-prop-xsdAsAttribute", "rule-xsd-prop-soft-typed", "rule-xsd-cls-union-as-group-property-type", "rule-xsd-prop-initialValue").collect(Collectors.toSet())));
        r.addRuleSet(ogcSweCommon2Prs);
        r.addRule("rule-xsd-all-gml21");
        r.addRule("rule-xsd-cls-codelist-anonymous-xlink");
        ProcessRuleSet gml21Prs = new ProcessRuleSet("gml21", "iso19136_2007", new TreeSet<String>(Stream.of("rule-xsd-all-gml21", "rule-xsd-cls-codelist-anonymous-xlink").collect(Collectors.toSet())));
        r.addRuleSet(gml21Prs);
        r.addRule("req-all-all-documentation");
        r.addRule("req-all-prop-sequenceNumber");
        r.addRule("req-xsd-pkg-targetNamespace");
        r.addRule("req-xsd-pkg-xmlns");
        r.addRule("req-xsd-pkg-namespace-schema-only");
        r.addRule("rec-xsd-pkg-version");
        r.addRule("req-xsd-pkg-xsdDocument");
        r.addRule("req-xsd-pkg-dependencies");
        r.addRule("req-xsd-cls-codelist-asDictionary-true");
        r.addRule("req-xsd-cls-codelist-extensibility-values");
        r.addRule("req-xsd-cls-codelist-extensibility-vocabulary");
        r.addRule("req-xsd-cls-codelist-no-supertypes");
        r.addRule("req-xsd-cls-datatype-noPropertyType");
        r.addRule("req-xsd-cls-enum-no-supertypes");
        r.addRule("req-xsd-cls-mixin-supertypes");
        r.addRule("req-xsd-cls-mixin-supertypes-overrule");
        r.addRule("req-xsd-cls-objecttype-byValuePropertyType");
        r.addRule("req-xsd-cls-objecttype-noPropertyType");
        r.addRule("req-xsd-cls-suppress-no-properties");
        r.addRule("req-xsd-cls-suppress-subtype");
        r.addRule("req-xsd-cls-suppress-supertype");
        r.addRule("req-xsd-prop-codelist-obligation");
        r.addRule("rule-xsd-all-descriptorAnnotation");
        r.addRule("rule-xsd-all-globalIdentifierAnnotation");
        r.addRule("rule-xsd-all-notEncoded");
        r.addRule("rule-xsd-all-propertyAssertion-ignoreProhibited");
        r.addRule("rule-xsd-cls-adeelement");
        r.addRule("rule-xsd-cls-basictype");
        r.addRule("rule-xsd-cls-basictype-list");
        r.addRule("rule-xsd-cls-codelist-constraints");
        r.addRule("rule-xsd-cls-codelist-constraints2");
        r.addRule("rule-xsd-cls-codelist-constraints-codeAbsenceInModelAllowed");
        r.addRule("rule-xsd-cls-codelist-gmlsf");
        r.addRule("rule-xsd-cls-enum-subtypes");
        r.addRule("rule-xsd-cls-enum-supertypes");
        r.addRule("rule-xsd-cls-mixin-classes-as-group");
        r.addRule("rule-xsd-cls-mixin-classes");
        r.addRule("rule-xsd-cls-mixin-classes-non-mixin-supertypes");
        r.addRule("rule-xsd-cls-no-abstract-classes");
        r.addRule("rule-xsd-cls-no-base-class");
        r.addRule("rule-xsd-cls-no-gml-types");
        r.addRule("rule-xsd-cls-okstra-fid");
        r.addRule("rule-xsd-cls-okstra-lifecycle");
        r.addRule("rule-xsd-cls-okstra-schluesseltabelle");
        r.addRule("rule-xsd-cls-suppress");
        r.addRule("rule-xsd-cls-union-asCharacterString");
        r.addRule("rule-xsd-cls-union-asGroup");
        r.addRule("rule-xsd-cls-union-direct");
        r.addRule("rule-xsd-cls-union-direct-optionality");
        r.addRule("rule-xsd-cls-union-omitUnionsRepresentingFeatureTypeSets");
        r.addRule("rule-xsd-prop-att-map-entry");
        r.addRule("rule-xsd-prop-constrainingFacets");
        r.addRule("rule-xsd-prop-exclude-derived");
        r.addRule("rule-xsd-prop-length-size-pattern");
        r.addRule("rule-xsd-prop-featureType-gmlsf-byReference");
        r.addRule("rule-xsd-prop-metadata");
        r.addRule("rule-xsd-prop-metadata-gmlsf-byReference");
        r.addRule("rule-xsd-prop-nillable");
        r.addRule("rule-xsd-prop-nilReasonAllowed");
        r.addRule("rule-xsd-prop-nilReason-constraints");
        r.addRule("rule-xsd-prop-gmlArrayProperty");
        r.addRule("rule-xsd-prop-gmlListProperty");
        r.addRule("rule-xsd-prop-qualified-associations");
        r.addRule("rule-xsd-prop-targetCodeListURI");
        r.addRule("rule-xsd-prop-valueOrNilReason-constraints");
        r.addRule("rule-xsd-all-no-documentation");
        r.addRule("rule-xsd-cls-local-enumeration");
        r.addRule("rule-xsd-cls-local-basictype");
        r.addRule("rule-xsd-pkg-dgiwgsp");
        r.addRule("rule-xsd-pkg-gmlsf");
        r.addRule("rule-xsd-pkg-schematron");
        r.addRule("rule-xsd-all-tagged-values");
        r.addRule("rule-xsd-cls-adehook");
        r.addRule("rule-all-cls-aixmDatatype");
        r.addRule("rule-all-prop-uomAsAttribute");
    }

    @Override
    public String getDefaultEncodingRule() {
        return "iso19136_2007";
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 0: {
                return "Context: property '$1$'.";
            }
            case 1: {
                return "Context: class '$1$'.";
            }
            case 2: {
                return "Context: association class '$1$'.";
            }
            case 3: {
                return "Context: association between class '$1$' (with property '$2$') and class '$3$' (with property '$4$')";
            }
            case 10: {
                return "Class '$1$' in package '$2$' is not associated with an XSD document.";
            }
            case 15: {
                return "Package '$1$' not associated with any XML Schema document. Set tagged value 'xsdDocument' on the according schema package. Alternatively, if a PackageInfo element is used in the input configuration of ShapeChange to mark that package as an application schema, set the XML attribute 'xsdDocument'. Package '$1$' will be associated with XML Schema document '$2$'.";
            }
            case 1000: {
                return "Skipping XML Schema output, as configured.";
            }
            case 1001: {
                return "No namespace was found for namespace abbreviation '$1$', configured via tagged value 'xsdForcedImports' on schema package '$2$'. No import will be created for this namespace abbreviation.";
            }
            case 2002: {
                return "??Property '$1$' of class '$2$' is encoded as an attribute. A schematron assertion to check for value or nilReason will not be created.";
            }
            case 2003: {
                return "??The value type of property '$1$' of class '$2$' is encoded as an attribute (group). A schematron assertion to check for value or nilReason will not be created.";
            }
            case 2004: {
                return "??Union '$1$' that has property '$2$' is encoded as an attribute group or as a CharacterString. A schematron assertion to check for value or nilReason will not be created for the property.";
            }
            case 2005: {
                return "??Mixin '$1$' that has property '$2$' is encoded as an attribute group. A schematron assertion to check for value or nilReason will not be created for the property.";
            }
            case 2006: {
                return "??Property '$1$' of class '$2$' is encoded as an attribute. A schematron assertion to check nilReason values will not be created.";
            }
            case 2007: {
                return "??Union '$1$' that has property '$2$' is encoded as an attribute group or as a CharacterString. A schematron assertion to check nilReason values will not be created for the property.";
            }
            case 2008: {
                return "??Mixin '$1$' that has property '$2$' is encoded as an attribute group. A schematron assertion to check nilReason values will not be created for the property.";
            }
            case 2009: {
                return "voidReasonType defined for property '$1$' (directly via tagged value or indirectly via parameter) is '$2$'. This type is not an enumeration or does not define any enum. An assertion to check @nilReason for this property will NOT be created.";
            }
            case 2010: {
                return "No voidReasonType defined or found for property '$1$' (directly via tagged value or indirectly via parameter). An assertion to check @nilReason for this property will NOT be created.";
            }
            case 2011: {
                return "Schematron schema '$1$' will not be written, because it does not contain any schematron rule (with assertion(s)).";
            }
            case 2012: {
                return "defaultVoidReasonType defined by the according target parameter is: '$1$'. The type could not be found in the model, using the rules defined for the parameter. Accordingly, a default void reason type is not set.";
            }
            case 2013: {
                return "voidReasonType defined for property '$1$' of class '$2$' (via tagged value 'voidReasonType') is: '$3$'. The type could not be found in the model, using the rules defined for finding the void reason type (defined by the tagged value). The tagged value will be ignored.";
            }
            case 10012: {
                return "Generating XML Schema for application schema '$1$'.";
            }
            case 10016: {
                return "Processing class '$1$', rule '$2$'.";
            }
            case 10017: {
                return "Creating XSD document '$1$' for package '$2$'.";
            }
        }
        return "(" + this.getClass().getName() + ") Unknown message with number: " + mnr;
    }
}

